/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.system;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.faf.dto.ResultDTO;
import kd.macc.faf.enums.FAFDimensionTypeEnum;
import kd.macc.faf.enums.ImportDimensionTypeEnum;
import kd.macc.faf.enums.OlapFromServiceEnum;
import kd.macc.faf.handle.DataImportFactoryBuilder;
import kd.macc.faf.param.FAFDimensionSelect;
import kd.macc.faf.template.FAFDynamicObjectTemplate;
import kd.macc.faf.template.FAFFrameworkTemplate;
import kd.macc.faf.template.FAFTemplate;
import kd.macc.faf.util.BaseDataUtil;

public class FAFDimensionList
extends AbstractListPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"_toolbar_"});
    }

    public void setFilter(SetFilterEvent e) {
        Long anaSystemId = (Long)this.getView().getFormShowParameter().getCustomParam("anaSystemId");
        if (anaSystemId != null && anaSystemId != 0L) {
            QFilter filter = new QFilter("system", "=", (Object)anaSystemId);
            e.addCustomQFilter(filter);
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        Long anaSystemId = (Long)this.getView().getFormShowParameter().getCustomParam("anaSystemId");
        if (anaSystemId != null && anaSystemId != 0L) {
            e.getParameter().setCustomParam("system", (Object)anaSystemId);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "importdatafromasstact": {
                this.showAsstactF7Page();
                break;
            }
            case "bcm": 
            case "epm": {
                this.showDimensionSelect(itemKey);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if ("delete".equals(operateKey) && operationResult.isSuccess()) {
            List successPkIds;
            IFormView parentView = this.getView().getParentView();
            if (parentView != null && "pa_anasystemconfig".equals(parentView.getEntityId())) {
                parentView.updateView();
                this.getView().sendFormAction(parentView);
            }
            if ((successPkIds = operationResult.getSuccessPkIds()) != null && !successPkIds.isEmpty()) {
                Set deleteIdSet = successPkIds.stream().map(p -> Long.parseLong(String.valueOf(p))).collect(Collectors.toSet());
                DataImportFactoryBuilder.deleteDimensionMapping((OlapFromServiceEnum)OlapFromServiceEnum.EPM, deleteIdSet);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        IFormView view = this.getView();
        if ("importdatafromasstact".equals(actionId)) {
            if (returnData != null) {
                this.importDimensionFromAsstact(returnData);
                view.updateView();
            }
        } else if (returnData != null && ("epm".equals(actionId) || "bcm".equals(actionId))) {
            ResultDTO result;
            IFormView parentView = view.getParentView();
            if (parentView != null && "pa_anasystemconfig".equals(parentView.getEntityId())) {
                parentView.updateView();
                view.sendFormAction(parentView);
            }
            if ((result = (ResultDTO)returnData).isExceptionInterrupt()) {
                view.showMessage(ResManager.loadKDString((String)"\u5bfc\u5165\u7ef4\u5ea6\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u76f8\u5173\u4eba\u5458\u6392\u67e5\u3002", (String)"FAFDimensionList_4", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            } else {
                int success = result.getSuccess();
                int failure = result.getFailure();
                String message = result.getMessage();
                if (failure == 0 && message == null) {
                    view.showMessage(String.format(ResManager.loadKDString((String)"\u6210\u529f\u4fdd\u5b58%d\u6761\u7ef4\u5ea6\u3002", (String)"FAFDimensionList_5", (String)"macc-faf-formplugin", (Object[])new Object[0]), success));
                } else {
                    view.showMessage(String.format(ResManager.loadKDString((String)"\u6210\u529f%1$d\u6761\uff0c\u5931\u8d25%2$d\u6761\uff0c\u539f\u56e0\uff1a%3$s", (String)"FAFDimensionList_6", (String)"macc-faf-formplugin", (Object[])new Object[0]), success, failure, message));
                }
            }
            view.invokeOperation("refresh");
        }
    }

    private void importDimensionFromAsstact(Object returnData) {
        Object[] primaryKeyValues = ((ListSelectedRowCollection)returnData).getPrimaryKeyValues();
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((Object[])primaryKeyValues, (String)"ai_asstacttype");
        List<String> dimensionNumbersOfCurrentSystem = BusinessDataServiceHelper.loadFromCache((String)"pa_dimension", (QFilter[])new QFilter("system", "=", (Object)this.getAnaCurrentSystemId()).toArray()).values().stream().map(dy -> dy.getString("number")).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty((Map)dynamicObjectMap)) {
            this.buildAndSaveDimensionThroughImport(dynamicObjectMap, dimensionNumbersOfCurrentSystem);
        }
    }

    private void buildAndSaveDimensionThroughImport(Map<Object, DynamicObject> dynamicObjectMap, List<String> dimensionNumbersOfCurrentSystem) {
        String nameLocalStr = FAFFrameworkTemplate.getName();
        String numberLocalStr = FAFFrameworkTemplate.getNumber();
        ArrayList<String> existDimensionNumberList = new ArrayList<String>();
        FAFTemplate.Builder builder = FAFDynamicObjectTemplate.create((String)"pa_dimension").propsCommon().put("isdefault", (Object)"0").put("system", (Object)this.getAnaCurrentSystemId()).put("typefield", (Object)Character.valueOf(' ')).put("grouptype", (Object)Character.valueOf(' ')).put("group_id", (Object)0).put("systemsource", (Object)"1").template().setFields(new Object[]{"number", "name", "dimensiontype", "dimensionsource", "assistantsource", "asstacttype_id", new Object[]{"fieldnumber", "fieldname", "datatype", "dimensionentryentity"}});
        for (DynamicObject dynamicObject : dynamicObjectMap.values()) {
            String nameStr;
            Object id = dynamicObject.get("id");
            String datatype = dynamicObject.getString("datatype");
            String name = dynamicObject.getString("name");
            String number = this.getImportDimensionNumber(dynamicObject.getString("number"));
            String string = nameStr = name == null ? "" : name.substring(0, Math.min(name.length(), 100));
            if (dimensionNumbersOfCurrentSystem.contains(number)) {
                existDimensionNumberList.add(nameStr + '[' + number + "]");
                continue;
            }
            switch (ImportDimensionTypeEnum.getEnumByCode((String)datatype)) {
                case BASE_DATA: {
                    builder.addValues(new Object[]{number, nameStr, String.valueOf(FAFDimensionTypeEnum.DATABASE.getCode()), dynamicObject.get("valuesource_id"), 0, id, new Object[]{new Object[]{"number", numberLocalStr, Character.valueOf('5')}, new Object[]{"name", nameLocalStr, Character.valueOf('5')}}});
                    break;
                }
                case ASSISTANT_DATA: {
                    builder.addValues(new Object[]{number, nameStr, String.valueOf(FAFDimensionTypeEnum.ASSISTANTDATA.getCode()), Character.valueOf(' '), dynamicObject.get("assistanttype_id"), id, new Object[]{new Object[]{"number", numberLocalStr, Character.valueOf('5')}, new Object[]{"name", nameLocalStr, Character.valueOf('5')}}});
                    break;
                }
                case TEXT: 
                case BOOL: {
                    builder.addValues(new Object[]{number, nameStr, String.valueOf(FAFDimensionTypeEnum.OTHER.getCode()), Character.valueOf(' '), 0, id, new Object[]{new Object[]{"number", numberLocalStr, Character.valueOf('5')}, new Object[]{"name", nameLocalStr, Character.valueOf('5')}}});
                    break;
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])builder.finish().getDynamicObjects());
        if (!CollectionUtils.isEmpty(existDimensionNumberList)) {
            DynamicObject anaSystem = BusinessDataServiceHelper.loadSingleFromCache((String)"pa_anasystemsetting", (String)"number,name", (QFilter[])new QFilter("id", "=", (Object)this.getAnaCurrentSystemId()).toArray());
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u4e3a%1$s\u7684\u6570\u636e\u5728[%2$s]\u4f53\u7cfb\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u3002", (String)"FAFDimensionList_3", (String)"macc-faf-formplugin", (Object[])new Object[0]), StringUtils.join((Object[])existDimensionNumberList.toArray(), (String)"\uff0c"), anaSystem.getString("name")));
        }
    }

    private String getImportDimensionNumber(String number) {
        String numberWithPrefix = "pa_" + number;
        return numberWithPrefix.substring(0, Math.min(numberWithPrefix.length(), 25)).toLowerCase(Locale.ENGLISH);
    }

    private Long getAnaCurrentSystemId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("anaSystemId");
    }

    private void showAsstactF7Page() {
        ListShowParameter fsp = BaseDataUtil.createF7ShowParameter("ai_asstacttype", true, "");
        fsp.setCustomParam("systemimport", (Object)"importdatafromasstact");
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "importdatafromasstact"));
        fsp.setListFilterParameter(new ListFilterParameter(Collections.singletonList(new QFilter("enable", "=", (Object)"1")), null));
        this.getView().showForm((FormShowParameter)fsp);
    }

    private void showDimensionSelect(String importTypeKey) {
        FAFDimensionSelect.showDimension((AbstractFormPlugin)this, importTypeKey, importTypeKey);
    }
}

