/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.system;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Delete;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonBaseDataFilterColumn;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.faf.datareview.FAFDataReview2Plugin;
import kd.macc.faf.helper.DLockHelper;
import kd.macc.faf.helper.FAFDataQueryHelper;
import kd.macc.faf.util.AnalysisModelUtil;
import kd.macc.faf.util.BusinessPermissionHelper;
import kd.macc.faf.util.DateUtil;

public class FAFDynamicBuildMetaListPlugin
extends AbstractListPlugin {
    public static final Log log = LogFactory.getLog(FAFDynamicBuildMetaListPlugin.class);

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"viewdata", "delete"});
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        try {
            long currUserId = RequestContext.get().getCurrUserId();
            if (!PermissionServiceHelper.isSuperUser((long)currUserId)) {
                this.filterInitOrg(args, currUserId);
            }
            this.filterInitPeriod(args);
            this.filterInitCreateTime(args);
        }
        catch (Exception exception) {
            throw new KDBizException(exception.getMessage());
        }
    }

    public void filterInitOrg(FilterContainerInitArgs args, Long currUserId) {
        block20: {
            List commonFilterColumns = args.getCommonFilterColumns();
            if (commonFilterColumns != null) {
                FilterColumn filterColumn = (FilterColumn)commonFilterColumns.get(0);
                String fieldName = filterColumn.getFieldName();
                if (fieldName.contains(".")) {
                    this.getPageCache().put("orgField", fieldName.split("\\.")[0]);
                }
                List comboItems = null;
                if (filterColumn instanceof SchemeFilterColumn) {
                    comboItems = ((SchemeFilterColumn)filterColumn).getComboItems();
                } else if (filterColumn instanceof CommonFilterColumn) {
                    comboItems = ((CommonFilterColumn)filterColumn).getComboItems();
                }
                if (comboItems != null && !comboItems.isEmpty()) {
                    comboItems.clear();
                    List permissionOrgIds = BusinessPermissionHelper.getUnionAppPermissionList((Long)currUserId, (String)"pa_anasystemsetting", (String)"3KAS06ROI392");
                    if (permissionOrgIds != null && !permissionOrgIds.isEmpty()) {
                        QFilter orgIdFilter = new QFilter("id", "in", (Object)permissionOrgIds);
                        try (DataSet orgDs = QueryServiceHelper.queryDataSet((String)FAFDynamicBuildMetaListPlugin.class.getName(), (String)"bos_org", (String)"id,name", (QFilter[])orgIdFilter.toArray(), null);){
                            if (orgDs == null) break block20;
                            while (orgDs.hasNext()) {
                                Row next = orgDs.next();
                                ComboItem comboItem = new ComboItem();
                                comboItem.setValue(String.valueOf(next.get("id")));
                                comboItem.setCaption(new LocaleString(next.getString("name")));
                                comboItems.add(comboItem);
                                if (comboItems.size() <= 19) continue;
                                break;
                            }
                        }
                    }
                }
            }
        }
    }

    private void filterInitCreateTime(FilterContainerInitArgs args) {
        args.getCommonFilterColumns().stream().filter(column -> "createtime".equals(column.getFieldName())).findFirst().ifPresent(filterColumn -> filterColumn.setDefaultValue("63"));
    }

    private void filterInitPeriod(FilterContainerInitArgs args) {
        Optional<FilterColumn> first;
        Long anaModelId = (Long)this.getView().getFormShowParameter().getCustomParam("analysis_model");
        DynamicObject anaModel = BusinessDataServiceHelper.loadSingle((Object)anaModelId, (String)"pa_analysismodel");
        if (anaModel.getBoolean("isnewlistfilter") && (first = args.getCommonFilterColumns().stream().filter(filterColumn -> filterColumn instanceof CommonBaseDataFilterColumn && "bd_period".equals(filterColumn.getFilterField().getRefEntityId())).findFirst()).isPresent()) {
            FilterColumn periodFilterColumn = first.get();
            QFilter periodTypeFilter = new QFilter("periodtype", "=", (Object)anaModel.getDynamicObject("periodtype").getLong("id"));
            DynamicObjectCollection periodDys = QueryServiceHelper.query((String)"bd_period", (String)"id,name", (QFilter[])new QFilter[]{periodTypeFilter}, (String)"number asc", (int)20);
            List<Object> periodComboItems = new ArrayList<ComboItem>(1);
            if (!CollectionUtils.isEmpty((Collection)periodDys)) {
                periodComboItems = periodDys.stream().map(model -> {
                    ComboItem item = new ComboItem();
                    item.setCaption(new LocaleString(model.getString("name")));
                    item.setValue(String.valueOf(model.getLong("id")));
                    item.setItemVisible(true);
                    return item;
                }).collect(Collectors.toList());
            }
            this.setComboItems(periodFilterColumn, periodComboItems);
            Date lastMonth = DateUtil.getDataFormat((Date)DateUtil.getLastMonth((Date)new Date(), (int)1), (boolean)true);
            QFilter dateFilter = new QFilter("begindate", "<=", (Object)lastMonth).and(new QFilter("enddate", ">=", (Object)lastMonth));
            List objectList = QueryServiceHelper.queryPrimaryKeys((String)"bd_period", (QFilter[])new QFilter[]{dateFilter, periodTypeFilter}, null, (int)1);
            if (!CollectionUtils.isEmpty((Collection)objectList)) {
                periodFilterColumn.setDefaultValue(objectList.get(0).toString());
            } else if (!CollectionUtils.isEmpty(periodComboItems)) {
                periodFilterColumn.setDefaultValue(((ComboItem)periodComboItems.get(0)).getValue());
            }
        }
    }

    private void setComboItems(FilterColumn filterColumn, List<ComboItem> comboItemList) {
        if (filterColumn instanceof SchemeFilterColumn) {
            ((SchemeFilterColumn)filterColumn).setComboItems(comboItemList);
        } else if (filterColumn instanceof CommonFilterColumn) {
            ((CommonFilterColumn)filterColumn).setComboItems(comboItemList);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        String orgField = this.getPageCache().get("orgField");
        if (orgField != null && (fieldName.equals(orgField + ".id") || fieldName.equals(orgField + ".name"))) {
            long currUserId = RequestContext.get().getCurrUserId();
            if (!PermissionServiceHelper.isSuperUser((long)currUserId)) {
                this.filterBeforeF7Select(args, currUserId);
            }
        } else {
            this.addF7SelectFilter(args, fieldName);
        }
    }

    private void addF7SelectFilter(BeforeFilterF7SelectEvent args, String fieldName) {
        Long anaModelId;
        DynamicObject anaModel;
        DynamicObject dimension;
        String[] fieldNameSplit = fieldName.split("\\.");
        if (fieldNameSplit.length == 2 && (dimension = (DynamicObject)(anaModel = BusinessDataServiceHelper.loadSingle((Object)(anaModelId = (Long)this.getView().getFormShowParameter().getCustomParam("analysis_model")), (String)"pa_analysismodel")).getDynamicObjectCollection("dimension_entry").stream().filter(dimEntry -> fieldNameSplit[0].equals(dimEntry.getDynamicObject("dimension").getString("number"))).map(dimEntry -> dimEntry.getDynamicObject("dimension")).findFirst().orElse(null)) != null) {
            QFilter qfilter = FAFDataQueryHelper.getDimensionF7SelectQFilter((DynamicObject)dimension);
            args.getCustomQFilters().add(qfilter);
        }
    }

    public void filterBeforeF7Select(BeforeFilterF7SelectEvent args, Long currUserId) {
        List permissionOrg = BusinessPermissionHelper.getUnionAppPermissionList((Long)currUserId, (String)"pa_anasystemsetting", (String)"3KAS06ROI392");
        QFilter filter = permissionOrg == null || permissionOrg.isEmpty() ? new QFilter("id", "=", (Object)-1L) : new QFilter("id", "in", (Object)permissionOrg);
        args.getQfilters().add(filter);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Object analysisSystem = fsp.getCustomParam("analysis_system");
        Object analysisModel = fsp.getCustomParam("analysis_model");
        if ("viewdata".equals(itemKey)) {
            if (analysisSystem != null && analysisModel != null) {
                Long analysisSystemId = Long.parseLong(analysisSystem.toString());
                Long analysisModelId = Long.parseLong(analysisModel.toString());
                FAFDataReview2Plugin.openF7((AbstractFormPlugin)this, null, analysisSystemId, analysisModelId, null, null);
            }
        } else if ("delete".equals(itemKey) && analysisModel != null) {
            ListSelectedRowCollection selectedRowsCol = this.getSelectedRows();
            if (selectedRowsCol == null || selectedRowsCol.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"FAFDynamicBuildMetaListPlugin_4", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                return;
            }
            OperateOption operateOption = OperateOption.create();
            String analysisModelStr = String.valueOf(analysisModel);
            operateOption.setVariableValue("analysismodel", analysisModelStr);
            for (ListSelectedRow selectedRow : selectedRowsCol) {
                operateOption.setVariableValue(String.valueOf(selectedRow.getPrimaryKeyValue()), String.valueOf(selectedRow.getRowKey()));
            }
            this.getView().invokeOperation("delete", operateOption);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        ListSelectedRowCollection selectedRows;
        String keyName = ((FormOperate)e.getSource()).getOperateKey();
        if (("delete".equals(keyName) || "importdata".equals(keyName) || "importdetails".equals(keyName) || "exportdata".equals(keyName) || "exportdata_expt".equals(keyName) || "exportlog".equals(keyName)) && !this.hasOperatePermission(keyName)) {
            e.setCancel(true);
            return;
        }
        if ("delete".equals(keyName) && (selectedRows = e.getListSelectedData()).size() > 0) {
            String orgField;
            IFormView view = this.getView();
            Object analysisModelId = view.getFormShowParameter().getCustomParam("analysis_model");
            DynamicObject analysisModelObj = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisModelId, (String)"pa_analysismodel");
            String entityNumber = AnalysisModelUtil.buildDetailEntityNumber((String)analysisModelObj.getString("tablenumber"));
            HashSet needDeleteIdSet = new HashSet(selectedRows.size());
            selectedRows.forEach(p -> needDeleteIdSet.add(Long.parseLong(String.valueOf(p.getPrimaryKeyValue()))));
            long currUserId = RequestContext.get().getCurrUserId();
            if (!PermissionServiceHelper.isSuperUser((long)currUserId) && (orgField = this.getPageCache().get("orgField")) != null) {
                List permissionOrgIds = BusinessPermissionHelper.getUnionAppPermissionList((Long)currUserId, (String)"pa_anasystemsetting", (String)"3KAS2BWOHZ7/");
                if (permissionOrgIds == null || permissionOrgIds.isEmpty()) {
                    e.setCancel(true);
                    view.showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6570\u636e\u8865\u5f55\u7684\u5220\u9664\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6dfb\u52a0\u6743\u9650\u3002", (String)"FAFDynamicBuildMetaListPlugin_3", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                    return;
                }
                QFilter idFilter = new QFilter("id", "in", needDeleteIdSet);
                DynamicObject[] dynObjArr = BusinessDataServiceHelper.load((String)entityNumber, (String)("id," + orgField), (QFilter[])idFilter.toArray());
                if (dynObjArr != null && dynObjArr.length > 0) {
                    HashSet<String> noPermissionOrgSet = new HashSet<String>(dynObjArr.length);
                    for (DynamicObject obj : dynObjArr) {
                        DynamicObject orgObj = obj.getDynamicObject(orgField);
                        if (permissionOrgIds.contains(orgObj.getLong("id"))) continue;
                        long noPermissionId = obj.getLong("id");
                        needDeleteIdSet.remove(noPermissionId);
                        noPermissionOrgSet.add(orgObj.getString("name"));
                    }
                    if (noPermissionOrgSet.size() == 1) {
                        e.setCancel(true);
                        view.showTipNotification(String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6570\u636e\u8865\u5f55\u7684\u7ec4\u7ec7\u3010%s\u3011\u7684\u5220\u9664\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6dfb\u52a0\u6743\u9650\u3002", (String)"FAFDynamicBuildMetaListPlugin_5", (String)"macc-faf-formplugin", (Object[])new Object[0]), noPermissionOrgSet.stream().findFirst().orElse(" ")));
                        return;
                    }
                    if (noPermissionOrgSet.size() > 1) {
                        e.setCancel(true);
                        view.showMessage(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6570\u636e\u8865\u5f55\u7684\u7ec4\u7ec7\u7684\u5220\u9664\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6dfb\u52a0\u6743\u9650\u3002", (String)"FAFDynamicBuildMetaListPlugin_6", (String)"macc-faf-formplugin", (Object[])new Object[0]), String.join((CharSequence)"\u3001", noPermissionOrgSet.toArray(new String[0])), MessageTypes.Default);
                        return;
                    }
                    if (needDeleteIdSet.isEmpty()) {
                        e.setCancel(true);
                        return;
                    }
                }
            }
            DLock dLock = null;
            try {
                String lockKey = DLockHelper.getMLockKey((String)entityNumber);
                dLock = DLock.create((String)lockKey);
                if (dLock != null && dLock.tryLock(1000L)) {
                    if (DLockHelper.existsMOPLock((Long)Long.valueOf(analysisModelId.toString()))) {
                        DLock.forceUnlock((String[])new String[]{DLockHelper.getMLockKey((String)entityNumber)});
                        e.setCancel(true);
                        view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u6790\u6a21\u578b\u6b63\u5728\u8fdb\u884c\u5176\u4ed6\u4efb\u52a1\u7684\u6570\u636e\u5904\u7406\uff0c\u76ee\u524d\u65e0\u6cd5\u5220\u9664\u6570\u636e\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"FAFDynamicBuildMetaListPlugin_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                    }
                } else {
                    e.setCancel(true);
                    view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u6790\u6a21\u578b\u6b63\u5728\u8fdb\u884c\u5176\u4ed6\u4efb\u52a1\u7684\u6570\u636e\u5904\u7406\uff0c\u76ee\u524d\u65e0\u6cd5\u5220\u9664\u6570\u636e\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"FAFDynamicBuildMetaListPlugin_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                }
            }
            catch (Exception ex) {
                e.setCancel(true);
                log.error(String.format("FAFDynamicBuildMetaListPlugin before delete data error, lock : %s", dLock), (Throwable)ex);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        block3: {
            if (e.getSource() instanceof Delete) {
                String entityNumber = null;
                try {
                    Object analysisModelId = this.getView().getFormShowParameter().getCustomParam("analysis_model");
                    DynamicObject analysisModelObj = BusinessDataServiceHelper.loadSingle((Object)analysisModelId, (String)"pa_analysismodel");
                    entityNumber = AnalysisModelUtil.buildDetailEntityNumber((String)analysisModelObj.getString("tablenumber"));
                    DLock.forceUnlock((String[])new String[]{DLockHelper.getMLockKey((String)entityNumber)});
                }
                catch (Exception ex) {
                    log.error("FAFDynamicBuildMetaListPlugin after delete data error", (Throwable)ex);
                    if (entityNumber == null) break block3;
                    DLock.forceUnlock((String[])new String[]{DLockHelper.getMLockKey(entityNumber)});
                }
            }
        }
    }

    private boolean hasOperatePermission(String operateKey) {
        List unionAppPermissionList;
        long userId = RequestContext.get().getCurrUserId();
        if (PermissionServiceHelper.isSuperUser((long)userId)) {
            return true;
        }
        String permissionPk = null;
        String msgIfNoPermission = null;
        if ("importdata".equals(operateKey) || "importdetails".equals(operateKey)) {
            permissionPk = "3KARYJAP3HYW";
            msgIfNoPermission = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6570\u636e\u8865\u5f55\u7684\u5bfc\u5165\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6dfb\u52a0\u6743\u9650\u3002", (String)"FAFDynamicBuildMetaListPlugin_1", (String)"macc-faf-formplugin", (Object[])new Object[0]);
        } else if ("exportlist".equals(operateKey) || "exportdetails".equals(operateKey) || "exportlist_expt".equals(operateKey)) {
            permissionPk = "3KAS06ROI392";
            msgIfNoPermission = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6570\u636e\u8865\u5f55\u7684\u67e5\u8be2\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6dfb\u52a0\u6743\u9650\u3002", (String)"FAFDynamicBuildMetaListPlugin_2", (String)"macc-faf-formplugin", (Object[])new Object[0]);
        } else if ("delete".equals(operateKey)) {
            permissionPk = "3KAS2BWOHZ7/";
            msgIfNoPermission = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6570\u636e\u8865\u5f55\u7684\u5220\u9664\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6dfb\u52a0\u6743\u9650\u3002", (String)"FAFDynamicBuildMetaListPlugin_3", (String)"macc-faf-formplugin", (Object[])new Object[0]);
        }
        if (permissionPk != null && ((unionAppPermissionList = BusinessPermissionHelper.getUnionAppPermissionList((Long)userId, (String)"pa_anasystemsetting", (String)permissionPk)) == null || unionAppPermissionList.isEmpty())) {
            this.getView().showTipNotification(msgIfNoPermission);
            return false;
        }
        return true;
    }
}

