/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.system;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.BasedataItem;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.QueryImportBasedataEventArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.plugin.Plugin;
import kd.bos.entity.property.DecimalProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.operate.imptapi.RowMapper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.faf.bservice.check.DataCheckBusinessHelper;
import kd.macc.faf.bservice.check.DataCheckRunModeEnum;
import kd.macc.faf.enums.DimensionNecessityEnum;
import kd.macc.faf.enums.DimensionTypeEnum;
import kd.macc.faf.enums.EnableStatusEnum;
import kd.macc.faf.enums.ImportSystemSourceTypeEnum;
import kd.macc.faf.enums.MeasureTypeEnum;
import kd.macc.faf.service.PeriodServiceHelper;
import kd.macc.faf.service.bean.PeriodCtrlResult;
import kd.macc.faf.util.BusinessPermissionHelper;
import kd.macc.faf.util.DataAdjustUtils;
import kd.macc.faf.util.ScriptBuilder;
import kd.macc.faf.util.ScriptEngine;

public class FAFDynamicMetaImportPlugin
extends AbstractBasePlugIn {
    private static final Log logger = LogFactory.getLog(FAFDynamicMetaImportPlugin.class);
    private Map<String, ThreeTuple<String, String, QFilter>> fieldInfoMap;
    private List<String> epmColumnList;
    private List<String> bcmColumnList;
    private String orgField;
    private List<Long> permissionOrgIds;
    private boolean isSuperUser;
    private String accountField;
    private String periodField;
    private boolean needCheckPeriod;
    private boolean isPeriodBaseData;
    private boolean isPeriodDateType;
    private Long analysisModelId;
    private static final String commonDimension = "common";
    private static final String requiredDimension = "required";
    private static final String ordinaryMeasure = "ordinary";
    private static final String calculationMeasure = "calculation";
    private Map<Long, List<DynamicObject>> dataCheckRuleListGroupByOrgId = new HashMap<Long, List<DynamicObject>>(2);
    private Map<String, Map<Object, Object>> fieldDataCache = new HashMap<String, Map<Object, Object>>(2);

    public void initImportData(InitImportDataEventArgs e) {
        this.initFieldAndFilterMap();
        if (this.fieldInfoMap == null) {
            return;
        }
        ThreeTuple<String, String, QFilter> periodTuple = this.fieldInfoMap.get(this.periodField);
        ThreeTuple<String, String, QFilter> accountTuple = this.fieldInfoMap.get(this.accountField);
        if (periodTuple == null || accountTuple == null) {
            return;
        }
        List dataList = e.getSourceDataList();
        for (int sourceDataIndex = 0; sourceDataIndex < dataList.size(); ++sourceDataIndex) {
            Map rowData = (Map)dataList.get(sourceDataIndex);
            boolean atLeastOneOrdinaryMeasure = false;
            boolean existColumnIsUnQualified = false;
            Object orgValue = rowData.get(this.orgField);
            Long orgId = 0L;
            JSONObject orgPropAndValue = (JSONObject)orgValue;
            if (!this.isAllowInputField(this.orgField, orgPropAndValue, sourceDataIndex, e)) continue;
            String orgFieldValue = orgPropAndValue.getString(orgPropAndValue.getString("importprop"));
            if (orgFieldValue == null || orgFieldValue.isEmpty()) {
                e.addCancelMessage(Integer.valueOf(sourceDataIndex), Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u7ef4\u5ea6\u503c\u4e3a\u5fc5\u586b\uff1a%s", (String)"FAFDynamicMetaImportPlugin_0", (String)"macc-faf-formplugin", (Object[])new Object[0]), this.orgField));
                continue;
            }
            Long currentOrgId = this.getMatchTypeBaseDataId(orgPropAndValue, this.orgField);
            if (currentOrgId == null) {
                e.addCancelMessage(Integer.valueOf(sourceDataIndex), Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u7ec4\u7ec7\u7f16\u53f7\u6ca1\u6709\u5bfc\u5165\u6743\u9650\uff1a%s\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6dfb\u52a0\u6743\u9650\u3002", (String)"FAFDynamicMetaImportPlugin_11", (String)"macc-faf-formplugin", (Object[])new Object[0]), orgFieldValue));
                continue;
            }
            orgId = currentOrgId;
            Object accountValue = rowData.get(this.accountField);
            JSONObject accountPropAndValue = (JSONObject)accountValue;
            if (!this.isAllowInputField(this.accountField, accountPropAndValue, sourceDataIndex, e)) continue;
            String accountFieldValue = accountPropAndValue.getString(accountPropAndValue.getString("importprop"));
            if (accountFieldValue == null || accountFieldValue.isEmpty()) {
                e.addCancelMessage(Integer.valueOf(sourceDataIndex), Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u7ef4\u5ea6\u503c\u4e3a\u5fc5\u586b\uff1a%s", (String)"FAFDynamicMetaImportPlugin_0", (String)"macc-faf-formplugin", (Object[])new Object[0]), this.accountField));
                continue;
            }
            Object periodValue = rowData.get(this.periodField);
            Long periodId = 0L;
            if (this.isPeriodBaseData) {
                JSONObject periodPropAndValue = (JSONObject)periodValue;
                if (!this.isAllowInputField(this.periodField, periodPropAndValue, sourceDataIndex, e)) continue;
                String periodFieldValue = periodPropAndValue.getString(periodPropAndValue.getString("importprop"));
                if (periodFieldValue == null || periodFieldValue.isEmpty()) {
                    e.addCancelMessage(Integer.valueOf(sourceDataIndex), Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u7ef4\u5ea6\u503c\u4e3a\u5fc5\u586b\uff1a%s", (String)"FAFDynamicMetaImportPlugin_0", (String)"macc-faf-formplugin", (Object[])new Object[0]), this.periodField));
                    continue;
                }
                Long currentRowPeriodId = this.getMatchTypeBaseDataId(periodPropAndValue, this.periodField);
                if (currentRowPeriodId == null) {
                    e.addCancelMessage(Integer.valueOf(sourceDataIndex), Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u671f\u95f4\u7f16\u53f7\u6ca1\u6709\u5339\u914d\u7684\u6570\u636e\uff1a%s", (String)"FAFDynamicMetaImportPlugin_1", (String)"macc-faf-formplugin", (Object[])new Object[0]), periodFieldValue));
                    continue;
                }
                DynamicObject periodObj = BusinessDataServiceHelper.loadSingleFromCache((Object)currentRowPeriodId, (String)((String)periodTuple.item1), (String)"enddate");
                if (periodObj != null && !"pa_account".equals(accountTuple.item1) && this.getVersionAccount(accountFieldValue, (QFilter)accountTuple.item3, currentOrgId, periodObj.getDate("enddate")) == null) {
                    e.addCancelMessage(Integer.valueOf(sourceDataIndex), Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u5728\u4f1a\u8ba1\u671f\u95f4\uff1a%1$s\u4e2d\u627e\u4e0d\u5230\u6709\u6548\u7684\u4f1a\u8ba1\u79d1\u76ee\u7f16\u53f7\uff1a%2$s\u3002", (String)"FAFDynamicMetaImportPlugin_2", (String)"macc-faf-formplugin", (Object[])new Object[0]), periodFieldValue, accountFieldValue));
                    continue;
                }
                periodId = currentRowPeriodId;
                if (this.needCheckPeriod) {
                    ArrayList orgAndPeriodList = new ArrayList(1);
                    HashMap<Long, Long> mp = new HashMap<Long, Long>(1);
                    mp.put(currentOrgId, currentRowPeriodId);
                    orgAndPeriodList.add(mp);
                    PeriodCtrlResult data = PeriodServiceHelper.checkPeriodOrgTuple((long)this.analysisModelId, orgAndPeriodList, (boolean)true);
                    logger.info(String.format("FAFDynamicMetaImportPlugin initImportData current period status : %s, current batch sourceDataIndex : %d", data != null ? JSON.toJSONString((Object)data) : "period manage is null", sourceDataIndex));
                    if (data != null && !data.isSuccess()) {
                        e.addCancelMessage(Integer.valueOf(sourceDataIndex), Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u5904\u4e8e\u5173\u95ed\u72b6\u6001\uff0c\u8bf7\u5230\u3010\u57fa\u7840\u8bbe\u7f6e\u3011-\u3010\u671f\u95f4\u7ba1\u7406\u3011\u6253\u5f00\u671f\u95f4", (String)"FAFDynamicMetaImportPlugin_8", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                        continue;
                    }
                }
            } else if (this.isPeriodDateType) {
                Object periodDate = rowData.get(this.periodField);
                if (periodDate == null) {
                    e.addCancelMessage(Integer.valueOf(sourceDataIndex), Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u7ef4\u5ea6\u503c\u4e3a\u5fc5\u586b\uff1a%s", (String)"FAFDynamicMetaImportPlugin_0", (String)"macc-faf-formplugin", (Object[])new Object[0]), this.periodField));
                    continue;
                }
                Date currentRowPeriodDate = null;
                try {
                    currentRowPeriodDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(periodDate.toString());
                }
                catch (ParseException exc) {
                    logger.error(String.format("FAFDynamicMetaImportPlugin initImportData current period %s, convert to date error", periodDate.toString()), (Throwable)exc);
                }
                if (this.getVersionAccount(accountFieldValue, (QFilter)accountTuple.item3, currentOrgId, currentRowPeriodDate) == null && !"pa_account".equals(accountTuple.item1)) {
                    e.addCancelMessage(Integer.valueOf(sourceDataIndex), Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u5728\u4f1a\u8ba1\u671f\u95f4\uff1a%1$s\u4e2d\u627e\u4e0d\u5230\u6709\u6548\u7684\u4f1a\u8ba1\u79d1\u76ee\u7f16\u53f7\uff1a%2$s\u3002", (String)"FAFDynamicMetaImportPlugin_2", (String)"macc-faf-formplugin", (Object[])new Object[0]), periodDate.toString(), accountFieldValue));
                    continue;
                }
            }
            for (Map.Entry entry : rowData.entrySet()) {
                String key = ((String)entry.getKey()).trim().toLowerCase();
                if (key.equalsIgnoreCase(this.orgField) || key.equalsIgnoreCase(this.periodField) || key.equalsIgnoreCase(this.accountField)) continue;
                Object value = entry.getValue();
                if ("rowNum".equalsIgnoreCase(key) || "_dindex_".equalsIgnoreCase(key)) continue;
                ThreeTuple<String, String, QFilter> threeTuple = this.fieldInfoMap.get(key);
                if (threeTuple == null) {
                    logger.info("FAFDynamicMetaImportPlugin initImportData no match field, fieldInfoMap : %s, key : %s", (Object)JSON.toJSONString(this.fieldInfoMap), (Object)key);
                    continue;
                }
                String fieldType = (String)threeTuple.item2;
                if (value instanceof JSONObject) {
                    if (this.isAllowInputField(key, (JSONObject)value, sourceDataIndex, e)) continue;
                    existColumnIsUnQualified = true;
                    break;
                }
                logger.info("FAFDynamicMetaImportPlugin initImportData fieldType : %s, value : %s", (Object)fieldType, (Object)String.valueOf(value));
                if (!ordinaryMeasure.equals(fieldType) || value == null) continue;
                atLeastOneOrdinaryMeasure = true;
            }
            if (!existColumnIsUnQualified && !atLeastOneOrdinaryMeasure) {
                e.addCancelMessage(Integer.valueOf(sourceDataIndex), Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u81f3\u5c11\u9700\u8981\u6307\u5b9a\u4e00\u4e2a\u666e\u901a\u578b\u5ea6\u91cf\u503c", (String)"FAFDynamicMetaImportPlugin_3", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            }
            if (DataAdjustUtils.allowReCollectData((Long)this.analysisModelId, (Long)periodId, (Long)orgId)) continue;
            e.addCancelMessage(Integer.valueOf(sourceDataIndex), Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u5b58\u5728\u6d41\u7a0b\u4e2d\u7684\u672a\u6267\u884c\u8c03\u6574\u7684\u8c03\u6574\u5355\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u6570\u636e\u83b7\u53d6\u3002", (String)"FAFDynamicMetaImportPlugin_14", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean isAllowInputField(String key, JSONObject propAndValue, int sourceDataIndex, InitImportDataEventArgs e) {
        String importProp = propAndValue.getString("importprop");
        if (importProp != null) {
            String excelInputValue = propAndValue.getString(importProp);
            if (this.epmColumnList != null && this.epmColumnList.contains(key) && excelInputValue != null && !String.valueOf(excelInputValue).isEmpty()) {
                e.addCancelMessage(Integer.valueOf(sourceDataIndex), Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u5206\u6790\u6a21\u578b\u4e0d\u652f\u6301\u76f4\u63a5\u5bfc\u5165\u661f\u701a\u9884\u7b97\u6570\u636e\uff0c\u8bf7\u901a\u8fc7\u6570\u636e\u83b7\u53d6\u529f\u80fd\u6765\u83b7\u53d6\u6570\u636e\u3002", (String)"FAFDynamicMetaImportPlugin_9", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (this.bcmColumnList != null && this.bcmColumnList.contains(key) && excelInputValue != null && !String.valueOf(excelInputValue).isEmpty()) {
                e.addCancelMessage(Integer.valueOf(sourceDataIndex), Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u5206\u6790\u6a21\u578b\u4e0d\u652f\u6301\u76f4\u63a5\u5bfc\u5165\u661f\u701a\u5408\u5e76\u6570\u636e\uff0c\u8bf7\u901a\u8fc7\u6570\u636e\u83b7\u53d6\u529f\u80fd\u6765\u83b7\u53d6\u6570\u636e\u3002", (String)"FAFDynamicMetaImportPlugin_10", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        if (this.fieldInfoMap == null) {
            return;
        }
        Set keySet = e.getSourceData().keySet();
        if (!keySet.contains("importbatch")) {
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u6a21\u677f\u5b57\u6bb5\u4e0d\u5141\u8bb8\u5220\u9664\uff0c\u8bf7\u8fd8\u539f\uff1a%s", (String)"FAFDynamicMetaImportPlugin_4", (String)"macc-faf-formplugin", (Object[])new Object[0]), "importbatch"));
            e.setCancel(true);
            return;
        }
        List<String> backGroundColumnList = Arrays.asList("operationstatus", "datastatus", "del", "collectstatus", "situationtype", "offstatus", "createtime", "id", "summaryid", "sourceformid", "sourcebillid", "execlogid", "subexeclogid", "execparentbillid");
        StringBuilder addedBackGroundFieldBuilder = new StringBuilder();
        StringBuilder calculatedMeasureAddedBuilder = new StringBuilder();
        StringBuilder necessityDeletedBuilder = new StringBuilder();
        HashSet<String> calculatedMeasureSet = new HashSet<String>(1);
        for (Map.Entry<String, ThreeTuple<String, String, QFilter>> entry : this.fieldInfoMap.entrySet()) {
            String field = entry.getKey();
            String type = (String)entry.getValue().item2;
            if (calculationMeasure.equals(type)) {
                calculatedMeasureSet.add(field);
            }
            if (!requiredDimension.equals(type) || keySet.contains(field)) continue;
            necessityDeletedBuilder.append(',').append(field);
        }
        for (String key : keySet) {
            if (backGroundColumnList.contains(key)) {
                addedBackGroundFieldBuilder.append(',').append(key);
            }
            if (!calculatedMeasureSet.contains(key)) continue;
            calculatedMeasureAddedBuilder.append(',').append(key);
        }
        if (necessityDeletedBuilder.length() > 0 || addedBackGroundFieldBuilder.length() > 0 || calculatedMeasureAddedBuilder.length() > 0) {
            if (necessityDeletedBuilder.length() > 0) {
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u7ef4\u5ea6\u4e3a\u6a21\u578b\u5fc5\u8981\u7ef4\u5ea6\uff0c\u8bf7\u6dfb\u52a0\u81f3\u6a21\u677f\u4e2d\uff1a%s", (String)"FAFDynamicMetaImportPlugin_5", (String)"macc-faf-formplugin", (Object[])new Object[0]), necessityDeletedBuilder.substring(1)));
            }
            if (addedBackGroundFieldBuilder.length() > 0) {
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u540e\u53f0\u5b57\u6bb5\u4e0d\u5141\u8bb8\u6307\u5b9a\uff0c\u8bf7\u4fee\u6539\uff1a%s", (String)"FAFDynamicMetaImportPlugin_6", (String)"macc-faf-formplugin", (Object[])new Object[0]), addedBackGroundFieldBuilder.substring(1)));
            }
            if (calculatedMeasureAddedBuilder.length() > 0) {
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u8ba1\u7b97\u578b\u5ea6\u91cf\u4e0d\u5141\u8bb8\u6307\u5b9a\uff0c\u8bf7\u4fee\u6539\uff1a%s", (String)"FAFDynamicMetaImportPlugin_7", (String)"macc-faf-formplugin", (Object[])new Object[0]), calculatedMeasureAddedBuilder.substring(1)));
            }
            e.setCancel(true);
        }
    }

    public void queryImportBasedata(QueryImportBasedataEventArgs e) {
        if (this.fieldInfoMap != null) {
            Map searchResult = e.getSearchResult();
            Long orgId = null;
            ThreeTuple<String, String, QFilter> periodTuple = this.fieldInfoMap.get(this.periodField);
            for (Map.Entry entry : searchResult.entrySet()) {
                Map bsdMap;
                ThreeTuple<String, String, QFilter> fieldAndFilterTuple;
                List idList;
                String fieldKey = ((BasedataItem)entry.getKey()).getFieldKey();
                if (fieldKey.equals(this.orgField) || this.epmColumnList != null && this.epmColumnList.contains(fieldKey) || this.bcmColumnList != null && this.bcmColumnList.contains(fieldKey) || (idList = (List)entry.getValue()).isEmpty() || (fieldAndFilterTuple = this.fieldInfoMap.get(fieldKey)) == null) continue;
                String entityNumber = (String)fieldAndFilterTuple.item1;
                QFilter baseFilter = (QFilter)fieldAndFilterTuple.item3;
                if (baseFilter != null) {
                    List<Object> objIdList = this.getIdByBaseFilter(entityNumber, idList, baseFilter);
                    if (objIdList.isEmpty()) {
                        idList.clear();
                    } else if (objIdList.size() == 1) {
                        idList.clear();
                        idList.add(objIdList.get(0));
                    }
                }
                if (idList.size() <= 1) continue;
                if (orgId == null) {
                    Object propAndValueObj = ((RowMapper)e.getSource()).getSourceObj().get(this.orgField);
                    orgId = this.getMatchTypeBaseDataId((JSONObject)propAndValueObj, this.orgField);
                }
                if (orgId == null) continue;
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                String primaryKey = dataEntityType.getPrimaryKey().getName();
                QFilter filter = new QFilter(primaryKey, "in", (Object)idList);
                if (dataEntityType.getProperty("enable") != null) {
                    filter.and(new QFilter("enable", "=", (Object)EnableStatusEnum.enable.getCodeString()));
                }
                if ((bsdMap = BaseDataServiceHelper.queryBaseDataFromCache((String)entityNumber, (Long)orgId, (QFilter)filter, (String)primaryKey)) != null && bsdMap.size() > 0) {
                    idList.clear();
                    idList.addAll(bsdMap.keySet());
                }
                if (idList.size() <= 1 || !fieldKey.equals(this.accountField)) continue;
                Long matchVersionAccount = null;
                Map sourceObj = ((RowMapper)e.getSource()).getSourceObj();
                JSONObject accountPropAndValue = (JSONObject)sourceObj.get(this.accountField);
                String accountNumber = accountPropAndValue.getString(accountPropAndValue.getString("importprop"));
                if (this.isPeriodBaseData) {
                    DynamicObject periodObj;
                    JSONObject periodPropAndValue = (JSONObject)sourceObj.get(this.periodField);
                    Long periodId = this.getMatchTypeBaseDataId(periodPropAndValue, this.periodField);
                    if (periodId != null && periodTuple != null && (periodObj = BusinessDataServiceHelper.loadSingleFromCache((Object)periodId, (String)((String)periodTuple.item1), (String)"enddate")) != null) {
                        matchVersionAccount = this.getVersionAccount(accountNumber, baseFilter, orgId, periodObj.getDate("enddate"));
                    }
                } else if (this.isPeriodDateType) {
                    String periodNumber = String.valueOf(sourceObj.get(this.periodField));
                    Date periodDate = null;
                    try {
                        periodDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(periodNumber);
                    }
                    catch (ParseException exc) {
                        logger.error(String.format("FAFDynamicMetaImportPlugin queryImportBaseData current period %s, convert to date error", periodNumber), (Throwable)exc);
                    }
                    matchVersionAccount = this.getVersionAccount(accountNumber, baseFilter, orgId, periodDate);
                }
                idList.clear();
                if (matchVersionAccount == null) continue;
                idList.add(matchVersionAccount);
            }
        }
    }

    public void afterImportData(ImportDataEventArgs eventArgs) {
        Tuple<Boolean, List<String>> checkResult;
        super.afterImportData(eventArgs);
        try {
            checkResult = this.validatedByDataCheckRule((BillModel)eventArgs.getSource());
        }
        catch (Exception exception) {
            throw new KDBizException(new ErrorCode("", exception.getMessage()), new Object[]{exception.getMessage(), exception});
        }
        if (Boolean.FALSE.equals(checkResult.item1)) {
            eventArgs.setCancel(true);
            eventArgs.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), (List)checkResult.item2);
        }
    }

    private Tuple<Boolean, List<String>> validatedByDataCheckRule(BillModel model) {
        List<DynamicObject> ruleList = this.getDataCheckRulesOfCurrentModel(model, this.orgField);
        if (!CollectionUtils.isEmpty(ruleList)) {
            ArrayList<Object> errorMessageList = new ArrayList<Object>(1);
            for (DynamicObject dataCheckRule : ruleList) {
                Tuple<Boolean, String> checkResult = this.dataCheck(model, dataCheckRule);
                if (!Boolean.FALSE.equals(checkResult.item1)) continue;
                errorMessageList.add(checkResult.item2);
            }
            if (!CollectionUtils.isEmpty(errorMessageList)) {
                return new Tuple((Object)Boolean.FALSE, errorMessageList);
            }
        }
        return new Tuple((Object)Boolean.TRUE, null);
    }

    private Tuple<Boolean, String> dataCheck(BillModel model, DynamicObject dataCheckRule) {
        DynamicObjectCollection checkConditionEntry = dataCheckRule.getDynamicObjectCollection("entryentity");
        MainEntityType entityType = (MainEntityType)model.getDataEntity().getDataEntityType();
        for (int i = 0; i < checkConditionEntry.size(); ++i) {
            DynamicObject checkCondition = (DynamicObject)checkConditionEntry.get(i);
            if (!checkCondition.getBoolean("checked") || !"3".equals(checkCondition.getString("promptmode"))) continue;
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)checkCondition.getString("checkcondition_tag"), FilterCondition.class);
            String script = new ScriptBuilder(entityType, filterCondition).buildScript().getValue();
            Object result = ScriptEngine.getEngine().runScript(script, this.buildScriptParameterMap(model, filterCondition));
            if (!(result instanceof Boolean) || !Boolean.TRUE.equals(result)) continue;
            String tipsText = checkCondition.getString("tipstext");
            String errorMessage = StringUtils.isNotEmpty((String)tipsText) ? String.format(ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3\u6821\u9a8c\u89c4\u5219:%1$s\u4e2d\u7684\u7b2c%2$s\u884c\u6821\u9a8c\u6761\u4ef6\uff0c\u63d0\u793a\u4fe1\u606f\uff1a%3$s", (String)"FAFDynamicMetaImportPlugin_13", (String)"macc-faf-formplugin", (Object[])new Object[0]), dataCheckRule.getString("number"), i + 1, tipsText) : String.format(ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3\u6821\u9a8c\u89c4\u5219:%1$s\u4e2d\u7684\u7b2c%2$s\u884c\u6821\u9a8c\u6761\u4ef6", (String)"FAFDynamicMetaImportPlugin_12", (String)"macc-faf-formplugin", (Object[])new Object[0]), dataCheckRule.getString("number"), i + 1);
            return new Tuple((Object)Boolean.FALSE, (Object)errorMessage);
        }
        return new Tuple((Object)Boolean.TRUE, (Object)"");
    }

    private Map<String, Object> buildScriptParameterMap(BillModel model, FilterCondition filterCondition) {
        HashMap<String, Object> parameterMap = new HashMap<String, Object>(2);
        for (SimpleFilterRow simpleFilterRow : filterCondition.getFilterRow()) {
            String fieldName = simpleFilterRow.getFieldName();
            boolean isBaseData = fieldName.contains(".");
            ThreeTuple<String, String, QFilter> fieldInfo = this.fieldInfoMap.get(isBaseData ? fieldName.split("\\.")[0] : fieldName);
            Object value = null;
            if (isBaseData) {
                String varField;
                DynamicObject dynamicObject;
                Object pkId = model.getValue(fieldName.split("\\.")[0] + "_id");
                Map<Object, Object> fieldDataCacheMap = this.fieldDataCache.get(fieldName);
                if (fieldDataCacheMap != null) {
                    value = fieldDataCacheMap.get(pkId);
                }
                if (value == null && (dynamicObject = QueryServiceHelper.queryOne((String)((String)fieldInfo.item1), (String)(varField = fieldName.substring(fieldName.indexOf(".") + 1)), (QFilter[])new QFilter("id", "=", pkId).toArray())) != null) {
                    value = dynamicObject.get(varField);
                    if (fieldDataCacheMap == null) {
                        this.fieldDataCache.put(fieldName, new HashMap());
                        fieldDataCacheMap = this.fieldDataCache.get(fieldName);
                    }
                    fieldDataCacheMap.putIfAbsent(pkId, value);
                }
            } else {
                value = model.getValue(fieldName);
                DataEntityPropertyCollection properties = model.getDataEntity().getDataEntityType().getProperties();
                value = this.convertValue(value, (IDataEntityProperty)properties.get((Object)fieldName));
            }
            parameterMap.put(fieldName, value);
        }
        return parameterMap;
    }

    private Object convertValue(Object value, IDataEntityProperty iDataEntityProperty) {
        Object convertValue = value instanceof String && "".equals(value) ? null : (iDataEntityProperty instanceof DecimalProp && value == null ? BigDecimal.ZERO : value);
        return convertValue;
    }

    private List<DynamicObject> getDataCheckRulesOfCurrentModel(BillModel model, String orgField) {
        Object[] dataCheckRuleIdList;
        Long orgId = ((DynamicObject)model.getValue(orgField)).getLong("id");
        if (!this.dataCheckRuleListGroupByOrgId.containsKey(orgId) && ArrayUtils.isNotEmpty((Object[])(dataCheckRuleIdList = DataCheckBusinessHelper.queryCheckRuleDynamicObjectList((Long)this.analysisModelId, (Long)orgId, (String)DataCheckRunModeEnum.AUTO_BY_REPLENISH_DATA.getCode())))) {
            this.dataCheckRuleListGroupByOrgId.put(orgId, Arrays.asList(dataCheckRuleIdList));
        }
        return this.dataCheckRuleListGroupByOrgId.get(orgId);
    }

    private Long getMatchTypeBaseDataId(JSONObject propAndValue, String field) {
        DynamicObject dynObj;
        String fieldProp = propAndValue.getString("importprop");
        if (fieldProp == null || fieldProp.isEmpty()) {
            return null;
        }
        String fieldValue = propAndValue.getString(fieldProp);
        if (fieldValue == null || fieldValue.isEmpty()) {
            return null;
        }
        QFilter fieldFilter = new QFilter(fieldProp, "=", (Object)fieldValue);
        ThreeTuple<String, String, QFilter> fieldAndFilterTuple = this.fieldInfoMap.get(field);
        if (fieldAndFilterTuple == null) {
            return null;
        }
        String entity = (String)fieldAndFilterTuple.item1;
        QFilter typeFilter = (QFilter)fieldAndFilterTuple.item3;
        if (typeFilter != null) {
            fieldFilter.and(typeFilter);
        }
        String primaryField = EntityMetadataCache.getDataEntityType((String)entity).getPrimaryKey().getName();
        if (field.equals(this.orgField) && !this.isSuperUser) {
            if (this.permissionOrgIds != null && !this.permissionOrgIds.isEmpty()) {
                fieldFilter.and(primaryField, "in", this.permissionOrgIds);
            } else {
                fieldFilter.and(primaryField, "=", (Object)-1L);
            }
        }
        if ((dynObj = BusinessDataServiceHelper.loadSingleFromCache((String)entity, (String)primaryField, (QFilter[])fieldFilter.toArray())) != null) {
            return dynObj.getLong(primaryField);
        }
        return null;
    }

    private List<Object> getIdByBaseFilter(String entityNumber, List<Object> idList, QFilter baseFilter) {
        QFilter filter = new QFilter("id", "in", idList).and(baseFilter);
        return QueryServiceHelper.queryPrimaryKeys((String)entityNumber, (QFilter[])filter.toArray(), null, (int)-1);
    }

    private void initFieldAndFilterMap() {
        String field;
        if (this.fieldInfoMap != null) {
            return;
        }
        List plugins = this.getView().getFormShowParameter().getFormConfig().getPlugins();
        if (plugins == null || plugins.isEmpty()) {
            return;
        }
        String scriptNumber = ((Plugin)plugins.get(0)).getScriptNumber();
        if (scriptNumber == null || scriptNumber.isEmpty()) {
            return;
        }
        this.analysisModelId = Long.parseLong(scriptNumber);
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)this.analysisModelId, (String)"pa_analysismodel");
        if (obj == null) {
            return;
        }
        DynamicObjectCollection dimensionCol = obj.getDynamicObjectCollection("dimension_entry");
        DynamicObjectCollection measureCol = obj.getDynamicObjectCollection("measure_entry");
        this.fieldInfoMap = new HashMap<String, ThreeTuple<String, String, QFilter>>(dimensionCol.size() + measureCol.size());
        for (DynamicObject dimensionRow : dimensionCol) {
            String type;
            DynamicObject dimension = dimensionRow.getDynamicObject("dimension");
            if (dimension == null) continue;
            field = dimension.getString("number").trim().toLowerCase();
            String necessityDim = dimensionRow.getString("necessity_dim");
            DimensionTypeEnum dimensionType = DimensionTypeEnum.getEnum((String)dimension.getString("dimensiontype"));
            DynamicObject dimensionSource = (DynamicObject)dimension.get("dimensionsource");
            String entityNumber = dimensionSource != null ? dimensionSource.getString("number") : null;
            String string = type = necessityDim != null && !necessityDim.isEmpty() ? requiredDimension : commonDimension;
            if (ImportSystemSourceTypeEnum.EPM.getCode().equals(dimension.getString("systemsource"))) {
                if (this.epmColumnList == null) {
                    this.epmColumnList = new ArrayList<String>(1);
                }
                this.epmColumnList.add(field);
            }
            if (ImportSystemSourceTypeEnum.BCM.getCode().equals(dimension.getString("systemsource"))) {
                if (this.bcmColumnList == null) {
                    this.bcmColumnList = new ArrayList<String>(1);
                }
                this.bcmColumnList.add(field);
            }
            QFilter qfilter = null;
            if (necessityDim != null && !necessityDim.isEmpty()) {
                if (DimensionNecessityEnum.ORG.getCode().equals(necessityDim)) {
                    this.orgField = field;
                } else if (DimensionNecessityEnum.PERIOD.getCode().equals(necessityDim)) {
                    this.periodField = field;
                    if (DimensionTypeEnum.DATABASE == dimensionType || DimensionTypeEnum.PERIOD == dimensionType) {
                        this.isPeriodBaseData = true;
                        if ("bd_period".equals(entityNumber) || "pa_analysisperiod".equals(entityNumber)) {
                            this.needCheckPeriod = true;
                        }
                    }
                    if (DimensionTypeEnum.DATE == dimensionType) {
                        this.isPeriodDateType = true;
                    }
                } else if (DimensionNecessityEnum.ACCOUNT.getCode().equals(necessityDim)) {
                    this.accountField = field;
                }
            }
            if (DimensionTypeEnum.DATABASE == dimensionType) {
                String typeField = dimension.getString("typefield");
                Object groupId = dimension.get("group_id");
                if (StringUtils.isNotEmpty((String)typeField)) {
                    qfilter = new QFilter(typeField, "=", groupId);
                }
            } else if (DimensionTypeEnum.ASSISTANTDATA == dimensionType) {
                entityNumber = "bos_assistantdata_detail";
                Long groupId = (Long)dimension.get("assistantsource_id");
                qfilter = new QFilter("group", "=", (Object)groupId);
            }
            this.fieldInfoMap.put(field, (ThreeTuple<String, String, QFilter>)new ThreeTuple((Object)entityNumber, (Object)type, qfilter));
        }
        for (DynamicObject measureRow : measureCol) {
            DynamicObject measure = measureRow.getDynamicObject("measure");
            if (measure == null) continue;
            field = measure.getString("number").trim().toLowerCase();
            String measureType = measure.getString("measuretype");
            String type = String.valueOf(MeasureTypeEnum.ORDINARY.getCode()).equals(measureType) ? ordinaryMeasure : calculationMeasure;
            this.fieldInfoMap.put(field, (ThreeTuple<String, String, QFilter>)new ThreeTuple((Object)measure.getDataEntityType().getName(), (Object)type, null));
        }
        long currUserId = RequestContext.get().getCurrUserId();
        this.isSuperUser = PermissionServiceHelper.isSuperUser((long)currUserId);
        if (!this.isSuperUser) {
            this.permissionOrgIds = BusinessPermissionHelper.getUnionAppPermissionList((Long)currUserId, (String)"pa_anasystemsetting", (String)"3KARYJAP3HYW");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Long getVersionAccount(String accountNumber, QFilter accountTableFilter, Long orgId, Date periodEndDate) {
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgId);
        QFilter accountNumberFilter = new QFilter("number", "=", (Object)accountNumber);
        QFilter dateFilter = new QFilter("startdate", "<=", (Object)periodEndDate).and(new QFilter("enddate", ">=", (Object)periodEndDate));
        QFilter[] filters = new QFilter[]{orgFilter, accountTableFilter, accountNumberFilter, dateFilter};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"FAFDynamicMetaImportPlugin.getVersionAccount", (String)"bd_accountview", (String)"id", (QFilter[])filters, null);){
            if (dataSet == null) return null;
            if (!dataSet.hasNext()) return null;
            Long l = dataSet.next().getLong("id");
            return l;
        }
        catch (Exception ex) {
            logger.error("FAFDynamicMetaImportPlugin getVersionAccount error", (Throwable)ex);
        }
        return null;
    }
}

