/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.system;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import org.apache.commons.lang3.StringUtils;

public class FAFFieldselectPopupFormPlugin
extends AbstractFormPlugin
implements SearchEnterListener {
    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addClickListeners(new String[]{"btnok"});
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map availableFields = (Map)formShowParameter.getCustomParam("param_available_field");
        if (availableFields != null && !availableFields.isEmpty()) {
            for (Map.Entry field : availableFields.entrySet()) {
                int entryRow = model.createNewEntryRow("field_entry");
                model.setValue("name", field.getValue(), entryRow);
                model.setValue("number", field.getKey(), entryRow);
            }
        }
        this.getPageCache().put("selectFields", JSON.toJSONString((Object)availableFields, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        int entryRowCount = model.getEntryRowCount("field_entry");
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String hadSelectField = (String)fsp.getCustomParam("had_selectField");
        if (StringUtils.isNotEmpty((CharSequence)hadSelectField)) {
            HashSet<String> selectFieldSet = new HashSet<String>(Arrays.asList(hadSelectField.split(",")));
            EntryGrid entryGrid = (EntryGrid)this.getControl("field_entry");
            int[] selectIdx = new int[selectFieldSet.size()];
            int j = 0;
            for (int i = 0; i < entryRowCount; ++i) {
                if (!selectFieldSet.contains(model.getValue("number", i))) continue;
                selectIdx[j++] = i;
            }
            entryGrid.selectRows(selectIdx, 0);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        String key = ctl.getKey();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        switch (key) {
            case "btnok": {
                int entryRowCount = model.getEntryRowCount("field_entry");
                EntryGrid entry = (EntryGrid)this.getControl("field_entry");
                int[] selectRows = entry.getSelectRows();
                HashMap<String, String> choiceFields = new HashMap<String, String>(entryRowCount);
                for (int selectRow : selectRows) {
                    choiceFields.put(model.getValue("number", selectRow).toString(), model.getValue("name", selectRow).toString());
                }
                model.setDataChanged(false);
                view.returnDataToParent(choiceFields);
                view.close();
                break;
            }
        }
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        IDataModel model = this.getModel();
        model.deleteEntryData("field_entry");
        String selectFieldJson = this.getPageCache().get("selectFields");
        Map selectFieldMap = (Map)JSON.parseObject((String)selectFieldJson, LinkedHashMap.class);
        if (searchEnterEvent.getSearchFields() == null || searchEnterEvent.getSearchFields().isEmpty()) {
            for (Map.Entry entry : selectFieldMap.entrySet()) {
                int entryRow = model.createNewEntryRow("field_entry");
                model.setValue("name", entry.getValue(), entryRow);
                model.setValue("number", entry.getKey(), entryRow);
            }
        } else {
            ArrayList searchValues = (ArrayList)((Map)searchEnterEvent.getSearchFields().get(0)).get("value");
            for (String searchValue : searchValues) {
                for (Map.Entry field : selectFieldMap.entrySet()) {
                    if (!((String)field.getValue()).contains(searchValue)) continue;
                    int entryRow = model.createNewEntryRow("field_entry");
                    model.setValue("name", field.getValue(), entryRow);
                    model.setValue("number", field.getKey(), entryRow);
                }
            }
        }
    }
}

