/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.system;

import com.alibaba.fastjson.JSON;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.macc.faf.dto.FAFMappingDimensionDTO;
import kd.macc.faf.dto.MappingDataUploadDTO;
import kd.macc.faf.dto.MappingRelationExcelCellStyleBuilder;
import kd.macc.faf.enums.DimensionTypeEnum;
import kd.macc.faf.enums.MappingUploadStatusEnum;
import kd.macc.faf.enums.RelationShipMappingDimensionEnum;
import kd.macc.faf.helper.FAFDimensionHelper;
import kd.macc.faf.helper.FAFMappingRelationShipDataHelper;
import kd.macc.faf.system.FAFAnalysisSystemConfigEdit;
import kd.macc.faf.system.FAFMappingUploadResultFormPlugin;
import kd.macc.faf.util.CRC32CodeUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.poi.hssf.usermodel.HSSFDataValidation;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class FAFMappingRelationshipConfigEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
UploadListener {
    private static final Log logger = LogFactory.getLog(FAFMappingRelationshipConfigEdit.class);
    private static final String SUB_PAGE_ID = "subPageId";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String SUB_PAGE_ENTRY_ENTITY = "entryentity";
    private final String[] flex_base = new String[]{"number", "anasystem", "sourcedim", "targetdim"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        MulBasedataEdit sourceDim = (MulBasedataEdit)this.getControl("sourcedim");
        MulBasedataEdit targetDim = (MulBasedataEdit)this.getControl("targetdim");
        sourceDim.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        targetDim.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"sourcedim", "targetdim"});
        this.addItemClickListeners(new String[]{"downloadtemplate", "download"});
        Toolbar toolbar = (Toolbar)this.getControl("tbmain");
        toolbar.addUploadListener((UploadListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long anaSystemId = (Long)this.getView().getFormShowParameter().getCustomParam("anaSystemId");
        if (anaSystemId != null && anaSystemId > 0L) {
            this.getModel().setValue("anasystem", (Object)anaSystemId);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Long anaSystemId = (Long)this.getView().getFormShowParameter().getCustomParam("anaSystemId");
        if (anaSystemId != null && anaSystemId > 0L) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"anasystem"});
        }
        this.initMappingRelationShipSubPage();
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        if (pkValue > 0L && BaseDataRefrenceHelper.isRefrenced((String)"pa_mappingrelationship", (Object)pkValue)) {
            this.getView().setEnable(Boolean.FALSE, this.flex_base);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if ("sourcedim".equals(propertyName) || "targetdim".equals(propertyName)) {
            IDataModel subPageModel = this.getSubPageModel();
            if (subPageModel == null) {
                return;
            }
            if (this.validateSourceAndTargetDimension()) {
                this.initMappingRelationShipSubPage();
            } else {
                this.getModel().beginInit();
                this.getModel().setValue(propertyName, e.getChangeSet()[0].getOldValue());
                this.getModel().endInit();
                this.getView().updateView(propertyName);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6e90\u7ef4\u5ea6\u4e0e\u76ee\u6807\u7ef4\u5ea6\u5b8c\u5168\u76f8\u540c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"FAFMappingRelationshipConfigEdit_17", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            }
        } else if ("anasystem".equals(propertyName)) {
            this.getModel().setValue("sourcedim", null);
            this.getModel().setValue("targetdim", null);
        }
    }

    private boolean validateSourceAndTargetDimension() {
        List sourceDimensionList = FAFMappingRelationShipDataHelper.getDimensionList((IDataModel)this.getModel(), (RelationShipMappingDimensionEnum)RelationShipMappingDimensionEnum.SOURCE);
        List targetDimensionList = FAFMappingRelationShipDataHelper.getDimensionList((IDataModel)this.getModel(), (RelationShipMappingDimensionEnum)RelationShipMappingDimensionEnum.TARGET);
        if (CollectionUtils.isEmpty((Collection)sourceDimensionList) || CollectionUtils.isEmpty((Collection)targetDimensionList)) {
            return true;
        }
        List sourceDimensionIds = sourceDimensionList.stream().map(FAFMappingDimensionDTO::getPkId).collect(Collectors.toList());
        List targetDimensionIds = targetDimensionList.stream().map(FAFMappingDimensionDTO::getPkId).collect(Collectors.toList());
        return sourceDimensionIds.size() != targetDimensionIds.size() || !sourceDimensionIds.containsAll(targetDimensionIds);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("save".equals(operateKey)) {
            if (this.isReferencedAndChangeBaseData()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6620\u5c04\u5173\u7cfb\u88ab\u5f15\u7528\uff0c\u4e0d\u80fd\u4fee\u6539\u57fa\u672c\u4fe1\u606f\u3002", (String)"FAFMappingRelationshipConfigEdit_18", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            IDataModel subPageModel = this.getSubPageModel();
            if (subPageModel == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6620\u5c04\u503c\u5206\u5f55\u4e0d\u5b58\u5728,\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"FAFMappingRelationshipConfigEdit_20", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            IDataModel model = this.getModel();
            DynamicObjectCollection currentSubPageEntryEntity = subPageModel.getEntryEntity("entryentity");
            if (CollectionUtils.isEmpty((Collection)currentSubPageEntryEntity)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u6dfb\u52a0\u4e00\u884c\u6620\u5c04\u503c\u5206\u5f55\u3002", (String)"FAFMappingRelationshipConfigEdit_21", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            List sourceDimDTOs = FAFMappingRelationShipDataHelper.getDimensionList((IDataModel)model, (RelationShipMappingDimensionEnum)RelationShipMappingDimensionEnum.SOURCE);
            List targetDimDTOs = FAFMappingRelationShipDataHelper.getDimensionList((IDataModel)model, (RelationShipMappingDimensionEnum)RelationShipMappingDimensionEnum.TARGET);
            List<String> sourceDimJsonList = this.transferDimEntry2JsonList(currentSubPageEntryEntity, sourceDimDTOs);
            List<String> targetDimJsonList = this.transferDimEntry2JsonList(currentSubPageEntryEntity, targetDimDTOs);
            List<Long> sourceDimCRC32List = sourceDimJsonList.stream().map(jsonStr -> CRC32CodeUtils.encode((byte[])jsonStr.getBytes(StandardCharsets.UTF_8))).collect(Collectors.toList());
            boolean isValidated = this.validate(sourceDimJsonList, this.getEmptyDimJsonStr(sourceDimDTOs));
            if (isValidated) {
                this.PostBackMappingEntryFromSubAsJson(sourceDimCRC32List, sourceDimJsonList, targetDimJsonList);
            } else {
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if ("save".equals(operateKey) && operationResult.isSuccess()) {
            FAFAnalysisSystemConfigEdit.refreshParentPageAfterSave(this.getView());
        }
    }

    private boolean validate(List<String> sourceDimJsonList, String emptySourceDimJsonStr) {
        String repeatedJson = null;
        HashSet<String> set = new HashSet<String>();
        for (String json : sourceDimJsonList) {
            if (json.equals(emptySourceDimJsonStr)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u6761\u6620\u5c04\u5173\u7cfb\u6e90\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u4fee\u6539\u540e\u518d\u8fdb\u884c\u4fdd\u5b58\u3002", (String)"FAFMappingRelationshipConfigEdit_0", (String)"macc-faf-formplugin", (Object[])new Object[0]), sourceDimJsonList.indexOf(json) + 1));
                return false;
            }
            boolean succeed = set.add(json);
            if (succeed) continue;
            repeatedJson = json;
            break;
        }
        if (repeatedJson != null) {
            int first = sourceDimJsonList.indexOf(repeatedJson);
            int last = sourceDimJsonList.lastIndexOf(repeatedJson);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u548c\u7b2c%2$s\u6761\u6620\u5c04\u5173\u7cfb\u6e90\u7ef4\u5ea6\u91cd\u590d,\u8bf7\u4fee\u6539\u540e\u518d\u8fdb\u884c\u4fdd\u5b58\u3002", (String)"FAFMappingRelationshipConfigEdit_1", (String)"macc-faf-formplugin", (Object[])new Object[0]), first + 1, last + 1));
            return false;
        }
        return true;
    }

    private String getEmptyDimJsonStr(List<FAFMappingDimensionDTO> dimDTOs) {
        LinkedHashMap<String, Object> emptyDimJsonMap = new LinkedHashMap<String, Object>();
        block5: for (FAFMappingDimensionDTO dimDTO : dimDTOs) {
            String number = dimDTO.getNumber();
            DimensionTypeEnum type = DimensionTypeEnum.getEnum((String)dimDTO.getType());
            String entityId = dimDTO.getBaseDataSourceNumber();
            if (type == null) continue;
            switch (type) {
                case DATABASE: {
                    Class propertyType = EntityMetadataCache.getDataEntityType((String)entityId).getPrimaryKey().getPropertyType();
                    if (String.class.isAssignableFrom(propertyType)) {
                        emptyDimJsonMap.put(number, "");
                        continue block5;
                    }
                    emptyDimJsonMap.put(number, 0L);
                    continue block5;
                }
                case ASSISTANTDATA: {
                    emptyDimJsonMap.put(number, 0L);
                    continue block5;
                }
                case OTHER: 
                case DENUMS: {
                    emptyDimJsonMap.put(number, "");
                    continue block5;
                }
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7ef4\u5ea6\u7c7b\u578b", (String)"FAFMappingRelationshipConfigEdit_19", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        }
        return JSON.toJSONString(emptyDimJsonMap);
    }

    private void PostBackMappingEntryFromSubAsJson(List<Long> sourceDimCRC32List, List<String> sourceDimJsonList, List<String> targetDimJsonList) {
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        if (!CollectionUtils.isEmpty(sourceDimCRC32List)) {
            model.beginInit();
            model.batchCreateNewEntryRow("entryentity", sourceDimCRC32List.size());
            DynamicObjectCollection dynamicObjects = model.getEntryEntity("entryentity");
            DynamicProperty sourceDimCRC = dynamicObjects.getDynamicObjectType().getProperty("sourcedimcrc");
            DynamicProperty sourceDimJson = dynamicObjects.getDynamicObjectType().getProperty("sourcedimtext");
            DynamicProperty targetDimJson = dynamicObjects.getDynamicObjectType().getProperty("targetdimtext");
            for (int i = 0; i < sourceDimCRC32List.size(); ++i) {
                DynamicObject entry = (DynamicObject)dynamicObjects.get(i);
                sourceDimCRC.setValueFast((Object)entry, (Object)sourceDimCRC32List.get(i));
                sourceDimJson.setValueFast((Object)entry, (Object)sourceDimJsonList.get(i));
                targetDimJson.setValueFast((Object)entry, (Object)targetDimJsonList.get(i));
            }
            model.endInit();
        }
    }

    private List<String> transferDimEntry2JsonList(DynamicObjectCollection currentSubPageEntryEntity, List<FAFMappingDimensionDTO> dimDTOs) {
        int size = currentSubPageEntryEntity.size();
        ArrayList<String> dimJsonList = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            LinkedHashMap<String, Object> dimJsonMap = new LinkedHashMap<String, Object>();
            DynamicObject subPageEntryDynamicObject = (DynamicObject)currentSubPageEntryEntity.get(i);
            block5: for (FAFMappingDimensionDTO dimensionDTO : dimDTOs) {
                String number = dimensionDTO.getNumber();
                String fieldNumber = dimensionDTO.getFieldNumber();
                DimensionTypeEnum type = DimensionTypeEnum.getEnum((String)dimensionDTO.getType());
                switch (type) {
                    case DATABASE: 
                    case ASSISTANTDATA: {
                        DynamicObject baseData = subPageEntryDynamicObject.getDynamicObject(fieldNumber);
                        dimJsonMap.put(number, baseData != null ? baseData.get("id") : Long.valueOf(0L));
                        continue block5;
                    }
                    case OTHER: 
                    case DENUMS: {
                        String textValue = subPageEntryDynamicObject.getString(fieldNumber);
                        dimJsonMap.put(number, textValue);
                        continue block5;
                    }
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7ef4\u5ea6\u7c7b\u578b", (String)"FAFMappingRelationshipConfigEdit_19", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            }
            dimJsonList.add(JSON.toJSONString(dimJsonMap));
        }
        return dimJsonList;
    }

    private IDataModel getSubPageModel() {
        IFormView view = this.getSubPageView();
        if (view == null) {
            return null;
        }
        return view.getModel();
    }

    private IFormView getSubPageView() {
        return this.getView().getView(this.getPageCache().get(SUB_PAGE_ID));
    }

    private void initMappingRelationShipSubPage() {
        this.shutHistorySubPage();
        FormShowParameter subFormShowParameter = new FormShowParameter();
        subFormShowParameter.setFormId("pa_anasystemmappingsett");
        subFormShowParameter.getOpenStyle().setTargetKey("flex_mapping_setting");
        subFormShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        this.getPageCache().put(SUB_PAGE_ID, subFormShowParameter.getPageId());
        this.getView().showForm(subFormShowParameter);
    }

    private void shutHistorySubPage() {
        String subPageId = this.getPageCache().get(SUB_PAGE_ID);
        if (StringUtils.isNotBlank((CharSequence)subPageId)) {
            IFormView subView = this.getView().getView(subPageId);
            subView.close();
            this.getView().sendFormAction(subView);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        MulBasedataProp prop = (MulBasedataProp)beforeF7SelectEvent.getProperty();
        String entityId = prop.getName();
        if ("sourcedim".equals(entityId) || "targetdim".equals(entityId)) {
            QFilter systemFilter = new QFilter("system", "=", this.getModel().getValue("anasystem_id"));
            QFilter nonDateDimension = new QFilter("dimensiontype", "!=", (Object)"5");
            ListShowParameter param = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            param.getListFilterParameter().setFilter(systemFilter.and(nonDateDimension));
            this.saveSubPageEntryInPageCache();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("downloadtemplate".equals(itemKey)) {
            List sourceDimDTOs = FAFMappingRelationShipDataHelper.getDimensionList((IDataModel)this.getModel(), (RelationShipMappingDimensionEnum)RelationShipMappingDimensionEnum.SOURCE);
            List targetDimDTOs = FAFMappingRelationShipDataHelper.getDimensionList((IDataModel)this.getModel(), (RelationShipMappingDimensionEnum)RelationShipMappingDimensionEnum.TARGET);
            if (CollectionUtils.isEmpty((Collection)sourceDimDTOs) || CollectionUtils.isEmpty((Collection)targetDimDTOs)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ef4\u5ea6\u3002", (String)"FAFMappingRelationshipConfigEdit_27", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                return;
            }
            this.downLoad(true);
        } else if ("download".equals(itemKey)) {
            List sourceDimDTOs = FAFMappingRelationShipDataHelper.getDimensionList((IDataModel)this.getModel(), (RelationShipMappingDimensionEnum)RelationShipMappingDimensionEnum.SOURCE);
            List targetDimDTOs = FAFMappingRelationShipDataHelper.getDimensionList((IDataModel)this.getModel(), (RelationShipMappingDimensionEnum)RelationShipMappingDimensionEnum.TARGET);
            if (CollectionUtils.isEmpty((Collection)sourceDimDTOs) || CollectionUtils.isEmpty((Collection)targetDimDTOs)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ef4\u5ea6\u3002", (String)"FAFMappingRelationshipConfigEdit_27", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                return;
            }
            this.downLoad(false);
        }
    }

    public void upload(UploadEvent evt) {
        super.upload(evt);
        List sourceDimDTOs = FAFMappingRelationShipDataHelper.getDimensionList((IDataModel)this.getModel(), (RelationShipMappingDimensionEnum)RelationShipMappingDimensionEnum.SOURCE);
        List targetDimDTOs = FAFMappingRelationShipDataHelper.getDimensionList((IDataModel)this.getModel(), (RelationShipMappingDimensionEnum)RelationShipMappingDimensionEnum.TARGET);
        if (CollectionUtils.isEmpty((Collection)sourceDimDTOs) || CollectionUtils.isEmpty((Collection)targetDimDTOs)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ef4\u5ea6\u3002", (String)"FAFMappingRelationshipConfigEdit_27", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            return;
        }
        Object[] urls = evt.getUrls();
        if (urls.length > 0) {
            MappingDataUploadDTO mappingDataUploadDTO;
            String url = (String)urls[0];
            FileService service = FileServiceFactory.getAttachmentFileService();
            HSSFWorkbook wb = null;
            try {
                InputStream is = service.getInputStream(url);
                String extStr = url.substring(url.lastIndexOf("."));
                if (".xls".equals(extStr)) {
                    wb = new HSSFWorkbook(is);
                } else if (".xlsx".equals(extStr)) {
                    wb = new XSSFWorkbook(is);
                }
            }
            catch (Exception e) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6620\u5c04\u89c4\u5219\u5bfc\u5165Excel\u6570\u636e\u5931\u8d25 :%s", (String)"FAFMappingRelationshipConfigEdit_2", (String)"macc-faf-formplugin", (Object[])new Object[0]), e.getMessage()));
            }
            if (wb == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u683c\u5f0f\u9519\u8bef,\u5fc5\u987b\u4e3axls\u6216xlsx\u6587\u4ef6", (String)"FAFMappingRelationshipConfigEdit_3", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            }
            try {
                mappingDataUploadDTO = this.appendExcelRowToMappingEntry((Workbook)wb);
            }
            catch (Exception e) {
                throw new KDBizException(StringUtils.isBlank((CharSequence)e.getMessage()) ? ResManager.loadKDString((String)"\u5bfc\u5165Excel\u6587\u4ef6\u9519\u8bef,\u8bf7\u4ece\u5bf9\u5e94\u7684\u6620\u5c04\u89c4\u5219\u65b9\u6848\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f", (String)"FAFMappingRelationshipConfigEdit_4", (String)"macc-faf-formplugin", (Object[])new Object[0]) : e.getMessage());
            }
            this.initMappingRelationShipSubPage();
            FAFMappingUploadResultFormPlugin.open(this.getView(), mappingDataUploadDTO);
        }
    }

    private MappingDataUploadDTO appendExcelRowToMappingEntry(Workbook wb) {
        IDataModel subPageModel = this.getSubPageModel();
        if (subPageModel == null || !subPageModel.isDataLoaded()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6620\u5c04\u65b9\u6848\u5217\u8868\u52a0\u8f7d\u5931\u8d25,\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762", (String)"FAFMappingRelationshipConfigEdit_5", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        }
        MappingDataUploadDTO mappingDataUploadDTO = this.validateAndTransformRowData(wb);
        List<List<Object>> entryDataList = mappingDataUploadDTO.getSuccessDataRows().stream().map(MappingDataUploadDTO.SuccessRowData::getSuccessDataRows).collect(Collectors.toList());
        this.saveSubPageEntryWithImportDataInParentEntry(entryDataList);
        return mappingDataUploadDTO;
    }

    private MappingDataUploadDTO validateAndTransformRowData(Workbook wb) {
        List<FAFMappingDimensionDTO> allDimensionDTOs = this.getAllDimensionDTOs();
        List<List<String>> rowDataList = this.handleExcelRowData(wb, allDimensionDTOs);
        List<List<Object>> entryColumnList = this.transferEntryFieldColumnList(rowDataList, allDimensionDTOs);
        return this.analyzeEntryColumnList(entryColumnList, allDimensionDTOs);
    }

    private List<List<String>> handleExcelRowData(Workbook wb, List<FAFMappingDimensionDTO> allDimensionDTOs) {
        ArrayList<List<String>> rowDataList = new ArrayList<List<String>>(allDimensionDTOs.size());
        for (int i = 0; i < allDimensionDTOs.size(); ++i) {
            rowDataList.add(new ArrayList());
        }
        Sheet firstSheet = wb.getSheetAt(0);
        int rowNumber = firstSheet.getPhysicalNumberOfRows();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        if (rowNumber < 3) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u89c4\u5219\u6a21\u677f\u4e0e\u65b9\u6848\u5b9e\u4f53\u4e0d\u4e00\u81f4,\u8bf7\u4ece\u6620\u5c04\u89c4\u5219\u65b9\u6848\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\u3002", (String)"FAFMappingRelationshipConfigEdit_8", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        }
        if (rowNumber >= 10004) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u6b21\u4e0a\u4f20\u6700\u5927\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc710000\u6761\u3002", (String)"FAFMappingRelationshipConfigEdit_6", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        }
        for (int i = 0; i < rowNumber; ++i) {
            Row row = firstSheet.getRow(i);
            if (row == null) {
                if (i <= 2) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u89c4\u5219\u6a21\u677f\u4e0e\u65b9\u6848\u5b9e\u4f53\u4e0d\u4e00\u81f4,\u8bf7\u4ece\u6620\u5c04\u89c4\u5219\u65b9\u6848\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\u3002", (String)"FAFMappingRelationshipConfigEdit_8", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                }
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0a\u4f20Excel\u6587\u4ef6\u7b2c%s\u884c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u6570\u636e", (String)"FAFMappingRelationshipConfigEdit_7", (String)"macc-faf-formplugin", (Object[])new Object[0]), i + 1));
            }
            if (i == 0) {
                String entityNumberStr = row.getCell(0).getStringCellValue();
                String[] split = entityNumberStr.split(":");
                if (split.length == 2 && split[1].trim().equals(this.getModel().getValue("number"))) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u89c4\u5219\u6a21\u677f\u4e0e\u65b9\u6848\u5b9e\u4f53\u4e0d\u4e00\u81f4,\u8bf7\u4ece\u6620\u5c04\u89c4\u5219\u65b9\u6848\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\u3002", (String)"FAFMappingRelationshipConfigEdit_8", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            }
            if (i == 1) {
                int columnIndex = 0;
                for (FAFMappingDimensionDTO fafMappingDimensionDTO : allDimensionDTOs) {
                    DimensionTypeEnum dimensionTypeEnum = DimensionTypeEnum.getEnum((String)fafMappingDimensionDTO.getType());
                    String fieldNumber = "";
                    if (dimensionTypeEnum == DimensionTypeEnum.DATABASE || dimensionTypeEnum == DimensionTypeEnum.ASSISTANTDATA) {
                        String[] fieldNumberSplit = row.getCell(columnIndex).getStringCellValue().split("\\.");
                        if (fieldNumberSplit.length == 2 && "number".equals(fieldNumberSplit[1])) {
                            fieldNumber = fieldNumberSplit[0];
                            columnIndex += 2;
                        }
                    } else {
                        fieldNumber = row.getCell(columnIndex).getStringCellValue();
                        ++columnIndex;
                    }
                    if (fafMappingDimensionDTO.getNumber().equals(fieldNumber)) continue;
                    throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u89c4\u5219\u6a21\u677f\u6e90\u6216\u76ee\u6807\u7ef4\u5ea6\u4e0e\u65b9\u6848\u5b9e\u4f53\u4e0d\u4e00\u81f4,\u8bf7\u4ece\u6620\u5c04\u89c4\u5219\u65b9\u6848\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\u3002", (String)"FAFMappingRelationshipConfigEdit_9", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                }
                continue;
            }
            if (i < 3) continue;
            int columnIndex = 0;
            for (int i1 = 0; i1 < allDimensionDTOs.size(); ++i1) {
                List columnData = (List)rowDataList.get(i1);
                Cell cell = row.getCell(columnIndex);
                String cellStrValue = "";
                if (cell != null) {
                    int cellTypeCode = cell.getCellType().getCode();
                    switch (cellTypeCode) {
                        case 0: {
                            if (DateUtil.isCellDateFormatted((Cell)cell)) {
                                cellStrValue = simpleDateFormat.format(cell.getDateCellValue());
                                break;
                            }
                            cellStrValue = BigDecimal.valueOf(cell.getNumericCellValue()).stripTrailingZeros().toPlainString();
                            break;
                        }
                        case 1: {
                            cellStrValue = cell.getStringCellValue();
                            break;
                        }
                        case 3: {
                            cellStrValue = "";
                            break;
                        }
                        case 4: {
                            cellStrValue = String.valueOf(cell.getBooleanCellValue());
                            break;
                        }
                        default: {
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b : %1$s--- \u7b2c%2$s\u884c,\u7b2c%3$s\u5217", (String)"FAFMappingRelationshipConfigEdit_10", (String)"macc-faf-formplugin", (Object[])new Object[0]), cell.getCellType().name(), i + 1, i1 + 1));
                        }
                    }
                } else {
                    cellStrValue = "";
                }
                columnData.add(cellStrValue);
                DimensionTypeEnum dimensionTypeEnum = DimensionTypeEnum.getEnum((String)allDimensionDTOs.get(i1).getType());
                if (dimensionTypeEnum == DimensionTypeEnum.DATABASE || dimensionTypeEnum == DimensionTypeEnum.ASSISTANTDATA) {
                    columnIndex += 2;
                    continue;
                }
                ++columnIndex;
            }
        }
        return rowDataList;
    }

    private List<List<Object>> transferEntryFieldColumnList(List<List<String>> rowDataList, List<FAFMappingDimensionDTO> allDimensionDTOs) {
        ArrayList<List<Object>> entryDataList = new ArrayList<List<Object>>(rowDataList.size());
        block10: for (int i = 0; i < rowDataList.size(); ++i) {
            List<String> columnData = rowDataList.get(i);
            FAFMappingDimensionDTO dimensionDTO = allDimensionDTOs.get(i);
            DimensionTypeEnum typeEnum = DimensionTypeEnum.getEnum((String)dimensionDTO.getType());
            if (typeEnum == null) {
                throw new KDBizException("[mapping-upload] DimensionTypeEnum is not exist");
            }
            switch (typeEnum) {
                case DATABASE: {
                    Map<String, Object> numberPkMap;
                    QFilter numberFilter = new QFilter("number", "in", columnData);
                    QFilter typeFilter = FAFDimensionHelper.getDimensionTypeQFilter((DynamicObject)BusinessDataServiceHelper.loadSingleFromCache((Object)dimensionDTO.getPkId(), (String)"pa_dimension"));
                    try {
                        numberPkMap = BusinessDataServiceHelper.loadFromCache((String)dimensionDTO.getBaseDataSourceNumber(), (String)"id,number", (QFilter[])new QFilter[]{numberFilter, typeFilter}).values().stream().collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy.get("id")));
                    }
                    catch (IllegalStateException e) {
                        String duplicateNumber = "";
                        ArrayList<String> numberList = new ArrayList<String>();
                        Collection values = BusinessDataServiceHelper.loadFromCache((String)dimensionDTO.getBaseDataSourceNumber(), (String)"id,number", (QFilter[])new QFilter[]{numberFilter, typeFilter}).values();
                        for (DynamicObject value : values) {
                            String number = value.getString("number");
                            if (numberList.contains(number)) {
                                duplicateNumber = number;
                                break;
                            }
                            numberList.add(number);
                        }
                        logger.error("PAMappingRelationshipConfigEdit#validateAndTransformRowData \u57fa\u7840\u8d44\u6599:" + e);
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6[%1$s]\u4e2d\u7f16\u53f7[%2$s]\u4e0d\u80fd\u786e\u5b9a\u6570\u636e\u7684\u552f\u4e00\u6027\u3002", (String)"FAFMappingRelationshipConfigEdit_11", (String)"macc-faf-formplugin", (Object[])new Object[0]), dimensionDTO.getName(), duplicateNumber));
                    }
                    List entryData = columnData.stream().map(data -> {
                        if (StringUtils.isBlank((CharSequence)data)) {
                            return 0L;
                        }
                        return numberPkMap.getOrDefault(data, -1L);
                    }).collect(Collectors.toList());
                    entryDataList.add(entryData);
                    continue block10;
                }
                case ASSISTANTDATA: {
                    Map<String, Object> numberPkMap;
                    QFilter numberFilter = new QFilter("number", "in", columnData);
                    QFilter groupFilter = new QFilter("group", "=", (Object)dimensionDTO.getAssistantDataTypeId());
                    try {
                        numberPkMap = BusinessDataServiceHelper.loadFromCache((String)"bos_assistantdata_detail", (String)"id,number", (QFilter[])new QFilter[]{numberFilter, groupFilter}).values().stream().collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy.get("id")));
                    }
                    catch (IllegalStateException e) {
                        String duplicateNumber = "";
                        ArrayList<String> numberList = new ArrayList<String>();
                        Collection values = BusinessDataServiceHelper.loadFromCache((String)"bos_assistantdata_detail", (String)"id,number", (QFilter[])new QFilter[]{numberFilter, groupFilter}).values();
                        for (DynamicObject value : values) {
                            String number = value.getString("number");
                            if (numberList.contains(number)) {
                                duplicateNumber = number;
                                break;
                            }
                            numberList.add(number);
                        }
                        logger.error("PAMappingRelationshipConfigEdit#validateAndTransformRowData \u8f85\u52a9\u8d44\u6599:" + e);
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6[%1$s]\u4e2d\u7f16\u53f7[%2$s]\u4e0d\u80fd\u786e\u5b9a\u6570\u636e\u7684\u552f\u4e00\u6027\u3002", (String)"FAFMappingRelationshipConfigEdit_11", (String)"macc-faf-formplugin", (Object[])new Object[0]), dimensionDTO.getName(), duplicateNumber));
                    }
                    List entryData = columnData.stream().map(data -> {
                        if (StringUtils.isBlank((CharSequence)data)) {
                            return 0L;
                        }
                        return numberPkMap.getOrDefault(data, -1L);
                    }).collect(Collectors.toList());
                    entryDataList.add(entryData);
                    continue block10;
                }
                case OTHER: {
                    entryDataList.add(new ArrayList<String>(columnData));
                    continue block10;
                }
                case DENUMS: {
                    List columnDataInEnumSet = columnData.stream().map(enumValue -> {
                        Optional<Map.Entry> first = dimensionDTO.getEnumMap().entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(enumValue)).findFirst();
                        return first.isPresent() ? (String)first.get().getKey() : "";
                    }).collect(Collectors.toList());
                    entryDataList.add(columnDataInEnumSet);
                    continue block10;
                }
                default: {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7ef4\u5ea6\u7c7b\u578b", (String)"FAFMappingRelationshipConfigEdit_19", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                }
            }
        }
        return entryDataList;
    }

    private MappingDataUploadDTO analyzeEntryColumnList(List<List<Object>> entryColumnList, List<FAFMappingDimensionDTO> allDimensionDTOs) {
        MappingDataUploadDTO mappingDataUploadDTO = new MappingDataUploadDTO(allDimensionDTOs);
        if (!CollectionUtils.isEmpty(entryColumnList)) {
            int excelRowCount = entryColumnList.get(0).size();
            List sourceDimDTOs = FAFMappingRelationShipDataHelper.getDimensionList((IDataModel)this.getModel(), (RelationShipMappingDimensionEnum)RelationShipMappingDimensionEnum.SOURCE);
            List targetDimDTOs = FAFMappingRelationShipDataHelper.getDimensionList((IDataModel)this.getModel(), (RelationShipMappingDimensionEnum)RelationShipMappingDimensionEnum.TARGET);
            for (int i = 0; i < excelRowCount; ++i) {
                Object data;
                int i1;
                ArrayList<Object> rowData = new ArrayList<Object>(allDimensionDTOs.size());
                for (i1 = 0; i1 < sourceDimDTOs.size(); ++i1) {
                    data = entryColumnList.get(i1).get(i);
                    rowData.add(data);
                }
                for (i1 = 0; i1 < targetDimDTOs.size(); ++i1) {
                    data = entryColumnList.get(i1 + sourceDimDTOs.size()).get(i);
                    rowData.add(data);
                }
                mappingDataUploadDTO.validateAndAddRowData(rowData, i + 4);
            }
            if (CollectionUtils.isEmpty((Collection)mappingDataUploadDTO.getFailedDataRows())) {
                mappingDataUploadDTO.setStatus(MappingUploadStatusEnum.SUCCESS);
            } else if (CollectionUtils.isEmpty((Collection)mappingDataUploadDTO.getSuccessDataRows())) {
                mappingDataUploadDTO.setStatus(MappingUploadStatusEnum.FAIL);
            } else {
                mappingDataUploadDTO.setStatus(MappingUploadStatusEnum.PARTIAL_SUCCESS);
            }
        }
        return mappingDataUploadDTO;
    }

    private void downLoad(boolean onlyTemplate) {
        OutputStream fos = null;
        FileInputStream fis = null;
        try {
            SXSSFWorkbook workbook = this.buildWorkBook(onlyTemplate);
            File temp = File.createTempFile(FilenameUtils.getName((String)UUID.randomUUID().toString()), ".xlsx");
            fos = new FileOutputStream(temp);
            workbook.write(fos);
            fis = new FileInputStream(temp);
            String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsFullUrl(ResManager.loadKDString((String)"\u6620\u5c04\u89c4\u5219\u6a21\u677fExcel.xlsx", (String)"FAFMappingRelationshipConfigEdit_12", (String)"macc-faf-formplugin", (Object[])new Object[0]), (InputStream)fis, 60);
            fis.close();
            this.getView().download(url);
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
        }
    }

    private void saveSubPageEntryInPageCache() {
        IDataModel model = this.getModel();
        IDataModel subPageModel = this.getSubPageModel();
        if (subPageModel == null || !subPageModel.isDataLoaded()) {
            return;
        }
        DynamicObjectCollection currentSubPageEntryEntity = subPageModel.getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)currentSubPageEntryEntity)) {
            this.getModel().deleteEntryData("entryentity");
            return;
        }
        List sourceDimDTOs = FAFMappingRelationShipDataHelper.getDimensionList((IDataModel)model, (RelationShipMappingDimensionEnum)RelationShipMappingDimensionEnum.SOURCE);
        List targetDimDTOs = FAFMappingRelationShipDataHelper.getDimensionList((IDataModel)model, (RelationShipMappingDimensionEnum)RelationShipMappingDimensionEnum.TARGET);
        List<String> sourceDimJsonList = this.transferDimEntry2JsonList(currentSubPageEntryEntity, sourceDimDTOs);
        List<String> targetDimJsonList = this.transferDimEntry2JsonList(currentSubPageEntryEntity, targetDimDTOs);
        List<Long> sourceDimCRC32List = sourceDimJsonList.stream().map(jsonStr -> CRC32CodeUtils.encode((byte[])jsonStr.getBytes(StandardCharsets.UTF_8))).collect(Collectors.toList());
        this.PostBackMappingEntryFromSubAsJson(sourceDimCRC32List, sourceDimJsonList, targetDimJsonList);
    }

    private void saveSubPageEntryWithImportDataInParentEntry(List<List<Object>> entryDataList) {
        IDataModel model = this.getModel();
        IDataModel subPageModel = this.getSubPageModel();
        if (subPageModel == null || !subPageModel.isDataLoaded()) {
            return;
        }
        List sourceDimDTOs = FAFMappingRelationShipDataHelper.getDimensionList((IDataModel)model, (RelationShipMappingDimensionEnum)RelationShipMappingDimensionEnum.SOURCE);
        List targetDimDTOs = FAFMappingRelationShipDataHelper.getDimensionList((IDataModel)model, (RelationShipMappingDimensionEnum)RelationShipMappingDimensionEnum.TARGET);
        List<String> sourceDimJsonList = new ArrayList<String>(100);
        List<String> targetDimJsonList = new ArrayList<String>(100);
        DynamicObjectCollection currentSubPageEntryEntity = subPageModel.getEntryEntity("entryentity");
        if (!CollectionUtils.isEmpty((Collection)currentSubPageEntryEntity)) {
            sourceDimJsonList = this.transferDimEntry2JsonList(currentSubPageEntryEntity, sourceDimDTOs);
            targetDimJsonList = this.transferDimEntry2JsonList(currentSubPageEntryEntity, targetDimDTOs);
        }
        this.filterEmptyDataInLast(sourceDimJsonList, targetDimJsonList, sourceDimDTOs, targetDimDTOs);
        int rowNumber = entryDataList.size();
        for (int i = 0; i < rowNumber; ++i) {
            Object data;
            String number;
            FAFMappingDimensionDTO dimensionDTO;
            int i1;
            LinkedHashMap<String, Object> sourceDimJsonMap = new LinkedHashMap<String, Object>(sourceDimDTOs.size());
            LinkedHashMap<String, Object> targetDimJsonMap = new LinkedHashMap<String, Object>(targetDimDTOs.size());
            List<Object> rowData = entryDataList.get(i);
            for (i1 = 0; i1 < sourceDimDTOs.size(); ++i1) {
                dimensionDTO = (FAFMappingDimensionDTO)sourceDimDTOs.get(i1);
                number = dimensionDTO.getNumber();
                data = rowData.get(i1);
                sourceDimJsonMap.put(number, data);
            }
            sourceDimJsonList.add(JSON.toJSONString(sourceDimJsonMap));
            for (i1 = 0; i1 < targetDimDTOs.size(); ++i1) {
                dimensionDTO = (FAFMappingDimensionDTO)targetDimDTOs.get(i1);
                number = dimensionDTO.getNumber();
                data = rowData.get(i1 + sourceDimDTOs.size());
                targetDimJsonMap.put(number, data);
            }
            targetDimJsonList.add(JSON.toJSONString(targetDimJsonMap));
        }
        List<Long> sourceDimCRC32List = sourceDimJsonList.stream().map(jsonStr -> CRC32CodeUtils.encode((byte[])jsonStr.getBytes(StandardCharsets.UTF_8))).collect(Collectors.toList());
        this.PostBackMappingEntryFromSubAsJson(sourceDimCRC32List, sourceDimJsonList, targetDimJsonList);
    }

    private void filterEmptyDataInLast(List<String> sourceDimJsonList, List<String> targetDimJsonList, List<FAFMappingDimensionDTO> sourceDimDTOs, List<FAFMappingDimensionDTO> targetDimDTOs) {
        String emptySourceDimJsonStr = this.getEmptyDimJsonStr(sourceDimDTOs);
        String emptyTargetDimJsonStr = this.getEmptyDimJsonStr(targetDimDTOs);
        for (int i = sourceDimJsonList.size() - 1; i >= 0; --i) {
            String sourceDimJsonOfIndex = sourceDimJsonList.get(i);
            String targetDimJsonOfIndex = targetDimJsonList.get(i);
            if (!sourceDimJsonOfIndex.equals(emptySourceDimJsonStr) || !targetDimJsonOfIndex.equals(emptyTargetDimJsonStr)) {
                return;
            }
            sourceDimJsonList.remove(i);
            targetDimJsonList.remove(i);
        }
    }

    private SXSSFWorkbook buildWorkBook(boolean onlyTemplate) {
        SXSSFWorkbook workbook = new SXSSFWorkbook();
        SXSSFSheet sheet1 = workbook.createSheet("sheet1");
        MappingRelationExcelCellStyleBuilder mappingRelationExcelCellStyleBuilder = new MappingRelationExcelCellStyleBuilder();
        SXSSFRow mappingNumberRow = FAFMappingRelationshipConfigEdit.getRow(sheet1, 0);
        this.createCell(mappingNumberRow, 0, mappingRelationExcelCellStyleBuilder.getCellStyle((Workbook)workbook, false, true)).setCellValue(String.format(ResManager.loadKDString((String)"\u6620\u5c04\u65b9\u6848:%s", (String)"FAFMappingRelationshipConfigEdit_13", (String)"macc-faf-formplugin", (Object[])new Object[0]), this.getModel().getValue("number")));
        this.createCell(mappingNumberRow, 1, mappingRelationExcelCellStyleBuilder.getCellStyle((Workbook)workbook, true, false)).setCellValue(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u548c\u8f85\u52a9\u8d44\u6599\u7c7b\u578b\u7684\u7ef4\u5ea6\uff0c\u8bf7\u586b\u5199\u5bf9\u5e94\u6570\u636e\u7684\u7f16\u53f7\uff1b\u679a\u4e3e\u7c7b\u578b\u7684\u7ef4\u5ea6\uff0c\u8bf7\u586b\u5199\u5bf9\u5e94\u7684\u679a\u4e3e\u503c\u3002", (String)"FAFMappingRelationshipConfigEdit_14", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        this.createFieldColumns(workbook, sheet1, mappingRelationExcelCellStyleBuilder);
        if (!onlyTemplate) {
            this.createMappingData(workbook, sheet1, mappingRelationExcelCellStyleBuilder);
        }
        return workbook;
    }

    private void createMappingData(SXSSFWorkbook workbook, SXSSFSheet sheet1, MappingRelationExcelCellStyleBuilder mappingRelationExcelCellStyleBuilder) {
        IDataModel subPageModel = this.getSubPageModel();
        if (subPageModel == null || !subPageModel.isDataLoaded()) {
            return;
        }
        DynamicObjectCollection currentSubPageEntryEntity = subPageModel.getEntryEntity("entryentity");
        int rowIndex = 3;
        for (DynamicObject subPageEntryDynamicObject : currentSubPageEntryEntity) {
            SXSSFRow mappingDataRow = FAFMappingRelationshipConfigEdit.getRow(sheet1, rowIndex++);
            int columnIndex = 0;
            block6: for (FAFMappingDimensionDTO dimensionDTO : this.getAllDimensionDTOs()) {
                String fieldNumber = dimensionDTO.getFieldNumber();
                DimensionTypeEnum type = DimensionTypeEnum.getEnum((String)dimensionDTO.getType());
                switch (type) {
                    case DATABASE: 
                    case ASSISTANTDATA: {
                        DynamicObject baseData = subPageEntryDynamicObject.getDynamicObject(fieldNumber);
                        if (baseData != null) {
                            this.createCell(mappingDataRow, columnIndex, mappingRelationExcelCellStyleBuilder.getCellStyle((Workbook)workbook, false, false)).setCellValue(baseData.getString("number"));
                            this.createCell(mappingDataRow, columnIndex + 1, mappingRelationExcelCellStyleBuilder.getCellStyle((Workbook)workbook, false, false)).setCellValue(baseData.getString("name"));
                        }
                        columnIndex += 2;
                        continue block6;
                    }
                    case OTHER: {
                        String textValue = subPageEntryDynamicObject.getString(fieldNumber);
                        this.createCell(mappingDataRow, columnIndex, mappingRelationExcelCellStyleBuilder.getCellStyle((Workbook)workbook, false, false)).setCellValue(StringUtils.isNotBlank((CharSequence)textValue) ? textValue : "");
                        ++columnIndex;
                        continue block6;
                    }
                    case DENUMS: {
                        String enumValue = subPageEntryDynamicObject.getString(fieldNumber);
                        String title = (String)dimensionDTO.getEnumMap().get(enumValue);
                        this.createCell(mappingDataRow, columnIndex, mappingRelationExcelCellStyleBuilder.getCellStyle((Workbook)workbook, false, false)).setCellValue(title != null ? title : "");
                        ++columnIndex;
                        continue block6;
                    }
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7ef4\u5ea6\u7c7b\u578b", (String)"FAFMappingRelationshipConfigEdit_19", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void createFieldColumns(SXSSFWorkbook workbook, SXSSFSheet sheet1, MappingRelationExcelCellStyleBuilder mappingRelationExcelCellStyleBuilder) {
        SXSSFRow dimensionNumberRow = FAFMappingRelationshipConfigEdit.getRow(sheet1, 1);
        SXSSFRow dimensionNameRow = FAFMappingRelationshipConfigEdit.getRow(sheet1, 2);
        int columnIndex = 0;
        List<FAFMappingDimensionDTO> dimDTOs = this.getAllDimensionDTOs();
        block5: for (FAFMappingDimensionDTO dimensionDTO : dimDTOs) {
            String number = dimensionDTO.getNumber();
            String name = dimensionDTO.getName();
            String fieldNumber = dimensionDTO.getFieldNumber();
            DimensionTypeEnum dimensionTypeEnum = DimensionTypeEnum.getEnum((String)dimensionDTO.getType());
            switch (dimensionTypeEnum) {
                case DATABASE: 
                case ASSISTANTDATA: {
                    this.createCell(dimensionNumberRow, columnIndex, mappingRelationExcelCellStyleBuilder.getCellStyle((Workbook)workbook, false, true)).setCellValue(number + ".number");
                    this.createCell(dimensionNameRow, columnIndex, mappingRelationExcelCellStyleBuilder.getCellStyle((Workbook)workbook, true, true)).setCellValue(name + (fieldNumber.startsWith("source") ? ResManager.loadKDString((String)".\u7f16\u53f7(\u6e90)*", (String)"FAFMappingRelationshipConfigEdit_15", (String)"macc-faf-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)".\u7f16\u53f7(\u76ee\u6807)*", (String)"FAFMappingRelationshipConfigEdit_16", (String)"macc-faf-formplugin", (Object[])new Object[0])));
                    this.createCell(dimensionNumberRow, columnIndex + 1, mappingRelationExcelCellStyleBuilder.getCellStyle((Workbook)workbook, false, true)).setCellValue(number + ".name");
                    this.createCell(dimensionNameRow, columnIndex + 1, mappingRelationExcelCellStyleBuilder.getCellStyle((Workbook)workbook, false, true)).setCellValue(name + (fieldNumber.startsWith("source") ? ResManager.loadKDString((String)".\u540d\u79f0(\u6e90)", (String)"FAFMappingRelationshipConfigEdit_23", (String)"macc-faf-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)".\u540d\u79f0(\u76ee\u6807)", (String)"FAFMappingRelationshipConfigEdit_24", (String)"macc-faf-formplugin", (Object[])new Object[0])));
                    columnIndex += 2;
                    continue block5;
                }
                case OTHER: {
                    this.createCell(dimensionNumberRow, columnIndex, mappingRelationExcelCellStyleBuilder.getCellStyle((Workbook)workbook, false, true)).setCellValue(number);
                    this.createCell(dimensionNameRow, columnIndex, mappingRelationExcelCellStyleBuilder.getCellStyle((Workbook)workbook, true, true)).setCellValue(name + (fieldNumber.startsWith("source") ? ResManager.loadKDString((String)"(\u6e90)*", (String)"FAFMappingRelationshipConfigEdit_25", (String)"macc-faf-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"(\u76ee\u6807)*", (String)"FAFMappingRelationshipConfigEdit_26", (String)"macc-faf-formplugin", (Object[])new Object[0])));
                    ++columnIndex;
                    continue block5;
                }
                case DENUMS: {
                    this.createCell(dimensionNumberRow, columnIndex, mappingRelationExcelCellStyleBuilder.getCellStyle((Workbook)workbook, false, true)).setCellValue(number);
                    this.createCell(dimensionNameRow, columnIndex, mappingRelationExcelCellStyleBuilder.getCellStyle((Workbook)workbook, true, true)).setCellValue(name + (fieldNumber.startsWith("source") ? ResManager.loadKDString((String)"(\u6e90)*", (String)"FAFMappingRelationshipConfigEdit_25", (String)"macc-faf-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"(\u76ee\u6807)*", (String)"FAFMappingRelationshipConfigEdit_26", (String)"macc-faf-formplugin", (Object[])new Object[0])));
                    String[] comboValues = dimensionDTO.getEnumMap().values().toArray(new String[0]);
                    DataValidationHelper dataValidationHelper = sheet1.getDataValidationHelper();
                    DataValidationConstraint explicitListConstraint = dataValidationHelper.createExplicitListConstraint(comboValues);
                    CellRangeAddressList cellRangeAddressList = new CellRangeAddressList(3, 10003, columnIndex, columnIndex);
                    DataValidation validation = dataValidationHelper.createValidation(explicitListConstraint, cellRangeAddressList);
                    if (validation instanceof HSSFDataValidation) {
                        validation.setSuppressDropDownArrow(false);
                    } else {
                        validation.setSuppressDropDownArrow(true);
                        validation.setShowErrorBox(true);
                    }
                    sheet1.addValidationData(validation);
                    ++columnIndex;
                    continue block5;
                }
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7ef4\u5ea6\u7c7b\u578b:%s", (String)"FAFMappingRelationshipConfigEdit_22", (String)"macc-faf-formplugin", (Object[])new Object[0]), dimensionTypeEnum.getCode()));
        }
    }

    private List<FAFMappingDimensionDTO> getAllDimensionDTOs() {
        List sourceDimDTOs = FAFMappingRelationShipDataHelper.getDimensionList((IDataModel)this.getModel(), (RelationShipMappingDimensionEnum)RelationShipMappingDimensionEnum.SOURCE);
        List targetDimDTOs = FAFMappingRelationShipDataHelper.getDimensionList((IDataModel)this.getModel(), (RelationShipMappingDimensionEnum)RelationShipMappingDimensionEnum.TARGET);
        ArrayList<FAFMappingDimensionDTO> dimDTOs = new ArrayList<FAFMappingDimensionDTO>();
        dimDTOs.addAll(sourceDimDTOs);
        dimDTOs.addAll(targetDimDTOs);
        return dimDTOs;
    }

    public static SXSSFRow getRow(SXSSFSheet sheet, int r) {
        SXSSFRow row = sheet.getRow(r);
        if (row == null) {
            row = sheet.createRow(r);
        }
        return row;
    }

    private SXSSFCell createCell(SXSSFRow row, int column, CellStyle style) {
        SXSSFCell cell = row.createCell(column);
        cell.setCellStyle(style);
        return cell;
    }

    private boolean isReferencedAndChangeBaseData() {
        Long pkId = (Long)this.getModel().getValue("id");
        if (pkId == 0L) {
            return false;
        }
        boolean isReferenced = BaseDataRefrenceHelper.isRefrenced((String)"pa_mappingrelationship", (Object)pkId);
        if (isReferenced) {
            boolean isAnaSystemChanged;
            boolean isNumberChanged;
            DynamicObject currentMapping = BusinessDataServiceHelper.loadSingle((String)"pa_mappingrelationship", (String)"number,name,anasystem,sourcedim,targetdim", (QFilter[])new QFilter("id", "=", (Object)pkId).toArray());
            boolean bl = isNumberChanged = !this.getModel().getValue("number").equals(currentMapping.getString("number"));
            if (isNumberChanged) {
                return true;
            }
            boolean bl2 = isAnaSystemChanged = ((Long)this.getModel().getValue("anasystem_id")).longValue() != currentMapping.getLong("anasystem_id");
            if (isAnaSystemChanged) {
                return true;
            }
            for (String dimNumber : new String[]{"sourcedim", "targetdim"}) {
                boolean isSourceDimChanged;
                List sourceDimInModel = ((DynamicObjectCollection)this.getModel().getValue(dimNumber)).stream().map(dy -> dy.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                List sourceDimInDataSet = currentMapping.getDynamicObjectCollection(dimNumber).stream().map(dy -> dy.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                boolean bl3 = isSourceDimChanged = sourceDimInModel.size() != sourceDimInDataSet.size() || !sourceDimInModel.containsAll(sourceDimInDataSet);
                if (!isSourceDimChanged) continue;
                return true;
            }
        }
        return false;
    }
}

