/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.system;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.tree.TreeFilterParameter;
import kd.macc.faf.dto.FAFMappingDimensionDTO;
import kd.macc.faf.dto.FAFMappingRelationShipDTO;
import kd.macc.faf.enums.DimensionTypeEnum;
import kd.macc.faf.enums.ImportSystemSourceTypeEnum;
import kd.macc.faf.enums.RelationShipMappingDimensionEnum;
import kd.macc.faf.helper.FAFDimensionHelper;
import kd.macc.faf.helper.FAFMappingRelationShipDataHelper;
import kd.macc.faf.util.M;

public class FAFMappingRelationshipConfigSettingEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String ENTRY_ENTITY = "entryentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        IFormView view = this.getView();
        this.getAllDimensionDTOs().stream().filter(dimensionDto -> DimensionTypeEnum.DATABASE == DimensionTypeEnum.getEnum((String)dimensionDto.getType())).filter(dimensionDto -> ImportSystemSourceTypeEnum.BCM == dimensionDto.getImportSystemSourceTypeEnum()).map(dimensionDto -> (BasedataEdit)view.getControl(dimensionDto.getFieldNumber())).forEach(editControl -> editControl.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
            beforeF7ViewDetailEvent.setCancel(true);
            view.showTipNotification(ResManager.loadKDString((String)"\u5408\u5e76\u7ef4\u5ea6\u7c7b\u578b\u7684\u57fa\u7840\u8d44\u6599\u4e0d\u652f\u6301\u67e5\u770b\u8be6\u60c5\u3002", (String)"FAFMappingRelationshipConfigSettingEdit_3", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        }));
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("copy".equals(itemKey)) {
            this.copyRelationMappingRows();
        } else if ("batchfill".equals(itemKey)) {
            try {
                this.batchFillFocusField();
            }
            catch (Exception e) {
                throw new KDBizException(e.getCause() != null ? e.getCause().getMessage() : e.getMessage());
            }
        }
    }

    private void batchFillFocusField() {
        AbstractGrid.GridState entryState = ((EntryGrid)this.getControl(ENTRY_ENTITY)).getEntryState();
        int focusRow = entryState.getFocusRow();
        String focusField = entryState.getFocusField();
        if (focusRow < 0 || StringUtils.isBlank((CharSequence)focusField) || "0".equals(focusField)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u7684\u5355\u5143\u683c\uff0c\u518d\u70b9\u51fb\u6279\u91cf\u586b\u5145\u3002", (String)"FAFMappingRelationshipConfigSettingEdit_5", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        DynamicProperty batchFillProperty = entryEntity.getDynamicObjectType().getProperty(focusField);
        Object batchFilledValue = ((DynamicObject)entryEntity.get(focusRow)).get(focusField);
        for (int i = focusRow + 1; i < entryEntity.size(); ++i) {
            batchFillProperty.setValueFast(entryEntity.get(i), batchFilledValue);
        }
        this.getView().updateView(ENTRY_ENTITY);
    }

    private void copyRelationMappingRows() {
        EntryGrid control = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int[] selectedRows = control.getEntryState().getSelectedRows();
        if (selectedRows.length <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u590d\u5236\u7684\u884c\u6570\u636e\u3002", (String)"FAFMappingRelationshipConfigSettingEdit_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            return;
        }
        IDataModel model = this.getModel();
        model.beginInit();
        int[] createRows = this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, selectedRows.length);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        DataEntityPropertyCollection properties = ((DynamicObject)entryEntity.get(0)).getDynamicObjectType().getProperties();
        for (int i = 0; i < selectedRows.length; ++i) {
            DynamicObject selectObj = (DynamicObject)entryEntity.get(selectedRows[i]);
            DynamicObject newObj = (DynamicObject)entryEntity.get(createRows[i]);
            for (IDataEntityProperty property : properties) {
                if ("seq".equals(property.getName())) continue;
                property.setValueFast((Object)newObj, property.getValue((Object)selectObj));
            }
        }
        model.endInit();
        this.getView().updateView(ENTRY_ENTITY);
    }

    public void initialize() {
        super.initialize();
        this.initRunTimeColumnMeta();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.buildColumnUI();
        this.fillingColumnDataByParentInitialize();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setEmptyDimensionTips();
        if (OperationStatus.VIEW.equals((Object)this.getView().getParentView().getFormShowParameter().getStatus())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{ENTRY_ENTITY});
            this.getView().setVisible(Boolean.FALSE, new String[]{"advcontoolbarap"});
        }
    }

    private void setEmptyDimensionTips() {
        if (CollectionUtils.isEmpty(this.getSourceDimensions()) && CollectionUtils.isEmpty(this.getTargetDimensions())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{ENTRY_ENTITY});
            this.getView().setVisible(Boolean.TRUE, new String[]{"emptyflex"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{ENTRY_ENTITY});
            this.getView().setVisible(Boolean.FALSE, new String[]{"emptyflex"});
        }
    }

    private List<FAFMappingDimensionDTO> getAllDimensionDTOs() {
        ArrayList<FAFMappingDimensionDTO> dimensions = new ArrayList<FAFMappingDimensionDTO>();
        dimensions.addAll(this.getSourceDimensions());
        dimensions.addAll(this.getTargetDimensions());
        return dimensions;
    }

    private void fillingColumnDataByParentInitialize() {
        IDataModel parentModel = this.getParentModel();
        if (parentModel == null) {
            return;
        }
        DynamicObjectCollection parentEntryEntity = parentModel.getEntryEntity(ENTRY_ENTITY);
        FAFMappingRelationShipDTO fAFMappingRelationShipDTO = this.transferEntryJson2MappingDTO(parentEntryEntity);
        int rowCount = fAFMappingRelationShipDTO.getRowCount();
        if (rowCount == 0) {
            return;
        }
        this.fillingColumnData(fAFMappingRelationShipDTO);
    }

    private void fillingColumnData(FAFMappingRelationShipDTO fAFMappingRelationShipDTO) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData(ENTRY_ENTITY);
        model.beginInit();
        List sourceDimensionDataMapList = fAFMappingRelationShipDTO.getSourceDimensionDataMapList();
        List targetDimensionDataMapList = fAFMappingRelationShipDTO.getTargetDimensionDataMapList();
        TableValueSetter tableValueSetter = new TableValueSetter(fAFMappingRelationShipDTO.getAllDimNumbers());
        for (int i = 0; i < fAFMappingRelationShipDTO.getRowCount(); ++i) {
            Object[] sourceDimArr = ((Map)sourceDimensionDataMapList.get(i)).values().toArray();
            Object[] targetDimArr = ((Map)targetDimensionDataMapList.get(i)).values().toArray();
            Object[] dimArr = new Object[sourceDimArr.length + targetDimArr.length];
            System.arraycopy(sourceDimArr, 0, dimArr, 0, sourceDimArr.length);
            System.arraycopy(targetDimArr, 0, dimArr, sourceDimArr.length, targetDimArr.length);
            tableValueSetter.addRow(dimArr);
        }
        model.batchCreateNewEntryRow(ENTRY_ENTITY, tableValueSetter);
        model.endInit();
        this.getView().updateView(ENTRY_ENTITY);
    }

    private FAFMappingRelationShipDTO transferEntryJson2MappingDTO(DynamicObjectCollection dynamicObjectCollection) {
        ArrayList<Map<String, Object>> sourceDimensionDataMapList = new ArrayList<Map<String, Object>>(dynamicObjectCollection.size());
        ArrayList<Map<String, Object>> targetDimensionDataMapList = new ArrayList<Map<String, Object>>(dynamicObjectCollection.size());
        List<FAFMappingDimensionDTO> sourceDimensions = this.getSourceDimensions();
        List<FAFMappingDimensionDTO> targetDimensions = this.getTargetDimensions();
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            String sourceDimJson = dynamicObject.getString("sourcedimtext");
            String targetDimJson = dynamicObject.getString("targetdimtext");
            if (StringUtils.isBlank((CharSequence)sourceDimJson) || StringUtils.isBlank((CharSequence)targetDimJson)) continue;
            Map oldSourceDimDataMap = (Map)JSON.parseObject((String)sourceDimJson, (TypeReference)new TypeReference<LinkedHashMap<String, Object>>(){}, (Feature[])new Feature[0]);
            Map oldTargetDimDataMap = (Map)JSON.parseObject((String)targetDimJson, (TypeReference)new TypeReference<LinkedHashMap<String, Object>>(){}, (Feature[])new Feature[0]);
            Map<String, Object> newSourceDimDataMap = this.transferOldDimMapToNewDimMap(oldSourceDimDataMap, sourceDimensions);
            Map<String, Object> newTargetDimDataMap = this.transferOldDimMapToNewDimMap(oldTargetDimDataMap, targetDimensions);
            sourceDimensionDataMapList.add(newSourceDimDataMap);
            targetDimensionDataMapList.add(newTargetDimDataMap);
        }
        FAFMappingRelationShipDTO fAFMappingRelationShipDTO = new FAFMappingRelationShipDTO();
        fAFMappingRelationShipDTO.setRowCount(sourceDimensionDataMapList.size());
        fAFMappingRelationShipDTO.setSourceDimensionDTOs(this.getSourceDimensions());
        fAFMappingRelationShipDTO.setTargetDimensionDTOs(this.getTargetDimensions());
        fAFMappingRelationShipDTO.setSourceDimensionDataMapList(sourceDimensionDataMapList);
        fAFMappingRelationShipDTO.setTargetDimensionDataMapList(targetDimensionDataMapList);
        return fAFMappingRelationShipDTO;
    }

    private Map<String, Object> transferOldDimMapToNewDimMap(Map<String, Object> oldDimDataMap, List<FAFMappingDimensionDTO> newDimensions) {
        LinkedHashMap<String, Object> newDimDataMap = new LinkedHashMap<String, Object>();
        block5: for (FAFMappingDimensionDTO newDimension : newDimensions) {
            String number = newDimension.getNumber();
            DimensionTypeEnum typeEnum = DimensionTypeEnum.getEnum((String)newDimension.getType());
            Object value = oldDimDataMap.get(number);
            if (value == null) {
                if (typeEnum == null) continue;
                switch (typeEnum) {
                    case DATABASE: {
                        Class propertyType = EntityMetadataCache.getDataEntityType((String)newDimension.getBaseDataSourceNumber()).getPrimaryKey().getPropertyType();
                        newDimDataMap.put(number, String.class.isAssignableFrom(propertyType) ? "" : Integer.valueOf(0));
                        continue block5;
                    }
                    case ASSISTANTDATA: {
                        newDimDataMap.put(number, 0);
                        continue block5;
                    }
                    case OTHER: 
                    case DENUMS: {
                        newDimDataMap.put(number, "");
                        continue block5;
                    }
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7ef4\u5ea6\u7c7b\u578b", (String)"FAFMappingRelationshipConfigSettingEdit_4", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            }
            newDimDataMap.put(number, value);
        }
        return newDimDataMap;
    }

    private void buildColumnUI() {
        List<FAFMappingDimensionDTO> dimensions = this.getAllDimensionDTOs();
        HashMap<String, Object> entryEntityMap = new HashMap<String, Object>();
        entryEntityMap.put("rk", "rk");
        entryEntityMap.put("fseq", "fseq");
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        list.add(this.genRKColumn());
        if (!dimensions.isEmpty()) {
            for (FAFMappingDimensionDTO dimension : dimensions) {
                String fieldNumber = dimension.getFieldNumber();
                DimensionTypeEnum type = DimensionTypeEnum.getEnum((String)dimension.getType());
                String name = dimension.getName();
                RelationShipMappingDimensionEnum dimensionType = dimension.getDimensionType();
                if (dimensionType == RelationShipMappingDimensionEnum.SOURCE) {
                    name = String.format(ResManager.loadKDString((String)"%s (\u6e90)", (String)"FAFMappingRelationshipConfigSettingEdit_1", (String)"macc-faf-formplugin", (Object[])new Object[0]), name);
                } else if (dimensionType == RelationShipMappingDimensionEnum.TARGET) {
                    name = String.format(ResManager.loadKDString((String)"%s (\u76ee\u6807)", (String)"FAFMappingRelationshipConfigSettingEdit_2", (String)"macc-faf-formplugin", (Object[])new Object[0]), name);
                }
                Map<String, Object> cssMap = this.genColumn(fieldNumber, name, this.genEditorByDimensionType(type));
                list.add(cssMap);
            }
        }
        entryEntityMap.put("columns", list);
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.preInvokeControlMethod(ENTRY_ENTITY, "createGridColumns", new Object[]{entryEntityMap});
    }

    private void initRunTimeColumnMeta() {
        List<FAFMappingDimensionDTO> sourceDimensions = this.getSourceDimensions();
        List<FAFMappingDimensionDTO> targetDimensions = this.getTargetDimensions();
        if (CollectionUtils.isEmpty(sourceDimensions) && CollectionUtils.isEmpty(targetDimensions)) {
            return;
        }
        ArrayList<Control> controlList = new ArrayList<Control>(sourceDimensions.size() + targetDimensions.size());
        for (FAFMappingDimensionDTO sourceDimension : sourceDimensions) {
            controlList.add(this.buildRunTimeFieldMeta(sourceDimension));
        }
        for (FAFMappingDimensionDTO targetDimension : targetDimensions) {
            controlList.add(this.buildRunTimeFieldMeta(targetDimension));
        }
        if (!controlList.isEmpty()) {
            this.getView().createControlIndex(controlList);
        }
    }

    private Control buildRunTimeFieldMeta(FAFMappingDimensionDTO dimensionDTO) {
        Container entryContainer = (Container)this.getControl(ENTRY_ENTITY);
        MainEntityType mainType = this.getModel().getDataEntityType();
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)mainType.getName(), (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)formMeta.getEntityId(), (MetaCategory)MetaCategory.Entity);
        EntryFieldAp entryFieldAp = new EntryFieldAp();
        DimensionTypeEnum type = DimensionTypeEnum.getEnum((String)dimensionDTO.getType());
        switch (type) {
            case DATABASE: 
            case ASSISTANTDATA: {
                BasedataField basedataField = new BasedataField();
                basedataField.setId(Uuid8.generateShortUuid());
                basedataField.setKey(dimensionDTO.getFieldNumber());
                basedataField.setName(new LocaleString(dimensionDTO.getName()));
                basedataField.setBaseEntityId(dimensionDTO.getBaseDataSourceNumber());
                basedataField.setMustInput(false);
                basedataField.setDisplayProp("name");
                basedataField.setEntityMetadata(entityMeta);
                entityMeta.getItems().add(basedataField);
                entryFieldAp.setId(dimensionDTO.getPkId().toString());
                entryFieldAp.setFieldId(dimensionDTO.getPkId().toString());
                entryFieldAp.setKey(dimensionDTO.getFieldNumber());
                entryFieldAp.setName(new LocaleString(dimensionDTO.getName()));
                entryFieldAp.setField((Field)basedataField);
                entryFieldAp.setWidth(new LocaleString("100px"));
                entryFieldAp.setQuickAddNew(false);
                BasedataEdit bsEdit = (BasedataEdit)entryFieldAp.buildRuntimeControl();
                bsEdit.setKey(dimensionDTO.getFieldNumber());
                bsEdit.setFieldKey(dimensionDTO.getFieldNumber());
                bsEdit.setModel(this.getModel());
                bsEdit.setView(this.getView());
                bsEdit.setEntryKey(ENTRY_ENTITY);
                bsEdit.setF7MultipleSelect(true);
                bsEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
                entryContainer.getItems().add(bsEdit);
                return bsEdit;
            }
            case OTHER: {
                TextField textField = new TextField();
                textField.setId(Uuid8.generateShortUuid());
                textField.setKey(dimensionDTO.getFieldNumber());
                textField.setName(new LocaleString(dimensionDTO.getName()));
                textField.setMustInput(false);
                textField.setEntityMetadata(entityMeta);
                entityMeta.getItems().add(textField);
                entryFieldAp.setId(dimensionDTO.getPkId().toString());
                entryFieldAp.setFieldId(dimensionDTO.getPkId().toString());
                entryFieldAp.setKey(dimensionDTO.getFieldNumber());
                entryFieldAp.setName(new LocaleString(dimensionDTO.getName()));
                entryFieldAp.setField((Field)textField);
                entryFieldAp.setWidth(new LocaleString("100px"));
                TextEdit textEdit = (TextEdit)entryFieldAp.buildRuntimeControl();
                textEdit.setFieldKey(dimensionDTO.getFieldNumber());
                textEdit.setModel(this.getModel());
                textEdit.setView(this.getView());
                textEdit.setEntryKey(ENTRY_ENTITY);
                entryContainer.getItems().add(textEdit);
                return textEdit;
            }
            case DENUMS: {
                ComboField comboField = new ComboField();
                comboField.setId(Uuid8.generateShortUuid());
                comboField.setKey(dimensionDTO.getFieldNumber());
                comboField.setName(new LocaleString(dimensionDTO.getName()));
                comboField.setMustInput(false);
                comboField.setEntityMetadata(entityMeta);
                entityMeta.getItems().add(comboField);
                entryFieldAp.setId(dimensionDTO.getPkId().toString());
                entryFieldAp.setFieldId(dimensionDTO.getPkId().toString());
                entryFieldAp.setKey(dimensionDTO.getFieldNumber());
                entryFieldAp.setName(new LocaleString(dimensionDTO.getName()));
                entryFieldAp.setField((Field)comboField);
                entryFieldAp.setWidth(new LocaleString("100px"));
                ComboEdit comboEdit = (ComboEdit)entryFieldAp.buildRuntimeControl();
                comboEdit.setFieldKey(dimensionDTO.getFieldNumber());
                comboEdit.setModel(this.getModel());
                comboEdit.setView(this.getView());
                comboEdit.setEntryKey(ENTRY_ENTITY);
                List comboItemsEdit = dimensionDTO.getEnumMap().entrySet().stream().map(dy -> new ComboItem(new LocaleString((String)dy.getValue()), (String)dy.getKey())).collect(Collectors.toList());
                comboEdit.setComboItems(comboItemsEdit);
                entryContainer.getItems().add(comboEdit);
                return comboEdit;
            }
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7ef4\u5ea6\u7c7b\u578b", (String)"FAFMappingRelationshipConfigSettingEdit_4", (String)"macc-faf-formplugin", (Object[])new Object[0]));
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        super.getEntityType(e);
        List<FAFMappingDimensionDTO> dimensions = this.getAllDimensionDTOs();
        if (CollectionUtils.isEmpty(dimensions)) {
            return;
        }
        try {
            MainEntityType originalEntityType = e.getOriginalEntityType();
            MainEntityType newEntityType = (MainEntityType)originalEntityType.clone();
            EntryProp entry = (EntryProp)newEntityType.getProperty(ENTRY_ENTITY);
            DynamicObjectType entryType = entry.getDynamicCollectionItemPropertyType();
            for (FAFMappingDimensionDTO dimension : dimensions) {
                String fieldNumber = dimension.getFieldNumber();
                DimensionTypeEnum type = DimensionTypeEnum.getEnum((String)dimension.getType());
                String entityId = dimension.getBaseDataSourceNumber();
                switch (type) {
                    case DATABASE: 
                    case ASSISTANTDATA: {
                        BasedataProp newBaseDataProperty = new BasedataProp();
                        newBaseDataProperty.setName(fieldNumber);
                        newBaseDataProperty.setBaseEntityId(entityId);
                        newBaseDataProperty.setDisplayName(new LocaleString(dimension.getName()));
                        newBaseDataProperty.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)entityId));
                        Class propertyType = EntityMetadataCache.getDataEntityType((String)entityId).getPrimaryKey().getPropertyType();
                        Object idProp = String.class.isAssignableFrom(propertyType) ? new VarcharProp() : new LongProp();
                        idProp.setName(fieldNumber + "_id");
                        newBaseDataProperty.setRefIdProp((IDataEntityProperty)idProp);
                        newBaseDataProperty.setRefIdPropName(idProp.getName());
                        entryType.addProperty((DynamicProperty)newBaseDataProperty);
                        entryType.addProperty((DynamicProperty)idProp);
                        break;
                    }
                    case OTHER: {
                        TextProp newTextProperty = new TextProp();
                        newTextProperty.setName(fieldNumber);
                        newTextProperty.setDisplayName(new LocaleString(dimension.getName()));
                        entryType.addProperty((DynamicProperty)newTextProperty);
                        break;
                    }
                    case DENUMS: {
                        ComboProp newComboProperty = new ComboProp();
                        newComboProperty.setName(fieldNumber);
                        newComboProperty.setDisplayName(new LocaleString(dimension.getName()));
                        List comboItems = dimension.getEnumMap().entrySet().stream().map(dy -> new ValueMapItem(null, (String)dy.getKey(), new LocaleString((String)dy.getValue()))).collect(Collectors.toList());
                        newComboProperty.setComboItems(comboItems);
                        entryType.addProperty((DynamicProperty)newComboProperty);
                        break;
                    }
                    default: {
                        throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7ef4\u5ea6\u7c7b\u578b", (String)"FAFMappingRelationshipConfigSettingEdit_4", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                    }
                }
                newEntityType.createPropIndexsNoCache();
                e.setNewEntityType(newEntityType);
            }
        }
        catch (Exception exception) {
            throw new KDBizException(exception.getCause() != null ? exception.getCause().getMessage() : exception.getMessage());
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        BasedataProp prop = (BasedataProp)beforeF7SelectEvent.getProperty();
        String baseEntityId = prop.getBaseEntityId();
        BasedataEdit source = (BasedataEdit)beforeF7SelectEvent.getSource();
        String key = source.getKey();
        ListShowParameter param = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        if ("bos_assistantdata_detail".equals(baseEntityId)) {
            List<FAFMappingDimensionDTO> dimensions = this.getAllDimensionDTOs();
            Long groupId = 0L;
            for (FAFMappingDimensionDTO dimension : dimensions) {
                if (!key.equals(dimension.getFieldNumber())) continue;
                groupId = dimension.getAssistantDataTypeId();
            }
            ListFilterParameter listFilter = param.getListFilterParameter();
            listFilter.setFilter(new QFilter("group", "=", (Object)groupId));
        } else {
            IDataModel parentModel = this.getParentModel();
            if (parentModel == null) {
                return;
            }
            String name = prop.getName();
            Long anaSystemId = (Long)parentModel.getValue("anasystem_id");
            QFilter systemFilter = new QFilter("system", "=", (Object)anaSystemId);
            QFilter numberFilter = new QFilter("number", "=", (Object)name.substring(name.indexOf("_") + 1));
            DynamicObject dimension = QueryServiceHelper.queryOne((String)"pa_dimension", (String)"id,dimensionsource.number,typefield,group,systemsource", (QFilter[])new QFilter[]{systemFilter, numberFilter});
            ImportSystemSourceTypeEnum systemSourceTypeEnum = ImportSystemSourceTypeEnum.getEnumByCode((String)dimension.getString("systemsource"));
            QFilter filter = null;
            switch (systemSourceTypeEnum) {
                case BCM: 
                case EPM: {
                    DynamicObjectCollection dimensionMappings = FAFDimensionHelper.queryDimensionMappingByDimensionIds((List)M.objectArraylist((Object[])new Object[]{dimension.getLong("id")}), (ImportSystemSourceTypeEnum)systemSourceTypeEnum);
                    if (CollectionUtils.isEmpty((Collection)dimensionMappings)) break;
                    filter = new QFilter("model.id", "=", (Object)((DynamicObject)dimensionMappings.get(0)).getLong("immodel")).and(new QFilter("dimension", "=", (Object)((DynamicObject)dimensionMappings.get(0)).getLong("imdimension")));
                    if (ImportSystemSourceTypeEnum.BCM == systemSourceTypeEnum) {
                        filter.and(new QFilter("storagetype", "!=", (Object)"3"));
                    }
                    if (!"epm_audittrialmembertree".equals(dimension.getString("dimensionsource.number"))) break;
                    param.setF7ClickByFilter(true);
                    break;
                }
                case NEW: {
                    String typeField = dimension.getString("typefield");
                    long group = dimension.getLong("group");
                    if (!StringUtils.isNotBlank((CharSequence)typeField) || group <= 0L) break;
                    filter = new QFilter(typeField, "=", (Object)group);
                    String dimensionSourceNumber = dimension.getString("dimensionsource.number");
                    if (!(EntityMetadataCache.getDataEntityType((String)dimensionSourceNumber).getProperty(typeField) instanceof GroupProp)) break;
                    TreeFilterParameter treeFilterParameter = new TreeFilterParameter(new QFilter("id", "=", (Object)group));
                    param.setTreeFilterParameter(treeFilterParameter);
                    break;
                }
            }
            ListFilterParameter listFilter = param.getListFilterParameter();
            if (filter != null) {
                listFilter.setFilter(filter);
            }
        }
    }

    private IDataModel getParentModel() {
        IFormView parentView = this.getParentView();
        if (parentView != null) {
            return parentView.getModel();
        }
        return null;
    }

    private IFormView getParentView() {
        return this.getView().getParentView();
    }

    private List<FAFMappingDimensionDTO> getSourceDimensions() {
        IDataModel parentModel = this.getParentModel();
        if (parentModel == null) {
            return new ArrayList<FAFMappingDimensionDTO>();
        }
        try {
            parentModel.getDataEntity();
        }
        catch (Exception ignoreException) {
            return new ArrayList<FAFMappingDimensionDTO>();
        }
        return FAFMappingRelationShipDataHelper.getDimensionList((IDataModel)parentModel, (RelationShipMappingDimensionEnum)RelationShipMappingDimensionEnum.SOURCE);
    }

    private List<FAFMappingDimensionDTO> getTargetDimensions() {
        IDataModel parentModel = this.getParentModel();
        if (parentModel == null) {
            return new ArrayList<FAFMappingDimensionDTO>();
        }
        try {
            parentModel.getDataEntity();
        }
        catch (Exception ignoreException) {
            return new ArrayList<FAFMappingDimensionDTO>();
        }
        return FAFMappingRelationShipDataHelper.getDimensionList((IDataModel)parentModel, (RelationShipMappingDimensionEnum)RelationShipMappingDimensionEnum.TARGET);
    }

    public Map<String, Object> genRKColumn() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataIndex", "seq");
        map.put("header", new LocaleString("#"));
        map.put("visible", Boolean.TRUE);
        map.put("filter", Boolean.FALSE);
        map.put("sort", Boolean.FALSE);
        map.put("width", 50);
        return map;
    }

    public Map<String, Object> genColumn(String key, String name, Map<String, Object> editor) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataIndex", key);
        map.put("filter", Boolean.TRUE);
        map.put("l", 0);
        map.put("vi", 63);
        map.put("sort", Boolean.FALSE);
        map.put("w", new LocaleString("150px"));
        map.put("header", new LocaleString(name));
        map.put("editor", editor);
        return map;
    }

    private Map<String, Object> genEditorByDimensionType(DimensionTypeEnum type) {
        switch (type) {
            case DATABASE: 
            case ASSISTANTDATA: {
                HashMap<String, Object> editor = new HashMap<String, Object>();
                editor.put("con", "()");
                editor.put("dsp", "name,number");
                editor.put("dst", 0);
                editor.put("ep", 0);
                editor.put("mi", Boolean.FALSE);
                editor.put("type", "basedata");
                editor.put("qan", false);
                return editor;
            }
            case OTHER: {
                HashMap<String, Object> editor = new HashMap<String, Object>();
                editor.put("mi", Boolean.FALSE);
                editor.put("type", "text");
                editor.put("eb", Boolean.TRUE);
                editor.put("showEditButton", Boolean.FALSE);
                editor.put("isshowtooltip", Boolean.TRUE);
                return editor;
            }
            case DENUMS: {
                HashMap<String, Object> editor = new HashMap<String, Object>();
                editor.put("mi", Boolean.FALSE);
                editor.put("eb", Boolean.TRUE);
                editor.put("st", new ArrayList(4));
                editor.put("type", "combo");
                editor.put("sd", Boolean.FALSE);
                editor.put("vas", "underline");
                return editor;
            }
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7ef4\u5ea6\u7c7b\u578b", (String)"FAFMappingRelationshipConfigSettingEdit_4", (String)"macc-faf-formplugin", (Object[])new Object[0]));
    }
}

