/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.system;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EventObject;
import java.util.List;
import java.util.UUID;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.faf.dto.MappingDataUploadDTO;
import org.apache.commons.io.FilenameUtils;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class FAFMappingUploadErrorDetailFormPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(FAFMappingUploadErrorDetailFormPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List<MappingDataUploadDTO.FailedRowData> failDataRows = this.getFailDataRows();
        this.initErrorInfoEntry(failDataRows);
    }

    private void initErrorInfoEntry(List<MappingDataUploadDTO.FailedRowData> failDataRows) {
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
        model.beginInit();
        int[] entryEntities = model.batchCreateNewEntryRow("entryentity", failDataRows.size());
        DynamicProperty errorInfo = entryEntity.getDynamicObjectType().getProperty("error_info");
        for (int i = 0; i < entryEntities.length; ++i) {
            errorInfo.setValueFast(entryEntity.get(entryEntities[i]), (Object)failDataRows.get(i).getFailMessage());
        }
        model.endInit();
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("download".equals(itemKey)) {
            this.download();
        }
    }

    private void download() {
        OutputStream fos = null;
        FileInputStream fis = null;
        try {
            SXSSFWorkbook workbook = this.buildWorkBook();
            File temp = File.createTempFile(FilenameUtils.getName((String)UUID.randomUUID().toString()), ".xlsx");
            fos = new FileOutputStream(temp);
            workbook.write(fos);
            fis = new FileInputStream(temp);
            String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsFullUrl(ResManager.loadKDString((String)"\u6620\u5c04\u5173\u7cfb\u4e0a\u4f20\u9519\u8bef\u8be6\u60c5.xlsx", (String)"FAFMappingUploadErrorDetailFormPlugin_2", (String)"macc-faf-formplugin", (Object[])new Object[0]), (InputStream)fis, 60);
            fis.close();
            this.getView().download(url);
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
        }
    }

    private SXSSFWorkbook buildWorkBook() {
        SXSSFWorkbook workbook = new SXSSFWorkbook();
        SXSSFSheet sheet = workbook.createSheet("sheet1");
        SXSSFRow titleRow = FAFMappingUploadErrorDetailFormPlugin.getRow(sheet, 0);
        this.createCell(titleRow, 0, this.getCellStyle((Workbook)workbook, false, true)).setCellValue(ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f", (String)"FAFMappingUploadErrorDetailFormPlugin_1", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entryEntity.size(); ++i) {
            SXSSFRow row = FAFMappingUploadErrorDetailFormPlugin.getRow(sheet, i + 1);
            String errorInfo = ((DynamicObject)entryEntity.get(i)).getString("error_info");
            this.createCell(row, 0, this.getCellStyle((Workbook)workbook, false, false)).setCellValue(errorInfo);
        }
        return workbook;
    }

    private CellStyle getCellStyle(Workbook workbook, boolean isHighLight, boolean isDefaultCell) {
        CellStyle cs = workbook.createCellStyle();
        cs.setAlignment(this.getAlignment("default"));
        if (isHighLight) {
            Font font = workbook.createFont();
            font.setColor(IndexedColors.RED.getIndex());
            cs.setFont(font);
            cs.setDataFormat(workbook.createDataFormat().getFormat("@"));
        }
        if (isDefaultCell) {
            cs.setFillForegroundColor(HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex());
            cs.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        }
        return cs;
    }

    private HorizontalAlignment getAlignment(String align) {
        try {
            return HorizontalAlignment.valueOf((String)align.toUpperCase());
        }
        catch (Throwable var3) {
            return HorizontalAlignment.GENERAL;
        }
    }

    public static SXSSFRow getRow(SXSSFSheet sheet, int r) {
        SXSSFRow row = sheet.getRow(r);
        if (row == null) {
            row = sheet.createRow(r);
        }
        return row;
    }

    private SXSSFCell createCell(SXSSFRow row, int column, CellStyle style) {
        SXSSFCell cell = row.createCell(column);
        cell.setCellStyle(style);
        return cell;
    }

    private List<MappingDataUploadDTO.FailedRowData> getFailDataRows() {
        return (List)JSON.parseObject((String)((String)this.getView().getFormShowParameter().getCustomParam("errorDetails")), (TypeReference)new TypeReference<List<MappingDataUploadDTO.FailedRowData>>(){}, (Feature[])new Feature[0]);
    }

    public static void open(IFormView view, List<MappingDataUploadDTO.FailedRowData> failedDataRows) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("pa_mappinguploaderrdetail");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u9519\u8bef\u8be6\u60c5", (String)"FAFMappingUploadErrorDetailFormPlugin_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("errorDetails", (Object)JSON.toJSONString(failedDataRows));
        view.showForm(formShowParameter);
    }
}

