/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.system;

import java.util.Collection;
import java.util.EventObject;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.SaveAndNew;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.macc.faf.enums.DimensionTypeEnum;
import kd.macc.faf.enums.FAFDimensionTypeEnum;
import kd.macc.faf.enums.ImportSystemSourceTypeEnum;
import kd.macc.faf.enums.MeasureTypeEnum;
import kd.macc.faf.helper.EntityMetaHelper;
import kd.macc.faf.helper.FAFAnalysisModelHelper;
import kd.macc.faf.system.FAFAnalysisSystemConfigEdit;
import kd.macc.faf.util.AnalysisModelUtil;
import kd.macc.faf.util.CustomizedDynamicFormBuilderUtil;
import kd.macc.faf.util.CustomizedFormBuilderInfo;

public class FAFMeasureEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private final String[] conentpanel = new String[]{"number", "system", "measuretype", "situationtype", "aggregationtype", "measure", "dimension", "dimensionattr"};

    public void registerListener(EventObject evt) {
        this.addClickListeners(new String[]{"dimensionattr"});
        BasedataEdit measureBaseDataEdit = (BasedataEdit)this.getView().getControl("measure");
        measureBaseDataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit dimensionBaseDataEdit = (BasedataEdit)this.getView().getControl("dimension");
        dimensionBaseDataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        DynamicObject system = this.getSystem();
        if (system == null) {
            e.setCancel(true);
            return;
        }
        switch (key) {
            case "measure": {
                e.addCustomQFilter(new QFilter("system", "=", system.getPkValue()));
                String situationType = (String)this.getModel().getValue("situationtype");
                if (situationType != null) {
                    e.addCustomQFilter(new QFilter("situationtype", "=", (Object)situationType));
                }
                e.addCustomQFilter(new QFilter("measuretype", "=", (Object)String.valueOf(MeasureTypeEnum.ORDINARY.getCode())));
                break;
            }
            case "dimension": {
                e.addCustomQFilter(new QFilter("system", "=", system.getPkValue()));
                e.addCustomQFilter(new QFilter("dimensiontype", "!=", (Object)FAFDimensionTypeEnum.DATE.getCode()));
                e.addCustomQFilter(new QFilter("dimensionsource", "=", (Object)"bd_period"));
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("measuretype", (Object)MeasureTypeEnum.ORDINARY.getCode());
        this.getView().setVisible(Boolean.FALSE, new String[]{"fieldsetpanelap"});
        Long anaSystemId = (Long)this.getView().getFormShowParameter().getCustomParam("system");
        if (anaSystemId != null && anaSystemId != 0L) {
            this.getModel().setValue("system", (Object)anaSystemId);
            this.getView().setEnable(Boolean.FALSE, new String[]{"system"});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.lockCtrls();
        String measureType = (String)this.getModel().getValue("measuretype");
        if (MeasureTypeEnum.ORDINARY == MeasureTypeEnum.getEnum((String)measureType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"fieldsetpanelap"});
        } else if (MeasureTypeEnum.CALCULATION == MeasureTypeEnum.getEnum((String)measureType)) {
            this.setMustInputOfCalculation(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if ("save".equals(operateKey) && operationResult.isSuccess()) {
            String nameChanged = this.getPageCache().get("nameChanged");
            if ("true".equals(nameChanged)) {
                try {
                    this.updateReferMeasureNameOfModel();
                    this.getPageCache().put("nameChanged", "false");
                }
                catch (Exception exception) {
                    throw new KDBizException(new ErrorCode("", exception.getMessage()), new Object[]{exception.getMessage(), exception});
                }
            }
            FAFAnalysisSystemConfigEdit.refreshParentPageAfterSave(this.getView());
        }
        if (args.getSource() instanceof SaveAndNew && operationResult.isSuccess()) {
            this.unlockCtrls();
        }
    }

    private void updateReferMeasureNameOfModel() {
        QFilter systemFilter = new QFilter("analysis_system", "=", (Object)((DynamicObject)this.getModel().getValue("system")).getLong("id"));
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"pa_analysismodel", (QFilter[])new QFilter[]{systemFilter, enableFilter});
        Object measureNumber = this.getModel().getValue("number");
        if (!CollectionUtils.isEmpty((Map)dynamicObjectMap)) {
            for (DynamicObject model : dynamicObjectMap.values()) {
                Optional<DynamicObject> first = model.getDynamicObjectCollection("measure_entry").stream().filter(entry -> measureNumber.equals(entry.getDynamicObject("measure").getString("number"))).findFirst();
                if (!first.isPresent()) continue;
                String tableNumber = model.getString("tablenumber");
                String tableName = model.getString("tablename");
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)tableNumber)) continue;
                this.updateModelTableName(tableNumber, tableName, model);
                boolean isNewVersion = FAFAnalysisModelHelper.isModelNewVersion((DynamicObject)model);
                if (!isNewVersion) continue;
                String tableNumber_dtl = tableNumber + "_d";
                String inputTableName_dtl = tableName + "_d";
                this.updateModelTableName(tableNumber_dtl, inputTableName_dtl, model);
            }
        }
    }

    private void updateModelTableName(String tableNumber, String tableName, DynamicObject model) {
        CustomizedFormBuilderInfo builderInfo = CustomizedDynamicFormBuilderUtil.createCustomizedFormBuilderInfo((String)AnalysisModelUtil.buildEntityNumber((String)tableNumber), (String)tableName, (String)"2UK0B8T0A=WJ", (String)"BaseFormModel");
        Object measureNumber = this.getModel().getValue("number");
        String measureName = this.getModel().getValue("name").toString();
        builderInfo.getEntityMeta().getItems().stream().filter(item -> measureNumber.equals(item.getKey())).findFirst().ifPresent(entityItem -> entityItem.setName(new LocaleString(measureName)));
        EntityMetaHelper.constructMetadataList((CustomizedFormBuilderInfo)builderInfo, (DynamicObject)model);
        CustomizedDynamicFormBuilderUtil.checkDesignerDataSaveResult((CustomizedFormBuilderInfo)builderInfo, (Map)CustomizedDynamicFormBuilderUtil.SaveEntityPage((CustomizedFormBuilderInfo)builderInfo, (Boolean)Boolean.FALSE), (boolean)true);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        switch (propName = e.getProperty().getName()) {
            case "measuretype": {
                this.changeMeasureType();
                break;
            }
            case "dimension": {
                this.clearDimensionAttr();
                break;
            }
            case "system": {
                this.clearComputationalFields();
                break;
            }
            case "number": {
                String number = (String)this.getModel().getValue("number");
                number = org.apache.commons.lang3.StringUtils.lowerCase((String)number);
                this.getModel().setValue("number", (Object)number);
                break;
            }
            case "measure": {
                this.changeMeasure();
                break;
            }
            case "situationtype": {
                this.getModel().setValue("measure", null);
                break;
            }
            case "name": {
                Object oldValue = e.getChangeSet()[0].getOldValue();
                Object newValue = e.getChangeSet()[0].getNewValue();
                if (ObjectUtils.nullSafeEquals((Object)oldValue, (Object)newValue)) break;
                this.getPageCache().put("nameChanged", "true");
                break;
            }
            case "dimensionattr": {
                if (e.getChangeSet() == null || !StringUtils.isBlank((Object)e.getChangeSet()[0].getNewValue())) break;
                this.getModel().setValue("dimensionattrnb", null);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("dimensionattr".equals(key)) {
            this.showAggregationAttribute();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        DynamicObjectCollection returnData = (DynamicObjectCollection)closedCallBackEvent.getReturnData();
        if (CollectionUtils.isEmpty((Collection)returnData)) {
            return;
        }
        String actionId = closedCallBackEvent.getActionId();
        if ("dimensionattr".equals(actionId)) {
            String showNumber = returnData.stream().map(e -> e.getString("shownumber")).collect(Collectors.joining(","));
            String showName = returnData.stream().map(e -> e.getString("showname")).collect(Collectors.joining(","));
            this.getModel().setValue("dimensionattrnb", (Object)showNumber);
            this.getModel().setValue("dimensionattr", (Object)showName);
        }
    }

    private void setMustInputOfCalculation(boolean isMustInput) {
        ComboEdit aggregationTypeControl = (ComboEdit)this.getControl("aggregationtype");
        BasedataEdit dimensionControl = (BasedataEdit)this.getControl("dimension");
        BasedataEdit measureControl = (BasedataEdit)this.getControl("measure");
        aggregationTypeControl.setMustInput(isMustInput);
        dimensionControl.setMustInput(isMustInput);
        measureControl.setMustInput(isMustInput);
    }

    private void changeMeasure() {
        String situationTypeOld = (String)this.getModel().getValue("situationtype");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)situationTypeOld)) {
            String situationTypeNew;
            DynamicObject measure = (DynamicObject)this.getModel().getValue("measure");
            String string = situationTypeNew = measure != null ? measure.getString("situationtype") : null;
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)situationTypeNew)) {
                this.getModel().setValue("situationtype", (Object)situationTypeNew);
            }
        }
    }

    private void clearDimensionAttr() {
        this.getModel().setValue("dimensionattr", null);
        this.getModel().setValue("dimensionattrnb", null);
    }

    private void changeMeasureType() {
        String measureType = (String)this.getModel().getValue("measuretype");
        MeasureTypeEnum measureTypeEnum = MeasureTypeEnum.getEnum((String)measureType);
        if (MeasureTypeEnum.ORDINARY == measureTypeEnum) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"fieldsetpanelap"});
            this.clearComputationalFields();
            this.setMustInputOfCalculation(false);
        } else if (MeasureTypeEnum.CALCULATION == measureTypeEnum) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"fieldsetpanelap"});
            this.setMustInputOfCalculation(true);
        }
    }

    private void clearComputationalFields() {
        this.getModel().setValue("aggregationtype", null);
        this.getModel().setValue("measure", null);
        this.getModel().setValue("dimension", null);
        this.clearDimensionAttr();
    }

    private void showAggregationAttribute() {
        DynamicObject dimensionAttr = (DynamicObject)this.getModel().getValue("dimension");
        if (dimensionAttr == null) {
            return;
        }
        String dimensionType = dimensionAttr.getString("dimensiontype");
        DimensionTypeEnum dimensionTypeEnum = DimensionTypeEnum.getCode((String)dimensionType);
        String entityName = "bos_assistantdata_detail";
        if (DimensionTypeEnum.DATABASE == dimensionTypeEnum) {
            DynamicObject dimensionSource = dimensionAttr.getDynamicObject("dimensionsource");
            entityName = dimensionSource.getString("number");
        } else if (DimensionTypeEnum.PERIOD == dimensionTypeEnum) {
            entityName = "kd.macc.faf.designer.FAFPeriodAttributeShow";
        }
        if (entityName != null) {
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("pa_aggregationattribute");
            fsp.setCustomParam("entityName", (Object)entityName);
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "dimensionattr"));
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(fsp);
        }
    }

    private void lockCtrls() {
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        if (pkValue > 0L) {
            Boolean isdefault = (Boolean)this.getModel().getValue("isdefault");
            if (Boolean.TRUE.equals(isdefault)) {
                this.getView().setEnable(Boolean.FALSE, this.conentpanel);
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"system"});
            }
            if (BaseDataRefrenceHelper.isRefrenced((String)"pa_measure", (Object)pkValue)) {
                this.getView().setEnable(Boolean.FALSE, this.conentpanel);
            }
        }
        String systemSource = (String)this.getModel().getValue("systemsource");
        if (ImportSystemSourceTypeEnum.BCM.getCode().equals(systemSource) || ImportSystemSourceTypeEnum.EPM.getCode().equals(systemSource)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"measuretype"});
        }
    }

    private void unlockCtrls() {
        this.getView().setEnable(Boolean.TRUE, this.conentpanel);
    }

    private DynamicObject getSystem() {
        DynamicObject dy = (DynamicObject)this.getModel().getValue("system");
        if (dy == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5206\u6790\u4f53\u7cfb\u201d\u3002", (String)"FAFMeasureEdit_1", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            return null;
        }
        return dy;
    }
}

