/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.system;

import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.macc.faf.dto.ResultDTO;
import kd.macc.faf.enums.OlapFromServiceEnum;
import kd.macc.faf.handle.DataImportFactoryBuilder;
import kd.macc.faf.param.FAFImportDimMember;

public class FAFMeasureList
extends AbstractListPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"_toolbar_"});
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "bcm": 
            case "epm": {
                this.showMemberSelect(itemKey);
                break;
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        Long anaSystemId = (Long)this.getView().getFormShowParameter().getCustomParam("anaSystemId");
        if (anaSystemId != null && anaSystemId != 0L) {
            QFilter filter = new QFilter("system", "=", (Object)anaSystemId);
            e.addCustomQFilter(filter);
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        Long anaSystemId = (Long)this.getView().getFormShowParameter().getCustomParam("anaSystemId");
        if (anaSystemId != null && anaSystemId != 0L) {
            e.getParameter().setCustomParam("system", (Object)anaSystemId);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if ("delete".equals(operateKey) && operationResult.isSuccess()) {
            List successPkIds;
            IFormView anaSystemConfigView = this.getView().getParentView();
            if (anaSystemConfigView != null && "pa_anasystemconfig".equals(anaSystemConfigView.getEntityId())) {
                anaSystemConfigView.updateView();
                this.getView().sendFormAction(anaSystemConfigView);
            }
            if ((successPkIds = operationResult.getSuccessPkIds()) != null && !successPkIds.isEmpty()) {
                Set deleteIdSet = successPkIds.stream().map(p -> Long.parseLong(String.valueOf(p))).collect(Collectors.toSet());
                DataImportFactoryBuilder.deleteMeasureMapping((OlapFromServiceEnum)OlapFromServiceEnum.EPM, deleteIdSet);
            }
        }
    }

    private void showMemberSelect(String importTypeKey) {
        FAFImportDimMember.showMember((AbstractFormPlugin)this, importTypeKey, importTypeKey);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        IFormView view = this.getView();
        if (returnData != null && ("epm".equals(actionId) || "bcm".equals(actionId))) {
            ResultDTO result;
            IFormView parentView = view.getParentView();
            if (parentView != null && "pa_anasystemconfig".equals(parentView.getEntityId())) {
                parentView.updateView();
                view.sendFormAction(parentView);
            }
            if ((result = (ResultDTO)returnData).isExceptionInterrupt()) {
                view.showMessage(ResManager.loadKDString((String)"\u5bfc\u5165\u5ea6\u91cf\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u76f8\u5173\u4eba\u5458\u6392\u67e5", (String)"FAFMeasureList_3", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            } else {
                int success = result.getSuccess();
                int failure = result.getFailure();
                String message = result.getMessage();
                if (failure == 0 && message == null) {
                    view.showMessage(String.format(ResManager.loadKDString((String)"\u6210\u529f\u4fdd\u5b58%d\u6761\u5ea6\u91cf", (String)"FAFMeasureList_4", (String)"macc-faf-formplugin", (Object[])new Object[0]), success));
                } else {
                    view.showMessage(String.format(ResManager.loadKDString((String)"\u6210\u529f%1$d\u6761\uff0c\u5931\u8d25%2$d\u6761\uff0c\u539f\u56e0\uff1a%3$s", (String)"FAFMeasureList_5", (String)"macc-faf-formplugin", (Object[])new Object[0]), success, failure, message));
                }
            }
            view.invokeOperation("refresh");
        }
    }
}

