/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.system;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.macc.faf.asynctask.model.BackGroupUpgradeTaskCreator;
import kd.macc.faf.exception.ModelUpgradeException;
import kd.macc.faf.helper.ModelUpgradeHelper;

public class FAFModelUpgradeRecordFormEdit
extends AbstractFormPlugin {
    private static final String ENTRY_ENTITY = "entryentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("cancelupgrade".equals(itemKey)) {
            this.cancelUpgrade();
        } else if ("retry".equals(itemKey)) {
            this.retryUpgrade();
        }
    }

    private void retryUpgrade() {
        int[] selectedRows = ((EntryGrid)this.getControl(ENTRY_ENTITY)).getEntryState().getSelectedRows();
        if (ArrayUtils.isEmpty((int[])selectedRows)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u91cd\u8bd5\u7684\u6a21\u578b\u5347\u7ea7\u5206\u5f55\u6570\u636e\u3002", (String)"FAFModelUpgradeRecordFormEdit_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            return;
        }
        Long systemId = (Long)this.getModel().getValue("anasystem_id");
        List modelIds = Arrays.stream(selectedRows).boxed().map(index -> (Long)this.getModel().getValue("anamodel_id", index.intValue())).collect(Collectors.toList());
        HashMap<Long, List<Long>> retryModelSystemMap = new HashMap<Long, List<Long>>();
        retryModelSystemMap.put(systemId, modelIds);
        try {
            ModelUpgradeHelper.preExecuteUpgradeModel(retryModelSystemMap);
            BackGroupUpgradeTaskCreator.createBackGroundModelUpgradeTask(this.getView(), retryModelSystemMap);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u8bd5\u6210\u529f\u3002", (String)"FAFModelUpgradeRecordFormEdit_1", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        }
        catch (ModelUpgradeException modelUpgradeException) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u5141\u8bb8\u5bf9\u5347\u7ea7\u72b6\u6001\u4e3a\u3010\u5931\u8d25\u3011\u6216\u3010\u5df2\u53d6\u6d88\u3011\u7684\u65e7\u7248\u672c\u6a21\u578b\u4efb\u52a1\u8fdb\u884c\u91cd\u8bd5\u3002", (String)"FAFModelUpgradeRecordFormEdit_2", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        }
        catch (Exception exception) {
            throw new KDBizException(exception.getCause() != null ? exception.getCause().getMessage() : exception.getMessage());
        }
    }

    private void cancelUpgrade() {
        int[] selectedRows = ((EntryGrid)this.getControl(ENTRY_ENTITY)).getEntryState().getSelectedRows();
        if (ArrayUtils.isEmpty((int[])selectedRows)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u53d6\u6d88\u7684\u6a21\u578b\u5347\u7ea7\u5206\u5f55\u6570\u636e\u3002", (String)"FAFModelUpgradeRecordFormEdit_3", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            return;
        }
        Long systemId = (Long)this.getModel().getValue("anasystem_id");
        List modelIds = Arrays.stream(selectedRows).boxed().map(index -> (Long)this.getModel().getValue("anamodel_id", index.intValue())).collect(Collectors.toList());
        try {
            Tuple isSucceed = ModelUpgradeHelper.cancelModelUpgrade((Long)systemId, modelIds);
            if (((Boolean)isSucceed.item1).booleanValue()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u5347\u7ea7\u6210\u529f\u3002", (String)"FAFModelUpgradeRecordFormEdit_4", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
                this.refreshParentView();
            } else {
                this.getView().showTipNotification((String)isSucceed.item2);
            }
        }
        catch (Exception e) {
            throw new KDBizException(e.getCause() != null ? e.getCause().getMessage() : e.getMessage());
        }
    }

    private void refreshParentView() {
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView != null) {
            parentView.updateView();
            this.getView().sendFormAction(parentView);
        }
    }
}

