/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.system;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.macc.faf.helper.ModelUpgradeHelper;

public class FAFModelUpgradeSelectFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String ENTRY_ENTITY = "entryentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        BasedataEdit system = (BasedataEdit)this.getControl("system");
        system.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit model = (MulBasedataEdit)this.getControl("model");
        model.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key) && this.validateEmpty()) {
            HashMap<Long, List<Long>> systemIdToModelIdsMap = this.buildReturnData();
            this.getView().returnDataToParent(systemIdToModelIdsMap);
            this.getView().close();
        }
    }

    private HashMap<Long, List<Long>> buildReturnData() {
        HashMap<Long, List<Long>> systemIdToModelIdsMap = new HashMap<Long, List<Long>>();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        for (DynamicObject entry : entryEntity) {
            long systemId = entry.getLong("system_id");
            List modelIds = entry.getDynamicObjectCollection("model").stream().map(dy -> dy.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            systemIdToModelIdsMap.put(systemId, modelIds);
        }
        return systemIdToModelIdsMap;
    }

    private boolean validateEmpty() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5347\u7ea7\u5206\u5f55\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"FAFModelUpgradeSelectFormPlugin_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            return false;
        }
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            if (entry.getDynamicObject("system") == null) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u660e\u7ec6\u4e2d,\u5206\u6790\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FAFModelUpgradeSelectFormPlugin_1", (String)"macc-faf-formplugin", (Object[])new Object[0]), i + 1));
                return false;
            }
            if (!CollectionUtils.isEmpty((Collection)entry.getDynamicObjectCollection("model"))) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u660e\u7ec6\u4e2d,\u5206\u6790\u6a21\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FAFModelUpgradeSelectFormPlugin_2", (String)"macc-faf-formplugin", (Object[])new Object[0]), i + 1));
            return false;
        }
        return true;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        switch (fieldKey) {
            case "system": {
                Map currentToUpgradeModelIds = ModelUpgradeHelper.getCurrentEnableUpgradeModelIds();
                if (CollectionUtils.isEmpty((Map)currentToUpgradeModelIds)) break;
                HashSet upgradeSystemIds = new HashSet(currentToUpgradeModelIds.keySet());
                Set selectedSystemIds = entryEntity.stream().map(entry -> entry.getLong("system_id")).collect(Collectors.toSet());
                upgradeSystemIds.removeAll(selectedSystemIds);
                beforeF7SelectEvent.getCustomQFilters().add(new QFilter("id", "in", upgradeSystemIds));
                break;
            }
            case "model": {
                EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
                int focusRow = entryGrid.getEntryState().getFocusRow();
                Long systemId = (Long)this.getModel().getValue("system_id", focusRow);
                if (0L == systemId) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u6790\u4f53\u7cfb\u3002", (String)"FAFModelUpgradeSelectFormPlugin_3", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                beforeF7SelectEvent.getCustomQFilters().add(new QFilter("id", "in", ModelUpgradeHelper.getCurrentEnableUpgradeModelIds().get(systemId)));
                break;
            }
        }
    }

    public static void openBy(IFormView formView, IFormPlugin formPlugin) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("faf_modelupgradeselect");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack(formPlugin, "model_upgrade_select"));
        formView.showForm(formShowParameter);
    }
}

