/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.system;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.CRValByConditions;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.macc.faf.absplugin.SafeAbstractFormPlugin;
import kd.macc.faf.common.FAFUtils;
import kd.macc.faf.datasource.dynamic.DataSource;
import kd.macc.faf.datasync.BusinessDynamicObjectFactory;
import kd.macc.faf.datasync.DataSyncBusinessHelper;
import kd.macc.faf.datasync.exec.data.DataSyncDimension;
import kd.macc.faf.datasync.exec.data.DataSyncModel;
import kd.macc.faf.datasync.exec.data.DataSyncSchema;
import kd.macc.faf.datasync.exec.impl.EntitySyncSchema;
import kd.macc.faf.designer.FAFNonBaseDataSelectFormPlugin;
import kd.macc.faf.designer.FAFSelectFieldDialogPlugin;
import kd.macc.faf.designer.field.DefaultCombo;
import kd.macc.faf.designer.field.DefaultDate;
import kd.macc.faf.designer.field.DefaultField;
import kd.macc.faf.designer.field.DefaultText;
import kd.macc.faf.dialog.SyncDataConditionDialogPlugin;
import kd.macc.faf.dto.TagTextFiledData;
import kd.macc.faf.enums.DataSourceTypeEnum;
import kd.macc.faf.enums.DimensionSelectTypeEnum;
import kd.macc.faf.enums.SelectTypeEnum;
import kd.macc.faf.helper.FAFAnasystemSettingHelper;
import kd.macc.faf.helper.FAFDataSourceConfigHelper;
import kd.macc.faf.system.FAFAnalysisSystemConfigEdit;
import kd.macc.faf.util.BaseDataUtil;
import kd.macc.faf.verification.GetValByConditionFormPlugin;

public class FAFSyncDataSchemaEdit
extends SafeAbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(FAFSyncDataSchemaEdit.class);
    private static final String PAGE_FIELDNODE = "fieldnode";
    private static final String FIELD_SYSTEM = "model";
    private static final String FIELD_MODEL = "analysismodel";
    private static final String FIELD_DATASOURCE = "datasource";
    private static final String ENTRY_F_DIMENSIONFIELD_NAME = "dimensionfieldname";
    private static final String ENTRY_F_DIMENSIONFIELD = "dimensionfield";
    private static final String ENTRY_F_DIM_DEFAULT_VALUE_NAME = "dimdefaultvaluename";
    private static final String ENTRY_F_DIM_DEFAULT_VALUE = "dimdefaultvalue";
    private static final String ENTRY_DIMENSION = "dimensionmapentry";
    private static final String ENTRY_F_DIMCONDITIONDESC = "dimconditiondesc";
    private static final String ENTRY_F_DIMCONDITIONVAL = "dimconditionval_tag";
    private static final String ENTRY_MEASURE = "measuremapentry";
    private static final String ENTRY_F_DIMMEASURE_FIELDNAME = "dimmeasurefieldname";
    private static final String ACTION_SET_SOURCE_DIMENSIONFIELD = "setsourcedimensionfield";
    private static final String ACTION_SET_SOURCE_MEASUREFIELD = "setsourcemeasurefield";
    private static final String ACTION_SET_MEASURECONDITION = "measurecondition";
    private static final String ACTIONID_SET_VALUE_BYDIALOG = "actionid_set_value_by_dialog";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{ENTRY_F_DIMENSIONFIELD_NAME, "conditiondesc", ENTRY_F_DIM_DEFAULT_VALUE_NAME, ENTRY_F_DIMMEASURE_FIELDNAME});
        this.addClickListeners(new String[]{ENTRY_F_DIMCONDITIONDESC});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        BasedataEdit analysisModel = (BasedataEdit)this.getControl(FIELD_MODEL);
        analysisModel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit dataSource = (BasedataEdit)this.getControl(FIELD_DATASOURCE);
        dataSource.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit mappingRelation = (BasedataEdit)this.getControl("mappingrelationship");
        mappingRelation.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key = ((BasedataEdit)event.getSource()).getKey();
        if (FIELD_MODEL.equals(key)) {
            Object analysisSystem = this.getModel().getValue(FIELD_SYSTEM);
            if (analysisSystem == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u6790\u4f53\u7cfb\u3002", (String)"FAFSyncDataSchemaEdit_1", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                event.setCancel(true);
                return;
            }
            QFilter filter = new QFilter("analysis_system", "=", ((DynamicObject)analysisSystem).get("id")).and("tablenumber", "!=", (Object)" ");
            ListShowParameter lsp = (ListShowParameter)event.getFormShowParameter();
            lsp.getListFilterParameter().setFilter(filter);
        } else if (FIELD_DATASOURCE.equals(key)) {
            DynamicObject analysisModel = (DynamicObject)this.getModel().getValue(FIELD_MODEL);
            if (analysisModel == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u6790\u6a21\u578b\u3002", (String)"FAFSyncDataSchemaEdit_2", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                event.setCancel(true);
                return;
            }
            DataSyncModel dataSyncModel = BusinessDynamicObjectFactory.createDataSyncModel((Object)analysisModel.getPkValue());
            EntitySyncSchema syncSchema = new EntitySyncSchema(this.getModel().getDataEntity(), dataSyncModel, null);
            QFilter qFilter = syncSchema.matchDataSources();
            ListShowParameter lsp = (ListShowParameter)event.getFormShowParameter();
            lsp.getListFilterParameter().setFilter(qFilter);
        } else if ("mappingrelationship".equals(key)) {
            int row = event.getRow();
            Long dimensionPkvalue = (Long)this.getModel().getValue("dimension_id", row);
            DataSyncSchema syncSchema = BusinessDynamicObjectFactory.createDataSyncSchema((Object)this.getModel().getDataEntity(true));
            Set mappingIds = syncSchema.matchMapping(dimensionPkvalue);
            ListShowParameter lsp = (ListShowParameter)event.getFormShowParameter();
            lsp.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)mappingIds));
            lsp.setMultiSelect(false);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long anaSystemId = (Long)this.getView().getFormShowParameter().getCustomParam("anaSystemId");
        if (anaSystemId != null && anaSystemId > 0L) {
            this.getModel().setValue(FIELD_SYSTEM, (Object)anaSystemId);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{FIELD_SYSTEM});
            DynamicObject allPropertyModel = FAFAnasystemSettingHelper.getAnasystemSettingById((Object)anaSystemId);
            this.getModel().setValue("bizapp", (Object)allPropertyModel.getDynamicObject("modulerange"));
        }
    }

    public void afterLoadData(EventObject e) {
        this.initDimensinMeasureEntryRow();
        this.resetEntryMeasureSelectSetting();
        this.refreshEntrySetting();
        this.getModel().setDataChanged(false);
    }

    public void afterCopyData(EventObject e) {
        this.initDimensinMeasureEntryRow();
        this.resetEntryMeasureSelectSetting();
        this.refreshEntrySetting();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if ("save".equals(operateKey) && operationResult.isSuccess()) {
            FAFAnalysisSystemConfigEdit.refreshParentPageAfterSave(this.getView());
        }
    }

    @Override
    public void propertyChangedSafe(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        switch (propertyName) {
            case "model": {
                DynamicObject model = (DynamicObject)changeData.getNewValue();
                this.changeModel(model);
                break;
            }
            case "analysismodel": {
                this.getModel().setValue(FIELD_DATASOURCE, null);
                break;
            }
            case "datasource": {
                if (this.validateAnaModelAndDataSource()) {
                    this.resetDimensionAndMeasureEntry();
                    break;
                }
                this.getModel().beginInit();
                this.getModel().setValue(propertyName, changeData.getOldValue());
                this.getModel().endInit();
                this.getView().updateView(propertyName);
                break;
            }
            case "dimensionfieldname": {
                if (!StringUtils.isEmpty((CharSequence)String.valueOf(changeData.getNewValue()))) break;
                int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_DIMENSION);
                this.getModel().setValue(ENTRY_F_DIMENSIONFIELD, null, rowIndex);
                this.getModel().setValue(ENTRY_F_DIMCONDITIONDESC, null, rowIndex);
                this.getModel().setValue(ENTRY_F_DIMCONDITIONVAL, null, rowIndex);
                break;
            }
            case "dimensionfield": 
            case "measurefield": {
                this.resetEntryMeasureSelectSetting();
                break;
            }
            case "selecttype": {
                this.getModel().setValue("condition_tag", null);
                this.getModel().setValue("dimmeasurefield", null);
                this.getModel().setValue(ENTRY_F_DIMMEASURE_FIELDNAME, null);
                this.refreshMeasureEntryVisible();
                break;
            }
            case "dimdefaultvaluename": {
                this.getModel().setValue(ENTRY_F_DIM_DEFAULT_VALUE, changeData.getNewValue(), this.getModel().getEntryCurrentRowIndex(ENTRY_DIMENSION));
                break;
            }
            case "dimensionselecttype": {
                int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_DIMENSION);
                this.getModel().setValue(ENTRY_F_DIMENSIONFIELD, null, rowIndex);
                this.getModel().setValue(ENTRY_F_DIMENSIONFIELD_NAME, null, rowIndex);
                this.getModel().setValue(ENTRY_F_DIMCONDITIONDESC, null, rowIndex);
                this.getModel().setValue(ENTRY_F_DIMCONDITIONVAL, null, rowIndex);
                this.getModel().setValue("mappingrelationship", null, rowIndex);
                this.getModel().setValue(ENTRY_F_DIM_DEFAULT_VALUE, null, rowIndex);
                this.getModel().setValue(ENTRY_F_DIM_DEFAULT_VALUE_NAME, null, rowIndex);
                this.refreshDimensionEntryVisible();
                break;
            }
            case "dimmeasurefieldname": {
                if (!StringUtils.isEmpty((CharSequence)String.valueOf(changeData.getNewValue()))) break;
                int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_MEASURE);
                this.getModel().setValue("dimmeasurefield", null, rowIndex);
                break;
            }
            case "dimconditiondesc": {
                Object newValue = e.getChangeSet()[0].getNewValue();
                if (!StringUtils.isBlank((Object)newValue)) break;
                int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_DIMENSION);
                this.getModel().setValue(ENTRY_F_DIMCONDITIONVAL, null, rowIndex);
            }
        }
    }

    @Override
    public void clickSafe(EventObject evt) {
        String key;
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "dimensionfieldname": {
                this.showSelectSourceDimensionDialog();
                break;
            }
            case "dimconditiondesc": {
                this.showDimensionConditionDialog();
                break;
            }
            case "dimmeasurefieldname": {
                this.showSelectSourceMeasureDialog();
                break;
            }
            case "conditiondesc": {
                this.showCondition();
                break;
            }
            case "dimdefaultvaluename": {
                this.showDefaultValueSelectPage();
            }
        }
    }

    @Override
    public void itemClickSafe(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("automatch".equals(itemKey)) {
            this.matchDimensionEntry("autoMatch");
            this.refreshEntrySetting();
            this.getView().updateView(ENTRY_DIMENSION);
        }
    }

    @Override
    public void closedCallBackSafe(ClosedCallBackEvent event) {
        TagTextFiledData data;
        String actionId = event.getActionId();
        if (ACTION_SET_SOURCE_DIMENSIONFIELD.equals(actionId)) {
            Map selectFields;
            Set entrySet;
            Iterator iterator;
            Object returnData = event.getReturnData();
            if (returnData instanceof Map && (iterator = (entrySet = (selectFields = (Map)FAFUtils.cast((Object)returnData)).entrySet()).iterator()).hasNext()) {
                Map.Entry next = iterator.next();
                IDataModel model = this.getModel();
                int dimensionEntryIndex = model.getEntryCurrentRowIndex(ENTRY_DIMENSION);
                model.setValue(ENTRY_F_DIMENSIONFIELD_NAME, next.getValue(), dimensionEntryIndex);
                model.setValue(ENTRY_F_DIMENSIONFIELD, next.getKey(), dimensionEntryIndex);
            }
        } else if (ACTION_SET_MEASURECONDITION.equals(actionId)) {
            String returnData = (String)event.getReturnData();
            if (StringUtils.isNotBlank((CharSequence)returnData)) {
                CRValByConditions valByConditions = (CRValByConditions)SerializationUtils.fromJsonString((String)returnData, CRValByConditions.class);
                int currentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_MEASURE);
                this.getModel().setValue("condition_tag", (Object)returnData, currentRowIndex);
                this.getModel().setValue("conditiondesc", (Object)valByConditions.getDescription(), currentRowIndex);
            }
        } else if ("DatabaseOrAssistantDimension".equals(actionId)) {
            TagTextFiledData filedData = new TagTextFiledData(ENTRY_F_DIM_DEFAULT_VALUE_NAME, ENTRY_F_DIM_DEFAULT_VALUE);
            filedData.callBackValue(event.getReturnData());
            filedData.fillValue(this.getModel());
        } else if ("NonBaseDataDimension".equals(actionId)) {
            DefaultField returnData = (DefaultField)event.getReturnData();
            if (returnData == null) {
                return;
            }
            String value = null;
            String name = null;
            switch (returnData.getType()) {
                case TEXT: {
                    name = value = ((DefaultText)returnData).getValue();
                    break;
                }
                case DATE: {
                    Date date = ((DefaultDate)returnData).getDate();
                    if (date == null) break;
                    name = value = new SimpleDateFormat("yyyy-MM-dd").format(date);
                    break;
                }
                case COMBO: {
                    DefaultCombo combo = (DefaultCombo)returnData;
                    LinkedHashMap comboEnumMap = combo.getComboEnumMap();
                    value = combo.getValue();
                    name = comboEnumMap.entrySet().stream().filter(entry -> ((String)entry.getKey()).equals(combo.getValue())).map(Map.Entry::getValue).findFirst().orElse(null);
                    break;
                }
                default: {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u5b57\u6bb5\u7c7b\u578b", (String)"FAFSyncDataSchemaEdit_9", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                }
            }
            int dimensionEntryIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_DIMENSION);
            this.getModel().beginInit();
            this.getModel().setValue(ENTRY_F_DIM_DEFAULT_VALUE, (Object)value, dimensionEntryIndex);
            this.getModel().setValue(ENTRY_F_DIM_DEFAULT_VALUE_NAME, (Object)name, dimensionEntryIndex);
            this.getModel().endInit();
            this.refreshEntrySetting();
            this.getView().updateView(ENTRY_DIMENSION);
        } else if (ACTION_SET_SOURCE_MEASUREFIELD.equals(actionId)) {
            Map selectFields;
            Set entrySet;
            Iterator iterator;
            Object returnData = event.getReturnData();
            if (returnData instanceof Map && (iterator = (entrySet = (selectFields = (Map)FAFUtils.cast((Object)returnData)).entrySet()).iterator()).hasNext()) {
                Map.Entry next = iterator.next();
                IDataModel model = this.getModel();
                int dimensionEntryIndex = model.getEntryCurrentRowIndex(ENTRY_MEASURE);
                model.setValue(ENTRY_F_DIMMEASURE_FIELDNAME, next.getValue(), dimensionEntryIndex);
                model.setValue("dimmeasurefield", next.getKey(), dimensionEntryIndex);
            }
        } else if (ACTIONID_SET_VALUE_BYDIALOG.equals(actionId) && event.getReturnData() != null && (data = (TagTextFiledData)FAFUtils.cast((Object)event.getReturnData())) != null) {
            data.fillValue(this.getModel());
        }
    }

    private void resetDimensionAndMeasureEntry() {
        this.getModel().deleteEntryData(ENTRY_DIMENSION);
        this.getModel().deleteEntryData(ENTRY_MEASURE);
        DynamicObject analysisModel = (DynamicObject)this.getModel().getValue(FIELD_MODEL);
        DynamicObject dataSource = (DynamicObject)this.getModel().getValue(FIELD_DATASOURCE);
        if (analysisModel != null && dataSource != null) {
            this.initDimensinMeasureEntryRow();
            this.resetEntryMeasureSelectSetting();
            this.matchDimensionEntry("matchImport");
            this.matchImportMeasureEntry();
            this.refreshEntrySetting();
            this.getPageCache().remove(PAGE_FIELDNODE);
        }
        this.getView().updateView(ENTRY_DIMENSION);
        this.getView().updateView(ENTRY_MEASURE);
    }

    private void refreshEntrySetting() {
        this.refreshDimensionEntryVisible();
        this.refreshMeasureEntryVisible();
    }

    private void refreshDimensionEntryVisible() {
        DataSyncModel dataSyncModel = BusinessDynamicObjectFactory.createDataSyncModel((Object)this.getModel().getValue("analysismodel_id"));
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_DIMENSION);
        HashSet<String> dimensionselecttypeSet = new HashSet<String>();
        boolean showDimconditiondesc = false;
        for (int i = 0; i < entryEntity.size(); ++i) {
            String dimensionselecttype;
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            Object object = dynamicObject.get("dimension_id");
            boolean necessity = dataSyncModel.isNecessity(object);
            if (necessity) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{ENTRY_F_DIMCONDITIONDESC});
            }
            if (!StringUtils.isNotEmpty((CharSequence)(dimensionselecttype = dynamicObject.getString("dimensionselecttype")))) continue;
            if (!necessity && DimensionSelectTypeEnum.SOURCE_DIMENSION.getCode().equals(dimensionselecttype)) {
                showDimconditiondesc = true;
            }
            dimensionselecttypeSet.add(dimensionselecttype);
        }
        this.getView().setVisible(Boolean.valueOf(showDimconditiondesc), new String[]{ENTRY_F_DIMCONDITIONDESC});
        for (DimensionSelectTypeEnum value : DimensionSelectTypeEnum.values()) {
            if (!dimensionselecttypeSet.contains(value.getCode())) {
                this.getView().setVisible(Boolean.FALSE, value.getShowControlKey());
                continue;
            }
            this.getView().setVisible(Boolean.TRUE, value.getShowControlKey());
        }
        Object value = this.getModel().getValue(FIELD_DATASOURCE);
        if (value instanceof DynamicObject) {
            DataSource dataSource = BusinessDynamicObjectFactory.createDataSource((Object)((DynamicObject)value).getPkValue());
            DataSourceTypeEnum type = dataSource.getType();
            if (DataSourceTypeEnum.INV_PERIODBALANCE == type) {
                Object modelPkvalue = this.getModel().getValue("analysismodel_id");
                DataSyncModel syncModel = BusinessDynamicObjectFactory.createDataSyncModel((Object)modelPkvalue);
                String periodNumber = syncModel.getPeriodNumber();
                DynamicObjectCollection dimensionEntry = this.getModel().getEntryEntity(ENTRY_DIMENSION);
                for (int i = 0; i < dimensionEntry.size(); ++i) {
                    DynamicObject entry = (DynamicObject)dimensionEntry.get(i);
                    String dimNum = entry.getDynamicObject("dimension").getString("number");
                    if (!Objects.equals(periodNumber, dimNum)) continue;
                    this.getModel().setValue("dimensionselecttype", (Object)" ", i);
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"dimensionselecttype"});
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{ENTRY_F_DIMENSIONFIELD_NAME});
                }
            } else if (DataSourceTypeEnum.BCM == type || DataSourceTypeEnum.EPM == type) {
                this.getView().setVisible(Boolean.FALSE, new String[]{ENTRY_F_DIMCONDITIONDESC});
            }
            this.getView().updateView(ENTRY_DIMENSION);
        }
    }

    private void refreshMeasureEntryVisible() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_MEASURE);
        Set dimensionselecttypeSet = entryEntity.stream().map(dynamicObject -> dynamicObject.getString("selecttype")).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
        for (SelectTypeEnum value : SelectTypeEnum.values()) {
            if (!dimensionselecttypeSet.contains(value.getCode())) {
                this.getView().setVisible(Boolean.FALSE, value.getShowControlKey());
                continue;
            }
            this.getView().setVisible(Boolean.TRUE, value.getShowControlKey());
        }
        this.getView().updateView(ENTRY_MEASURE);
    }

    private void matchDimensionEntry(String matchModel) {
        DataSyncSchema syncSchema = BusinessDynamicObjectFactory.createDataSyncSchema((Object)this.getModel().getDataEntity(true));
        syncSchema.setMatchModel(matchModel);
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount(ENTRY_DIMENSION);
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            if (!Objects.equals(model.getValue("dimensionselecttype", rowIndex), "1") || !StringUtils.isBlank((Object)model.getValue(ENTRY_F_DIMENSIONFIELD, rowIndex))) continue;
            Long dimensionId = (Long)model.getValue("dimension_id", rowIndex);
            Map matchFields = syncSchema.matchFields((Object)dimensionId);
            model.setValue("mappingrelationship", null, rowIndex);
            model.setValue(ENTRY_F_DIM_DEFAULT_VALUE, null, rowIndex);
            model.setValue(ENTRY_F_DIM_DEFAULT_VALUE_NAME, null, rowIndex);
            if (matchFields.size() != 1) continue;
            for (Map.Entry entry : matchFields.entrySet()) {
                model.setValue(ENTRY_F_DIMENSIONFIELD, entry.getKey(), rowIndex);
                model.setValue(ENTRY_F_DIMENSIONFIELD_NAME, entry.getValue(), rowIndex);
            }
        }
    }

    private void matchImportMeasureEntry() {
        DataSyncSchema syncSchema = BusinessDynamicObjectFactory.createDataSyncSchema((Object)this.getModel().getDataEntity(true));
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount(ENTRY_MEASURE);
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            Long measureId = (Long)model.getValue("measure_id", rowIndex);
            Object measurefield = syncSchema.matchMeasureField((Object)measureId);
            if (measurefield == null) continue;
            this.getModel().setValue("selecttype", (Object)SelectTypeEnum.MEASUREFIELD.getCode(), rowIndex);
            this.getModel().setValue("measurefield", measurefield, rowIndex);
        }
    }

    private void showSelectSourceDimensionDialog() {
        Object dimensionPkvalue = this.getModel().getValue("dimension_id");
        DataSyncSchema syncSchema = BusinessDynamicObjectFactory.createDataSyncSchema((Object)this.getModel().getDataEntity(true));
        Map availableField = syncSchema.matchFields(dimensionPkvalue);
        FAFSelectFieldDialogPlugin.openBy((AbstractFormPlugin)this, availableField, (String)this.getModel().getValue(ENTRY_F_DIMENSIONFIELD), ACTION_SET_SOURCE_DIMENSIONFIELD);
    }

    private void showDimensionConditionDialog() {
        Object value = this.getModel().getValue(ENTRY_F_DIMENSIONFIELD_NAME);
        if (StringUtils.isBlank((Object)value)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6570\u636e\u6e90\u7ef4\u5ea6\u3002", (String)"FAFSyncDataSchemaEdit_18", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            return;
        }
        TagTextFiledData data = new TagTextFiledData(ENTRY_F_DIMCONDITIONDESC, ENTRY_F_DIMCONDITIONVAL).pickValue(this.getModel(), ENTRY_DIMENSION);
        data.getParams().put(FIELD_SYSTEM, this.getModel().getValue("analysismodel_id"));
        SyncDataConditionDialogPlugin.openBy((AbstractFormPlugin)this, data, ACTIONID_SET_VALUE_BYDIALOG);
    }

    private void showSelectSourceMeasureDialog() {
        Object datasourcePkvalue = this.getModel().getValue("datasource_id");
        if (datasourcePkvalue == null) {
            return;
        }
        DataSource dataSource = BusinessDynamicObjectFactory.createDataSource((Object)datasourcePkvalue);
        if (DataSourceTypeEnum.BIZVOUCHER == dataSource.getType()) {
            FAFSelectFieldDialogPlugin.openBy((AbstractFormPlugin)this, DataSyncBusinessHelper.getAIasstacttypeMeasureFields(), (String)this.getModel().getValue(ENTRY_F_DIMENSIONFIELD), ACTION_SET_SOURCE_MEASUREFIELD);
        }
    }

    private boolean validateAnaModelAndDataSource() {
        DynamicObject dataSource = (DynamicObject)this.getModel().getValue(FIELD_DATASOURCE);
        DynamicObject analysisModel = (DynamicObject)this.getModel().getValue(FIELD_MODEL);
        if (dataSource == null || analysisModel == null) {
            return true;
        }
        DataSyncSchema syncSchema = BusinessDynamicObjectFactory.createDataSyncSchema((Object)this.getModel().getDataEntity(false));
        try {
            syncSchema.validModelMatchDataSource();
        }
        catch (Exception ex) {
            logger.info("faf-sync-data: schema_edit", (Object)ex);
            this.getView().showTipNotification(ex.getMessage());
            return false;
        }
        return true;
    }

    private void resetEntryMeasureSelectSetting() {
        DataSyncSchema syncSchema = BusinessDynamicObjectFactory.createDataSyncSchema((Object)this.getModel().getDataEntity(true));
        ComboEdit selectTypeCombo = (ComboEdit)this.getControl("selecttype");
        selectTypeCombo.setComboItems(syncSchema.getSelectTypeComboItems());
        ComboEdit measureFieldCombo = (ComboEdit)this.getControl("measurefield");
        measureFieldCombo.setComboItems(syncSchema.matchMeasureFields());
    }

    private void initDimensinMeasureEntryRow() {
        Object modelObj = this.getModel().getValue(FIELD_MODEL);
        Object datasourceObj = this.getModel().getValue(FIELD_DATASOURCE);
        if (modelObj == null || datasourceObj == null) {
            return;
        }
        IDataModel model = this.getModel();
        model.beginInit();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DataSyncSchema syncSchema = BusinessDynamicObjectFactory.createDataSyncSchema((Object)dataEntity);
        DataSyncModel syncModel = syncSchema.getSyncModel();
        DynamicObjectCollection dimensionEntry = syncModel.getDimensionEntry();
        Set dimensionId = syncSchema.getDimensionMapEntry().stream().map(dynamicObject -> dynamicObject.getLong("dimension_id")).collect(Collectors.toSet());
        for (DynamicObject object : dimensionEntry) {
            DynamicObject dimension = object.getDynamicObject("dimension");
            if (dimensionId.contains(dimension.getLong("id"))) continue;
            int row = model.createNewEntryRow(ENTRY_DIMENSION);
            model.setValue("dimension", (Object)dimension, row);
        }
        DynamicObjectCollection measureEntry = syncModel.getMeasureEntry();
        Set measureSet = syncSchema.getMeasureMapEntry().stream().map(dynamicObject -> dynamicObject.getLong("measure_id")).collect(Collectors.toSet());
        for (DynamicObject dynamicObject2 : measureEntry) {
            DynamicObject measure = dynamicObject2.getDynamicObject("measure");
            if (measureSet.contains(measure.getLong("id"))) continue;
            int row = model.createNewEntryRow(ENTRY_MEASURE);
            model.setValue("measure", (Object)measure, row);
        }
        Map allAvailableField = syncSchema.matchFields(null);
        List dimensionList = syncSchema.getSettingSyncDimensionList();
        for (int i = 0; i < dimensionList.size(); ++i) {
            DataSyncDimension syncDimension = (DataSyncDimension)dimensionList.get(i);
            String defaultValueText = syncDimension.getDefaultValueText();
            if (StringUtils.isNotEmpty((CharSequence)defaultValueText)) {
                this.getModel().setValue(ENTRY_F_DIM_DEFAULT_VALUE_NAME, (Object)defaultValueText, i);
            }
            String numberKey = (String)model.getValue(ENTRY_F_DIMENSIONFIELD, i);
            model.setValue(ENTRY_F_DIMENSIONFIELD_NAME, (Object)allAvailableField.getOrDefault(numberKey, numberKey), i);
        }
        Map measureDimensionFields = DataSyncBusinessHelper.getAIasstacttypeMeasureFields();
        if (!measureDimensionFields.isEmpty()) {
            int mRowCount = model.getEntryRowCount(ENTRY_MEASURE);
            for (int i = 0; i < mRowCount; ++i) {
                String value = (String)model.getValue("dimmeasurefield", i);
                if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                model.setValue(ENTRY_F_DIMMEASURE_FIELDNAME, (Object)measureDimensionFields.getOrDefault(value, value), i);
            }
        }
        model.endInit();
    }

    private void changeModel(DynamicObject model) {
        IDataModel dataModel = this.getModel();
        dataModel.setValue(FIELD_MODEL, null);
        dataModel.setValue(FIELD_DATASOURCE, null);
        dataModel.deleteEntryData(ENTRY_DIMENSION);
        dataModel.deleteEntryData(ENTRY_MEASURE);
        if (model == null) {
            dataModel.setValue("bizapp", null);
        } else {
            DynamicObject allPropertyModel = FAFAnasystemSettingHelper.getAnasystemSettingById((Object)model.getPkValue());
            dataModel.setValue("bizapp", (Object)allPropertyModel.getDynamicObject("modulerange"));
        }
    }

    private void showCondition() {
        DynamicObject dataSource = (DynamicObject)this.getModel().getValue(FIELD_DATASOURCE);
        if (dataSource == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u6e90\u3002", (String)"FAFSyncDataSchemaEdit_3", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            return;
        }
        int rowCount = this.getModel().getEntryRowCount(ENTRY_MEASURE);
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_MEASURE);
        if (rowCount > 0 && currentRowIndex > -1) {
            String conditionJson = (String)this.getModel().getValue("condition_tag", currentRowIndex);
            String entityNumber = FAFDataSourceConfigHelper.queryEntityById((Object)dataSource.getPkValue());
            String fieldNodeJson = this.getPageCache().get(PAGE_FIELDNODE);
            if (StringUtils.isBlank((CharSequence)fieldNodeJson)) {
                fieldNodeJson = GetValByConditionFormPlugin.fieldNode(entityNumber, true);
                this.getPageCache().put(PAGE_FIELDNODE, fieldNodeJson);
            }
            GetValByConditionFormPlugin.openForm(conditionJson, entityNumber, fieldNodeJson, (AbstractFormPlugin)this, ACTION_SET_MEASURECONDITION);
        }
    }

    private void showDefaultValueSelectPage() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_DIMENSION);
        DataSyncModel syncModel = BusinessDynamicObjectFactory.createDataSyncModel((Object)this.getModel().getValue("analysismodel_id"));
        DataSyncDimension syncDimension = BusinessDynamicObjectFactory.createDataSyncDimension((Object)this.getModel().getValue("dimension_id", rowIndex));
        Object defaultVal = this.getModel().getValue(ENTRY_F_DIM_DEFAULT_VALUE, rowIndex);
        switch (syncDimension.getDimensiontype()) {
            case DATABASE: 
            case ASSISTANTDATA: 
            case PERIOD: {
                this.openF7setDefaultValue(syncModel.getEntitynumber(), syncDimension.getNumber(), defaultVal, syncDimension.getQFilter());
                break;
            }
            case OTHER: {
                String text = (String)this.getModel().getValue(ENTRY_F_DIM_DEFAULT_VALUE, this.getModel().getEntryCurrentRowIndex(ENTRY_DIMENSION));
                FAFNonBaseDataSelectFormPlugin.openDefaultValueFillingPage((AbstractFormPlugin)this, (DefaultField)new DefaultText(text));
                break;
            }
            case DATE: {
                Date date = null;
                try {
                    String dateStr = (String)this.getModel().getValue(ENTRY_F_DIM_DEFAULT_VALUE, this.getModel().getEntryCurrentRowIndex(ENTRY_DIMENSION));
                    if (StringUtils.isNotBlank((CharSequence)dateStr)) {
                        date = new SimpleDateFormat("yyyy-MM-dd").parse(dateStr);
                    }
                }
                catch (ParseException e) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u65f6\u95f4\u683c\u5f0f\u89e3\u6790\u9519\u8bef", (String)"FAFSyncDataSchemaEdit_10", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                }
                FAFNonBaseDataSelectFormPlugin.openDefaultValueFillingPage((AbstractFormPlugin)this, (DefaultField)new DefaultDate(date));
                break;
            }
            case DENUMS: {
                String comboValue = (String)this.getModel().getValue(ENTRY_F_DIM_DEFAULT_VALUE, this.getModel().getEntryCurrentRowIndex(ENTRY_DIMENSION));
                DynamicObject comboDimension = (DynamicObject)this.getModel().getValue("dimension", this.getModel().getEntryCurrentRowIndex(ENTRY_DIMENSION));
                LinkedHashMap comboEnumMap = comboDimension.getDynamicObjectCollection("entryentityenums").stream().collect(Collectors.toMap(dy -> dy.getString("value"), dy -> dy.getString("title"), (o1, o2) -> o1, LinkedHashMap::new));
                FAFNonBaseDataSelectFormPlugin.openDefaultValueFillingPage((AbstractFormPlugin)this, (DefaultField)new DefaultCombo(comboValue, comboEnumMap));
                break;
            }
            default: {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7ef4\u5ea6\u7c7b\u578b", (String)"FAFSyncDataSchemaEdit_11", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void openF7setDefaultValue(String entitynumber, String propName, Object pkId, QFilter qFilter) {
        ListShowParameter lsp = BaseDataUtil.createFieldF7ShowParameter(entitynumber, propName, false, (String)pkId);
        if (qFilter != null) {
            lsp.getListFilterParameter().getQFilters().add(qFilter);
        }
        lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "DatabaseOrAssistantDimension"));
        this.getView().showForm((FormShowParameter)lsp);
    }
}

