/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.system;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.macc.faf.helper.FAFSyncDataSchemeHelper;
import kd.macc.faf.helper.FAFTableDataHelper;

public class FAFSyncDataSchemaList
extends AbstractListPlugin {
    private CommonFilterColumn analysisModelNameFilter;

    public void setFilter(SetFilterEvent e) {
        Long anaSystemId = (Long)this.getView().getFormShowParameter().getCustomParam("anaSystemId");
        if (anaSystemId != null && anaSystemId != 0L) {
            QFilter filter = new QFilter("model", "=", (Object)anaSystemId);
            e.addCustomQFilter(filter);
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        Long anaSystemId = (Long)this.getView().getFormShowParameter().getCustomParam("anaSystemId");
        if (anaSystemId != null && anaSystemId != 0L) {
            e.getParameter().setCustomParam("anaSystemId", (Object)anaSystemId);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if ("delete".equals(operateKey) && operationResult.isSuccess()) {
            IFormView anaSystemConfigView = this.getView().getParentView();
            List successPkIds = operationResult.getSuccessPkIds();
            for (Object successPkId : successPkIds) {
                QFilter[] qFilters = new QFilter[]{new QFilter("syncdatascheme", "=", successPkId)};
                FAFTableDataHelper.delete((String)"pa_taskpreview", (QFilter[])qFilters);
                FAFTableDataHelper.delete((String)"pa_tasklog", (QFilter[])qFilters);
            }
            if (anaSystemConfigView != null && "pa_anasystemconfig".equals(anaSystemConfigView.getEntityId())) {
                anaSystemConfigView.updateView();
                this.getView().sendFormAction(anaSystemConfigView);
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        Long anaSystemId = (Long)this.getView().getFormShowParameter().getCustomParam("anaSystemId");
        if (anaSystemId != null && anaSystemId != 0L) {
            QFilter filter = new QFilter("model", "=", (Object)anaSystemId);
            Map modelMap = FAFSyncDataSchemeHelper.queryCommonFilter((QFilter[])filter.toArray());
            LinkedHashSet analysisModelList = (LinkedHashSet)modelMap.get("analysismodel");
            this.analysisModelNameFilter = (CommonFilterColumn)args.getFilterColumn("analysismodel.name");
            this.setItemList(analysisModelList, this.analysisModelNameFilter);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if ("analysismodel.id".equals(fieldName) || "analysismodel.name".equals(fieldName)) {
            Long anaSystemId = (Long)this.getView().getFormShowParameter().getCustomParam("anaSystemId");
            QFilter modelFilter = new QFilter("model", "=", (Object)anaSystemId);
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            Map modelMap = FAFSyncDataSchemeHelper.queryCommonFilter((QFilter[])modelFilter.toArray());
            List modelIds = ((LinkedHashSet)modelMap.get("analysismodel")).stream().map(str -> Long.parseLong(str.split(",")[0])).collect(Collectors.toList());
            args.getQfilters().add(new QFilter("id", "in", modelIds).and(enableFilter));
        }
    }

    private void setItemList(LinkedHashSet<String> valueList, CommonFilterColumn anaModelName) {
        if (valueList != null) {
            ArrayList<ComboItem> itemList = new ArrayList<ComboItem>();
            for (String idAndName : valueList) {
                ComboItem item = new ComboItem();
                String[] values = idAndName.split(",");
                item.setValue(values[0]);
                item.setCaption(new LocaleString(values[1]));
                itemList.add(item);
            }
            anaModelName.setComboItems(itemList);
        }
    }
}

