/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.system;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.faf.enums.FAFSyncLogStatusEnum;
import kd.macc.faf.enums.FAFWorkTaskTypeEnum;
import kd.macc.faf.enums.ModelVersionEnum;
import kd.macc.faf.model.impl.IDataMapEntry;
import kd.macc.faf.util.AnalysisModelUtil;
import kd.macc.faf.util.FAFTableUtil;

public class FAFTableconfigFormPlugin
extends AbstractFormPlugin {
    private static final String PREFIX = "dyn";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.init();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "btnok": {
                this.createTable();
                break;
            }
        }
    }

    private void createTable() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String inputTableName = (String)model.getValue("name");
        if (StringUtils.isEmpty((String)inputTableName) || inputTableName.length() > 19) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8868\u540d\u957f\u5ea6\u9700\u8981\u5c0f\u4e8e19\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"FAFTableconfigFormPlugin_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            return;
        }
        String inputTableNumber = (String)model.getValue("number");
        if (!this.numVerify(inputTableNumber)) {
            return;
        }
        long id = (Long)view.getFormShowParameter().getCustomParam("analysisModel_id");
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"pa_analysismodel");
        String originTableNumber = dynamicObject.getString("tablenumber");
        if (MetadataDao.checkNumber((String)this.formatForm(PREFIX + inputTableNumber))) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u7f16\u53f7\u76f8\u540c\u7684\u6570\u636e\u8868\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"FAFTableconfigFormPlugin_1", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        } else if (StringUtils.isEmpty((String)originTableNumber)) {
            this.returnData(new HashMap<String, String>());
        }
    }

    private void returnData(Map<String, String> returnValue) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String tableNumber = PREFIX + model.getValue("number");
        String tableName = (String)model.getValue("name");
        Long analysisModelId = (Long)view.getFormShowParameter().getCustomParam("analysisModel_id");
        IDataMapEntry result = FAFTableUtil.createOrDropTable((Long)analysisModelId, (FAFWorkTaskTypeEnum)FAFWorkTaskTypeEnum.Create_Table_Task, (String)tableNumber, (String)tableName, (Boolean)Boolean.FALSE, (boolean)false);
        if (result == null || FAFSyncLogStatusEnum.SUCCESS != result.getKey()) {
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u6570\u636e\u8868[%1$s]\u521b\u5efa\u5931\u8d25,\u539f\u56e0:%2$s", (String)"FAFTableconfigFormPlugin_6", (String)"macc-faf-formplugin", (Object[])new Object[0]), tableName, result != null ? result.getValue() : ""));
        } else {
            DynamicObject analysisModel = BusinessDataServiceHelper.loadSingle((Object)analysisModelId, (String)"pa_analysismodel");
            analysisModel.set("tablename", (Object)tableName);
            analysisModel.set("tablenumber", (Object)tableNumber);
            analysisModel.set("version", (Object)ModelVersionEnum.new_version.getCodeStr());
            SaveServiceHelper.update((DynamicObject)analysisModel);
            returnValue.put("tablename", tableName);
            returnValue.put("tablenumber", tableNumber);
            returnValue.put("result", "true");
            view.returnDataToParent(returnValue);
            view.close();
        }
    }

    private void init() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        FormShowParameter originFsp = view.getFormShowParameter();
        String tableName = (String)originFsp.getCustomParam("tablename");
        String tableNumber = (String)originFsp.getCustomParam("tablenumber");
        if (StringUtils.isNotEmpty((String)tableName) && tableName.length() > 19) {
            view.showTipNotification(ResManager.loadKDString((String)"\u751f\u6210\u7684\u8868\u540d\u79f0\u957f\u5ea6\u8d85\u8fc719\u4e2a\u5b57\u7b26\uff0c\u8bf7\u624b\u52a8\u4fee\u6539\u3002", (String)"FAFTableconfigFormPlugin_3", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        }
        model.setValue("name", (Object)tableName);
        if (StringUtils.isNotEmpty((String)tableNumber) && tableNumber.length() > 15) {
            view.showTipNotification(ResManager.loadKDString((String)"\u751f\u6210\u7684\u8868\u7f16\u53f7\u957f\u5ea6\u8d85\u8fc715\u4e2a\u5b57\u7b26\uff0c\u8bf7\u624b\u52a8\u4fee\u6539\u3002", (String)"FAFTableconfigFormPlugin_4", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        }
        model.setValue("number", (Object)tableNumber);
    }

    private boolean numVerify(String str) {
        if (!StringUtils.isEmpty((String)str) && str.matches("[0-9a-z_]*") && str.length() <= 15) {
            return true;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u53f7\u53ea\u80fd\u5305\u542b\u5c0f\u5199\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf\uff0c\u4e14\u5b57\u7b26\u6570\u5c0f\u4e8e\u7b49\u4e8e15\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"FAFTableconfigFormPlugin_5", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        return false;
    }

    private String formatForm(String tableName) {
        return AnalysisModelUtil.buildEntityNumber((String)tableName.toLowerCase());
    }
}

