/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.macc.faf.cache.DistributeCache;
import kd.macc.faf.cache.IDataCacheModule;
import kd.macc.faf.datasync.exec.AlgoXIncrementSummaryExecutor;
import kd.macc.faf.datasync.exec.data.DataSyncParams;
import kd.macc.faf.datasync.util.FAFDataSyncUtil;
import kd.macc.faf.enums.DimensionTypeEnum;
import kd.macc.faf.enums.FAFDimensionTypeEnum;
import kd.macc.faf.enums.FAFStatusEnum;
import kd.macc.faf.enums.FAFWorkTaskTypeEnum;
import kd.macc.faf.enums.MeasureTypeEnum;
import kd.macc.faf.enums.TimeTypeEnum;
import kd.macc.faf.helper.DLockHelper;
import kd.macc.faf.helper.FAFAnalysisModelHelper;
import kd.macc.faf.helper.OrgHelper;
import kd.macc.faf.service.PeriodServiceHelper;
import kd.macc.faf.util.AnalysisModelHashUtil;
import kd.macc.faf.util.AnalysisModelUtil;
import kd.macc.faf.util.DateUtil;
import kd.macc.faf.util.ValidatorTipsUtil;

public class FAFAnalysisModelMakeDataFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
ProgresssListener {
    private static final Log logger = LogFactory.getLog(FAFAnalysisModelMakeDataFormPlugin.class);
    private final DistributeCache cache = DistributeCache.getCache((IDataCacheModule)IDataCacheModule.FAF);
    private static final String staticUrl = "/images/pc/other/zncw_cwgx_200_200.png";
    private static final String gifUrl = "/icons/pc/other/zncw_sjtb_214_214.gif";
    private static final String FILTER_FLEXPANEL = "filter_flexpanel";
    private static final String COMPLETEFLEXPANEL = "completeflexpanel";
    private static final String BUTTON_CLOSE = "close";
    private static final String BUTTON_MAKEDATA = "make_data";
    private static final String BUTTON_SUMMARY = "summary";
    private static final String PARAMETERFLEX = "parameterflex";
    private static final String FBASEDATAID_ID = "fbasedataid_id";
    private static final String KEY_TIME_TYPE = "timetype";
    private static final String KEY_DATE_RANGE = "daterange";
    private static final String KEY_PERIOD_BASEDATA = "periodbasedata";
    private static final String KEY_ACCOUNT_PERIOD = "accountperiod";
    private static final String KEY_ANALYSIS_PERIOD = "analysisperiod";
    private static final String KEY_START_DATE = "range_startdate";
    private static final String KEY_END_DATE = "range_enddate";
    private static final String KEY_DATA_COUNT = "data_count";
    private static final String KEY_DIM_GAP = "dim_gap";
    private static final String KEY_DIM_DATA_COUNT = "dim_data_count";
    private static final String KEY_DIM_AGGR_RATE = "dim_aggr_rate";
    private static final String KEY_THREAD_COUNT = "thread_count";
    private static final String KEY_ACCOUNT = "account";
    private static final ExecutorService fafMakeDataExecutorService = ThreadPools.newCachedExecutorService((String)"faf_model_makedata", (int)1, (int)100);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.init();
    }

    public void registerListener(EventObject e) {
        BasedataEdit analysisPeriod;
        super.registerListener(e);
        this.addClickListeners(new String[]{BUTTON_CLOSE, BUTTON_MAKEDATA, BUTTON_SUMMARY});
        BasedataEdit anaSystem = (BasedataEdit)this.getControl("analysis_system");
        anaSystem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit analysisModel = (BasedataEdit)this.getControl("analysismodel");
        analysisModel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit account = (BasedataEdit)this.getControl(KEY_ACCOUNT);
        account.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        bar.addProgressListener((ProgresssListener)this);
        BasedataEdit accountPeriod = (BasedataEdit)this.getControl(KEY_ACCOUNT_PERIOD);
        if (accountPeriod != null) {
            accountPeriod.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((analysisPeriod = (BasedataEdit)this.getControl(KEY_ANALYSIS_PERIOD)) != null) {
            analysisPeriod.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        IDataModel model = this.getModel();
        switch (key) {
            case "close": {
                this.getView().setVisible(Boolean.TRUE, new String[]{PARAMETERFLEX});
                this.getView().setVisible(Boolean.FALSE, new String[]{FILTER_FLEXPANEL, COMPLETEFLEXPANEL});
                model.setValue("statusinfo", (Object)"");
                model.setValue("executioninfo", (Object)"");
                model.setValue("successcout", (Object)"");
                model.setValue("failcount", (Object)"");
                break;
            }
            case "summary": 
            case "make_data": {
                FormParam formParam = FormParam.get(this.getModel());
                if (!formParam.verifyParam(this.getView())) {
                    return;
                }
                formParam.clickButtonKey = key;
                this.makeData(formParam);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key;
        IDataModel model = this.getModel();
        ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
        switch (key = ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey()) {
            case "analysismodel": {
                Long anaSystemId = (Long)model.getValue("analysis_system_id");
                if (anaSystemId == null || anaSystemId == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u5206\u6790\u4f53\u7cfb\u201d\u3002", (String)"FAFAnalysisModelMakeDataFormPlugin_6", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(1);
                QFilter filter = new QFilter("analysis_system", "=", (Object)anaSystemId);
                filter.and(new QFilter("tablenumber", "!=", (Object)" "));
                qFilterList.add(filter);
                ListShowParameter param = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                param.setListFilterParameter(new ListFilterParameter(qFilterList, "createtime desc"));
                break;
            }
            case "org": 
            case "accountperiod": {
                FormParam formParam = FormParam.get(this.getModel());
                if (!formParam.verifyAnaSystem(this.getView()) || !formParam.verifyAnaModel(this.getView())) {
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                if ("org".equals(key)) {
                    OrgHelper.PermOrgResult permOrgResult = OrgHelper.getPermOrgSet((String)"pa_dataextracting", (String)this.getView().getFormShowParameter().getAppId());
                    if (permOrgResult.hasAllOrgPerm()) break;
                    QFilter orgIdFilter = new QFilter("id", "in", (Object)permOrgResult.getPermOrgs());
                    listFilterParameter.setFilter(orgIdFilter);
                    break;
                }
                if (!KEY_ACCOUNT_PERIOD.equals(key)) break;
                Long modelId = (Long)this.getModel().getValue("analysismodel_id");
                DynamicObject timeDimension = FAFAnalysisModelHelper.queryModelNecessityTimeDimension((Long)modelId);
                Long periodType = timeDimension.getLong("dimension_entry.dimension.group");
                QFilter periodTypeFilter = new QFilter("periodtype", "=", (Object)periodType);
                listFilterParameter.setFilter(periodTypeFilter);
                break;
            }
            case "account": {
                Long accountTableId = (Long)this.getModel().getValue("accounttable_id");
                if (accountTableId != null && accountTableId != 0L) {
                    QFilter accountTableFilter = new QFilter("accounttable", "=", (Object)accountTableId);
                    listFilterParameter.setFilter(accountTableFilter);
                }
            }
            case "analysisperiod": {
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String key = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)"analysis_system", (CharSequence)key)) {
            model.setValue("analysismodel", null);
            model.setValue(KEY_TIME_TYPE, (Object)TimeTypeEnum.PERIOD.getCode());
        }
        if (StringUtils.equals((CharSequence)"analysismodel", (CharSequence)key)) {
            Long modelId = (Long)this.getModel().getValue("analysismodel_id");
            if (modelId == null || modelId == 0L) {
                model.setValue(KEY_TIME_TYPE, (Object)TimeTypeEnum.PERIOD.getCode());
                model.setValue(KEY_PERIOD_BASEDATA, (Object)"bd_period");
                return;
            }
            DynamicObject timeDimension = FAFAnalysisModelHelper.queryModelNecessityTimeDimension((Long)modelId);
            String dimType = timeDimension.getString("dimension_entry.dimension.dimensiontype");
            String dimBaseData = timeDimension.getString("dimension_entry.dimension.dimensionsource");
            DimensionTypeEnum dimensionTypeEnum = DimensionTypeEnum.getEnum((String)dimType);
            if (dimensionTypeEnum == null) {
                model.setValue(KEY_TIME_TYPE, (Object)TimeTypeEnum.OTHER.getCode());
                return;
            }
            switch (dimensionTypeEnum) {
                case DATABASE: 
                case ASSISTANTDATA: 
                case PERIOD: {
                    model.setValue(KEY_TIME_TYPE, (Object)TimeTypeEnum.PERIOD.getCode());
                    model.setValue(KEY_PERIOD_BASEDATA, (Object)dimBaseData);
                    break;
                }
                case DATE: {
                    model.setValue(KEY_TIME_TYPE, (Object)TimeTypeEnum.DATE.getCode());
                    break;
                }
                default: {
                    model.setValue(KEY_TIME_TYPE, (Object)TimeTypeEnum.OTHER.getCode());
                }
            }
            this.setTimeFieldAttr();
        }
        if (StringUtils.equals((CharSequence)KEY_TIME_TYPE, (CharSequence)key)) {
            this.setTimeFieldAttr();
        }
    }

    public void onProgress(ProgressEvent progressEvent) {
        IFormView view = this.getView();
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        String taskId = this.getPageCache().get("syncTaskId");
        String cacheStatusStr = this.cache.get("FAF|" + taskId);
        if ("true".equals(cacheStatusStr)) {
            progressEvent.setProgress(95);
            this.getModel().setValue("statusinfo", (Object)ResManager.loadKDString((String)"\u9020\u6570\u5b8c\u6210\uff0c\u6b63\u5728\u6267\u884c\u6570\u636e\u6c47\u603b\u3002", (String)"FAFAnalysisModelMakeDataFormPlugin_2", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        } else if ("summarySuccess".equals(cacheStatusStr)) {
            progressEvent.setProgress(100);
            this.changeImage("imageap", staticUrl);
            view.setVisible(Boolean.TRUE, new String[]{BUTTON_CLOSE});
            view.setEnable(Boolean.TRUE, new String[]{"fetch_data"});
            this.getModel().setValue("statusinfo", (Object)ResManager.loadKDString((String)"\u9020\u6570\u5df2\u5b8c\u6210\u3002", (String)"FAFAnalysisModelMakeDataFormPlugin_3", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            bar.stop();
            this.cache.remove("FAF|" + taskId);
        } else if (StringUtils.isNotEmpty((CharSequence)cacheStatusStr) && (cacheStatusStr.startsWith("error:") || cacheStatusStr.startsWith("success:"))) {
            this.changeImage("imageap", staticUrl);
            view.setVisible(Boolean.TRUE, new String[]{BUTTON_CLOSE});
            view.setEnable(Boolean.TRUE, new String[]{"fetch_data"});
            if (cacheStatusStr.startsWith("success:")) {
                this.getModel().setValue("statusinfo", (Object)String.format(ResManager.loadKDString((String)"\u9020\u6570\u5df2\u7ed3\u675f\u3002%s", (String)"FAFAnalysisModelMakeDataFormPlugin_1", (String)"macc-faf-formplugin", (Object[])new Object[0]), cacheStatusStr.substring(8)));
            } else {
                this.getModel().setValue("statusinfo", (Object)String.format(ResManager.loadKDString((String)"\u9020\u6570\u65f6\u53d1\u751f\u9519\u8bef\u3002%s", (String)"FAFAnalysisModelMakeDataFormPlugin_0", (String)"macc-faf-formplugin", (Object[])new Object[0]), cacheStatusStr));
            }
            bar.stop();
        } else if (StringUtils.isNotEmpty((CharSequence)cacheStatusStr)) {
            float percent = 0.0f;
            try {
                percent = Float.parseFloat(cacheStatusStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (percent >= 100.0f) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"cancel"});
            } else {
                if (percent > 0.0f) {
                    // empty if block
                }
                progressEvent.setProgress((int)percent);
            }
            view.setVisible(Boolean.TRUE, new String[]{BUTTON_CLOSE});
        }
    }

    private void init() {
        this.getView().setVisible(Boolean.FALSE, new String[]{FILTER_FLEXPANEL, COMPLETEFLEXPANEL, "progressbarap", "cancel"});
        this.setTimeFieldAttr();
    }

    private void setTimeFieldAttr() {
        IDataModel model = this.getModel();
        HashSet<String> trueFieldSet = new HashSet<String>();
        HashSet<String> falseFieldSet = new HashSet<String>();
        String timeType = (String)model.getValue(KEY_TIME_TYPE);
        TimeTypeEnum timeTypeEnum = TimeTypeEnum.getTimeTypeEnum((String)timeType);
        switch (timeTypeEnum) {
            case DATE: {
                trueFieldSet.add(KEY_DATE_RANGE);
                falseFieldSet.add(KEY_ACCOUNT_PERIOD);
                falseFieldSet.add(KEY_ANALYSIS_PERIOD);
                break;
            }
            case PERIOD: {
                String periodBaseData = (String)model.getValue(KEY_PERIOD_BASEDATA);
                if (StringUtils.equals((CharSequence)"bd_period", (CharSequence)periodBaseData)) {
                    trueFieldSet.add(KEY_ACCOUNT_PERIOD);
                    falseFieldSet.add(KEY_ANALYSIS_PERIOD);
                } else if (StringUtils.equals((CharSequence)"pa_analysisperiod", (CharSequence)periodBaseData)) {
                    trueFieldSet.add(KEY_ANALYSIS_PERIOD);
                    falseFieldSet.add(KEY_ACCOUNT_PERIOD);
                } else {
                    falseFieldSet.add(KEY_ACCOUNT_PERIOD);
                    falseFieldSet.add(KEY_ANALYSIS_PERIOD);
                }
                falseFieldSet.add(KEY_DATE_RANGE);
                break;
            }
            default: {
                falseFieldSet.add(KEY_DATE_RANGE);
                falseFieldSet.add(KEY_ACCOUNT_PERIOD);
                falseFieldSet.add(KEY_ANALYSIS_PERIOD);
            }
        }
        String[] trueFields = trueFieldSet.toArray(new String[0]);
        String[] falseFields = falseFieldSet.toArray(new String[0]);
        this.setFieldMustInput(true, trueFields);
        this.setFieldMustInput(false, falseFields);
        this.setFieldVisible(true, trueFields);
        this.setFieldVisible(false, falseFields);
    }

    private void setFieldMustInput(boolean flag, String ... fields) {
        IFormView view = this.getView();
        for (String field : fields) {
            FieldEdit fieldEdit = (FieldEdit)view.getControl(field);
            fieldEdit.setMustInput(flag);
        }
    }

    private void setFieldVisible(boolean flag, String ... fields) {
        IFormView view = this.getView();
        view.setVisible(Boolean.valueOf(flag), fields);
    }

    private Long makeData(FormParam formParam) {
        Long syncTaskId = null;
        TimeTypeEnum timeTypeEnum = TimeTypeEnum.getTimeTypeEnum((String)formParam.timeType);
        if (timeTypeEnum == TimeTypeEnum.DATE) {
            syncTaskId = this.doMakeData(formParam);
        } else {
            ArrayList orgIdList = new ArrayList(formParam.orgIds);
            ArrayList periodIdList = new ArrayList(formParam.periodIds);
            if (PeriodServiceHelper.checkPeriodOrgList((long)formParam.anaModelId, orgIdList, periodIdList, (boolean)true).booleanValue()) {
                PeriodServiceHelper.batchCreateCtrlRecord((long)formParam.anaSystemId, (long)formParam.anaModelId, orgIdList, periodIdList, (String)formParam.periodBaseData);
                syncTaskId = this.doMakeData(formParam);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u671f\u95f4\u5df2\u5173\u95ed\uff0c\u4e0d\u5141\u8bb8\u9020\u6570\u3002", (String)"FAFAnalysisModelMakeDataFormPlugin_4", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            }
        }
        return syncTaskId;
    }

    private Long doMakeData(FormParam formParam) {
        Long syncTaskId = this.createSyncDataTaskPreview();
        this.getPageCache().put("syncTaskId", syncTaskId.toString());
        this.changeVIewToInitialSart();
        this.getModel().setValue("statusinfo", (Object)ResManager.loadKDString((String)"\u6b63\u5728\u9020\u6570\u4e2d......", (String)"FAFAnalysisModelMakeDataFormPlugin_5", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        ThreadPools.executeOnceIncludeRequestContext((String)"FAFAnalysisModelMakeDataFormPlugin", (Runnable)new FAFMakeDataTask(syncTaskId, this.cache, formParam));
        this.startProgressBar();
        return syncTaskId;
    }

    private void changeVIewToInitialSart() {
        IFormView view = this.getView();
        view.setVisible(Boolean.TRUE, new String[]{"progressbarap", FILTER_FLEXPANEL});
        view.setVisible(Boolean.FALSE, new String[]{PARAMETERFLEX, BUTTON_CLOSE, "cancel"});
        this.changeImage("imageap", gifUrl);
        this.getModel().setValue("statusinfo", (Object)ResManager.loadKDString((String)"\u4efb\u52a1\u6b63\u5728\u521d\u59cb\u5316", (String)"FAFAnalysisModelMakeDataFormPlugin_12", (String)"macc-faf-formplugin", (Object[])new Object[0]));
    }

    private Long createSyncDataTaskPreview() {
        DynamicObject syncTask = BusinessDataServiceHelper.newDynamicObject((String)"pa_taskpreview");
        syncTask.set("syncdatascheme", (Object)1L);
        syncTask.set("creator", (Object)RequestContext.get().getCurrUserId());
        syncTask.set("createtime", (Object)new Date());
        syncTask.set("status", (Object)FAFStatusEnum.NEW.getCodeString());
        syncTask.set("tasktype", (Object)String.valueOf(FAFWorkTaskTypeEnum.Query_DB_Data_Sync_Group_Task.getValue()));
        syncTask.set("syncschemename", (Object)BUTTON_MAKEDATA);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{syncTask});
        return (Long)syncTask.getPkValue();
    }

    private void startProgressBar() {
        ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
        progressBar.setPercent(0);
        progressBar.start();
    }

    private void changeImage(String apMark, String imageUrl) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("imageKey", imageUrl);
        this.getView().updateControlMetadata(apMark, data);
    }

    private static class FormParam {
        private Long anaSystemId;
        private DynamicObject analysisSystem;
        private Long anaModelId;
        private DynamicObject analysisModel;
        private Set<Long> orgIds;
        private String timeType;
        private Set<Long> periodIds;
        private String periodBaseData;
        private Date startDate;
        private Date endDate;
        private int dataCount;
        private int dimGap;
        private int dimDataCount;
        private int dimAggrRate;
        private int threadCount;
        private Set<Long> accountIds;
        private String clickButtonKey;

        private FormParam() {
        }

        public static FormParam get(IDataModel model) {
            FormParam formParam = new FormParam();
            formParam.anaSystemId = (Long)model.getValue("analysis_system_id");
            if (formParam.anaSystemId != null) {
                formParam.analysisSystem = BusinessDataServiceHelper.loadSingleFromCache((Object)formParam.anaSystemId, (String)"pa_anasystemsetting");
            }
            formParam.anaModelId = (Long)model.getValue("analysismodel_id");
            if (formParam.anaModelId != null) {
                formParam.analysisModel = BusinessDataServiceHelper.loadSingleFromCache((Object)formParam.anaModelId, (String)"pa_analysismodel");
            }
            MulBasedataDynamicObjectCollection orgDyCol = (MulBasedataDynamicObjectCollection)model.getValue("org");
            formParam.orgIds = orgDyCol.stream().map(dy -> dy.getLong(FAFAnalysisModelMakeDataFormPlugin.FBASEDATAID_ID)).collect(Collectors.toSet());
            formParam.timeType = (String)model.getValue(FAFAnalysisModelMakeDataFormPlugin.KEY_TIME_TYPE);
            TimeTypeEnum timeTypeEnum = TimeTypeEnum.getTimeTypeEnum((String)formParam.timeType);
            switch (timeTypeEnum) {
                case PERIOD: {
                    formParam.periodBaseData = (String)model.getValue(FAFAnalysisModelMakeDataFormPlugin.KEY_PERIOD_BASEDATA);
                    if ("bd_period".equals(formParam.periodBaseData)) {
                        MulBasedataDynamicObjectCollection acPeriodDyCol = (MulBasedataDynamicObjectCollection)model.getValue(FAFAnalysisModelMakeDataFormPlugin.KEY_ACCOUNT_PERIOD);
                        formParam.periodIds = acPeriodDyCol.stream().map(dy -> dy.getLong(FAFAnalysisModelMakeDataFormPlugin.FBASEDATAID_ID)).collect(Collectors.toSet());
                        break;
                    }
                    if (!"pa_analysisperiod".equals(formParam.periodBaseData)) break;
                    MulBasedataDynamicObjectCollection anPeriodDyCol = (MulBasedataDynamicObjectCollection)model.getValue(FAFAnalysisModelMakeDataFormPlugin.KEY_ANALYSIS_PERIOD);
                    formParam.periodIds = anPeriodDyCol.stream().map(dy -> dy.getLong(FAFAnalysisModelMakeDataFormPlugin.FBASEDATAID_ID)).collect(Collectors.toSet());
                    break;
                }
                case DATE: {
                    formParam.startDate = (Date)model.getValue(FAFAnalysisModelMakeDataFormPlugin.KEY_START_DATE);
                    formParam.endDate = DateUtil.getNextDay((Date)((Date)model.getValue(FAFAnalysisModelMakeDataFormPlugin.KEY_END_DATE)), (int)1);
                    break;
                }
            }
            formParam.dataCount = (Integer)model.getValue(FAFAnalysisModelMakeDataFormPlugin.KEY_DATA_COUNT);
            formParam.dimGap = (Integer)model.getValue(FAFAnalysisModelMakeDataFormPlugin.KEY_DIM_GAP);
            formParam.dimDataCount = (Integer)model.getValue(FAFAnalysisModelMakeDataFormPlugin.KEY_DIM_DATA_COUNT);
            formParam.dimAggrRate = (Integer)model.getValue(FAFAnalysisModelMakeDataFormPlugin.KEY_DIM_AGGR_RATE);
            formParam.threadCount = (Integer)model.getValue(FAFAnalysisModelMakeDataFormPlugin.KEY_THREAD_COUNT);
            MulBasedataDynamicObjectCollection accountDyCol = (MulBasedataDynamicObjectCollection)model.getValue(FAFAnalysisModelMakeDataFormPlugin.KEY_ACCOUNT);
            formParam.accountIds = accountDyCol.stream().map(dy -> dy.getLong(FAFAnalysisModelMakeDataFormPlugin.FBASEDATAID_ID)).collect(Collectors.toSet());
            return formParam;
        }

        public boolean verifyParam(IFormView view) {
            if (!this.verifyAnaSystem(view) || !this.verifyAnaModel(view)) {
                return false;
            }
            if (!"1".equals(this.analysisModel.getString("enable"))) {
                view.showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u5206\u6790\u6a21\u578b\u5df2\u88ab\u7981\u7528,\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"FAFAnalysisModelMakeDataFormPlugin_9", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                return false;
            }
            String tableNumber = this.analysisModel.getString("tablenumber");
            if (StringUtils.isEmpty((CharSequence)tableNumber) || !MetadataDao.checkNumber((String)AnalysisModelUtil.buildEntityNumber((String)tableNumber))) {
                view.showTipNotification(ResManager.loadKDString((String)"\u540c\u6b65\u6570\u636e\u524d\u8bf7\u5148\u521b\u5efa\u6570\u636e\u8868\u3002", (String)"FAFAnalysisModelMakeDataFormPlugin_10", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                return false;
            }
            String modelNewVersionMsg = ValidatorTipsUtil.isModelNewVersion(this.anaModelId);
            if (StringUtils.isNotEmpty((CharSequence)modelNewVersionMsg)) {
                view.showTipNotification(modelNewVersionMsg);
                return false;
            }
            return true;
        }

        public boolean verifyAnaSystem(IFormView view) {
            if (this.analysisSystem == null) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u5206\u6790\u4f53\u7cfb\u201d\u3002", (String)"FAFAnalysisModelMakeDataFormPlugin_6", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                return false;
            }
            return true;
        }

        public boolean verifyAnaModel(IFormView view) {
            if (this.analysisModel == null) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u5206\u6790\u6a21\u578b\u201d\u3002", (String)"FAFAnalysisModelMakeDataFormPlugin_11", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                return false;
            }
            return true;
        }
    }

    private static class BatchDbTask
    implements Runnable {
        private final CountDownLatch cdl;
        private final BlockingQueue<List<DynamicObject>> queue;

        public BatchDbTask(CountDownLatch cdl, BlockingQueue<List<DynamicObject>> queue) {
            this.cdl = cdl;
            this.queue = queue;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    List<DynamicObject> dataList;
                    while ((dataList = this.queue.poll(30L, TimeUnit.SECONDS)) != null) {
                        SaveServiceHelper.save((DynamicObject[])dataList.toArray(new DynamicObject[0]));
                        dataList.clear();
                        this.cdl.countDown();
                    }
                }
                catch (Exception e) {
                    logger.error("BatchDbTask error:", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }

    private static class FAFMakeDataTask
    implements Runnable {
        private static final Log logger = LogFactory.getLog(FAFMakeDataTask.class);
        private Long syncTaskId;
        private DistributeCache cache;
        private FormParam formParam;
        private Long[] orgIds;
        private Object[] periodIds;
        private Long[] accountIds;
        private String orgFieldNumber = "";
        private String periodFieldNumber = "";
        private String accountFieldNumber = "";
        private List<String> baseDimFieldList;
        private List<String> textDimFieldList;
        private List<String> timeDimFieldList;
        private List<Date> timeValueFieldList;
        private List<String> ordinaryMeasureList;
        private Date now;
        private String modelDetailEntityNumber;
        private List<String> modelHashDimensionNumberList;

        public FAFMakeDataTask(Long syncTaskId, DistributeCache cache, FormParam formParam) {
            this.syncTaskId = syncTaskId;
            this.cache = cache;
            this.formParam = formParam;
            this.orgIds = formParam.orgIds.toArray(new Long[0]);
            this.periodIds = formParam.periodIds.toArray(new Long[0]);
            if (TimeTypeEnum.DATE.getCode().equals(formParam.timeType)) {
                this.periodIds = this.generateDateList(formParam.startDate, formParam.endDate).toArray();
            }
            this.accountIds = formParam.accountIds.toArray(new Long[0]);
            DynamicObject analysisModel = formParam.analysisModel;
            this.initDimFields(analysisModel);
            this.ordinaryMeasureList = this.initOrdinaryMeasures(analysisModel);
            this.now = new Date();
            this.modelDetailEntityNumber = AnalysisModelUtil.buildDetailEntityNumber((String)analysisModel.getString("tablenumber"));
            this.modelHashDimensionNumberList = AnalysisModelHashUtil.queryModelHashDimension((DynamicObject)analysisModel);
            Arrays.sort((Object[])this.orgIds);
            Arrays.sort(this.periodIds);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String lockKey = DLockHelper.getMLockKey((String)this.modelDetailEntityNumber);
            DLock dLock = DLock.create((String)lockKey);
            if (dLock.tryLock(1000L)) {
                try {
                    if (FAFAnalysisModelMakeDataFormPlugin.BUTTON_MAKEDATA.equals(this.formParam.clickButtonKey)) {
                        int current;
                        boolean isShardingTable = AnalysisModelUtil.isShardingEntity((String)this.modelDetailEntityNumber);
                        int batchSize = isShardingTable ? 5000 : 50000;
                        long start = System.currentTimeMillis();
                        logger.info("begin make data");
                        int totalDataCount = this.formParam.dataCount;
                        int batchCount = totalDataCount % batchSize == 0 ? totalDataCount / batchSize : totalDataCount / batchSize + 1;
                        CountDownLatch cdl = new CountDownLatch(batchCount);
                        boolean containsDimHash = AnalysisModelHashUtil.isModelContainsDimHash((String)this.modelDetailEntityNumber);
                        Map<Integer, List<String>> textDimValuesMap = this.buildTextDimValues();
                        List<DynamicObject> dataList = new ArrayList<DynamicObject>(batchSize);
                        int noRepeatCount = (int)((float)(totalDataCount * this.formParam.dimAggrRate) / 100.0f);
                        if (noRepeatCount == 0) {
                            noRepeatCount = totalDataCount;
                        }
                        ArrayList<Object[]> noRepeatDataList = new ArrayList<Object[]>(noRepeatCount);
                        int threadCount = this.formParam.threadCount;
                        int queueSize = isShardingTable ? threadCount * 2 : threadCount + 1;
                        ArrayBlockingQueue<List<DynamicObject>> queue = new ArrayBlockingQueue<List<DynamicObject>>(queueSize);
                        boolean hadStartBatchDbThread = false;
                        HashMap<Integer, AtomicInteger> textDimValueIndexMap = new HashMap<Integer, AtomicInteger>(this.textDimFieldList.size());
                        int propertyCount = EntityMetadataCache.getDataEntityType((String)this.modelDetailEntityNumber).getProperties().size();
                        for (current = 1; current <= noRepeatCount; ++current) {
                            Object[] detail = this.buildDetail(current, textDimValuesMap, containsDimHash, propertyCount, textDimValueIndexMap);
                            noRepeatDataList.add(detail);
                            DynamicObject copyDetail = this.copyDetail(detail, propertyCount);
                            dataList.add(copyDetail);
                            if (dataList.size() != batchSize && current != totalDataCount) continue;
                            this.cache.put("FAF|" + this.syncTaskId, (Object)Float.valueOf((float)current / (float)totalDataCount * 100.0f));
                            queue.put(dataList);
                            if (!hadStartBatchDbThread) {
                                this.startBatchDbThread(cdl, queue);
                                hadStartBatchDbThread = true;
                            }
                            dataList = new ArrayList(batchSize);
                        }
                        while (current <= totalDataCount) {
                            DynamicObject copyDetail = this.copyDetail((Object[])noRepeatDataList.get(current % noRepeatCount), propertyCount);
                            dataList.add(copyDetail);
                            if (dataList.size() == batchSize || current == totalDataCount) {
                                this.cache.put("FAF|" + this.syncTaskId, (Object)Float.valueOf((float)current / (float)totalDataCount * 100.0f));
                                queue.put(dataList);
                                if (!hadStartBatchDbThread) {
                                    this.startBatchDbThread(cdl, queue);
                                    hadStartBatchDbThread = true;
                                }
                                dataList = new ArrayList(batchSize);
                            }
                            ++current;
                        }
                        if (!cdl.await(100L, TimeUnit.SECONDS)) {
                            while (queue.size() > 0) {
                                dataList = (List)queue.take();
                                SaveServiceHelper.save((DynamicObject[])dataList.toArray(new DynamicObject[0]));
                            }
                        }
                        long end = System.currentTimeMillis();
                        logger.info("end make data, cost time " + (end - start) + "ms");
                    }
                    this.summary(dLock);
                    this.cache.put("FAF|" + this.syncTaskId, (Object)"summarySuccess");
                }
                catch (Exception e) {
                    logger.error("kd.fi.pa.datasync.FAFLazyAlgoXQueryTask", (Throwable)e);
                    FAFDataSyncUtil.updateCacheErrorMessage((DistributeCache)this.cache, (Long)this.syncTaskId, (String)e.getMessage());
                }
                finally {
                    dLock.unlock();
                }
            } else {
                FAFDataSyncUtil.updateCacheErrorMessage((DistributeCache)this.cache, (Long)this.syncTaskId, (String)ResManager.loadKDString((String)"\u83b7\u53d6\u5206\u6790\u6a21\u578b\u7684\u5206\u5e03\u5f0f\u9501\u5931\u8d25\u3002", (String)"FAFAnalysisModelMakeDataFormPlugin_13", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                throw new KDBizException(new ErrorCode("kd.fi.pa.datasync.FAFLazyAlgoXQueryTask", "FAFLazyAlgoXQueryTask TryLock error!"), new Object[0]);
            }
        }

        private void summary(DLock dLock) {
            DataSyncParams params = new DataSyncParams();
            params.setOrgIdSet(this.formParam.orgIds);
            if (TimeTypeEnum.PERIOD.getCode().equals(this.formParam.timeType)) {
                params.setTimeType(TimeTypeEnum.PERIOD.getCode());
                params.setPeriodIdSet(this.formParam.periodIds);
            } else if (TimeTypeEnum.DATE.getCode().equals(this.formParam.timeType)) {
                params.setTimeType(TimeTypeEnum.DATE.getCode());
                params.setStartDate(this.formParam.startDate);
                params.setEndDate(this.formParam.endDate);
                params.setPeriodIdSet(Collections.emptySet());
            }
            if (TimeTypeEnum.DATE.getCode().equals(this.formParam.timeType)) {
                AlgoXIncrementSummaryExecutor executor = new AlgoXIncrementSummaryExecutor(this.formParam.analysisModel, params);
                executor.asyncCommit(dLock);
            } else {
                Set collect = this.formParam.periodIds.stream().sorted(Comparator.naturalOrder()).collect(Collectors.toCollection(LinkedHashSet::new));
                for (Long period : collect) {
                    params.setPeriodIdSet(Collections.singleton(period));
                    AlgoXIncrementSummaryExecutor executor = new AlgoXIncrementSummaryExecutor(this.formParam.analysisModel, params);
                    executor.asyncCommit(dLock);
                }
            }
        }

        private void startBatchDbThread(CountDownLatch cdl, BlockingQueue<List<DynamicObject>> queue) {
            for (int i = 0; i < this.formParam.threadCount; ++i) {
                fafMakeDataExecutorService.submit(new BatchDbTask(cdl, queue));
            }
        }

        private Object[] buildDetail(int current, Map<Integer, List<String>> textDimValuesMap, boolean containsDimHash, int propertyCount, Map<Integer, AtomicInteger> textDimValueIndexMap) {
            int index;
            DynamicObject o = BusinessDataServiceHelper.newDynamicObject((String)this.modelDetailEntityNumber);
            o.set("del", (Object)0);
            o.set("collectstatus", (Object)0);
            o.set("operationstatus", (Object)0);
            o.set("offstatus", (Object)0);
            o.set("datastatus", (Object)0);
            o.set("situationtype", (Object)0);
            o.set("createstamp", (Object)this.now);
            o.set(this.orgFieldNumber, (Object)this.orgIds[(current - 1) % this.orgIds.length]);
            o.set(this.periodFieldNumber, this.periodIds[(current - 1) % this.periodIds.length]);
            o.set(this.accountFieldNumber, (Object)this.accountIds[(current - 1) % this.accountIds.length]);
            for (index = 0; index < this.baseDimFieldList.size(); ++index) {
                o.set(this.baseDimFieldList.get(index), (Object)0);
            }
            for (index = 0; index < this.textDimFieldList.size(); ++index) {
                String value = "";
                if (index == 0) {
                    value = String.valueOf(current).intern();
                } else {
                    AtomicInteger valueIndex = textDimValueIndexMap.get(index);
                    if (valueIndex == null) {
                        valueIndex = new AtomicInteger(0);
                        textDimValueIndexMap.put(index, valueIndex);
                    }
                    if ((current + index) % this.formParam.dimGap == 0) {
                        value = textDimValuesMap.get(index % 26).get(valueIndex.getAndIncrement() % this.formParam.dimDataCount);
                    }
                }
                o.set(this.textDimFieldList.get(index), (Object)value);
            }
            for (index = 0; index < this.timeDimFieldList.size(); ++index) {
                o.set(this.timeDimFieldList.get(index), (Object)this.timeValueFieldList.get((current - 1) % this.timeValueFieldList.size()));
            }
            for (index = 0; index < this.ordinaryMeasureList.size(); ++index) {
                o.set(this.ordinaryMeasureList.get(index), (Object)Float.valueOf((float)(current % 100000) / 10.0f + 100000.0f));
            }
            if (containsDimHash) {
                o.set("dimhash", (Object)this.calculateDimHash(o));
            }
            Object[] values = new Object[propertyCount];
            for (int i = 0; i < propertyCount; ++i) {
                values[i] = o.get(i);
            }
            return values;
        }

        private DynamicObject copyDetail(Object[] detail, int propertyCount) {
            DynamicObject newDetail = BusinessDataServiceHelper.newDynamicObject((String)this.modelDetailEntityNumber);
            for (int i = 0; i < propertyCount; ++i) {
                newDetail.set(i, detail[i]);
            }
            return newDetail;
        }

        private Map<Integer, List<String>> buildTextDimValues() {
            HashMap<Integer, List<String>> textDimValuesMap = new HashMap<Integer, List<String>>(26);
            for (int j = 0; j < 26; ++j) {
                ArrayList<String> numbers = new ArrayList<String>(100);
                for (int i = 1; i <= 100; ++i) {
                    char prefix = (char)(j + 65);
                    String number = prefix + StringUtils.leftPad((String)String.valueOf(i), (int)10, (char)'0');
                    numbers.add(number.intern());
                }
                textDimValuesMap.put(j, numbers);
            }
            return textDimValuesMap;
        }

        private void initDimFields(DynamicObject analysisModel) {
            this.baseDimFieldList = new ArrayList<String>(16);
            this.textDimFieldList = new ArrayList<String>(16);
            this.timeDimFieldList = new ArrayList<String>(16);
            DynamicObjectCollection dEntry = analysisModel.getDynamicObjectCollection("dimension_entry");
            for (DynamicObject entry : dEntry) {
                String dimensionNumber = entry.getString("dimension.number");
                String necessity = entry.getString("necessity_dim");
                if ("0".equals(necessity)) {
                    this.orgFieldNumber = dimensionNumber;
                    continue;
                }
                if ("1".equals(necessity)) {
                    this.periodFieldNumber = dimensionNumber;
                    continue;
                }
                if ("2".equals(necessity)) {
                    this.accountFieldNumber = dimensionNumber;
                    continue;
                }
                String dimensionType = entry.getString("dimension.dimensiontype");
                if (FAFDimensionTypeEnum.OTHER.getCode().equals(dimensionType)) {
                    this.textDimFieldList.add(dimensionNumber);
                    continue;
                }
                if (FAFDimensionTypeEnum.DATE.getCode().equals(dimensionType)) {
                    this.timeDimFieldList.add(dimensionNumber);
                    continue;
                }
                if (!FAFDimensionTypeEnum.DATABASE.getCode().equals(dimensionType)) continue;
                this.baseDimFieldList.add(dimensionNumber);
            }
            this.timeValueFieldList = this.generateDateList();
        }

        private List<Date> generateDateList() {
            ArrayList<Date> dateList = new ArrayList<Date>(16);
            Calendar calendar = Calendar.getInstance();
            calendar.set(2019, 11, 1, 0, 0, 0);
            calendar.set(14, 0);
            Date startDate = calendar.getTime();
            calendar.set(2019, 11, 31);
            Date endDate = calendar.getTime();
            while (!startDate.after(endDate)) {
                dateList.add(startDate);
                calendar.setTime(startDate);
                calendar.add(5, 1);
                startDate = calendar.getTime();
            }
            return dateList;
        }

        private List<Date> generateDateList(Date startDate, Date endDate) {
            ArrayList<Date> dateList = new ArrayList<Date>(16);
            Calendar calendar = Calendar.getInstance();
            while (!startDate.after(endDate)) {
                dateList.add(startDate);
                calendar.setTime(startDate);
                calendar.add(5, 1);
                startDate = calendar.getTime();
            }
            return dateList;
        }

        private List<String> initOrdinaryMeasures(DynamicObject analysisModel) {
            DynamicObjectCollection dEntry = analysisModel.getDynamicObjectCollection("measure_entry");
            ArrayList<String> fields = new ArrayList<String>();
            for (DynamicObject entry : dEntry) {
                DynamicObject measure = entry.getDynamicObject("measure");
                String number = measure.getString("number");
                String measuretype = measure.getString("measuretype");
                if (!String.valueOf(MeasureTypeEnum.ORDINARY.getCode()).equals(measuretype)) continue;
                fields.add(number);
            }
            return fields;
        }

        private String calculateDimHash(DynamicObject detailData) {
            return AnalysisModelHashUtil.calculateDimHash((DynamicObject)detailData, this.modelHashDimensionNumberList);
        }
    }
}

