/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.CoreShowFormHelper;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;

public class BaseDataUtil {
    public static void openF7List(AbstractFormPlugin that, String datarequest, String closeCallBackName, String filterName, Collection filterCollections, Map<String, Object> customParams) {
        ListShowParameter listShowParameter = new ListShowParameter();
        if (StringUtils.isNotEmpty((CharSequence)filterName) && !CollectionUtils.isEmpty((Collection)filterCollections)) {
            ListFilterParameter filterParam = listShowParameter.getListFilterParameter();
            filterParam.getQFilters().add(new QFilter(filterName, "in", (Object)filterCollections));
        }
        listShowParameter.setLookUp(true);
        listShowParameter.setMultiSelect(false);
        listShowParameter.setBillFormId(datarequest);
        for (Map.Entry<String, Object> next : customParams.entrySet()) {
            String key = next.getKey();
            Object value = next.getValue();
            listShowParameter.setCustomParam(key, value);
        }
        if (StringUtils.isNotEmpty((CharSequence)closeCallBackName)) {
            listShowParameter.setCloseCallBack(new CloseCallBack(that.getClass().getName(), closeCallBackName));
        }
        listShowParameter.setFormId("bos_listf7");
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        listShowParameter.setShowTitle(false);
        StyleCss css = new StyleCss();
        css.setWidth("960");
        css.setHeight("580");
        listShowParameter.getOpenStyle().setInlineStyleCss(css);
        that.getView().showForm((FormShowParameter)listShowParameter);
    }

    public static ListShowParameter createFieldF7ShowParameter(String entitynumber, String propName, boolean isMultiSelect, String selectedRow) {
        try {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entitynumber);
            DynamicProperty property = dataEntityType.getProperty(propName);
            return BaseDataUtil.createF7ShowParameter(((BasedataProp)property).getBaseEntityId(), ((BasedataProp)property).getLayoutId(), isMultiSelect, selectedRow);
        }
        catch (Exception ex) {
            throw new KDBizException(ex.getMessage());
        }
    }

    public static ListShowParameter createF7ShowParameter(String baseEntityId, boolean isMultiSelect, String selectedRow) {
        return BaseDataUtil.createF7ShowParameter(baseEntityId, baseEntityId, isMultiSelect, selectedRow);
    }

    public static ListShowParameter createF7ShowParameter(String baseEntityId, String layoutId, boolean isMultiSelect, String selectedRow) {
        if (StringUtils.isBlank((CharSequence)layoutId)) {
            layoutId = baseEntityId;
        }
        ListShowParameter lsp = CoreShowFormHelper.createShowListForm((String)layoutId, (boolean)isMultiSelect);
        if (StringUtils.isNotBlank((CharSequence)selectedRow) && !Objects.equals("null", selectedRow)) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)baseEntityId);
            ISimpleProperty primaryKey = dataEntityType.getPrimaryKey();
            if (isMultiSelect) {
                Object[] pkIds = Arrays.stream(selectedRow.split(",")).filter(StringUtils::isNotBlank).map(row -> {
                    if (primaryKey instanceof VarcharProp) {
                        return String.valueOf(row);
                    }
                    if (primaryKey instanceof LongProp) {
                        return Long.valueOf(String.valueOf(row));
                    }
                    return null;
                }).distinct().toArray();
                lsp.setSelectedRows(pkIds);
            } else if (primaryKey instanceof VarcharProp) {
                lsp.setSelectedRow((Object)selectedRow);
            } else if (primaryKey instanceof LongProp) {
                lsp.setSelectedRow((Object)Long.valueOf(selectedRow));
            }
        }
        return lsp;
    }
}

