/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.verification;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.form.IFormView;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.macc.faf.verification.FAFConditionEdit;
import kd.macc.faf.verification.IFAFConditionEditProxy;

public class FAFConditionVerificationProxy
extends IFAFConditionEditProxy {
    private static final Log logger = LogFactory.getLog(FAFConditionVerificationProxy.class);
    final List<String> contansList = Arrays.asList("account", "beginfor", "debitfor", "creditfor", "endfor", "beginlocal", "debitlocal", "creditlocal", "endlocal", "yeardebitfor", "yeardebitlocal", "yearcreditfor", "yearcreditlocal", "beginqty", "debitqty", "creditqty", "endqty", "yeardebitqty", "yearcreditqty", "count");

    @Override
    public void afterCreateNewData(EventObject e) {
        this.FAFConditionEdit.getView().setVisible(Boolean.valueOf(false), new String[]{"tabpageap_expression"});
        String entityNumber = (String)this.FAFConditionEdit.getView().getFormShowParameter().getCustomParam("entitynumber");
        if (StringUtils.isNotBlank((CharSequence)entityNumber)) {
            FilterGrid filterGrid = (FilterGrid)this.FAFConditionEdit.getView().getControl("ffiltergrid");
            filterGrid.setEntityNumber(entityNumber);
            if ("gl_balance".equals(entityNumber)) {
                FilterGrid filterGrid1 = this.setInitFilterGridCondition(this.FAFConditionEdit.getView());
                this.colsHandle(this.FAFConditionEdit.getView(), entityNumber, filterGrid1);
            } else {
                this.colsHandle(this.FAFConditionEdit.getView(), entityNumber, filterGrid);
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeFilterF7SelectEvent beforeF7SelectEvent) {
        logger.info("PaConditionVerificationProxy beforeF7Select getRefEntityId " + beforeF7SelectEvent.getRefEntityId());
        if (!"bos_assistantdata_detail".equals(beforeF7SelectEvent.getRefEntityId())) {
            return;
        }
        Map map = (Map)JSON.parseObject((String)((String)this.FAFConditionEdit.getView().getFormShowParameter().getCustomParam("analysismodel")), Map.class);
        String fieldName = beforeF7SelectEvent.getFieldName();
        if (fieldName.contains(".")) {
            fieldName = fieldName.substring(0, fieldName.indexOf("."));
        }
        logger.info("PaConditionVerificationProxy beforeF7Select map " + map);
        if (map.containsKey(fieldName)) {
            List qFilters = beforeF7SelectEvent.getCustomQFilters();
            qFilters.add(new QFilter("group", "=", (Object)Long.valueOf((String)map.get(fieldName))));
        }
    }

    public FAFConditionVerificationProxy(FAFConditionEdit FAFConditionEdit2) {
        this.FAFConditionEdit = FAFConditionEdit2;
    }

    private void colsHandle(IFormView view, String entityNumber, FilterGrid filterGrid) {
        if ("pa_verificationrule".equals(view.getFormShowParameter().getCustomParam("sourcebill"))) {
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
            EntityTypeUtil helper = new EntityTypeUtil();
            List cols = helper.getFilterColumns((IDataEntityType)entityType);
            ArrayList<String> objects = new ArrayList<String>();
            objects.add("operationstatus");
            objects.add("del");
            objects.add("datastatus");
            Iterator iterator = cols.iterator();
            while (iterator.hasNext()) {
                Map next = (Map)iterator.next();
                for (String object : objects) {
                    if (!next.containsValue(object)) continue;
                    iterator.remove();
                }
            }
            filterGrid.setEntityNumber(entityType.getName());
            filterGrid.setFilterColumns(cols);
        }
    }

    private FilterGrid setInitFilterGridCondition(IFormView view) {
        EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
        FilterGrid filterGrid = (FilterGrid)view.getControl("ffiltergrid");
        LinkedHashMap<String, Map> colMap = new LinkedHashMap<String, Map>(10);
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"gl_balance");
        filterGrid.setEntityNumber("gl_balance");
        List allFilterColumns = entityTypeUtil.getFilterColumns((IDataEntityType)entityType);
        for (Map fc : allFilterColumns) {
            String fieldName = String.valueOf(fc.get("fieldName"));
            int charIndex = fieldName.indexOf(".");
            String baseField = charIndex > -1 ? fieldName.substring(0, charIndex) : fieldName;
            if (!this.contansList.contains(baseField)) continue;
            colMap.put(fieldName, fc);
        }
        filterGrid.setFilterColumns(new ArrayList(colMap.values()));
        return filterGrid;
    }
}

