/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.verification;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.FormulaEditHelper;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.formula.excel.FormulaException;
import kd.macc.faf.util.CalculateUtils;
import kd.macc.faf.verification.FAFConditionEdit;
import kd.macc.faf.verification.IFAFConditionEditProxy;

public class FAFIncomeProxy
extends IFAFConditionEditProxy {
    @Override
    public void click(EventObject evt) {
        Control ctlSource = (Control)evt.getSource();
        String ctlSourceKey = ctlSource.getKey();
        if ("btnok".equals(ctlSourceKey)) {
            IFormView view = this.FAFConditionEdit.getView();
            IDataModel model = view.getModel();
            String fexpression = (String)model.getValue("fexpression");
            String ftranexpr = (String)model.getValue("ftranexpr");
            String fextraexpression = (String)model.getValue("fextraexpression");
            String fdescription = (String)model.getValue("fdescription");
            if ("".equals(fexpression)) {
                this.FAFConditionEdit.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u516c\u5f0f\u8868\u8fbe\u5f0f\u3002", (String)"FAFIncomeProxy_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!fexpression.equals(ftranexpr)) {
                this.FAFConditionEdit.getView().showTipNotification(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u9519\u8bef\u3002", (String)"FAFIncomeProxy_1", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                return;
            }
            try {
                this.tranExpression(fexpression);
            }
            catch (Exception e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u9519\u8bef", (String)"FAFIncomeProxy_2", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            }
            HashMap<String, String> formulaObj = new HashMap<String, String>(3);
            formulaObj.put("expression", fexpression);
            formulaObj.put("fextraexpression", fextraexpression);
            formulaObj.put("description", fdescription);
            this.FAFConditionEdit.getView().returnDataToParent((Object)SerializationUtils.toJsonString(formulaObj));
            this.FAFConditionEdit.getView().close();
        }
        if ("btncancel".contains(ctlSourceKey)) {
            this.FAFConditionEdit.setIproxy(null);
            this.FAFConditionEdit.click(evt);
        } else if ("clr".equalsIgnoreCase(ctlSourceKey)) {
            this.FAFConditionEdit.getView().getModel().setValue("fextraexpression", (Object)"");
            this.FAFConditionEdit.getView().getModel().setValue("fexpression", (Object)"");
            this.FAFConditionEdit.getView().getModel().setValue("fdescription", (Object)"");
            FormulaEditHelper.setCursorIndex((IFormView)this.FAFConditionEdit.getView(), (String)"fextraexpression", (int)0);
            FormulaEditHelper.setCursorIndex((IFormView)this.FAFConditionEdit.getView(), (String)"fexpression", (int)0);
            FormulaEditHelper.setCursorIndex((IFormView)this.FAFConditionEdit.getView(), (String)"fdescription", (int)0);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)ctlSourceKey, (CharSequence)"backspace")) {
            FormulaEditHelper.backSpaceExpression((IFormView)this.FAFConditionEdit.getView(), (String)"backspace", (String)"fextraexpression");
            FormulaEditHelper.backSpaceExpression((IFormView)this.FAFConditionEdit.getView(), (String)"backspace", (String)"fexpression");
            FormulaEditHelper.backSpaceExpression((IFormView)this.FAFConditionEdit.getView(), (String)"backspace", (String)"fdescription");
        } else {
            this.clickCompareButton(ctlSourceKey);
        }
    }

    @Override
    public void treeNodeClick(TreeNodeEvent e) {
        String treenodes = (String)this.FAFConditionEdit.getView().getFormShowParameter().getCustomParam("treenodes");
        TreeNode treeNode = (TreeNode)SerializationUtils.fromJsonString((String)treenodes, TreeNode.class);
        String str = e.getNodeId().toString();
        TreeNode clickNode = treeNode.getTreeNode(str, Integer.MAX_VALUE);
        String text = clickNode.getText();
        String name = text.substring(text.indexOf(" ") + 1);
        FormulaEditHelper.insertExpression((IFormView)this.FAFConditionEdit.getView(), (String)"tv_fields", (String)"fexpression", (String)str);
        FormulaEditHelper.insertExpression((IFormView)this.FAFConditionEdit.getView(), (String)"tv_fields", (String)"fdescription", (String)name);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        this.FAFConditionEdit.setIproxy(null);
        this.FAFConditionEdit.afterCreateNewData(e);
        this.FAFConditionEdit.getView().setVisible(Boolean.valueOf(false), new String[]{"tabpageap_condition", "btnequal", "btnnotequal", "btnlessthen", "btnmorethen", "btnlessequal", "btnmoreequal", "btnand", "btnor", "btnfunction"});
        this.FAFConditionEdit.getView().setEnable(Boolean.valueOf(false), new String[]{"fexpression", "fdescription"});
    }

    @Override
    void afterBindData(EventObject e) {
        String fextraexpression = (String)this.FAFConditionEdit.getView().getFormShowParameter().getCustomParam("fextraexpression");
        if (StringUtils.isBlank((CharSequence)fextraexpression)) {
            fextraexpression = (String)this.FAFConditionEdit.getView().getModel().getValue("fexpression");
        }
        this.FAFConditionEdit.getView().getModel().setValue("fextraexpression", (Object)fextraexpression);
        this.FAFConditionEdit.setIproxy(null);
        this.FAFConditionEdit.afterBindData(e);
    }

    public FAFIncomeProxy(FAFConditionEdit FAFConditionEdit2) {
        this.FAFConditionEdit = FAFConditionEdit2;
    }

    @Override
    public String tranExpression(String expression) {
        this.FAFConditionEdit.setIproxy(null);
        String expression_desc = expression;
        String fextraexpression = (String)this.FAFConditionEdit.getView().getModel().getValue("fextraexpression");
        String expression_new = CalculateUtils.format((String)fextraexpression, p -> "(A" + p + ")");
        String tranExpressionReturnData = "";
        try {
            tranExpressionReturnData = this.FAFConditionEdit.tranExpression(expression_new);
        }
        catch (Exception e) {
            throw new FormulaException(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u9519\u8bef", (String)"FAFIncomeProxy_2", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        }
        if (tranExpressionReturnData.equals(expression_new)) {
            return expression_desc;
        }
        return tranExpressionReturnData;
    }

    private void clickCompareButton(String compareKey) {
        String compareValue = "";
        int var4 = -1;
        switch (compareKey.hashCode()) {
            case -1378808635: {
                if (!compareKey.equals("btnadd")) break;
                var4 = 0;
                break;
            }
            case -1378808325: {
                if (!compareKey.equals("btnand")) break;
                var4 = 10;
                break;
            }
            case -1179832642: {
                if (!compareKey.equals("btndivison")) break;
                var4 = 3;
                break;
            }
            case -997791075: {
                if (!compareKey.equals("btnnotequal")) break;
                var4 = 5;
                break;
            }
            case -845487581: {
                if (!compareKey.equals("btnmoreequal")) break;
                var4 = 9;
                break;
            }
            case -616237854: {
                if (!compareKey.equals("btnmultiplication")) break;
                var4 = 2;
                break;
            }
            case -489169518: {
                if (!compareKey.equals("btnlessthen")) break;
                var4 = 6;
                break;
            }
            case 94070079: {
                if (!compareKey.equals("btnor")) break;
                var4 = 11;
                break;
            }
            case 206934115: {
                if (!compareKey.equals("btnleft")) break;
                var4 = 12;
                break;
            }
            case 1497184590: {
                if (!compareKey.equals("btnmorethen")) break;
                var4 = 7;
                break;
            }
            case 1859708056: {
                if (!compareKey.equals("btnsubtraction")) break;
                var4 = 1;
                break;
            }
            case 2002044511: {
                if (!compareKey.equals("btnlessequal")) break;
                var4 = 8;
                break;
            }
            case 2113897048: {
                if (!compareKey.equals("btnequal")) break;
                var4 = 4;
                break;
            }
            case 2125651264: {
                if (!compareKey.equals("btnright")) break;
                var4 = 13;
            }
        }
        switch (var4) {
            case 0: {
                compareValue = "+";
                break;
            }
            case 1: {
                compareValue = "-";
                break;
            }
            case 2: {
                compareValue = "*";
                break;
            }
            case 3: {
                compareValue = "/";
                break;
            }
            case 4: {
                compareValue = "=";
                break;
            }
            case 5: {
                compareValue = "<>";
                break;
            }
            case 6: {
                compareValue = "<";
                break;
            }
            case 7: {
                compareValue = ">";
                break;
            }
            case 8: {
                compareValue = "<=";
                break;
            }
            case 9: {
                compareValue = ">=";
                break;
            }
            case 10: {
                compareValue = "and";
                break;
            }
            case 11: {
                compareValue = "or";
                break;
            }
            case 12: {
                compareValue = "(";
                break;
            }
            case 13: {
                compareValue = ")";
            }
        }
        if (!StringUtils.isBlank((CharSequence)compareValue)) {
            FormulaEditHelper.insertExpression((IFormView)this.FAFConditionEdit.getView(), (String)compareKey, (String)"fextraexpression", (String)compareValue);
            FormulaEditHelper.insertExpression((IFormView)this.FAFConditionEdit.getView(), (String)compareKey, (String)"fexpression", (String)compareValue);
            FormulaEditHelper.insertExpression((IFormView)this.FAFConditionEdit.getView(), (String)compareKey, (String)"fdescription", (String)compareValue);
        }
    }
}

