/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.verification;

import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.designer.botp.FormulaEditHelper;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.macc.faf.util.CalculateUtils;
import kd.macc.faf.verification.FAFConditionEdit;
import kd.macc.faf.verification.FAFIncomeProxy;

public class FAFReportItemProxy
extends FAFIncomeProxy {
    public FAFReportItemProxy(FAFConditionEdit FAFConditionEdit2) {
        super(FAFConditionEdit2);
    }

    @Override
    public void treeNodeClick(TreeNodeEvent e) {
        String treeNodes = (String)this.FAFConditionEdit.getView().getFormShowParameter().getCustomParam("treenodes");
        TreeNode treeNode = (TreeNode)SerializationUtils.fromJsonString((String)treeNodes, TreeNode.class);
        IFormView view = this.FAFConditionEdit.getView();
        String id = e.getNodeId().toString();
        TreeNode clickNode = treeNode.getTreeNode(id, Integer.MAX_VALUE);
        Object data = clickNode.getData();
        List children = clickNode.getChildren();
        if (children != null && !children.isEmpty()) {
            StringBuilder transExpressionBuilder = new StringBuilder("(");
            StringBuilder expressionBuilder = new StringBuilder("(");
            StringBuilder descriptionBuilder = new StringBuilder("(");
            this.appendNodeData(clickNode, transExpressionBuilder, expressionBuilder, descriptionBuilder);
            transExpressionBuilder.append(")");
            expressionBuilder.append(")");
            descriptionBuilder.append(")");
            FormulaEditHelper.insertExpression((IFormView)view, (String)"tv_fields", (String)"fextraexpression", (String)transExpressionBuilder.toString());
            FormulaEditHelper.insertExpression((IFormView)view, (String)"tv_fields", (String)"fexpression", (String)expressionBuilder.toString());
            FormulaEditHelper.insertExpression((IFormView)view, (String)"tv_fields", (String)"fdescription", (String)descriptionBuilder.toString());
            return;
        }
        String text = clickNode.getText();
        String name = text.substring(text.indexOf(" ") + 1);
        FormulaEditHelper.insertExpression((IFormView)view, (String)"tv_fields", (String)"fextraexpression", (String)CalculateUtils.formulaItemFormat((String)String.valueOf(data)));
        FormulaEditHelper.insertExpression((IFormView)view, (String)"tv_fields", (String)"fexpression", (String)String.valueOf(data));
        FormulaEditHelper.insertExpression((IFormView)view, (String)"tv_fields", (String)"fdescription", (String)(name.isEmpty() ? text : name));
    }

    @Override
    void initialize() {
        this.FAFConditionEdit.setSearchExtraJudge((treeNode, text) -> treeNode.getData() != null);
    }

    private void appendNodeData(TreeNode currentNode, StringBuilder transExpressionBuilder, StringBuilder expressionBuilder, StringBuilder descriptionBuilder) {
        List children;
        Object dataObj = currentNode.getData();
        if (dataObj != null) {
            String dataStr = String.valueOf(dataObj);
            String text = currentNode.getText();
            String name = text.substring(text.indexOf(" ") + 1);
            if (transExpressionBuilder.toString().endsWith("(")) {
                transExpressionBuilder.append(CalculateUtils.formulaItemFormat((String)dataStr));
            } else {
                transExpressionBuilder.append(" + ").append(CalculateUtils.formulaItemFormat((String)dataStr));
            }
            if (expressionBuilder.toString().endsWith("(")) {
                expressionBuilder.append(dataStr);
            } else {
                expressionBuilder.append(" + ").append(dataStr);
            }
            if (descriptionBuilder.toString().endsWith("(")) {
                descriptionBuilder.append(name.isEmpty() ? text : name);
            } else {
                descriptionBuilder.append(" + ").append(name.isEmpty() ? text : name);
            }
        }
        if ((children = currentNode.getChildren()) != null && !children.isEmpty()) {
            for (TreeNode child : children) {
                this.appendNodeData(child, transExpressionBuilder, expressionBuilder, descriptionBuilder);
            }
        }
    }
}

