/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.verification;

import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.GetValByConditionEdit;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.macc.faf.util.EntityFieldTreeOption;
import kd.macc.faf.util.EntityFieldTreeResult;
import kd.macc.faf.util.EntityTreeUtil;
import kd.macc.faf.util.ExpressionType;
import kd.macc.faf.verification.GetValByFormulaEdit;

public class GetValByConditionFormPlugin
extends GetValByConditionEdit {
    public void initialize() {
        this.addClickListeners(new String[]{"conditiondesc", "formuladesc", "btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void click(EventObject e) {
        Control srcCtrl = (Control)e.getSource();
        if (srcCtrl.getKey().equalsIgnoreCase("conditiondesc")) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            String formulaJson = (String)this.getModel().getValue("condition", rowIndex);
            String fieldNodes = (String)this.getView().getFormShowParameter().getCustomParam("treenodes");
            String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entitynumber");
            this.showPAConditionForm(formulaJson, entityNumber, fieldNodes, "conditiondesc");
        } else if (srcCtrl.getKey().equalsIgnoreCase("formuladesc")) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            String formulaJson = (String)this.getModel().getValue("formula", rowIndex);
            String fieldNodes = (String)this.getView().getFormShowParameter().getCustomParam("treenodes");
            String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entitynumber");
            this.showPAFormulaForm(formulaJson, entityNumber, fieldNodes, "formuladesc");
        } else if (srcCtrl.getKey().equalsIgnoreCase("btnok")) {
            int rowCount = this.getModel().getEntryRowCount("entryentity");
            if (rowCount > 0) {
                if (this.validate()) {
                    super.click(e);
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u53d6\u503c\u6761\u4ef6\u3002", (String)"GetValByConditionFormPlugin_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            }
        } else {
            super.click(e);
        }
    }

    private boolean validate() {
        int rowCount = this.getModel().getEntryRowCount("entryentity");
        if (rowCount > 0) {
            String selectTypeErr = ResManager.loadKDString((String)"\u53d6\u503c\u65b9\u5f0f", (String)"GetValByConditionFormPlugin_1", (String)"macc-faf-formplugin", (Object[])new Object[0]);
            String conditionErr = ResManager.loadKDString((String)"\u6761\u4ef6", (String)"GetValByConditionFormPlugin_2", (String)"macc-faf-formplugin", (Object[])new Object[0]);
            String formulaErr = ResManager.loadKDString((String)"\u53d6\u503c\u516c\u5f0f", (String)"GetValByConditionFormPlugin_3", (String)"macc-faf-formplugin", (Object[])new Object[0]);
            String rowErr = ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u8bf7\u5f55\u5165%2$s\u3002", (String)"GetValByConditionFormPlugin_4", (String)"macc-faf-formplugin", (Object[])new Object[0]);
            for (int index = 0; index < rowCount; ++index) {
                String formula;
                String condition;
                String selectType = (String)this.getModel().getValue("selecttype", index);
                StringBuilder sb = new StringBuilder();
                if (StringUtils.isEmpty((CharSequence)selectType)) {
                    sb.append(selectTypeErr).append('\u3001');
                }
                if (StringUtils.isEmpty((CharSequence)(condition = (String)this.getModel().getValue("conditiondesc", index)))) {
                    sb.append(conditionErr).append('\u3001');
                }
                if (StringUtils.isEmpty((CharSequence)(formula = (String)this.getModel().getValue("formuladesc", index)))) {
                    sb.append(formulaErr).append('\u3001');
                }
                if (sb.length() <= 0) continue;
                this.getView().showTipNotification(String.format(rowErr, index + 1, sb.substring(0, sb.length() - 1)));
                return false;
            }
        }
        return true;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
    }

    private void showPAFormulaForm(String formulaJson, String entityNumber, String fieldNodes, String sourceCtrlKey) {
        GetValByFormulaEdit.openForm(formulaJson, entityNumber, fieldNodes, (AbstractFormPlugin)this, sourceCtrlKey);
    }

    private void showPAConditionForm(String conditionJson, String entityNumber, String fieldNodes, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("faf_expression");
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        showParameter.getCustomParams().put("PROXY_CLASS", "kd.macc.faf.verification.FAFConditionVerificationProxy");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public static void openForm(String conditionJson, String entityNumber, String fieldNodes, AbstractFormPlugin plugin, String closeActionId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("pa_valbycondition");
        showParameter.getCustomParams().put("crvalbyconditions", conditionJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, closeActionId));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        plugin.getView().showForm(showParameter);
    }

    public static String fieldNode(String entityNumber, boolean readChildEntity) {
        EntityFieldTreeOption option = EntityFieldTreeOption.create();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        option.setEntityType((IDataEntityType)mainEntityType);
        option.setReadEntryEntity(readChildEntity);
        option.setExprType(ExpressionType.Condition);
        EntityFieldTreeResult result = EntityTreeUtil.getEntityFieldNodes((EntityFieldTreeOption)option);
        TreeNode tree = EntityTreeUtil.buildBillTree((List)result.getNodes());
        return SerializationUtils.toJsonString((Object)tree);
    }
}

