/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasource;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.macc.faf.enums.DataSourceTypeEnum;

public class DataSourceSaveValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            this.validateEntry(dataEntity);
        }
    }

    private void validateEntry(ExtendedDataEntity dataEntity) {
        DynamicObject newEntity = dataEntity.getDataEntity();
        String datasourceType = newEntity.getString("datasource_type");
        boolean synctype = newEntity.getBoolean("synctype");
        if (DataSourceTypeEnum.BCM.getCode().equals(datasourceType) && synctype) {
            DynamicObjectCollection entryentity = newEntity.getDynamicObjectCollection("entryentityfilterapi");
            boolean tagScenario = false;
            for (DynamicObject dyn : entryentity) {
                String number = dyn.getString("bcmdimension.number");
                if (!"Scenario".equals(number)) continue;
                tagScenario = true;
                String textfilterTag = dyn.getString("textfilter_tag");
                if (!StringUtils.isEmpty((CharSequence)textfilterTag)) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u60c5\u666f\u7ef4\u5ea6\u7684\u53d6\u6570\u8303\u56f4\u3002", (String)"DataSourceSaveValidator_0", (String)"macc-faf-opplugin", (Object[])new Object[0]));
            }
            if (!tagScenario) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u60c5\u666f\u7ef4\u5ea6\u7684\u53d6\u6570\u8303\u56f4\u3002", (String)"DataSourceSaveValidator_0", (String)"macc-faf-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

