/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.mservice;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.faf.bservice.BusinessDynamicFactory;
import kd.macc.faf.bservice.check.DataCheckReport;
import kd.macc.faf.bservice.check.DataCheckReportRunnable;
import kd.macc.faf.bservice.check.ICheckReportCallBack;

public class DataCheckReportUpdateValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            this.validateEntry(dataEntity);
        }
    }

    private void validateEntry(final ExtendedDataEntity dataEntity) {
        DynamicObject newEntity = dataEntity.getDataEntity();
        try {
            if (newEntity.getDataEntityType().getProperties().get((Object)"model") == null) {
                newEntity = BusinessDataServiceHelper.loadSingle((Object)newEntity.getPkValue(), (String)"faf_datacheckreport");
            }
            DataCheckReport checkReport = BusinessDynamicFactory.createDataCheckReport((Object)newEntity);
            DataCheckReportRunnable runnable = new DataCheckReportRunnable(checkReport);
            runnable.setCallBack(new ICheckReportCallBack(){

                public void onFail(DataCheckReport report, String message) {
                    DataCheckReportUpdateValidator.this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u5931\u8d25\uff0c%s", (String)"DataCheckReportUpdateValidator_0", (String)"macc-faf-opplugin", (Object[])new Object[0]), message));
                }
            });
            runnable.run();
        }
        catch (Exception ex) {
            this.addErrorMessage(dataEntity, ex.getMessage());
        }
    }
}

