/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.system.opplugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.macc.faf.helper.FAFAnalysisModelHelper;
import kd.macc.faf.system.validate.FAFAnalysisModelSaveValidator;

public class FAFAnalysisModelSaveOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new FAFAnalysisModelSaveValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        for (DynamicObject dataEntity : e.getDataEntities()) {
            try {
                this.checkEntryDuplication(dataEntity);
            }
            catch (Exception exception) {
                throw new KDBizException(exception.getMessage());
            }
        }
    }

    private void checkEntryDuplication(DynamicObject dataEntity) {
        long modelId = dataEntity.getLong("id");
        if (modelId != 0L) {
            DynamicObject anaModelDy = FAFAnalysisModelHelper.loadAnalysisModel((Object)modelId);
            this.checkEntry(anaModelDy, "dimension_entry", "dimension", ResManager.loadKDString((String)"\u7ef4\u5ea6", (String)"FAFAnalysisModelSaveOp_1", (String)"macc-faf-opplugin", (Object[])new Object[0]));
            this.checkEntry(anaModelDy, "measure_entry", "measure", ResManager.loadKDString((String)"\u5ea6\u91cf", (String)"FAFAnalysisModelSaveOp_2", (String)"macc-faf-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkEntry(DynamicObject anaModelDY, String entryFieldNumber, String fieldNumber, String entryName) {
        Map<String, List<DynamicObject>> entryGroupByNumber = anaModelDY.getDynamicObjectCollection(entryFieldNumber).stream().collect(Collectors.groupingBy(entry -> entry.getDynamicObject(fieldNumber).getString("number")));
        ArrayList<String> duplicateNumbers = new ArrayList<String>(2);
        for (Map.Entry<String, List<DynamicObject>> entry2 : entryGroupByNumber.entrySet()) {
            List<DynamicObject> dynamicObjects = entry2.getValue();
            if (CollectionUtils.isEmpty(dynamicObjects) || dynamicObjects.size() <= 1) continue;
            duplicateNumbers.add(entry2.getKey());
        }
        if (!CollectionUtils.isEmpty(duplicateNumbers)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u7f16\u53f7\u4e3a[%2$s]\u7684\u6570\u636e\u5df2\u5b58\u5728\u3002", (String)"FAFAnalysisModelSaveOp_0", (String)"macc-faf-opplugin", (Object[])new Object[0]), entryName, String.join((CharSequence)",", duplicateNumbers)));
        }
    }
}

