/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.system.opplugin;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.interaction.InteractionContext;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.faf.enums.FAFWorkTaskTypeEnum;
import kd.macc.faf.helper.FAFSaveServiceHelper;
import kd.macc.faf.system.validate.FAFAnalysisSystemSaveValidator;
import kd.macc.faf.util.FAFTableUtil;

public class FAFAnalysisSystemSaveOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(FAFSaveServiceHelper.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        String entityKey = this.billEntityType.getName();
        FAFAnalysisSystemSaveValidator validator = new FAFAnalysisSystemSaveValidator();
        validator.setEntityKey(entityKey);
        e.addValidator((AbstractValidator)validator);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities.length != 1) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u5206\u6790\u4f53\u7cfb\u4e0d\u652f\u6301\u6279\u91cf\u4fdd\u5b58\u3002", (String)"FAFAnalysisSystemSaveOp_0", (String)"macc-faf-opplugin", (Object[])new Object[0]));
            e.setCancel(true);
        } else {
            this.getOperationResult().setInteractionContext(new InteractionContext());
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            String bytempalte = this.getOption().getVariableValue("bytemplate", "false");
            if (!"true".equals(bytempalte)) continue;
            try {
                FAFSaveServiceHelper.newFrameworkByTemplate((DynamicObject)dataEntity, (String)"defaulttempalte");
            }
            catch (KDBizException ex) {
                e.setCancelOperation(true);
                throw ex;
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        for (DynamicObject dataEntity : e.getDataEntities()) {
            String bytempalte = this.getOption().getVariableValue("bytemplate", "false");
            if (!"true".equals(bytempalte)) continue;
            Object systemId = dataEntity.getPkValue();
            Long modelId = 0L;
            boolean createTableFlag = false;
            try {
                QFilter qFilter = new QFilter("analysis_system", "=", systemId);
                DynamicObjectCollection objs = QueryServiceHelper.query((String)"pa_analysismodel", (String)"id,tablenumber,tablename", (QFilter[])qFilter.toArray(), null, (int)1);
                if (objs.size() == 0) {
                    return;
                }
                DynamicObject dyn = (DynamicObject)objs.get(0);
                modelId = dyn.getLong("id");
                String tablenumber = dyn.getString("tablenumber");
                String tablenname = dyn.getString("tablename");
                createTableFlag = FAFTableUtil.createOrDropTable((Long)modelId, (FAFWorkTaskTypeEnum)FAFWorkTaskTypeEnum.Create_Table_Task, (String)tablenumber.toLowerCase(), (String)tablenname, (Boolean)Boolean.FALSE);
            }
            catch (KDException ex) {
                logger.error("\u6a21\u578b\u521b\u5efa\u5931\u8d25\uff01", (Throwable)ex);
            }
            if (!createTableFlag) {
                DynamicObject paAnalysismodel = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"pa_analysismodel");
                paAnalysismodel.set("tablenumber", (Object)Character.valueOf(' '));
                paAnalysismodel.set("tablename", (Object)Character.valueOf(' '));
                SaveServiceHelper.update((DynamicObject)paAnalysismodel);
            }
            Map cusP = this.getOperationResult().getInteractionContext().getCustShowParameter();
            cusP.put("createTabelFlag", String.valueOf(createTableFlag));
            cusP.put("systemId", String.valueOf(dataEntity.getPkValue()));
            cusP.put("modelId", String.valueOf(modelId));
        }
    }
}

