/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.system.validate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.macc.faf.enums.DimensionNecessityEnum;
import kd.macc.faf.enums.DimensionTypeEnum;
import kd.macc.faf.enums.ImportSystemSourceTypeEnum;
import kd.macc.faf.helper.FAFDimensionHelper;
import kd.macc.faf.helper.FAFMeasureHelper;
import org.apache.commons.lang3.ArrayUtils;

public class FAFAnalysisModelSaveValidator
extends AbstractValidator {
    private static final String BOS_ORG = "bos_org";
    private static final String PA_ACCOUNT = "pa_account";
    private static final String BD_ACCOUNTVIEW = "bd_accountview";
    private static final String[] BD_PERIOD = new String[]{"bd_period", "pa_analysisperiod"};

    public void validate() {
        try {
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                this.validateEntry(dataEntity);
                this.validateSystemSource(dataEntity);
            }
        }
        catch (Exception exception) {
            throw new KDBizException(exception.getMessage());
        }
    }

    private void validateEntry(ExtendedDataEntity dataEntity) {
        DynamicObjectCollection measureEntry;
        DynamicObjectCollection dimensionEntry = (DynamicObjectCollection)dataEntity.getValue("dimension_entry");
        HashSet<Long> dimeAndMeasureSet = new HashSet<Long>(10);
        Integer periodIndex = null;
        Integer subjectIndex = null;
        boolean verifyPeriodType = false;
        boolean accountTypeNess = false;
        if (dimensionEntry != null && !dimensionEntry.isEmpty()) {
            int rowIndex = 1;
            boolean entityNess = true;
            boolean periodNess = true;
            boolean subjectNess = true;
            HashSet<String> dimensionNumbers = new HashSet<String>(dimensionEntry.size());
            for (DynamicObject dimEntry : dimensionEntry) {
                String necessityDim = dimEntry.getString("necessity_dim");
                DynamicObject dim = dimEntry.getDynamicObject("dimension");
                dimeAndMeasureSet.add((Long)dim.getPkValue());
                dimensionNumbers.add(dim.getString("number"));
                if (DimensionNecessityEnum.ORG.getCode().equals(necessityDim)) {
                    if (!BOS_ORG.equals(dim.getString("dimensionsource.number"))) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u7ef4\u5ea6\u5206\u5f55\uff1a\u6a21\u578b\u5fc5\u8981\u7ef4\u5ea6\u201c\u7ec4\u7ec7\u201d\u5bf9\u5e94\u7684\u7ef4\u5ea6\u6240\u7ed1\u5b9a\u7684\u7ef4\u5ea6\u6765\u6e90\u5fc5\u987b\u662f\u4e1a\u52a1\u5355\u5143\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"FAFAnalysisModelSaveValidator_0", (String)"macc-faf-opplugin", (Object[])new Object[0]), rowIndex));
                    }
                    entityNess = false;
                } else if (DimensionNecessityEnum.PERIOD.getCode().equals(necessityDim)) {
                    periodIndex = rowIndex;
                    String dimensionsourceNumber = dim.getString("dimensionsource.number");
                    String dimensionType = dim.getString("dimensiontype");
                    if (!ArrayUtils.contains((Object[])BD_PERIOD, (Object)dimensionsourceNumber) && DimensionTypeEnum.DATE != DimensionTypeEnum.getCode((String)dimensionType)) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u7ef4\u5ea6\u5206\u5f55\uff1a\u6a21\u578b\u5fc5\u8981\u7ef4\u5ea6\u201c\u65f6\u95f4/\u671f\u95f4\u201d\u5bf9\u5e94\u7684\u7ef4\u5ea6\u6240\u7ed1\u5b9a\u7684\u7ef4\u5ea6\u6765\u6e90\u5fc5\u987b\u662f\u4f1a\u8ba1\u671f\u95f4/\u5206\u6790\u671f\u95f4\u6216\u65f6\u95f4\u7ef4\u5ea6\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"FAFAnalysisModelSaveValidator_1", (String)"macc-faf-opplugin", (Object[])new Object[0]), rowIndex));
                        periodIndex = null;
                    }
                    if (DimensionTypeEnum.DATE == DimensionTypeEnum.getCode((String)dimensionType)) {
                        subjectNess = false;
                    }
                    verifyPeriodType = BD_PERIOD[0].equals(dimensionsourceNumber) && dim.get("group") == null;
                    periodNess = false;
                } else if (DimensionNecessityEnum.ACCOUNT.getCode().equals(necessityDim)) {
                    subjectIndex = rowIndex;
                    subjectNess = false;
                    String dimEntityNumber = dim.getString("dimensionsource.number");
                    if ((BD_ACCOUNTVIEW.equals(dimEntityNumber) || PA_ACCOUNT.equals(dimEntityNumber)) && dim.get("group") == null) {
                        accountTypeNess = true;
                    }
                }
                ++rowIndex;
            }
            if (dimensionNumbers.size() != dimensionEntry.size()) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7ef4\u5ea6\u5206\u5f55\u4e2d\u4e0d\u5141\u8bb8\u5b58\u5728\u91cd\u590d\u7684\u6570\u636e\u3002", (String)"FAFAnalysisModelSaveValidator_18", (String)"macc-faf-opplugin", (Object[])new Object[0]));
            }
            if (entityNess) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5728\u7ef4\u5ea6\u5206\u5f55\u4e2d\u9009\u62e9\uff1a\u6a21\u578b\u5fc5\u8981\u7ef4\u5ea6\u201c\u7ec4\u7ec7\u201d\u3002", (String)"FAFAnalysisModelSaveValidator_2", (String)"macc-faf-opplugin", (Object[])new Object[0]));
            }
            if (periodNess) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5728\u7ef4\u5ea6\u5206\u5f55\u4e2d\u9009\u62e9\uff1a\u6a21\u578b\u5fc5\u8981\u7ef4\u5ea6\u201c\u65f6\u95f4/\u671f\u95f4\u201d\u3002", (String)"FAFAnalysisModelSaveValidator_3", (String)"macc-faf-opplugin", (Object[])new Object[0]));
            }
            if (subjectNess) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5728\u7ef4\u5ea6\u5206\u5f55\u4e2d\u9009\u62e9\uff1a\u6a21\u578b\u5fc5\u8981\u7ef4\u5ea6\u201c\u4f1a\u8ba1\u79d1\u76ee\u201d\u3002", (String)"FAFAnalysisModelSaveValidator_4", (String)"macc-faf-opplugin", (Object[])new Object[0]));
            }
        }
        if ((measureEntry = (DynamicObjectCollection)dataEntity.getValue("measure_entry")) != null && !measureEntry.isEmpty()) {
            HashSet<String> measureNumbers = new HashSet<String>(measureEntry.size());
            for (DynamicObject meaEntry : measureEntry) {
                DynamicObject measure = meaEntry.getDynamicObject("measure");
                measureNumbers.add(measure.getString("number"));
                if ("2".equals(measure.getString("measuretype"))) continue;
                dimeAndMeasureSet.add((Long)measure.getPkValue());
            }
            int rowIndex = 1;
            for (DynamicObject meaEntry : measureEntry) {
                String tip = null;
                DynamicObject measure = meaEntry.getDynamicObject("measure");
                if ("2".equals(measure.getString("measuretype"))) {
                    DynamicObject measureCal = measure.getDynamicObject("measure");
                    DynamicObject dimensionCal = measure.getDynamicObject("dimension");
                    if (measureCal != null && dimensionCal != null) {
                        if (!dimeAndMeasureSet.contains((Long)measureCal.getPkValue()) && !dimeAndMeasureSet.contains((Long)dimensionCal.getPkValue())) {
                            tip = ResManager.loadKDString((String)"\u805a\u5408\u7ef4\u5ea6\u548c\u8ba1\u7b97\u5ea6\u91cf\u6dfb\u52a0\u5230\u7ef4\u5ea6\u5206\u5f55\u548c\u5ea6\u91cf\u5206\u5f55\u4e2d", (String)"FAFAnalysisModelSaveValidator_20", (String)"macc-faf-opplugin", (Object[])new Object[0]);
                        } else if (!dimeAndMeasureSet.contains((Long)dimensionCal.getPkValue())) {
                            tip = ResManager.loadKDString((String)"\u805a\u5408\u7ef4\u5ea6\u6dfb\u52a0\u5230\u7ef4\u5ea6\u5206\u5f55\u4e2d", (String)"FAFAnalysisModelSaveValidator_21", (String)"macc-faf-opplugin", (Object[])new Object[0]);
                        } else if (!dimeAndMeasureSet.contains((Long)measureCal.getPkValue())) {
                            tip = ResManager.loadKDString((String)"\u8ba1\u7b97\u5ea6\u91cf\u6dfb\u52a0\u5230\u5ea6\u91cf\u5206\u5f55\u4e2d", (String)"FAFAnalysisModelSaveValidator_22", (String)"macc-faf-opplugin", (Object[])new Object[0]);
                        }
                        if (StringUtils.isNotEmpty((String)tip)) {
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u5ea6\u91cf\u5206\u5f55\uff1a\u8bf7\u5c06\u8be5\u8ba1\u7b97\u578b\u5ea6\u91cf\u4e2d\u7684%s\u3002", (String)"FAFAnalysisModelSaveValidator_8", (String)"macc-faf-opplugin", (Object[])new Object[0]), rowIndex, tip));
                        }
                    } else {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7b2c%d\u884c\u5ea6\u91cf\u5206\u5f55\uff1a\u8ba1\u7b97\u578b\u7ef4\u5ea6\u7684\u805a\u5408\u7ef4\u5ea6\u548c\u8ba1\u7b97\u5ea6\u91cf\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FAFAnalysisModelSaveValidator_9", (String)"macc-faf-opplugin", (Object[])new Object[0]));
                    }
                }
                ++rowIndex;
            }
            if (measureNumbers.size() != measureEntry.size()) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5ea6\u91cf\u5206\u5f55\u4e2d\u4e0d\u5141\u8bb8\u5b58\u5728\u91cd\u590d\u7684\u6570\u636e\u3002", (String)"FAFAnalysisModelSaveValidator_19", (String)"macc-faf-opplugin", (Object[])new Object[0]));
            }
        }
        if (verifyPeriodType && periodIndex != null) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u7ef4\u5ea6\u5206\u5f55\uff1a\u6a21\u578b\u5fc5\u8981\u7ef4\u5ea6\u201c\u65f6\u95f4/\u671f\u95f4\u201d\u5bf9\u5e94\u7684\u7ef4\u5ea6\u5fc5\u987b\u8bbe\u7f6e\u7c7b\u578b\u5b57\u6bb5\u4e3a\uff1a\u671f\u95f4\u7c7b\u578b\u3002", (String)"FAFAnalysisModelSaveValidator_10", (String)"macc-faf-opplugin", (Object[])new Object[0]), periodIndex));
        }
        if (accountTypeNess && subjectIndex != null) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u7ef4\u5ea6\u5206\u5f55\uff1a\u6a21\u578b\u5fc5\u8981\u7ef4\u5ea6\u201c\u4f1a\u8ba1\u79d1\u76ee\u201d\u5bf9\u5e94\u7684\u7ef4\u5ea6\u5fc5\u987b\u8bbe\u7f6e\u7c7b\u578b\u5b57\u6bb5\u4e3a\uff1a\u79d1\u76ee\u8868\u3002", (String)"FAFAnalysisModelSaveValidator_11", (String)"macc-faf-opplugin", (Object[])new Object[0]), subjectIndex));
        }
    }

    private void validateSystemSource(ExtendedDataEntity dataEntity) {
        Tuple<ImportSystemSourceTypeEnum, List<Object>> importDimensionInfo = this.getImportDimensionEntryInfo(dataEntity);
        Tuple<ImportSystemSourceTypeEnum, List<Object>> importMeasureInfo = this.getImportMeasureEntryInfo(dataEntity);
        if (importDimensionInfo != null && importMeasureInfo != null && importDimensionInfo.item1 != importMeasureInfo.item1) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u9009\u7ef4\u5ea6/\u5ea6\u91cf\u5bf9\u5e94\u591a\u4e2a\u6765\u6e90\u4f53\u7cfb\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"FAFAnalysisModelSaveValidator_16", (String)"macc-faf-opplugin", (Object[])new Object[0]));
        }
        long importDimensionModelId = 0L;
        long importMeasureModelId = 0L;
        DynamicObjectCollection dimensionMappings = null;
        if (importDimensionInfo != null && !CollectionUtils.isEmpty((Collection)(dimensionMappings = FAFDimensionHelper.queryDimensionMappingByDimensionIds((List)((List)importDimensionInfo.item2), (ImportSystemSourceTypeEnum)((ImportSystemSourceTypeEnum)importDimensionInfo.item1))))) {
            Set dimensionModelIds = dimensionMappings.stream().map(mapping -> mapping.getLong("immodel")).collect(Collectors.toSet());
            if (dimensionModelIds.size() > 1) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u9009\u7ef4\u5ea6/\u5ea6\u91cf\u5bf9\u5e94\u591a\u4e2a\u6765\u6e90\u4f53\u7cfb\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"FAFAnalysisModelSaveValidator_16", (String)"macc-faf-opplugin", (Object[])new Object[0]));
            } else {
                for (Object dimensionModelId : dimensionModelIds) {
                    importDimensionModelId = (Long)dimensionModelId;
                }
            }
        }
        DynamicObjectCollection measureMappings = null;
        if (importMeasureInfo != null && !CollectionUtils.isEmpty((Collection)(measureMappings = FAFMeasureHelper.queryMeasureMappingByMeasureIds((List)((List)importMeasureInfo.item2), (ImportSystemSourceTypeEnum)((ImportSystemSourceTypeEnum)importMeasureInfo.item1))))) {
            Set measureModelIds = measureMappings.stream().map(mapping -> mapping.getLong("immodel")).collect(Collectors.toSet());
            if (measureModelIds.size() > 1) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u9009\u7ef4\u5ea6/\u5ea6\u91cf\u5bf9\u5e94\u591a\u4e2a\u6765\u6e90\u4f53\u7cfb\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"FAFAnalysisModelSaveValidator_16", (String)"macc-faf-opplugin", (Object[])new Object[0]));
            } else {
                for (Long dimensionModelId : measureModelIds) {
                    importMeasureModelId = dimensionModelId;
                }
            }
        }
        if (importDimensionModelId != 0L && importMeasureModelId != 0L && importDimensionModelId != importMeasureModelId) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u9009\u7ef4\u5ea6/\u5ea6\u91cf\u5bf9\u5e94\u591a\u4e2a\u6765\u6e90\u4f53\u7cfb\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"FAFAnalysisModelSaveValidator_16", (String)"macc-faf-opplugin", (Object[])new Object[0]));
        }
        Set<Object> dimensionEntryImportDimensionIdSet = new HashSet(16);
        if (dimensionMappings != null) {
            dimensionEntryImportDimensionIdSet = dimensionMappings.stream().map(mapping -> mapping.getLong("imdimension")).collect(Collectors.toSet());
        }
        Set<Object> measureEntryImportDimensionIdSet = new HashSet(16);
        if (measureMappings != null) {
            measureEntryImportDimensionIdSet = measureMappings.stream().map(mapping -> mapping.getLong("entryimdimension")).collect(Collectors.toSet());
        }
        dimensionEntryImportDimensionIdSet.retainAll(measureEntryImportDimensionIdSet);
        if (dimensionEntryImportDimensionIdSet.size() > 0 && dimensionMappings != null) {
            for (DynamicObject dimensionMapping : dimensionMappings) {
                if (!dimensionEntryImportDimensionIdSet.contains(dimensionMapping.getLong("imdimension"))) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6%s\u4e0d\u5141\u8bb8\u5728\u540c\u4e00\u5206\u6790\u6a21\u578b\u7684\u7ef4\u5ea6\u548c\u5ea6\u91cf\u4e2d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"FAFAnalysisModelSaveValidator_17", (String)"macc-faf-opplugin", (Object[])new Object[0]), dimensionMapping.getString("imdimname")));
            }
        }
    }

    private Tuple<ImportSystemSourceTypeEnum, List<Object>> getImportDimensionEntryInfo(ExtendedDataEntity dataEntity) {
        DynamicObjectCollection dimensionEntry = (DynamicObjectCollection)dataEntity.getValue("dimension_entry");
        ImportSystemSourceTypeEnum existImportDimensionSystemSourceType = null;
        ArrayList<Object> importDimensionIds = new ArrayList<Object>(16);
        for (DynamicObject dynamicObject : dimensionEntry) {
            DynamicObject dimension = dynamicObject.getDynamicObject("dimension");
            ImportSystemSourceTypeEnum dimensionSystemSourceTypeEnum = ImportSystemSourceTypeEnum.getEnumByCode((String)dimension.getString("systemsource"));
            if (dimensionSystemSourceTypeEnum == ImportSystemSourceTypeEnum.NEW) continue;
            if (existImportDimensionSystemSourceType == null) {
                existImportDimensionSystemSourceType = dimensionSystemSourceTypeEnum;
            } else if (dimensionSystemSourceTypeEnum != existImportDimensionSystemSourceType) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u9009\u7ef4\u5ea6/\u5ea6\u91cf\u5bf9\u5e94\u591a\u4e2a\u6765\u6e90\u4f53\u7cfb\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"FAFAnalysisModelSaveValidator_16", (String)"macc-faf-opplugin", (Object[])new Object[0]));
                return null;
            }
            importDimensionIds.add(dimension.getPkValue());
        }
        if (existImportDimensionSystemSourceType != null) {
            return new Tuple(existImportDimensionSystemSourceType, importDimensionIds);
        }
        return null;
    }

    private Tuple<ImportSystemSourceTypeEnum, List<Object>> getImportMeasureEntryInfo(ExtendedDataEntity dataEntity) {
        DynamicObjectCollection measureEntry = (DynamicObjectCollection)dataEntity.getValue("measure_entry");
        ImportSystemSourceTypeEnum existImportMeasureSystemSourceType = null;
        ArrayList<Object> ImportMeasureIds = new ArrayList<Object>(16);
        for (DynamicObject dynamicObject : measureEntry) {
            DynamicObject measure = dynamicObject.getDynamicObject("measure");
            ImportSystemSourceTypeEnum measureSystemSourceTypeEnum = ImportSystemSourceTypeEnum.getEnumByCode((String)measure.getString("systemsource"));
            if (measureSystemSourceTypeEnum == ImportSystemSourceTypeEnum.NEW) continue;
            if (existImportMeasureSystemSourceType == null) {
                existImportMeasureSystemSourceType = measureSystemSourceTypeEnum;
            } else if (measureSystemSourceTypeEnum != existImportMeasureSystemSourceType) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u9009\u7ef4\u5ea6/\u5ea6\u91cf\u5bf9\u5e94\u591a\u4e2a\u6765\u6e90\u4f53\u7cfb\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"FAFAnalysisModelSaveValidator_16", (String)"macc-faf-opplugin", (Object[])new Object[0]));
                return null;
            }
            ImportMeasureIds.add(measure.getPkValue());
        }
        if (existImportMeasureSystemSourceType != null) {
            return new Tuple(existImportMeasureSystemSourceType, ImportMeasureIds);
        }
        return null;
    }
}

