/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.system.validate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.basedataref.BaseDataRefenceKey;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.RequiredValidator;
import kd.bos.entity.validate.ValidateContext;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.macc.faf.enums.FAFDimensionTypeEnum;
import kd.macc.faf.helper.FAFDimensionHelper;

public class FAFDimensionSaveValidator
extends AbstractValidator {
    private static final Set<String> fields = new HashSet<String>();

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            this.validateEntry(dataEntity);
        }
    }

    private void validateEntry(ExtendedDataEntity dataEntity) {
        Long group;
        String value;
        DynamicObject baseData;
        String dimensionType;
        DynamicObject newEntity = dataEntity.getDataEntity();
        Long pkvalue = (Long)dataEntity.getBillPkId();
        if (pkvalue > 0L && BaseDataRefrenceHelper.isRefrenced((String)this.getEntityKey(), (Object)pkvalue)) {
            DynamicObjectCollection entry;
            DynamicObjectCollection oldentry;
            DynamicObject oldEntity;
            boolean valid;
            ArrayList<String> excludeFields = new ArrayList<String>(2);
            List allRefs = BaseDataRefrenceHelper.getAllRefs((String)this.getEntityKey(), (Object)pkvalue);
            if (!CollectionUtils.isEmpty((Collection)allRefs) && allRefs.size() == 1 && "pa_measure".equals(((BaseDataRefenceKey)allRefs.get(0)).getRefEntityKey())) {
                excludeFields.add("group");
            }
            if (!(valid = this.valid(oldEntity = BusinessDataServiceHelper.loadSingle((Object)pkvalue, (DynamicObjectType)dataEntity.getDataEntity().getDynamicObjectType()), newEntity, excludeFields))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7ef4\u5ea6\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u57fa\u672c\u4fe1\u606f\u3002", (String)"FAFDimensionSaveValidator_0", (String)"macc-faf-opplugin", (Object[])new Object[0]));
                return;
            }
            String oldDimensionType = oldEntity.getString("dimensiontype");
            if (FAFDimensionTypeEnum.DATABASE.eqScene((Object)oldDimensionType) || FAFDimensionTypeEnum.ASSISTANTDATA.eqScene((Object)oldDimensionType)) {
                oldentry = oldEntity.getDynamicObjectCollection("dimensionentryentity");
                boolean validentry = this.valid(oldentry, entry = newEntity.getDynamicObjectCollection("dimensionentryentity"));
                if (!validentry) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u7ef4\u5ea6\u5df2\u88ab\u5f15\u7528\uff0c\u5206\u6790\u6a21\u578b\u663e\u793a\u5b57\u6bb5\u5141\u8bb8\u65b0\u589e\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"FAFDimensionSaveValidator_1", (String)"macc-faf-opplugin", (Object[])new Object[0]));
                    return;
                }
            } else if (FAFDimensionTypeEnum.DENUMS.eqScene((Object)oldDimensionType) && FAFDimensionHelper.dimensionAlreadyCreateModeling((Object)pkvalue) && this.isChange(oldentry = oldEntity.getDynamicObjectCollection("entryentityenums"), entry = newEntity.getDynamicObjectCollection("entryentityenums"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7ef4\u5ea6\u5df2\u88ab\u5206\u6790\u6a21\u578b\u5f15\u7528\u5e76\u521b\u5efa\u6570\u636e\u8868\uff0c\u201c\u679a\u4e3e\u503c\u9009\u9879\u8868\u201d\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"FAFDimensionSaveValidator_2", (String)"macc-faf-opplugin", (Object[])new Object[0]));
                return;
            }
        }
        if (FAFDimensionTypeEnum.DATABASE.eqScene((Object)(dimensionType = (String)dataEntity.getValue("dimensiontype"))) && ((baseData = (DynamicObject)dataEntity.getValue("dimensionsource")) == null || EntityMetadataCache.getDataEntityType((String)baseData.getString("id")).getProperties().stream().map(IMetadata::getName).noneMatch("name"::equals))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u56e0\u8be5\u57fa\u7840\u8d44\u6599\u6ca1\u6709name\u5c5e\u6027\uff0c\u6682\u4e0d\u652f\u6301\u914d\u7f6e\u5bf9\u5e94\u7684\u7ef4\u5ea6\u3002", (String)"FAFDimensionSaveValidator_3", (String)"macc-faf-opplugin", (Object[])new Object[0]));
        }
        Object dimensionNumber = dataEntity.getValue("number");
        DynamicObject system = (DynamicObject)dataEntity.getValue("system");
        QFilter qFilter = new QFilter("number", "=", dimensionNumber);
        qFilter.and("system", "=", system.getPkValue());
        boolean numberExists = QueryServiceHelper.exists((String)"pa_measure", (QFilter[])new QFilter[]{qFilter});
        if (numberExists) {
            String message = ResManager.loadKDString((String)"\u7f16\u53f7\u4e0e\u8be5\u4f53\u7cfb\u4e0b\u7684\u5ea6\u91cf\u7f16\u53f7\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"FAFDimensionSaveValidator_4", (String)"macc-faf-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, message);
        }
        if (StringUtils.isNotEmpty((CharSequence)(value = (String)dataEntity.getValue("typefield"))) && ((group = (Long)dataEntity.getValue("group_id")) == null || group == 0L)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u5b57\u6bb5\u503c\u201d\u4e0d\u80fd\u7a7a\u3002", (String)"FAFDimensionSaveValidator_5", (String)"macc-faf-opplugin", (Object[])new Object[0]));
        }
        if (FAFDimensionTypeEnum.DATABASE.eqScene((Object)dimensionType) || FAFDimensionTypeEnum.ASSISTANTDATA.eqScene((Object)dimensionType)) {
            DynamicObjectCollection entryEntity = dataEntity.getDataEntity().getDynamicObjectCollection("dimensionentryentity");
            if (entryEntity.isEmpty()) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5206\u6790\u6a21\u578b\u663e\u793a\u5b57\u6bb5\u201d\u3002", (String)"FAFDimensionSaveValidator_6", (String)"macc-faf-opplugin", (Object[])new Object[0]));
            }
        } else if (FAFDimensionTypeEnum.DENUMS.eqScene((Object)dimensionType)) {
            EntryProp property = (EntryProp)newEntity.getDynamicObjectType().getProperty("entryentityenums");
            RequiredValidator validator = new RequiredValidator((DynamicProperty)property, property.getName(), property.getDisplayName().toString(), property.getValueComparator());
            ArrayList validationMeta = new ArrayList();
            ValidateContext validateContext = new ValidateContext(validationMeta, newEntity.getDataEntityType().getName(), "save", null);
            validator.setValidateContext(validateContext);
            validator.setDataEntities(new ExtendedDataEntity[]{dataEntity});
            validator.validate();
            ValidateResult validateResult = validator.getValidateResult();
            for (OperateErrorInfo info : validateResult.getAllErrorInfo()) {
                this.addErrorMessage(dataEntity, info.getMessage());
            }
        }
    }

    private boolean valid(DynamicObject oldDyn, DynamicObject dyn, List<String> excludeFields) {
        DataEntityPropertyCollection properties = oldDyn.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : properties) {
            boolean equals;
            String propertyName = property.getName().toLowerCase();
            if (!CollectionUtils.isEmpty(excludeFields) && excludeFields.contains(propertyName) || !fields.contains(propertyName) || property instanceof EntryProp || (equals = property instanceof MuliLangTextProp ? Objects.equals(oldDyn.getString(property), dyn.getString(property)) : this.myEquals(oldDyn.get(property), dyn.get(property)))) continue;
            return false;
        }
        return true;
    }

    private boolean myEquals(Object a, Object b) {
        if ("".equals(a) || a == null) {
            return "".equals(b) || b == null;
        }
        return Objects.equals(a, b);
    }

    private boolean valid(DynamicObjectCollection oldcoll, DynamicObjectCollection ncoll) {
        if (oldcoll.size() > ncoll.size()) {
            return false;
        }
        if (ncoll.getDeleteRows().size() > 0) {
            return false;
        }
        Set collect = ncoll.stream().map(dynamicObject -> dynamicObject.getString("fieldnumber")).collect(Collectors.toSet());
        for (DynamicObject o : oldcoll) {
            if (collect.contains(o.getString("fieldnumber"))) continue;
            return false;
        }
        return true;
    }

    private boolean isChange(DynamicObjectCollection oldcoll, DynamicObjectCollection ncoll) {
        if (oldcoll.size() != ncoll.size()) {
            return true;
        }
        if (ncoll.getInsertRows().size() > 0 || ncoll.getDeleteRows().size() > 0) {
            return true;
        }
        DataEntityPropertyCollection properties = oldcoll.getDynamicObjectType().getProperties();
        for (int i = 0; i < oldcoll.size(); ++i) {
            DynamicObject o = (DynamicObject)oldcoll.get(i);
            DynamicObject n = (DynamicObject)ncoll.get(i);
            for (IDataEntityProperty property : properties) {
                if (o.get(property).equals(n.get(property))) continue;
                return true;
            }
        }
        return false;
    }

    static {
        fields.add("number");
        fields.add("system");
        fields.add("dimensiontype");
        fields.add("isdefault");
        fields.add("dimensionsource");
        fields.add("assistantsource");
        fields.add("grouptype");
        fields.add("group");
    }
}

