/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.system.validate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.faf.dto.FAFDynamicEntryDTO;
import kd.macc.faf.enums.DimensionNecessityEnum;
import kd.macc.faf.service.PeriodServiceHelper;
import kd.macc.faf.util.AnalysisModelUtil;

public class FAFImportDataDeleteValidator
extends AbstractValidator {
    public void validate() {
        Map params = this.getOption().getVariables();
        if (params == null || params.isEmpty()) {
            return;
        }
        String analysisModelStr = (String)params.get("analysismodel");
        if (analysisModelStr == null || analysisModelStr.isEmpty()) {
            return;
        }
        ExtendedDataEntity[] dataEntities = this.dataEntities;
        int size = dataEntities.length;
        HashMap<Long, Integer> selectIndexMap = new HashMap<Long, Integer>(size);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            Long rowId = dataEntity.getDataEntity().getLong("id");
            int rowIndex = Integer.parseInt((String)params.get(String.valueOf(rowId)));
            selectIndexMap.put(rowId, rowIndex);
        }
        Long analysisModelId = Long.parseLong(analysisModelStr);
        DynamicObject analysisModelObj = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisModelId, (String)"pa_analysismodel");
        String orgField = null;
        String periodField = null;
        DynamicObjectCollection dimensionCol = analysisModelObj.getDynamicObjectCollection("dimension_entry");
        for (DynamicObject dimensionRow : dimensionCol) {
            String sourceEntity;
            DynamicObject dimensionSource;
            if (StringUtils.isNotEmpty(orgField) && StringUtils.isNotEmpty(periodField)) break;
            DynamicObject dimension = dimensionRow.getDynamicObject("dimension");
            if (dimension == null) continue;
            String field = dimension.getString("number");
            String necessityDim = dimensionRow.getString("necessity_dim");
            if (DimensionNecessityEnum.ORG.getCode().equals(necessityDim)) {
                orgField = field;
                continue;
            }
            if (!DimensionNecessityEnum.PERIOD.getCode().equals(necessityDim) || (dimensionSource = dimension.getDynamicObject("dimensionsource")) == null || !"bd_period".equals(sourceEntity = dimensionSource.getString("number")) && !"pa_analysisperiod".equals(sourceEntity)) continue;
            periodField = field;
        }
        String selectFields = "id,createtime,summaryid";
        ArrayList<Long> orgIdList = null;
        ArrayList<Long> periodIdList = null;
        if (orgField != null && periodField != null) {
            selectFields = "id,createtime,summaryid," + orgField + "," + periodField;
            orgIdList = new ArrayList<Long>(size);
            periodIdList = new ArrayList<Long>(size);
        }
        ArrayList<Integer> rowDataHasDealList = new ArrayList<Integer>(1);
        HashMap<Integer, Object> rowDataHasUsedByAdjustMap = new HashMap<Integer, Object>(1);
        Map<Long, List<Tuple<Date, String>>> adjustData = this.geDataFromAdjust(analysisModelId);
        HashSet<Long> summaryIdSet = new HashSet<Long>(size);
        QFilter idFilter = new QFilter("id", "in", selectIndexMap.keySet());
        String entityNumber = AnalysisModelUtil.buildDetailEntityNumber((String)analysisModelObj.getString("tablenumber"));
        DynamicObjectCollection selectRowCol = QueryServiceHelper.query((String)entityNumber, (String)selectFields, (QFilter[])idFilter.toArray());
        block2: for (DynamicObject selectRowObj : selectRowCol) {
            List<Tuple<Date, String>> tupleList;
            Long currentId = selectRowObj.getLong("id");
            Integer selectRowIndex = (Integer)selectIndexMap.get(currentId);
            if (orgIdList != null) {
                orgIdList.add(selectRowObj.getLong(orgField));
            }
            if (periodIdList != null) {
                periodIdList.add(selectRowObj.getLong(periodField));
            }
            Date selectRowCreateTime = selectRowObj.getDate("createtime");
            Long summaryId = selectRowObj.getLong("summaryid");
            this.appendMsgIfDataProcessed(entityNumber, currentId, summaryId, selectRowCreateTime, selectRowIndex, rowDataHasDealList);
            if (adjustData == null || !summaryIdSet.add(summaryId) || (tupleList = adjustData.get(summaryId)) == null || selectRowCreateTime == null) continue;
            for (Tuple<Date, String> dateAndBillNumberTuple : tupleList) {
                if (!selectRowCreateTime.before((Date)dateAndBillNumberTuple.item1)) continue;
                rowDataHasUsedByAdjustMap.put(selectRowIndex, dateAndBillNumberTuple.item2);
                continue block2;
            }
        }
        if (orgField != null && periodField != null && !PeriodServiceHelper.checkPeriodOrgList((long)analysisModelId, orgIdList, periodIdList, (boolean)true).booleanValue()) {
            if (1 == selectIndexMap.size()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u5904\u4e8e\u5173\u95ed\u72b6\u6001\uff0c\u8bf7\u5230\u3010\u57fa\u7840\u8bbe\u7f6e\u3011-\u3010\u671f\u95f4\u7ba1\u7406\u3011\u6253\u5f00\u671f\u95f4\u3002", (String)"FAFImportDataDeleteValidator_4", (String)"macc-faf-opplugin", (Object[])new Object[0]));
            }
            if (selectIndexMap.size() > 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u6570\u636e\u4e2d\u6709\u5305\u542b\u5904\u4e8e\u5173\u95ed\u72b6\u6001\u7684\u671f\u95f4\uff0c\u8bf7\u5230\u3010\u57fa\u7840\u8bbe\u7f6e\u3011-\u3010\u671f\u95f4\u7ba1\u7406\u3011\u6253\u5f00\u76f8\u5e94\u7684\u671f\u95f4\u3002", (String)"FAFImportDataDeleteValidator_3", (String)"macc-faf-opplugin", (Object[])new Object[0]));
            }
        }
        ArrayList<Integer> successDeleteRowList = new ArrayList<Integer>(1);
        ArrayList<Integer> failureDeleteRowList = new ArrayList<Integer>(1);
        for (Long rowId : selectIndexMap.keySet()) {
            int rowIndex = Integer.parseInt((String)params.get(String.valueOf(rowId)));
            if (rowDataHasDealList.contains(rowIndex) || rowDataHasUsedByAdjustMap.containsKey(rowIndex)) {
                failureDeleteRowList.add(rowIndex);
                continue;
            }
            successDeleteRowList.add(rowIndex);
        }
        if (!successDeleteRowList.isEmpty() && failureDeleteRowList.isEmpty()) {
            return;
        }
        boolean hasSuccessAndFailure = !successDeleteRowList.isEmpty();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            int newRowNumber;
            Long rowId = dataEntity.getDataEntity().getLong("id");
            int rowIndex = Integer.parseInt((String)params.get(String.valueOf(rowId)));
            int n = newRowNumber = hasSuccessAndFailure ? this.getNewRowIndexAfterSuccessDelete(rowIndex, successDeleteRowList) + 1 : rowIndex + 1;
            if (rowDataHasDealList.isEmpty() && rowDataHasUsedByAdjustMap.size() == 1 && rowDataHasUsedByAdjustMap.containsKey(rowIndex)) {
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u6570\u636e\u5df2\u88ab\u4f7f\u7528\uff0c\u5982\u9700\u5220\u9664\uff0c\u8bf7\u5148\u5728\u6570\u636e\u8c03\u6574\u5355%s\u4e2d\u5220\u9664\u8be5\u6570\u636e\u3002", (String)"FAFImportDataDeleteValidator_0", (String)"macc-faf-opplugin", (Object[])new Object[0]), newRowNumber, rowDataHasUsedByAdjustMap.get(rowIndex)));
                break;
            }
            if (rowDataHasDealList.contains(rowIndex)) {
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"%d: \u6570\u636e\u5df2\u88ab\u5904\u7406\u8fc7\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"FAFImportDataDeleteValidator_1", (String)"macc-faf-opplugin", (Object[])new Object[0]), newRowNumber));
                continue;
            }
            if (!rowDataHasUsedByAdjustMap.containsKey(rowIndex)) continue;
            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"%d: \u6570\u636e\u5df2\u88ab\u4f7f\u7528\uff0c\u8bf7\u5148\u5728\u6570\u636e\u8c03\u6574\u5355%s\u4e2d\u5220\u9664\u8be5\u6570\u636e\u3002", (String)"FAFImportDataDeleteValidator_2", (String)"macc-faf-opplugin", (Object[])new Object[0]), newRowNumber, rowDataHasUsedByAdjustMap.get(rowIndex)));
        }
    }

    private Integer getNewRowIndexAfterSuccessDelete(int currentRowIndex, List<Integer> successDeleteRowList) {
        for (Integer successDeleteRowIndex : successDeleteRowList) {
            if (successDeleteRowIndex >= currentRowIndex || currentRowIndex <= 0) continue;
            --currentRowIndex;
        }
        return currentRowIndex;
    }

    private Map<Long, List<Tuple<Date, String>>> geDataFromAdjust(Long analysisModelId) {
        HashMap<Long, List> result = null;
        QFilter dataAdjustModelFilter = new QFilter("analysismodel", "=", (Object)analysisModelId);
        DynamicObjectCollection dataAdjustCol = QueryServiceHelper.query((String)"pa_dataadjust", (String)"id,modifytime,billno,adjustjson_tag", (QFilter[])dataAdjustModelFilter.toArray());
        if (dataAdjustCol != null && !dataAdjustCol.isEmpty()) {
            result = new HashMap<Long, List>(dataAdjustCol.size());
            for (DynamicObject dataAdjust : dataAdjustCol) {
                String adjustJsonTag = dataAdjust.getString("adjustjson_tag");
                String adjustBillNo = dataAdjust.getString("billno");
                Date modifyTime = dataAdjust.getDate("modifytime");
                List entryList = (List)JSON.parseObject((String)adjustJsonTag, (TypeReference)new TypeReference<List<FAFDynamicEntryDTO>>(){}, (Feature[])new Feature[0]);
                for (FAFDynamicEntryDTO dto : entryList) {
                    Object[][] dataArr = dto.getData();
                    if (dataArr == null) continue;
                    for (Object[] objects : dataArr) {
                        String idStrValue = String.valueOf(objects[objects.length - 1]);
                        if (idStrValue == null || idStrValue.length() <= 1) continue;
                        Long summaryId = Long.valueOf(idStrValue);
                        List tupleList = result.computeIfAbsent(summaryId, k -> new ArrayList(1));
                        tupleList.add(Tuple.create((Object)modifyTime, (Object)adjustBillNo));
                    }
                }
            }
        }
        return result;
    }

    private void appendMsgIfDataProcessed(String entityNumber, Long currentId, Long summaryId, Date selectRowCreateTime, Integer selectRowIndex, List<Integer> rowDataHasDealList) {
        QFilter summaryIdFilter = new QFilter("summaryid", "=", (Object)summaryId).and(new QFilter("datastatus", "in", Arrays.asList(-1, -2, -3)));
        DynamicObjectCollection dataCol = QueryServiceHelper.query((String)entityNumber, (String)"id,createtime", (QFilter[])summaryIdFilter.toArray());
        if (dataCol != null && !dataCol.isEmpty()) {
            for (DynamicObject obj : dataCol) {
                Date createTime;
                if (currentId.longValue() == obj.getLong("id") || (createTime = obj.getDate("createtime")) != null && !selectRowCreateTime.before(createTime)) continue;
                rowDataHasDealList.add(selectRowIndex);
            }
        }
    }
}

