/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.system.validate;

import java.util.Objects;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.util.StringUtils;
import kd.macc.faf.datasync.BusinessDynamicObjectFactory;
import kd.macc.faf.enums.DataSourceTypeEnum;
import kd.macc.faf.enums.DimensionSelectTypeEnum;
import kd.macc.faf.enums.ImportSystemSourceTypeEnum;
import kd.macc.faf.enums.SelectTypeEnum;
import kd.macc.faf.helper.FAFAnalysisModelHelper;
import kd.macc.faf.helper.FAFDataSourceConfigHelper;
import kd.macc.faf.model.impl.DataSourceConfigModel;
import kd.macc.faf.olap.driver.bcm.BcmOlapRequestParam;
import kd.macc.faf.olap.driver.epm.EpmOlapRequestParam;

public class FAFSyncDataSchemaSaveValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            this.validateDimensionEntry(dataEntity);
            this.validateMeasureEntry(dataEntity);
            this.validateSystemSource(dataEntity);
        }
    }

    private void validateSystemSource(ExtendedDataEntity dataEntity) {
        ImportSystemSourceTypeEnum dataSourceSystemSourceTypeEnum;
        Long dataSourceModelId;
        DynamicObject dataSource = (DynamicObject)dataEntity.getValue("datasource");
        DataSourceConfigModel dataSourceConfigModel = FAFDataSourceConfigHelper.getDataSource((Long)dataSource.getLong("id"));
        DataSourceTypeEnum dataSourceTypeEnum = dataSourceConfigModel.getDataSourceTypeEnum();
        switch (dataSourceTypeEnum) {
            case BCM: {
                BcmOlapRequestParam bcmOlapRequestParam = (BcmOlapRequestParam)dataSourceConfigModel.getOlapRequestParam();
                dataSourceModelId = bcmOlapRequestParam.getModuleId();
                dataSourceSystemSourceTypeEnum = ImportSystemSourceTypeEnum.BCM;
                break;
            }
            case EPM: {
                EpmOlapRequestParam epmOlapRequestParam = (EpmOlapRequestParam)dataSourceConfigModel.getOlapRequestParam();
                dataSourceModelId = epmOlapRequestParam.getModuleId();
                dataSourceSystemSourceTypeEnum = ImportSystemSourceTypeEnum.EPM;
                break;
            }
            default: {
                return;
            }
        }
        long currentAnaSystemModelId = ((DynamicObject)dataEntity.getValue("analysismodel")).getLong("id");
        Tuple modelSystemSourceInfo = FAFAnalysisModelHelper.getModelSystemSourceInfo((Long)currentAnaSystemModelId);
        if (modelSystemSourceInfo != null) {
            if (dataSourceSystemSourceTypeEnum != modelSystemSourceInfo.item1) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6570\u636e\u6e90\u548c\u5206\u6790\u6a21\u578b\u4e2d\u7684\u7ef4\u5ea6/\u5ea6\u91cf\u7684\u5bfc\u5165\u6765\u6e90\u7cfb\u7edf\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"FAFSyncDataSchemaSaveValidator_10", (String)"macc-faf-opplugin", (Object[])new Object[0]));
            }
            if (dataSourceModelId != 0L && (Long)modelSystemSourceInfo.item2 != 0L && !dataSourceModelId.equals(modelSystemSourceInfo.item2)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6570\u636e\u6e90\u548c\u5206\u6790\u6a21\u578b\u4e2d\u7684\u7ef4\u5ea6/\u5ea6\u91cf\u7684\u5bfc\u5165\u6765\u6e90\u4f53\u7cfb\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"FAFSyncDataSchemaSaveValidator_11", (String)"macc-faf-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private void validateMeasureEntry(ExtendedDataEntity dataEntity) {
        DynamicObjectCollection entityEntry = (DynamicObjectCollection)dataEntity.getValue("measuremapentry");
        if (entityEntry == null || entityEntry.isEmpty()) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5ea6\u91cf\u6620\u5c04\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bf7\u5f55\u5165\u3002", (String)"FAFSyncDataSchemaSaveValidator_0", (String)"macc-faf-opplugin", (Object[])new Object[0]));
        } else {
            int index = 0;
            int emptyCount = 0;
            for (DynamicObject row : entityEntry) {
                String selectType = row.getString("selecttype");
                ++index;
                if (StringUtils.isEmpty((String)selectType)) {
                    ++emptyCount;
                    continue;
                }
                SelectTypeEnum selectTypeEnum = SelectTypeEnum.getEnum((String)selectType);
                String mappingStr = "";
                String mesage = "";
                switch (selectTypeEnum) {
                    case MEASUREFIELD: {
                        mappingStr = row.getString("measurefield");
                        mesage = String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u5ea6\u91cf\u6620\u5c04\uff1a\u6570\u636e\u6e90\u5ea6\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5f55\u5165\u3002", (String)"FAFSyncDataSchemaSaveValidator_1", (String)"macc-faf-opplugin", (Object[])new Object[0]), index);
                        break;
                    }
                    case CONSTANT: {
                        mappingStr = row.getString("measuredefaultvalue");
                        mesage = String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u5ea6\u91cf\u6620\u5c04\uff1a\u5e38\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5f55\u5165\u3002", (String)"FAFSyncDataSchemaSaveValidator_2", (String)"macc-faf-opplugin", (Object[])new Object[0]), index);
                        break;
                    }
                    case CONDITION: {
                        mappingStr = row.getString("condition_tag");
                        mesage = String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u5ea6\u91cf\u6620\u5c04\uff1a\u6761\u4ef6\u53d6\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5f55\u5165\u3002", (String)"FAFSyncDataSchemaSaveValidator_3", (String)"macc-faf-opplugin", (Object[])new Object[0]), index);
                        break;
                    }
                    case DIMMEASUREFIELD: {
                        mappingStr = row.getString("dimmeasurefield");
                        mesage = String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u5ea6\u91cf\u6620\u5c04\uff1a\u6570\u636e\u6e90\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5f55\u5165\u3002", (String)"FAFSyncDataSchemaSaveValidator_13", (String)"macc-faf-opplugin", (Object[])new Object[0]), index);
                        break;
                    }
                }
                if (!StringUtils.isEmpty((String)mappingStr)) continue;
                this.addErrorMessage(dataEntity, mesage);
            }
            if (emptyCount == index) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5ea6\u91cf\u6620\u5c04\u5206\u5f55\uff1a\u6570\u636e\u6e90\u5ea6\u91cf\u3001\u5e38\u91cf\u3001\u6761\u4ef6\u53d6\u503c\u4e0d\u80fd\u5168\u90e8\u4e3a\u7a7a\uff0c\u8bf7\u5f55\u5165\u3002", (String)"FAFSyncDataSchemaSaveValidator_4", (String)"macc-faf-opplugin", (Object[])new Object[0]));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void validateDimensionEntry(ExtendedDataEntity dataEntity) {
        block12: {
            block11: {
                entityEntry = (DynamicObjectCollection)dataEntity.getValue("dimensionmapentry");
                if (entityEntry != null && !entityEntry.isEmpty()) break block11;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7ef4\u5ea6\u6620\u5c04\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bf7\u5f55\u5165\u3002", (String)"FAFSyncDataSchemaSaveValidator_7", (String)"macc-faf-opplugin", (Object[])new Object[0]));
                break block12;
            }
            modelPkvalue = ((DynamicObject)dataEntity.getValue("analysismodel")).getLong("id");
            syncModel = BusinessDynamicObjectFactory.createDataSyncModel((Object)modelPkvalue);
            dataSource = (DynamicObject)dataEntity.getValue("datasource");
            dataSourceTypeEnum = DataSourceTypeEnum.getEnum((String)dataSource.getString("datasource_type"));
            rowIndex = 1;
            for (DynamicObject row : entityEntry) {
                block14: {
                    block13: {
                        dimension = row.getDynamicObject("dimension");
                        dimensionSelectType = row.getString("dimensionselecttype");
                        dimPk = dimension.get("id");
                        if (!Objects.equals(dimPk, syncModel.getOrgField().get("id")) && !Objects.equals(dimPk, syncModel.getPeriodField().get("id"))) break block13;
                        switch (1.$SwitchMap$kd$macc$faf$enums$DataSourceTypeEnum[dataSourceTypeEnum.ordinal()]) {
                            case 1: 
                            case 2: {
                                if (StringUtils.isEmpty((String)row.getString("dimensionfield")) && row.getString("mappingrelationship") == null) {
                                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6620\u5c04\u5206\u5f55\uff1a%s\u7684\u6570\u636e\u6e90\u7ef4\u5ea6\u548c\u6620\u5c04\u5173\u7cfb\u4e0d\u5141\u8bb8\u5168\u4e3a\u7a7a\u3002", (String)"FAFSyncDataSchemaSaveValidator_12", (String)"macc-faf-opplugin", (Object[])new Object[0]), new Object[]{dimension.getString("name")}));
                                    break;
                                }
                                break block14;
                            }
                            case 3: {
                                if (!DimensionSelectTypeEnum.SOURCE_DIMENSION.getCode().equals(dimensionSelectType)) ** GOTO lbl28
                                if (StringUtils.isEmpty((String)row.getString("dimensionfield"))) {
                                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6620\u5c04\u5206\u5f55\uff1a%s\u7684\u6570\u636e\u6e90\u7ef4\u5ea6\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"FAFSyncDataSchemaSaveValidator_5", (String)"macc-faf-opplugin", (Object[])new Object[0]), new Object[]{dimension.getString("name")}));
                                    break;
                                }
                                break block14;
lbl28:
                                // 1 sources

                                if (!DimensionSelectTypeEnum.MAPPING.getCode().equals(dimensionSelectType)) ** GOTO lbl34
                                object = row.get("mappingrelationship");
                                if (object == null) {
                                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6620\u5c04\u5206\u5f55\uff1a%s\u7684\u6620\u5c04\u5173\u7cfb\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"FAFSyncDataSchemaSaveValidator_15", (String)"macc-faf-opplugin", (Object[])new Object[0]), new Object[]{dimension.getString("name")}));
                                    break;
                                }
                                break block14;
lbl34:
                                // 1 sources

                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6620\u5c04\u5206\u5f55\uff1a%s\u7684\u6570\u636e\u6e90\u7ef4\u5ea6\u4e0d\u652f\u6301\u5f53\u524d\u53d6\u503c\u7c7b\u578b\u3002", (String)"FAFSyncDataSchemaSaveValidator_16", (String)"macc-faf-opplugin", (Object[])new Object[0]), new Object[]{dimension.getString("name")}));
                                break;
                            }
                            case 4: {
                                if (Objects.equals(dimPk, syncModel.getPeriodField().get("id"))) break;
                            }
                            default: {
                                if (StringUtils.isEmpty((String)row.getString("dimensionfield"))) {
                                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6620\u5c04\u5206\u5f55\uff1a%s\u7684\u6570\u636e\u6e90\u7ef4\u5ea6\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"FAFSyncDataSchemaSaveValidator_5", (String)"macc-faf-opplugin", (Object[])new Object[0]), new Object[]{dimension.getString("name")}));
                                    break;
                                }
                                break block14;
                            }
                        }
                        break block14;
                    }
                    if (StringUtils.isNotEmpty((String)dimensionSelectType) && DimensionSelectTypeEnum.getEnumByCode((String)dimensionSelectType) == DimensionSelectTypeEnum.MAPPING && row.getDynamicObject("mappingrelationship") == null) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u7ef4\u5ea6\u6620\u5c04\u5206\u5f55\uff1a\u6620\u5c04\u5173\u7cfb\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FAFSyncDataSchemaSaveValidator_18", (String)"macc-faf-opplugin", (Object[])new Object[0]), new Object[]{rowIndex}));
                    }
                }
                ++rowIndex;
            }
        }
    }
}

