/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.common;

import java.time.LocalDate;
import java.util.AbstractMap;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.SubEntryType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.macc.faf.fas.dto.FAFDateRange;

public class FAFUtils {
    public static <T> T cast(Object object) {
        return (T)object;
    }

    public static boolean idNotNull(Object pkvalue) {
        return !FAFUtils.idIsNull(pkvalue);
    }

    public static boolean idIsNull(Object pkvalue) {
        if (pkvalue instanceof Integer) {
            pkvalue = (long)((Integer)pkvalue).intValue();
        }
        return pkvalue == null || Objects.equals(pkvalue, 0L);
    }

    public static Long toLongPkvalue(Object pkvalue) {
        if (pkvalue instanceof Long) {
            return (Long)pkvalue;
        }
        if (pkvalue instanceof Integer) {
            return (long)((Integer)pkvalue);
        }
        if (pkvalue == null) {
            return 0L;
        }
        return Long.valueOf(String.valueOf(pkvalue));
    }

    public static QFilter timeSection(String property, FAFDateRange dateRange) {
        LocalDate startDate = dateRange.getStartLocalDate();
        LocalDate endDate = dateRange.getEndLocalDate();
        if (endDate == null) {
            if (startDate == null) {
                return null;
            }
            return QFilter.of((String)(property + " >= ?"), (Object[])new Object[]{startDate});
        }
        if (startDate == null) {
            return QFilter.of((String)(property + " <= ?"), (Object[])new Object[]{endDate.plusDays(1L)});
        }
        return QFilter.of((String)(property + " >= ? and " + property + " < ?"), (Object[])new Object[]{startDate, endDate.plusDays(1L)});
    }

    public static String bigTextField(String fieldName) {
        return fieldName + "_tag";
    }

    public static <T> T safeGet(DynamicObject dynamicObject, String propertyName) {
        if (dynamicObject == null) {
            return null;
        }
        Object o = dynamicObject.get(propertyName);
        if (o == null || o instanceof String && StringUtils.isEmpty((CharSequence)((CharSequence)o))) {
            DynamicProperty property = dynamicObject.getDynamicObjectType().getProperty(propertyName);
            String name = property == null ? propertyName : property.getDisplayName().toString();
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e0d\u80fd\u4e3a\u7a7a.", (String)"FAFUtils_0", (String)"macc-faf-common", (Object[])new Object[0]), name));
        }
        return FAFUtils.cast(o);
    }

    public static <T> T safeGet(DynamicObject dynamicObject, String propertyName, T defaultV) {
        if (dynamicObject == null) {
            return defaultV;
        }
        return FAFUtils.cast(dynamicObject.get(propertyName));
    }

    public static Map<String, Map<Long, Long>> convert(Map<String, Map<Long, Long>> linkMap) {
        if (linkMap == null) {
            return null;
        }
        HashMap<String, Map<Long, Long>> map = new HashMap<String, Map<Long, Long>>(linkMap.size());
        Set<Map.Entry<String, Map<Long, Long>>> entries = linkMap.entrySet();
        for (Map.Entry<String, Map<Long, Long>> entry : entries) {
            map.put(entry.getKey(), FAFUtils.rotate(entry.getValue()));
        }
        return map;
    }

    public static Map<Long, Long> rotate(Map<Long, Long> map) {
        HashMap<Long, Long> rotate = new HashMap<Long, Long>(map.size());
        Set<Map.Entry<Long, Long>> entries = map.entrySet();
        for (Map.Entry<Long, Long> entry : entries) {
            rotate.put(entry.getValue(), entry.getKey());
        }
        return rotate;
    }

    public static AbstractMap.SimpleEntry<String, String> getPathPropertyName(IDataEntityProperty property) {
        if (property.getParent() instanceof SubEntryType) {
            SubEntryType parent = (SubEntryType)property.getParent();
            EntryType parentParent = (EntryType)parent.getParent();
            String subEntryPropertyName = parentParent.getName() + "." + parent.getName() + "." + property.getName();
            String subEntryPropertyDisplayName = parentParent.getDisplayName() + "." + parent.getDisplayName() + "." + property.getDisplayName();
            return new AbstractMap.SimpleEntry<String, String>(subEntryPropertyName, subEntryPropertyDisplayName);
        }
        if (property.getParent() instanceof EntryType) {
            EntryType parent = (EntryType)property.getParent();
            String entryPropertyName = parent.getName() + "." + property.getName();
            String entryPropertyDisplayName = parent.getDisplayName() + "." + property.getDisplayName();
            return new AbstractMap.SimpleEntry<String, String>(entryPropertyName, entryPropertyDisplayName);
        }
        return new AbstractMap.SimpleEntry<String, String>(property.getName(), property.getDisplayName() + "");
    }

    public static String calcDurationText(Date startTime, Date endTime) {
        long seconds;
        long minutes;
        StringBuilder sb = new StringBuilder();
        long milliseconds = endTime.getTime() - startTime.getTime();
        long hours = milliseconds / 3600000L;
        if (hours > 0L) {
            sb.append(String.format(ResManager.loadKDString((String)"%s\u65f6", (String)"FAFUtils_1", (String)"macc-faf-common", (Object[])new Object[0]), hours));
        }
        if ((minutes = (milliseconds %= 3600000L) / 60000L) > 0L) {
            sb.append(String.format(ResManager.loadKDString((String)"%s\u5206", (String)"FAFUtils_2", (String)"macc-faf-common", (Object[])new Object[0]), minutes));
        }
        if ((seconds = (milliseconds %= 60000L) / 1000L) > 0L) {
            sb.append(String.format(ResManager.loadKDString((String)"%s\u79d2", (String)"FAFUtils_3", (String)"macc-faf-common", (Object[])new Object[0]), seconds));
        }
        sb.append(String.format(ResManager.loadKDString((String)"%s\u6beb\u79d2", (String)"FAFUtils_4", (String)"macc-faf-common", (Object[])new Object[0]), milliseconds %= 1000L));
        return sb.toString();
    }
}

