/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.common;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.AppMetadataCache;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.LogFactory;
import kd.bos.service.ServiceFactory;

public class OpLogProxy
extends AppLogInfo {
    private static final long serialVersionUID = 6094075245522271172L;
    private static final String APP_ID = AppMetadataCache.getAppInfo((String)"faf").getId();
    private String opKey;
    private MultiLangEnumBridge opNameBridge;
    private MultiLangEnumBridge descBridge;
    private String[] opDescArgs;

    public OpLogProxy(String formid) {
        this.setBizObjID(formid);
    }

    public static OpLogProxy create(String formid) {
        return new OpLogProxy(formid);
    }

    public String getKeyWord() {
        return this.modifyBillNo;
    }

    public OpLogProxy setKeyWord(String keyWord) {
        this.modifyBillNo = keyWord;
        return this;
    }

    public OpLogProxy setOpName(String opKey, String opName) {
        this.opKey = opKey;
        this.opName = opName;
        return this;
    }

    public OpLogProxy setOpName(String opKey, MultiLangEnumBridge opNameBridge) {
        this.opKey = opKey;
        this.opNameBridge = opNameBridge;
        if (opNameBridge != null) {
            this.opName = opNameBridge.loadKDString();
        }
        return this;
    }

    public OpLogProxy setOpDesc(MultiLangEnumBridge descBridge, String ... args) {
        this.descBridge = descBridge;
        if (args != null) {
            this.opDescArgs = args;
        }
        if (descBridge != null) {
            this.opDescription = String.format(descBridge.loadKDString(), args);
        }
        return this;
    }

    public AppLogInfo createLog() {
        OpLogAppInfo logInfo = new OpLogAppInfo();
        RequestContext context = RequestContext.get();
        logInfo.setUserID(Long.valueOf(context.getCurrUserId()));
        logInfo.setOrgID(Long.valueOf(context.getOrgId()));
        logInfo.setClientIP(context.getLoginIP());
        logInfo.setClientType(context.getClient());
        logInfo.setBizAppID(APP_ID);
        logInfo.setBizObjID(this.bizObjID);
        logInfo.setOpTime(new Date());
        if (this.opName != null) {
            logInfo.setOpName(this.opKey, this.opName);
        }
        if (this.opNameBridge != null) {
            logInfo.setOpName(this.opKey, this.opNameBridge);
        }
        if (this.descBridge != null) {
            logInfo.setOpDesc(this.descBridge, this.opDescArgs);
        }
        logInfo.setKeyWord(this.getKeyWord());
        return logInfo;
    }

    public void saveLog() {
        try {
            ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
            logService.addLog(this.createLog());
        }
        catch (Exception ex) {
            LogFactory.getLog(OpLogProxy.class).error("[faf]log", (Throwable)ex);
        }
    }
}

