/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.designer;

import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IBasedataField;
import kd.macc.faf.util.IDataValueUtil;

public class FAFEntityMetadata {
    private final Map<String, RefFieldProp> refFieldPropMap = new LinkedHashMap<String, RefFieldProp>();
    private final Map<String, RefFieldProp> refBaseFieldPropMap = new LinkedHashMap<String, RefFieldProp>();

    public FAFEntityMetadata(String entityNumber) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        this.parseRefFieldPropMap((IDataEntityType)dataEntityType, "", "");
    }

    private void parseRefFieldPropMap(IDataEntityType dt, String prefixName, String prefixDisplayName) {
        DataEntityPropertyCollection properties = dt.getProperties();
        for (IDataEntityProperty property : properties) {
            String name = property.getName();
            if ("_lk".endsWith(name) || "_id".endsWith(name)) continue;
            if (property instanceof IBasedataField) {
                this.parseRefFieldPropMap(((IBasedataField)property).getComplexType(), FAFEntityMetadata.append(prefixName, property.getName()), FAFEntityMetadata.append(prefixDisplayName, property.getDisplayName().toString()));
                this.refBaseFieldPropMap.put(FAFEntityMetadata.append(prefixName, property.getName()), new RefFieldProp(property, prefixName, prefixDisplayName));
                continue;
            }
            if (property instanceof EntryProp) {
                this.parseRefFieldPropMap(((EntryProp)property).getItemType(), FAFEntityMetadata.append(prefixName, property.getName()), FAFEntityMetadata.append(prefixDisplayName, property.getDisplayName().toString()));
                continue;
            }
            if (StringUtils.isBlank((CharSequence)property.getAlias())) continue;
            this.refFieldPropMap.put(FAFEntityMetadata.append(prefixName, name), new RefFieldProp(property, prefixName, prefixDisplayName));
        }
        RefFieldProp idRefFieldProp = new RefFieldProp(FAFEntityMetadata.append(prefixName, dt.getPrimaryKey().getName()), FAFEntityMetadata.append(prefixDisplayName, ResManager.loadKDString((String)"\u5185\u7801", (String)"FAFEntityMetadata_0", (String)"macc-faf-common", (Object[])new Object[0])), IDataValueUtil.getDataType((IDataEntityProperty)dt.getPrimaryKey()).getCodeString());
        this.refFieldPropMap.put(idRefFieldProp.getName(), idRefFieldProp);
    }

    public RefFieldProp getRefFieldProp(String fieldKey) {
        String prefixName;
        RefFieldProp basedataProp;
        RefFieldProp refFieldProp = this.refFieldPropMap.get(fieldKey);
        if (refFieldProp == null && fieldKey.contains(".") && (basedataProp = this.refBaseFieldPropMap.get(prefixName = fieldKey.substring(0, fieldKey.lastIndexOf(".")))) != null) {
            IDataEntityProperty prop = basedataProp.getRefProp();
            String endName = fieldKey.substring(fieldKey.lastIndexOf(".") + 1);
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)((IBasedataField)prop).getBaseEntityId());
            DynamicProperty typeProperty = dataEntityType.getProperty(endName);
            return new RefFieldProp((IDataEntityProperty)typeProperty, basedataProp.getName(), basedataProp.getDisplayName());
        }
        return refFieldProp;
    }

    private static String append(String prefix, String field) {
        if (prefix != null && prefix.length() > 0) {
            field = prefix + "." + field;
        }
        return field;
    }

    public static class RefFieldProp {
        IDataEntityProperty refProp;
        private final String name;
        private final String displayName;
        private final String type;

        public RefFieldProp(IDataEntityProperty refProp, String prefixName, String prefixDisplayName) {
            this.refProp = refProp;
            this.name = FAFEntityMetadata.append(prefixName, refProp.getName());
            LocaleString displayName = refProp.getDisplayName();
            this.displayName = FAFEntityMetadata.append(prefixDisplayName, displayName == null ? "" : displayName.toString());
            this.type = IDataValueUtil.getDataType(refProp).getCodeString();
        }

        public RefFieldProp(String name, String displayName, String type) {
            this.name = name;
            this.displayName = displayName;
            this.type = type;
        }

        public IDataEntityProperty getRefProp() {
            return this.refProp;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getType() {
            return this.type;
        }
    }
}

