/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.dto;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.faf.bservice.check.DataCheckRuleExecParams;
import kd.macc.faf.enums.AnalysisPeriodEnum;
import kd.macc.faf.enums.DateRangeEnum;
import kd.macc.faf.enums.DimensionNecessityEnum;
import kd.macc.faf.enums.TimeTypeEnum;
import kd.macc.faf.helper.FAFAnalysisModelHelper;
import kd.macc.faf.management.enums.TaskExecTypeEnum;
import kd.macc.faf.util.DateUtil;

public class DataExtractingDTO
implements Serializable {
    private static final long serialVersionUID = -5283703363117606552L;
    private Set<Long> orgIdSet;
    private String timeType;
    private Date startDate;
    private Date endDate;
    private String periodBaseData;
    private Set<Long> periodIdSet;
    private String orgDimNumber;
    private String periodDimNumber;
    private boolean force;
    private String batchNo;
    private String taskExecType = TaskExecTypeEnum.MANUAL.getCode();

    public DataExtractingDTO() {
    }

    public DataExtractingDTO(Set<Long> orgIdSet, String timeType, Date startDate, Date endDate, String periodBaseData, Set<Long> periodIdSet, String orgDimNumber, String periodDimNumber) {
        this.orgIdSet = orgIdSet;
        this.timeType = timeType;
        this.startDate = startDate;
        this.endDate = endDate;
        this.periodBaseData = periodBaseData;
        this.periodIdSet = periodIdSet;
        this.orgDimNumber = orgDimNumber;
        this.periodDimNumber = periodDimNumber;
    }

    public static DataExtractingDTO parseSyncDataParam(DynamicObject syncParamDynamicObject) {
        DynamicObjectCollection orgColDy = syncParamDynamicObject.getDynamicObjectCollection("org");
        Set<Long> orgIdSet = orgColDy.stream().map(dy -> dy.getLong("fbasedataid.id")).collect(Collectors.toSet());
        String orgDimNumber = null;
        String periodNumber = null;
        Long modelId = syncParamDynamicObject.getLong("model.id");
        DynamicObject model = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"pa_analysismodel");
        for (DynamicObject dim : model.getDynamicObjectCollection("dimension_entry")) {
            if (DimensionNecessityEnum.ORG.getCode().equals(dim.get("necessity_dim"))) {
                orgDimNumber = dim.getDynamicObject("dimension").getString("number");
                continue;
            }
            if (!DimensionNecessityEnum.PERIOD.getCode().equals(dim.get("necessity_dim"))) continue;
            periodNumber = dim.getDynamicObject("dimension").getString("number");
        }
        String periodBaseData = null;
        HashSet<Long> periodIdSet = new HashSet<Long>(4);
        Date startDate = null;
        Date endDate = null;
        String timeType = syncParamDynamicObject.getString("timetype");
        TimeTypeEnum timeTypeEnum = TimeTypeEnum.getTimeTypeEnum(timeType);
        switch (timeTypeEnum) {
            case PERIOD: {
                periodBaseData = syncParamDynamicObject.getString("periodbasedata");
                if (StringUtils.equals((CharSequence)"pa_analysisperiod", (CharSequence)periodBaseData)) {
                    QFilter analysisPeriodFilter = DataExtractingDTO.getAnalysisPeriodQFilter(syncParamDynamicObject);
                    QFilter analysisAdjustFilter = new QFilter("isadjust", "=", (Object)"0");
                    QFilter analysisEnableFilter = new QFilter("enable", "=", (Object)"1");
                    DynamicObject analysisPeriodDy = BusinessDataServiceHelper.loadSingleFromCache((String)"pa_analysisperiod", (QFilter[])new QFilter[]{analysisPeriodFilter, analysisEnableFilter, analysisAdjustFilter});
                    if (analysisPeriodDy != null) {
                        periodIdSet.add(analysisPeriodDy.getLong("id"));
                    }
                }
                if (!StringUtils.equals((CharSequence)"bd_period", (CharSequence)periodBaseData)) break;
                DynamicObject analysisModel = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"pa_analysismodel");
                QFilter periodTypeQFilter = FAFAnalysisModelHelper.getBaseQFilter(analysisModel, DimensionNecessityEnum.PERIOD.getCode());
                DynamicObject periodTypeObj = QueryServiceHelper.queryOne((String)"bd_period", (String)"periodtype", (QFilter[])periodTypeQFilter.toArray());
                Long periodTypeId = periodTypeObj.getLong("periodtype");
                QFilter accountPeriodTypeFilter = new QFilter("periodtype", "=", (Object)periodTypeId);
                QFilter accountPeriodQFilter = DataExtractingDTO.getAccountPeriodQFilter(syncParamDynamicObject);
                QFilter accountAdjustFilter = new QFilter("isadjustperiod", "=", (Object)"0");
                DynamicObject accountPeriodDy = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])new QFilter[]{accountPeriodTypeFilter, accountPeriodQFilter, accountAdjustFilter});
                if (accountPeriodDy == null) break;
                periodIdSet.add(accountPeriodDy.getLong("id"));
                break;
            }
            case DATE: {
                Date[] dates = DataExtractingDTO.getDateRange(syncParamDynamicObject);
                startDate = dates[0];
                endDate = dates[1];
                break;
            }
        }
        DataExtractingDTO dataExtractingDTO = new DataExtractingDTO();
        dataExtractingDTO.setOrgIdSet(orgIdSet);
        dataExtractingDTO.setTimeType(timeType);
        dataExtractingDTO.setPeriodBaseData(periodBaseData);
        dataExtractingDTO.setPeriodIdSet(periodIdSet);
        dataExtractingDTO.setStartDate(startDate);
        dataExtractingDTO.setEndDate(endDate);
        dataExtractingDTO.setOrgDimNumber(orgDimNumber);
        dataExtractingDTO.setPeriodDimNumber(periodNumber);
        dataExtractingDTO.setTaskExecType(TaskExecTypeEnum.AUTO.getCode());
        return dataExtractingDTO;
    }

    public static Date[] getDateRange(DynamicObject syncParamDynamicObject) {
        String dateRange = syncParamDynamicObject.getString("daterange");
        int count = syncParamDynamicObject.getInt("count");
        Date rangeStartDate = syncParamDynamicObject.getDate("range_startdate");
        Date rangeEndDate = syncParamDynamicObject.getDate("range_enddate");
        Date date = syncParamDynamicObject.getDate("date");
        Date startDate = null;
        Date endDate = null;
        DateRangeEnum dateRangeEnum = DateRangeEnum.getDateRangeEnum(dateRange);
        switch (dateRangeEnum) {
            case OTHER_DAYS: {
                if (count == 0) {
                    startDate = DateUtil.getCurrentDate();
                    endDate = DateUtil.getNextDay(DateUtil.getCurrentDate(), 1);
                    break;
                }
                startDate = DateUtil.getLastDay(DateUtil.getCurrentDate(), count);
                endDate = DateUtil.getCurrentDate();
                break;
            }
            case FEW_DAYS_AGO: {
                if (count == 0) {
                    endDate = DateUtil.getNextDay(DateUtil.getCurrentDate(), 1);
                    break;
                }
                endDate = DateUtil.getLastDay(DateUtil.getCurrentDate(), count - 1);
                break;
            }
            case SOME_DAYS: {
                startDate = rangeStartDate;
                endDate = DateUtil.getNextDay(rangeEndDate, 1);
                break;
            }
            case EQUAL_DAY: {
                startDate = date;
                endDate = DateUtil.getNextDay(date, 1);
                break;
            }
            case LARGE_DAY: {
                startDate = DateUtil.getNextDay(date, 1);
                break;
            }
            case LESS_DAY: {
                endDate = date;
                break;
            }
        }
        return new Date[]{startDate, endDate};
    }

    public static boolean existAnalysisPeriodType() {
        return MetadataServiceHelper.getDataEntityType((String)"pa_syncdataparam").getProperties().stream().anyMatch(iDataEntityProperty -> "analysisperiodtype".equals(iDataEntityProperty.getName()));
    }

    public static QFilter getAnalysisPeriodQFilter(DynamicObject syncParamDynamicObject) {
        if (!DataExtractingDTO.existAnalysisPeriodType()) {
            return null;
        }
        String analysisPeriod = syncParamDynamicObject.getString("analysisperiodtype");
        if (StringUtils.isEmpty((CharSequence)analysisPeriod)) {
            return null;
        }
        int year = 0;
        int quarter = 0;
        int month = 0;
        Date curDate = DateUtil.getCurrentDate();
        AnalysisPeriodEnum analysisPeriodEnum = AnalysisPeriodEnum.getAnalysisPeriodEnum(analysisPeriod);
        switch (analysisPeriodEnum) {
            case CUR_MONTH: {
                year = DateUtil.getYear(curDate);
                quarter = DateUtil.getQuarter(curDate);
                month = DateUtil.getMonth(curDate);
                break;
            }
            case LAST_MONTH: {
                Date lastMonthDate = DateUtil.getLastMonth(curDate, 1);
                year = DateUtil.getYear(lastMonthDate);
                quarter = DateUtil.getQuarter(lastMonthDate);
                month = DateUtil.getMonth(lastMonthDate);
                break;
            }
            case CUR_QUARTER: {
                year = DateUtil.getYear(curDate);
                quarter = DateUtil.getQuarter(curDate);
                break;
            }
            case LAST_QUARTER: {
                Date lastQuarterDate = DateUtil.getLastQuarter(curDate, 1);
                year = DateUtil.getYear(lastQuarterDate);
                quarter = DateUtil.getQuarter(lastQuarterDate);
                break;
            }
            case CUR_YEAR: {
                year = DateUtil.getYear(curDate);
                break;
            }
            case LAST_YEAR: {
                Date lastYearDate = DateUtil.getLastYear(curDate, 1);
                year = DateUtil.getYear(lastYearDate);
                break;
            }
        }
        return new QFilter("year", "=", (Object)year).and("quarter", "=", (Object)quarter).and("month", "=", (Object)month);
    }

    public static QFilter getAccountPeriodQFilter(DynamicObject syncParamDynamicObject) {
        String offSet = syncParamDynamicObject.getString("periodoffset");
        if (StringUtils.isEmpty((CharSequence)offSet)) {
            return null;
        }
        Date curDate = DateUtil.getCurrentDate();
        Date lastMonthDate = DateUtil.getLastMonth(curDate, Integer.parseInt(offSet));
        int year = DateUtil.getYear(lastMonthDate);
        int quarter = DateUtil.getQuarter(lastMonthDate);
        int month = DateUtil.getMonth(lastMonthDate);
        return new QFilter("periodyear", "=", (Object)year).and("periodquarter", "=", (Object)quarter).and("periodnumber", "=", (Object)month);
    }

    public Long[] getOrgIds() {
        return this.orgIdSet.toArray(new Long[0]);
    }

    public Long[] getPeriodIds() {
        TimeTypeEnum timeTypeEnum = TimeTypeEnum.getTimeTypeEnum(this.timeType);
        switch (timeTypeEnum) {
            case PERIOD: {
                return this.periodIdSet.toArray(new Long[0]);
            }
        }
        return new Long[0];
    }

    public QFilter getOrgQFilter(String orgField) {
        return new QFilter(orgField, "in", this.orgIdSet);
    }

    public QFilter getPeriodQFilter(String periodField) {
        QFilter periodFilter = null;
        TimeTypeEnum timeTypeEnum = TimeTypeEnum.getTimeTypeEnum(this.timeType);
        switch (timeTypeEnum) {
            case PERIOD: {
                periodFilter = new QFilter(periodField, "in", this.periodIdSet);
                break;
            }
            case DATE: {
                if (this.startDate != null && this.endDate != null) {
                    periodFilter = new QFilter(periodField, ">=", (Object)this.startDate).and(new QFilter(periodField, "<", (Object)this.endDate));
                    break;
                }
                if (this.startDate != null) {
                    periodFilter = new QFilter(periodField, ">=", (Object)this.startDate);
                    break;
                }
                if (this.endDate == null) break;
                periodFilter = new QFilter(periodField, "<", (Object)this.endDate);
                break;
            }
        }
        return periodFilter;
    }

    public Set<Long> getOrgIdSet() {
        return this.orgIdSet;
    }

    public void setOrgIdSet(Set<Long> orgIdSet) {
        this.orgIdSet = orgIdSet;
    }

    public String getTimeType() {
        return this.timeType;
    }

    public void setTimeType(String timeType) {
        this.timeType = timeType;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public String getPeriodBaseData() {
        return this.periodBaseData;
    }

    public void setPeriodBaseData(String periodBaseData) {
        this.periodBaseData = periodBaseData;
    }

    public Set<Long> getPeriodIdSet() {
        return this.periodIdSet;
    }

    public void setPeriodIdSet(Set<Long> periodIdSet) {
        this.periodIdSet = periodIdSet;
    }

    public String getOrgDimNumber() {
        return this.orgDimNumber;
    }

    public void setOrgDimNumber(String orgDimNumber) {
        this.orgDimNumber = orgDimNumber;
    }

    public String getPeriodDimNumber() {
        return this.periodDimNumber;
    }

    public void setPeriodDimNumber(String periodDimNumber) {
        this.periodDimNumber = periodDimNumber;
    }

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public String getTaskExecType() {
        return this.taskExecType;
    }

    public void setTaskExecType(String taskExecType) {
        this.taskExecType = taskExecType;
    }

    public boolean isRegisterTask() {
        if (TimeTypeEnum.PERIOD.getCode().equals(this.getTimeType())) {
            return "bd_period".equals(this.getPeriodBaseData());
        }
        return false;
    }

    public synchronized String getBatchNo() {
        if (this.batchNo == null) {
            this.batchNo = new DataCheckRuleExecParams().getBatchNo();
        }
        return this.batchNo;
    }
}

