/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.dto;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.macc.faf.dto.FAFMappingDimensionDTO;
import kd.macc.faf.enums.DimensionTypeEnum;
import kd.macc.faf.enums.MappingUploadStatusEnum;
import kd.macc.faf.enums.RelationShipMappingDimensionEnum;

public class MappingDataUploadDTO
implements Serializable {
    public static final long serialVersionUID = 1L;
    private List<FAFMappingDimensionDTO> fafMappingDimensionDTOS;
    private MappingUploadStatusEnum status;
    private List<SuccessRowData> successDataRows;
    private List<FailedRowData> failedDataRows;
    private static final Object[] emptyArray = new Object[]{"", 0L, -1L};

    public MappingDataUploadDTO() {
    }

    public MappingDataUploadDTO(List<FAFMappingDimensionDTO> fafMappingDimensionDTOS) {
        this.fafMappingDimensionDTOS = fafMappingDimensionDTOS;
    }

    public List<FAFMappingDimensionDTO> getFafMappingDimensionDTOS() {
        return this.fafMappingDimensionDTOS;
    }

    public void setFafMappingDimensionDTOS(List<FAFMappingDimensionDTO> fafMappingDimensionDTOS) {
        this.fafMappingDimensionDTOS = fafMappingDimensionDTOS;
    }

    public MappingUploadStatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(MappingUploadStatusEnum status) {
        this.status = status;
    }

    public List<SuccessRowData> getSuccessDataRows() {
        if (this.successDataRows == null) {
            this.successDataRows = new ArrayList<SuccessRowData>(8);
        }
        return this.successDataRows;
    }

    public void setSuccessDataRows(List<SuccessRowData> successDataRows) {
        this.successDataRows = successDataRows;
    }

    public List<FailedRowData> getFailedDataRows() {
        if (this.failedDataRows == null) {
            this.failedDataRows = new ArrayList<FailedRowData>(8);
        }
        return this.failedDataRows;
    }

    public void setFailedDataRows(List<FailedRowData> failedDataRows) {
        this.failedDataRows = failedDataRows;
    }

    public void validateAndAddRowData(List<Object> rowData, int rowindexInExcel) {
        List<FailedRowData> failedDataRows = this.getFailedDataRows();
        if (CollectionUtils.isEmpty(rowData) || this.fafMappingDimensionDTOS == null || rowData.size() != this.fafMappingDimensionDTOS.size()) {
            FailedRowData failedRowData = new FailedRowData();
            failedRowData.setFailedDataRows(rowData);
            failedRowData.setRowIndex(rowindexInExcel);
            failedRowData.setFailMessage(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u6570\u636e\u7ed3\u6784\u9519\u8bef", (String)"MappingDataUploadDTO_0", (String)"macc-faf-common", (Object[])new Object[0]), rowindexInExcel));
            failedDataRows.add(failedRowData);
            return;
        }
        List<FAFMappingDimensionDTO> sourceDimensionDTOs = this.fafMappingDimensionDTOS.stream().filter(dto -> RelationShipMappingDimensionEnum.SOURCE == dto.getDimensionType()).collect(Collectors.toList());
        boolean importValid = false;
        for (int i = 0; i < sourceDimensionDTOs.size(); ++i) {
            FAFMappingDimensionDTO sourceDimensionDTO = (FAFMappingDimensionDTO)sourceDimensionDTOs.get(i);
            DimensionTypeEnum dimensionTypeEnum = DimensionTypeEnum.getEnum(sourceDimensionDTO.getType());
            switch (dimensionTypeEnum) {
                case DATABASE: 
                case ASSISTANTDATA: {
                    Object pkValue = rowData.get(i);
                    if (pkValue instanceof Long) {
                        Long pkId = (Long)pkValue;
                        if (pkId <= 0L) break;
                        importValid = true;
                        break;
                    }
                    if (!StringUtils.isNotBlank((CharSequence)((String)pkValue))) break;
                    importValid = true;
                    break;
                }
                case OTHER: 
                case DENUMS: {
                    String textValue = (String)rowData.get(i);
                    if (!StringUtils.isNotBlank((CharSequence)textValue)) break;
                    importValid = true;
                }
            }
            if (importValid) break;
        }
        if (!importValid) {
            failedDataRows.add(this.buildFailedRowData(rowData, rowindexInExcel, sourceDimensionDTOs));
        } else {
            List<SuccessRowData> successDataRows = this.getSuccessDataRows();
            for (int i = 0; i < successDataRows.size(); ++i) {
                List<Object> successDataRow = successDataRows.get(i).getSuccessDataRows();
                boolean isDuplicate = true;
                for (int i1 = 0; i1 < sourceDimensionDTOs.size(); ++i1) {
                    Object o1 = rowData.get(i1);
                    Object o2 = successDataRow.get(i1);
                    if (ArrayUtils.contains((Object[])emptyArray, (Object)o1) && ArrayUtils.contains((Object[])emptyArray, (Object)o2) || ObjectUtils.nullSafeEquals((Object)rowData.get(i1), (Object)successDataRow.get(i1))) continue;
                    isDuplicate = false;
                    break;
                }
                if (!isDuplicate) continue;
                FailedRowData failedRowData = new FailedRowData();
                failedRowData.setFailedDataRows(rowData);
                failedRowData.setRowIndex(rowindexInExcel);
                failedRowData.setFailMessage(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u4e0e\u7b2c%2$s\u884c\u7684\u6e90\u7ef4\u5ea6\u6570\u636e\u91cd\u590d", (String)"MappingDataUploadDTO_3", (String)"macc-faf-common", (Object[])new Object[0]), rowindexInExcel, i + 4));
                failedDataRows.add(failedRowData);
                return;
            }
            SuccessRowData successRowData = new SuccessRowData();
            successRowData.setSuccessDataRows(rowData);
            successDataRows.add(successRowData);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private FailedRowData buildFailedRowData(List<Object> rowData, int rowindexInExcel, List<FAFMappingDimensionDTO> sourceDimensionDTOs) {
        String failMessage = "";
        boolean isAllSourceFieldEmpty = true;
        block5: for (int i = 0; i < sourceDimensionDTOs.size(); ++i) {
            FAFMappingDimensionDTO sourceDimensionDTO = sourceDimensionDTOs.get(i);
            DimensionTypeEnum dimensionTypeEnum = DimensionTypeEnum.getEnum(sourceDimensionDTO.getType());
            switch (dimensionTypeEnum) {
                case DATABASE: 
                case ASSISTANTDATA: {
                    Object databaseValue = rowData.get(i);
                    if (databaseValue instanceof Long) {
                        long databaseLongValue = (Long)databaseValue;
                        if (databaseLongValue > 0L) {
                            isAllSourceFieldEmpty = false;
                            break;
                        }
                        if (databaseLongValue != -1L) break;
                        isAllSourceFieldEmpty = false;
                        failMessage = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c:%2$s\u5bf9\u5e94\u7f16\u53f7\u7684\u6570\u636e\u4e0d\u5b58\u5728", (String)"MappingDataUploadDTO_1", (String)"macc-faf-common", (Object[])new Object[0]), rowindexInExcel, sourceDimensionDTO.getName());
                        break block5;
                    }
                    if (!(databaseValue instanceof String)) {
                        throw new KDBizException(String.format("Invalid primaryKey Type,field : %s", sourceDimensionDTO.getName()));
                    }
                    String databaseStringValue = (String)databaseValue;
                    if (!StringUtils.isNotBlank((CharSequence)databaseStringValue)) break;
                    isAllSourceFieldEmpty = false;
                    break;
                }
                case OTHER: {
                    String textValue = (String)rowData.get(i);
                    if (!StringUtils.isNotBlank((CharSequence)textValue)) break;
                    isAllSourceFieldEmpty = false;
                    break;
                }
                case DENUMS: {
                    String enumValue = (String)rowData.get(i);
                    isAllSourceFieldEmpty = false;
                    if (!StringUtils.isBlank((CharSequence)enumValue)) break;
                    failMessage = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c:%2$s\u5bf9\u5e94\u7684\u679a\u4e3e\u503c\u6570\u636e\u4e0d\u5b58\u5728", (String)"MappingDataUploadDTO_4", (String)"macc-faf-common", (Object[])new Object[0]), rowindexInExcel, sourceDimensionDTO.getName());
                    break block5;
                }
            }
        }
        if (isAllSourceFieldEmpty) {
            failMessage = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c:\u6e90\u7ef4\u5ea6\u4e0d\u80fd\u5168\u90e8\u4e3a\u7a7a", (String)"MappingDataUploadDTO_2", (String)"macc-faf-common", (Object[])new Object[0]), rowindexInExcel);
        }
        FailedRowData failedRowData = new FailedRowData();
        failedRowData.setFailedDataRows(rowData);
        failedRowData.setRowIndex(rowindexInExcel);
        failedRowData.setFailMessage(failMessage);
        return failedRowData;
    }

    public static class FailedRowData
    implements Serializable {
        public static final long serialVersionUID = 1L;
        private List<Object> failedDataRows;
        private int rowIndex;
        private String failMessage;

        public List<Object> getFailedDataRows() {
            return this.failedDataRows;
        }

        public void setFailedDataRows(List<Object> failedDataRows) {
            this.failedDataRows = failedDataRows;
        }

        public int getRowIndex() {
            return this.rowIndex;
        }

        public void setRowIndex(int rowIndex) {
            this.rowIndex = rowIndex;
        }

        public String getFailMessage() {
            return this.failMessage;
        }

        public void setFailMessage(String failMessage) {
            this.failMessage = failMessage;
        }
    }

    public static class SuccessRowData
    implements Serializable {
        public static final long serialVersionUID = 1L;
        private List<Object> successDataRows;

        public List<Object> getSuccessDataRows() {
            return this.successDataRows;
        }

        public void setSuccessDataRows(List<Object> successDataRows) {
            this.successDataRows = successDataRows;
        }
    }
}

