/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.dto;

import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Workbook;

public class MappingRelationExcelCellStyleBuilder {
    private final Map<String, CellStyle> CellStyleMap = new HashMap<String, CellStyle>(4);

    public CellStyle getCellStyle(Workbook workbook, boolean isHighLight, boolean isDefaultCell) {
        String cellStyleKey = String.format("%1$s%2$s", isHighLight ? "1" : "0", isDefaultCell ? "1" : "0");
        return this.CellStyleMap.computeIfAbsent(cellStyleKey, key -> this.build(workbook, isHighLight, isDefaultCell));
    }

    private CellStyle build(Workbook workbook, boolean isHighLight, boolean isDefaultCell) {
        CellStyle cs = workbook.createCellStyle();
        cs.setAlignment(this.getAlignment());
        if (isHighLight) {
            Font font = workbook.createFont();
            font.setColor(IndexedColors.RED.getIndex());
            cs.setFont(font);
            cs.setDataFormat(workbook.createDataFormat().getFormat("@"));
        }
        if (isDefaultCell) {
            cs.setFillForegroundColor(HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex());
            cs.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        }
        return cs;
    }

    private HorizontalAlignment getAlignment() {
        try {
            return HorizontalAlignment.valueOf((String)"DEFAULT");
        }
        catch (Throwable var3) {
            return HorizontalAlignment.GENERAL;
        }
    }
}

