/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.dto;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.util.StringUtils;
import kd.macc.faf.dto.MappingRelationShipDTO;
import kd.macc.faf.enums.ImportSystemSourceTypeEnum;
import kd.macc.faf.enums.OlapFromServiceEnum;

public class OlapDataExtractingDTO
implements Serializable {
    private static final long serialVersionUID = -5063398955324424312L;
    private String cubeCatelog;
    private String analysisModelDyObj;
    protected OlapFromServiceEnum dataSourceTypeEnum;
    protected Long moduleId;
    private Long orgViewId;
    protected Map<Integer, List<String>> selectDimensionMap;
    protected Map<String, Set<String>> dimFilters;
    private Map<List<String>, String> transformFieldIndexMap;
    protected Map<String, String> fieldMappings;
    protected Map<String, Object> defaultValueMap;
    private Map<String, String> dimEntityMapping;
    private List<MappingRelationShipDTO> mappingRelationShipDTOs;
    transient Map<String, SyncDataSchemaDimensionDTO> dimEntityMappingMap;
    private boolean haveTime;
    private boolean createStamp;

    public void buildExtractingValues() {
        int size = this.dimEntityMappingMap.size();
        this.fieldMappings = new HashMap<String, String>(size);
        this.defaultValueMap = new HashMap<String, Object>(size);
        this.dimEntityMapping = new HashMap<String, String>(size);
        this.mappingRelationShipDTOs = new ArrayList<MappingRelationShipDTO>(size);
        for (Map.Entry<String, SyncDataSchemaDimensionDTO> dimDTO : this.dimEntityMappingMap.entrySet()) {
            SyncDataSchemaDimensionDTO dimDTOValue = dimDTO.getValue();
            String olapDimNumber = dimDTOValue.getDimensionField();
            String analysisDimNumber = dimDTO.getKey();
            if ("1".equals(dimDTOValue.getDimensionSelectType()) && StringUtils.isNotEmpty((String)olapDimNumber)) {
                this.fieldMappings.put(olapDimNumber, analysisDimNumber);
                this.dimEntityMapping.put(olapDimNumber, dimDTOValue.getMetadataNumber());
                continue;
            }
            if ("2".equals(dimDTOValue.getDimensionSelectType()) && dimDTOValue.getMappingRelationShipDTO() != null) {
                this.mappingRelationShipDTOs.add(dimDTOValue.getMappingRelationShipDTO());
                continue;
            }
            if (!"3".equals(dimDTOValue.getDimensionSelectType()) || !StringUtils.isNotEmpty((String)dimDTOValue.getDefaultValue())) continue;
            this.defaultValueMap.put(analysisDimNumber, dimDTOValue.getDefaultValue());
        }
        this.haveTime = EntityMetadataCache.getDataEntityType((String)this.analysisModelDyObj).getProperty("createtime") != null;
        this.createStamp = EntityMetadataCache.getDataEntityType((String)this.analysisModelDyObj).getProperty("createstamp") != null;
    }

    public String getCubeCatelog() {
        return this.cubeCatelog;
    }

    public void setCubeCatelog(String cubeCatelog) {
        this.cubeCatelog = cubeCatelog;
    }

    public String getAnalysisModelDyObj() {
        return this.analysisModelDyObj;
    }

    public void setAnalysisModelDyObj(String analysisModelDyObj) {
        this.analysisModelDyObj = analysisModelDyObj;
    }

    public Map<Integer, List<String>> getSelectDimensionMap() {
        return this.selectDimensionMap;
    }

    public void setSelectDimensionMap(Map<Integer, List<String>> selectDimensionMap) {
        this.selectDimensionMap = selectDimensionMap;
    }

    public Map<String, Set<String>> getDimFilters() {
        return this.dimFilters;
    }

    public void setDimFilters(Map<String, Set<String>> dimFilters) {
        this.dimFilters = dimFilters;
    }

    public Map<List<String>, String> getTransformFieldIndexMap() {
        return this.transformFieldIndexMap;
    }

    public void setTransformFieldIndexMap(Map<List<String>, String> transformFieldIndexMap) {
        this.transformFieldIndexMap = transformFieldIndexMap;
    }

    public Map<String, String> getFieldMappings() {
        return this.fieldMappings;
    }

    public void setFieldMappings(Map<String, String> fieldMappings) {
        this.fieldMappings = fieldMappings;
    }

    public Map<String, String> getDimEntityMapping() {
        return this.dimEntityMapping;
    }

    public Map<String, Object> getDefaultValueMap() {
        return this.defaultValueMap;
    }

    public List<MappingRelationShipDTO> getMappingRelationShipDTOs() {
        return this.mappingRelationShipDTOs;
    }

    public void setMappingRelationShipDTOs(List<MappingRelationShipDTO> mappingRelationShipDTOs) {
        this.mappingRelationShipDTOs = mappingRelationShipDTOs;
    }

    public void setDimEntityMappingMap(Map<String, SyncDataSchemaDimensionDTO> dimEntityMappingMap) {
        this.dimEntityMappingMap = dimEntityMappingMap;
    }

    public OlapFromServiceEnum getDataSourceTypeEnum() {
        return this.dataSourceTypeEnum;
    }

    public void setDataSourceTypeEnum(OlapFromServiceEnum dataSourceTypeEnum) {
        this.dataSourceTypeEnum = dataSourceTypeEnum;
    }

    public Long getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(Long moduleId) {
        this.moduleId = moduleId;
    }

    public void setOrgViewId(Long orgViewId) {
        this.orgViewId = orgViewId;
    }

    public String toString() {
        return "OlapDataExtractingDTO{cubeCatelog='" + this.cubeCatelog + '\'' + ", analysisModelDyObj='" + this.analysisModelDyObj + '\'' + ", dataSourceTypeEnum=" + (Object)((Object)this.dataSourceTypeEnum) + ", moduleId=" + this.moduleId + ", orgViewId=" + this.orgViewId + ", selectDimensionMap=" + this.selectDimensionMap + ", dimFilters=" + this.dimFilters + ", transformFieldIndexMap=" + this.transformFieldIndexMap + ", fieldMappings=" + this.fieldMappings + ", defaultValueMap=" + this.defaultValueMap + ", dimEntityMapping=" + this.dimEntityMapping + '}';
    }

    public RowMeta buildOlapRowMeta() {
        ArrayList fieldList = new ArrayList(20);
        for (Map.Entry<Integer, List<String>> entry : this.selectDimensionMap.entrySet()) {
            List<String> value = entry.getValue();
            if (Integer.valueOf(0).equals(entry.getKey())) {
                fieldList.addAll(value.stream().map(x -> new Field(x, (DataType)DataType.BigDecimalType, true)).collect(Collectors.toList()));
                continue;
            }
            fieldList.addAll(value.stream().map(x -> new Field(x, (DataType)DataType.StringType, true)).collect(Collectors.toList()));
        }
        return new RowMeta(fieldList.toArray(new Field[0]));
    }

    public boolean isHaveTime() {
        return this.haveTime;
    }

    public boolean isCreateStamp() {
        return this.createStamp;
    }

    public static class SyncDataSchemaDimensionDTO {
        String dimensionNumber;
        ImportSystemSourceTypeEnum dimensionSystemSourceTypeEnum;
        String dimensionSelectType;
        String dimensionField;
        MappingRelationShipDTO mappingRelationShipDTO;
        String defaultValue;
        String metadataNumber;

        public String getDimensionNumber() {
            return this.dimensionNumber;
        }

        public void setDimensionNumber(String dimensionNumber) {
            this.dimensionNumber = dimensionNumber;
        }

        public ImportSystemSourceTypeEnum getDimensionSystemSourceTypeEnum() {
            return this.dimensionSystemSourceTypeEnum;
        }

        public void setDimensionSystemSourceTypeEnum(ImportSystemSourceTypeEnum dimensionSystemSourceTypeEnum) {
            this.dimensionSystemSourceTypeEnum = dimensionSystemSourceTypeEnum;
        }

        public String getDimensionSelectType() {
            return this.dimensionSelectType;
        }

        public void setDimensionSelectType(String dimensionSelectType) {
            this.dimensionSelectType = dimensionSelectType;
        }

        public String getDimensionField() {
            return this.dimensionField;
        }

        public void setDimensionField(String dimensionField) {
            this.dimensionField = dimensionField;
        }

        public MappingRelationShipDTO getMappingRelationShipDTO() {
            return this.mappingRelationShipDTO;
        }

        public void setMappingRelationShipDTO(MappingRelationShipDTO mappingRelationShipDTO) {
            this.mappingRelationShipDTO = mappingRelationShipDTO;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public String getMetadataNumber() {
            return this.metadataNumber;
        }

        public void setMetadataNumber(String metadataNumber) {
            this.metadataNumber = metadataNumber;
        }
    }
}

