/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.engine.model;

import java.math.BigDecimal;
import kd.bos.exception.KDBizException;
import kd.bos.olap.dataSources.OlapDataReader;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.macc.faf.engine.model.FAFOlapDataStatisticsInfo;
import kd.macc.faf.engine.task.IDataAbstractWorkTask;
import kd.macc.faf.model.impl.IDataMapEntry;

public class FAFOlapDataStatisticsTask
extends IDataAbstractWorkTask<FAFOlapDataStatisticsInfo> {
    protected boolean ignoreMeasureNull;
    IDataMapEntry<String, Integer>[] primayDim;

    public FAFOlapDataStatisticsTask() {
        super(FAFOlapDataStatisticsTask.class.getSimpleName());
    }

    public FAFOlapDataStatisticsTask(boolean ignoreMeasureNull, IDataMapEntry<String, Integer>[] primayDim) {
        super(FAFOlapDataStatisticsTask.class.getSimpleName());
        this.ignoreMeasureNull = ignoreMeasureNull;
        this.primayDim = primayDim;
    }

    protected FAFOlapDataStatisticsTask(String taskKey) {
        super(taskKey);
    }

    public FAFOlapDataStatisticsInfo processOlapQueryReader(SelectCommandInfo selectCommandInfo, OlapDataReader dataReader) {
        FAFOlapDataStatisticsInfo FAFOlapDataStatisticsInfo2 = null;
        if (this.primayDim != null && this.primayDim.length == 1) {
            FAFOlapDataStatisticsInfo2 = new FAFOlapDataStatisticsInfo(this.primayDim[0]);
        } else if (this.primayDim != null && this.primayDim.length == 2) {
            FAFOlapDataStatisticsInfo2 = new FAFOlapDataStatisticsInfo(this.primayDim[0], this.primayDim[1]);
        } else {
            throw new KDBizException("Invalid Parameter on initialize FSAOlapDataStatisticsInfo");
        }
        Object[] measureValue = new Object[1];
        Object[] rowBuffer = new Object[dataReader.getFieldCount()];
        while (dataReader.next()) {
            dataReader.getValues(rowBuffer);
            FAFOlapDataStatisticsInfo2.updateTotalCnt();
            if (!this.fetchMeasureValue(0, rowBuffer, measureValue)) {
                FAFOlapDataStatisticsInfo2.updateSkipCnt();
            }
            FAFOlapDataStatisticsInfo2.updateDimMemberCnt(rowBuffer);
        }
        FAFOlapDataStatisticsInfo2.refreshStatistics();
        return FAFOlapDataStatisticsInfo2;
    }

    protected boolean fetchMeasureValue(int fetchIndex, Object[] srcRowBuffer, Object[] measureValue) {
        measureValue[0] = srcRowBuffer[fetchIndex];
        if (measureValue[0] == null) {
            return !this.ignoreMeasureNull;
        }
        if (!(measureValue[0] instanceof Number)) {
            try {
                measureValue[0] = new BigDecimal(measureValue[0].toString());
            }
            catch (Exception ex) {
                return !this.ignoreMeasureNull;
            }
        }
        return true;
    }

    @Override
    protected FAFOlapDataStatisticsInfo doTaskJob() {
        return null;
    }
}

