/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.engine.task;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.macc.faf.dto.DataExtractingDTO;
import kd.macc.faf.dto.MappingRelationShipDTO;
import kd.macc.faf.engine.model.FAFWorkTaskMeta;
import kd.macc.faf.engine.model.IWorkTaskTransLog;
import kd.macc.faf.engine.task.FAFSplitDataSyncTask;
import kd.macc.faf.engine.task.IDataAbstractParallelWorkTaskGroup;
import kd.macc.faf.engine.task.status.FAFWorkTaskStatusConsumer;
import kd.macc.faf.engine.task.status.IDataSimpleWorkTaskStatisticStatus;
import kd.macc.faf.engine.task.status.IDataWorkTaskStatusMgr;
import kd.macc.faf.helper.QueryRDBHelper;
import kd.macc.faf.model.impl.ThreeValueTuple;
import kd.macc.faf.rdb.RdbSQLSplitTaskIterator;
import kd.macc.faf.stream.pipe.IExceptionListener;
import org.apache.commons.lang3.exception.ExceptionUtils;

public abstract class AbstractRdbDataQueryTask
extends IDataAbstractParallelWorkTaskGroup<Long, Callable<Long>, IDataSimpleWorkTaskStatisticStatus>
implements Cloneable {
    private static final Log logger = LogFactory.getLog(AbstractRdbDataQueryTask.class);
    protected boolean multipleSQLQuery;
    protected RdbSQLSplitTaskIterator splitTaskIterator;
    protected MainEntityType outputDynEntity;
    protected Long analysisModelId;
    protected IWorkTaskTransLog<Long> taskMeta;
    protected List<MappingRelationShipDTO> mappingRelationShipDTOList;

    protected AbstractRdbDataQueryTask(Serializable taskKey, Serializable version, IExceptionListener exceptionListener, MainEntityType outputDynEntity, RdbSQLSplitTaskIterator splitTaskIterator, Long analysisModelId) {
        super(taskKey, version, exceptionListener, false);
        this.outputDynEntity = outputDynEntity;
        this.splitTaskIterator = splitTaskIterator;
        this.multipleSQLQuery = true;
        this.analysisModelId = analysisModelId;
        this.exceptionListener = this::onTaskError;
    }

    protected boolean onTaskError(Throwable exception) {
        this.exception = exception;
        return true;
    }

    @Override
    protected IDataWorkTaskStatusMgr getWorkTaskStatusMgr() {
        return FAFWorkTaskStatusConsumer.getInstance();
    }

    protected abstract long processQueryReader(QFilter[] var1, DataSet var2);

    protected void updateTaskStatistics(int fetchDataCnt, int processDataCnt, int skipErrorDataCnt) {
        IDataSimpleWorkTaskStatisticStatus workTaskStatusEvent = ((IDataSimpleWorkTaskStatisticStatus)this.getWorkTaskStatusEvent()).copy();
        workTaskStatusEvent.updateTaskStatistics(fetchDataCnt, processDataCnt, skipErrorDataCnt, this.totalStatisticsPoints);
        workTaskStatusEvent.updateSubTaskStartStatus(true);
        try {
            this.getWorkTaskStatusMgr().updateTaskStatus(workTaskStatusEvent);
        }
        catch (InterruptedException e) {
            throw new KDBizException((Throwable)e, new ErrorCode(ResManager.loadKDString((String)"\u66f4\u65b0\u53d6\u6570\u4efb\u52a1\u6761\u6570\u5931\u8d25", (String)"AbstractRdbDataQueryTask_0", (String)"macc-faf-common", (Object[])new Object[0]), e.getMessage()), new Object[0]);
        }
    }

    @Override
    protected Long doTaskJob() {
        try {
            if (logger.isInfoEnabled()) {
                logger.info(String.format("Start Do Task Job: multipleSQLQuery=%s, outputDynEntity=%s", this.multipleSQLQuery, this.outputDynEntity));
            }
            this.taskResult = this.doTaskJobNoLock();
            if (logger.isInfoEnabled()) {
                logger.info(String.format("Complete Do Task Job on [%sms]: multipleSQLQuery=%s, outputDynEntity=%s, taskResult=%s", this.getTaskExecutionTime(), this.multipleSQLQuery, this.outputDynEntity, this.taskResult));
            }
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", String.format(ResManager.loadKDString((String)"\u6267\u884cAbstractRdbDataQueryTask\u5f02\u5e38 :%s", (String)"AbstractRdbDataQueryTask_1", (String)"macc-faf-common", (Object[])new Object[0]), e.getMessage())), new Object[0]);
        }
        return (Long)this.taskResult;
    }

    protected Long doTaskJobNoLock() {
        this.updateTaskStatistics(0, 0, 0);
        this.taskResult = super.doTaskJob();
        return (Long)this.taskResult;
    }

    @Override
    protected Long processTaskResult(int taskIndex, Callable<Long> task, Object taskResult) {
        AbstractRdbDataQueryTask abstractRdbDataQueryTask = this;
        abstractRdbDataQueryTask.taskResult = (Long)abstractRdbDataQueryTask.taskResult + (taskResult != null ? (Long)taskResult : 0L);
        return abstractRdbDataQueryTask.taskResult;
    }

    @Override
    protected void doTaskFinallyCleanUp(boolean isCancelled, boolean withError) {
        if (this.taskMeta instanceof FAFWorkTaskMeta) {
            FAFWorkTaskMeta FAFWorkTaskMeta2 = (FAFWorkTaskMeta)this.taskMeta;
            ThreeValueTuple<QFilter[], Integer, Integer> qFiltersTuple = this.splitTaskIterator.getQFiltersTuple();
            String[] orgAndPeriodTargetNumber = this.splitTaskIterator.getOrgAndPeriodTargetNumber();
            DataExtractingDTO dataExtractingDTO = FAFWorkTaskMeta2.getDataExtractingDTO();
            if (isCancelled || withError) {
                if (qFiltersTuple != null) {
                    logger.info("start deleting historical data when failed fetching data");
                    QFilter[] qFilters = qFiltersTuple.getKey();
                    QFilter rollBackFilter = new QFilter("del", "=", (Object)Long.valueOf(this.taskKey.toString()));
                    rollBackFilter.and(new QFilter(orgAndPeriodTargetNumber[0], "=", qFilters[0].getValue()));
                    rollBackFilter.and(dataExtractingDTO.getPeriodQFilter(orgAndPeriodTargetNumber[1]));
                    if (this.outputDynEntity.getProperty("importbatch") != null) {
                        logger.info("rollBack data, add filter which importbatch is empty");
                        rollBackFilter.and(new QFilter("importbatch", "=", (Object)" "));
                    }
                    int deleteSize = DeleteServiceHelper.delete((String)this.outputDynEntity.getName(), (QFilter[])rollBackFilter.toArray());
                    this.updateTaskStatistics(-deleteSize, -deleteSize, 0);
                }
                if (this.exception != null) {
                    String stackTrace = ExceptionUtils.getStackTrace((Throwable)this.exception);
                    logger.error("traceId :" + RequestContext.getOrCreate().getTraceId() + "StackTrace :" + stackTrace);
                }
                this.waitingTaskQueue.clear();
                this.splitTaskIterator.close();
            } else if (qFiltersTuple != null) {
                logger.info("start deleting historical data when successful fetching data");
                QFilter[] qFilters = qFiltersTuple.getKey();
                QFilter deleteFilter = new QFilter("del", "!=", (Object)Long.valueOf(this.taskKey.toString()));
                deleteFilter.and(new QFilter(orgAndPeriodTargetNumber[0], "=", qFilters[0].getValue()));
                deleteFilter.and(dataExtractingDTO.getPeriodQFilter(orgAndPeriodTargetNumber[1]));
                if (this.outputDynEntity.getProperty("importbatch") != null) {
                    logger.info("have importbatch field, add filter which importbatch is empty");
                    deleteFilter.and(new QFilter("importbatch", "=", (Object)" "));
                } else {
                    logger.info(String.format("%s does not have importbatch field", this.outputDynEntity.getName()));
                }
                DeleteServiceHelper.delete((String)this.outputDynEntity.getName(), (QFilter[])new QFilter[]{deleteFilter});
            }
        }
    }

    protected Callable<Long> createQuerySubTask(String taskTypeName, final QFilter[] qFilter, final RdbSQLSplitTaskIterator splitTaskIterator) {
        logger.info(String.format("start createQuerySubTask, qFilter:%s", Arrays.toString(qFilter)));
        return new FAFSplitDataSyncTask(taskTypeName, this.exceptionListener, this.outputDynEntity.getName(), this.analysisModelId, this.taskGroupCondition){

            @Override
            protected Long doTaskJob() {
                if (splitTaskIterator == null) {
                    return 0L;
                }
                return QueryRDBHelper.queryRDataBaseToDataSet(splitTaskIterator, qFilter, (qFilter, dataSet) -> AbstractRdbDataQueryTask.this.processQueryReader((QFilter[])qFilter, (DataSet)dataSet));
            }
        };
    }

    @Override
    public ThreeValueTuple<Callable<Long>, Boolean, Boolean> doGetNextSubTask() {
        Object nextTuple = this.splitTaskIterator.next();
        if (nextTuple == null) {
            return null;
        }
        QFilter[] nextQFilter = (QFilter[])((ThreeValueTuple)nextTuple).getKey();
        if (nextQFilter == null) {
            return null;
        }
        QFilter[] qFilters = RdbSQLSplitTaskIterator.concat(nextQFilter, this.splitTaskIterator.getFilters());
        return new ThreeValueTuple<Callable<Long>, Boolean, Boolean>(this.createQuerySubTask("InnerMultiQueryTask", qFilters, this.splitTaskIterator), Boolean.FALSE, Boolean.TRUE);
    }

    @Override
    public boolean hasSubTask() {
        return this.multipleSQLQuery && this.splitTaskIterator.hasNext() && !this.isCancelled();
    }

    public RdbSQLSplitTaskIterator getSplitTaskIterator() {
        return this.splitTaskIterator;
    }

    public MainEntityType getOutputDynEntity() {
        return this.outputDynEntity;
    }

    public String getOutputTargetEntityName() {
        return this.outputDynEntity != null ? this.outputDynEntity.getName() : null;
    }

    public Long getAnalysisModelId() {
        return this.analysisModelId;
    }

    public IWorkTaskTransLog<Long> getTaskMeta() {
        return this.taskMeta;
    }

    public void setTaskMeta(IWorkTaskTransLog<Long> taskMeta) {
        this.taskMeta = taskMeta;
    }

    public List<MappingRelationShipDTO> getMappingRelationShipDTOList() {
        return this.mappingRelationShipDTOList;
    }

    public void setMappingRelationShipDTOList(List<MappingRelationShipDTO> mappingRelationShipDTOList) {
        this.mappingRelationShipDTOList = mappingRelationShipDTOList;
    }
}

