/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.engine.task;

import java.io.Serializable;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.faf.dto.DataExtractingDTO;
import kd.macc.faf.engine.model.FAFWorkTaskMeta;
import kd.macc.faf.engine.model.IWorkTaskTransLog;
import kd.macc.faf.engine.task.FAFAbstractWorkTask;
import kd.macc.faf.engine.task.IFinallyTask;
import kd.macc.faf.engine.task.impl.FAFDataEntityCreateTask;
import kd.macc.faf.engine.task.status.IDataSimpleWorkTaskStatisticStatus;
import kd.macc.faf.enums.DimensionNecessityEnum;
import kd.macc.faf.event.IWorkTaskStatusEvent;
import kd.macc.faf.helper.FAFTableDataHelper;
import kd.macc.faf.helper.QueryRDBHelper;
import kd.macc.faf.rdb.RdbSQLInfo;

public class FAFDataEntityDataProcessTask
extends FAFAbstractWorkTask<Long>
implements IFinallyTask {
    protected IWorkTaskTransLog transLog;
    protected boolean rollbackMode;
    protected boolean markDelete;
    protected RdbSQLInfo rdbSQLInfo;

    public FAFDataEntityDataProcessTask(IWorkTaskTransLog transLog, boolean markDelete, RdbSQLInfo rdbSQLInfo) {
        super((Serializable)((Object)FAFDataEntityCreateTask.class.getSimpleName()));
        if (transLog instanceof FAFWorkTaskMeta) {
            FAFWorkTaskMeta meta = (FAFWorkTaskMeta)transLog;
            this.taskKey = meta.getTaskId();
        }
        this.transLog = transLog;
        this.markDelete = markDelete;
        this.rdbSQLInfo = rdbSQLInfo;
        this.rollbackMode = false;
    }

    @Override
    protected Long doTaskJob() {
        String entityNumber = this.rdbSQLInfo.getEntityNumber();
        if (this.markDelete) {
            QueryRDBHelper.batchUpdateDeleteMark(entityNumber, this.rdbSQLInfo.getFilters(), 1L);
        } else if (this.transLog instanceof FAFWorkTaskMeta) {
            Long analysisModelId;
            DataExtractingDTO dataExtractingDTO;
            List<Object> summaryIds;
            boolean hasImportBatchField;
            FAFWorkTaskMeta meta = (FAFWorkTaskMeta)this.transLog;
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            boolean bl = hasImportBatchField = dataEntityType.getProperty("importbatch") != null;
            if (hasImportBatchField) {
                this.rdbSQLInfo.getFilters()[0].and(new QFilter("importbatch", "=", (Object)" "));
            }
            if (!(summaryIds = FAFTableDataHelper.delete(entityNumber, this.rdbSQLInfo.getFilters())).isEmpty()) {
                // empty if block
            }
            if (hasImportBatchField && (dataExtractingDTO = meta.getDataExtractingDTO()) != null && (analysisModelId = meta.getAnalysisModelId()) != null) {
                String[] orgAndPeriodField = new String[2];
                DynamicObject analysisModel = BusinessDataServiceHelper.loadSingle((Object)analysisModelId, (String)"pa_analysismodel");
                DynamicObjectCollection dimensionEntry = analysisModel.getDynamicObjectCollection("dimension_entry");
                if (dimensionEntry != null && !dimensionEntry.isEmpty()) {
                    for (DynamicObject dim : dimensionEntry) {
                        if (DimensionNecessityEnum.ORG.getCode().equals(dim.get("necessity_dim"))) {
                            orgAndPeriodField[0] = dim.getDynamicObject("dimension").getString("number");
                            continue;
                        }
                        if (!DimensionNecessityEnum.PERIOD.getCode().equals(dim.get("necessity_dim"))) continue;
                        orgAndPeriodField[1] = dim.getDynamicObject("dimension").getString("number");
                    }
                    QFilter basicFilter = new QFilter("importbatch", "!=", (Object)" ").and(dataExtractingDTO.getOrgQFilter(orgAndPeriodField[0])).and(dataExtractingDTO.getPeriodQFilter(orgAndPeriodField[1]));
                    DynamicObject[] resultArr = BusinessDataServiceHelper.load((String)entityNumber, (String)"id,operationstatus", (QFilter[])basicFilter.toArray(), null);
                    if (resultArr != null) {
                        for (DynamicObject obj : resultArr) {
                            obj.set("operationstatus", (Object)0);
                        }
                        SaveServiceHelper.save((DynamicObject[])resultArr);
                    }
                }
            }
        }
        IWorkTaskStatusEvent workTaskStatusEvent = this.getWorkTaskStatusMgr().getCachedWorkTaskStatusEvent(this.taskKey);
        if (workTaskStatusEvent instanceof IDataSimpleWorkTaskStatisticStatus) {
            try {
                workTaskStatusEvent.setNeedMergeStatus(false);
                ((IDataSimpleWorkTaskStatisticStatus)workTaskStatusEvent).updateSubTaskEndStatus(true);
                this.getWorkTaskStatusMgr().updateTaskStatus(workTaskStatusEvent);
            }
            catch (InterruptedException e) {
                throw new KDBizException(e.getMessage());
            }
        }
        return null;
    }

    @Override
    public void setRollBack(boolean rollBack) {
        this.rollbackMode = rollBack;
    }
}

