/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.engine.task;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.faf.engine.task.IDataAbstractWorkGroupMainTask;
import kd.macc.faf.engine.task.IDataAbstractWorkTask;
import kd.macc.faf.engine.task.IDataWorkTaskManager;
import kd.macc.faf.engine.task.TaskGroupCondition;
import kd.macc.faf.event.IWorkTaskStatusEvent;
import kd.macc.faf.model.impl.IDataMapEntry;
import kd.macc.faf.model.impl.ThreeValueTuple;
import kd.macc.faf.stream.pipe.IExceptionListener;

public abstract class IDataAbstractParallelWorkTaskGroup<TASK_RESULT, TASK_STEP extends Callable, TASK_STATUS extends IWorkTaskStatusEvent>
extends IDataAbstractWorkGroupMainTask<TASK_RESULT, TASK_STEP, TASK_STATUS> {
    private static final Log logger = LogFactory.getLog(IDataAbstractParallelWorkTaskGroup.class);
    protected int maxWorkerThreadCnt = IDataWorkTaskManager.getInstance().getMaxThreadCnt();
    protected AtomicInteger runningWorkerThreadCnt;
    protected Map<Object, Map.Entry<SubWorkTaskWrapper, Future>> registeredWorkThreads;
    protected Map<Object, List<Object>> completedTaskResults;
    protected ConcurrentLinkedDeque<TASK_STEP> waitingTaskQueue;
    protected AtomicBoolean suspendGetNextTask;

    protected IDataAbstractParallelWorkTaskGroup(Serializable taskKey, Serializable version) {
        this(taskKey, version, null);
    }

    protected IDataAbstractParallelWorkTaskGroup(Serializable taskKey, Serializable version, IExceptionListener exceptionListener) {
        super(taskKey, version, exceptionListener);
        this.continueOnSubTaskError = true;
        this.suspendGetNextTask = new AtomicBoolean(false);
        this.waitingTaskQueue = new ConcurrentLinkedDeque();
        this.completedTaskResults = new HashMap<Object, List<Object>>(4);
        this.registeredWorkThreads = new ConcurrentHashMap<Object, Map.Entry<SubWorkTaskWrapper, Future>>(4);
        this.runningWorkerThreadCnt = new AtomicInteger(0);
    }

    protected IDataAbstractParallelWorkTaskGroup(Serializable taskKey, Serializable version, IExceptionListener exceptionListener, boolean throwException) {
        super(taskKey, version, exceptionListener, throwException);
        this.continueOnSubTaskError = true;
        this.suspendGetNextTask = new AtomicBoolean(false);
        this.waitingTaskQueue = new ConcurrentLinkedDeque();
        this.completedTaskResults = new HashMap<Object, List<Object>>(4);
        this.registeredWorkThreads = new ConcurrentHashMap<Object, Map.Entry<SubWorkTaskWrapper, Future>>(4);
        this.runningWorkerThreadCnt = new AtomicInteger(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ThreeValueTuple<TASK_STEP, Boolean, Boolean> getNextSubTask() {
        while (this.suspendGetNextTask.get()) {
            AtomicBoolean atomicBoolean = this.suspendGetNextTask;
            synchronized (atomicBoolean) {
                try {
                    this.suspendGetNextTask.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return this.doGetNextSubTask();
    }

    protected abstract ThreeValueTuple<TASK_STEP, Boolean, Boolean> doGetNextSubTask();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Future processSubTask(TASK_STEP subWorkTask) {
        boolean canAddNewThread;
        if (subWorkTask == null) {
            return null;
        }
        boolean bl = canAddNewThread = this.runningWorkerThreadCnt.get() < this.maxWorkerThreadCnt;
        if (!canAddNewThread && !this.waitingTaskQueue.isEmpty()) {
            this.changeGetNextTaskSuspendStatus(true);
        }
        this.waitingTaskQueue.add(subWorkTask);
        ConcurrentLinkedDeque<TASK_STEP> concurrentLinkedDeque = this.waitingTaskQueue;
        synchronized (concurrentLinkedDeque) {
            this.waitingTaskQueue.notifyAll();
        }
        Future taskFutureResult = null;
        if (!this.waitingTaskQueue.isEmpty() && canAddNewThread) {
            this.runningWorkerThreadCnt.incrementAndGet();
            SubWorkTaskWrapper taskWrapper = new SubWorkTaskWrapper(UUID.randomUUID().toString(), this.subTaskExceptionListener, this.taskGroupCondition, (taskInfo, taskResult) -> {
                Object task_result = this.processTaskResult((Integer)taskInfo.getElement(), (Callable)taskInfo.getValue(), taskResult);
                if (this.suspendGetNextTask.get() && this.waitingTaskQueue.size() < this.maxWorkerThreadCnt) {
                    this.changeGetNextTaskSuspendStatus(false);
                }
                return task_result;
            });
            this.updateSubTaskReference(taskWrapper);
            Map<Object, Map.Entry<SubWorkTaskWrapper, Future>> map = this.registeredWorkThreads;
            synchronized (map) {
                taskFutureResult = IDataWorkTaskManager.getInstance().submit(taskWrapper, false);
                this.registeredWorkThreads.put(taskWrapper.getTaskUUId(), new IDataMapEntry(taskWrapper, taskFutureResult));
            }
        }
        return taskFutureResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean isCancelled;
        this.waitingTaskQueue.clear();
        Object object = this.taskGroupCondition;
        synchronized (object) {
            isCancelled = this.taskGroupCondition.cancelMode;
        }
        if (!isCancelled) {
            object = this.registeredWorkThreads;
            synchronized (object) {
                for (Map.Entry<SubWorkTaskWrapper, Future> taskEn : this.registeredWorkThreads.values()) {
                    if (taskEn.getValue() == null || taskEn.getValue().isDone()) continue;
                    taskEn.getValue().cancel(true);
                }
            }
            return super.cancel(mayInterruptIfRunning);
        }
        return true;
    }

    @Override
    protected TASK_RESULT waitSubTaskCompleted() {
        if (this.runningWorkerThreadCnt.get() <= 0 && this.registeredWorkThreads.isEmpty() && this.waitingTaskQueue.isEmpty()) {
            return (TASK_RESULT)this.taskResult;
        }
        int taskIndex = 0;
        for (Map.Entry<SubWorkTaskWrapper, Future> taskEn : this.registeredWorkThreads.values()) {
            if (taskEn == null) continue;
            try {
                this.processTaskResult(taskIndex++, (Callable)taskEn.getKey(), taskEn.getValue().get());
            }
            catch (InterruptedException e) {
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                this.onSubTaskError(ex);
            }
        }
        return (TASK_RESULT)this.taskResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeGetNextTaskSuspendStatus(boolean suspend) {
        if (suspend != this.suspendGetNextTask.get()) {
            this.suspendGetNextTask.set(suspend);
            if (!suspend) {
                AtomicBoolean atomicBoolean = this.suspendGetNextTask;
                synchronized (atomicBoolean) {
                    this.suspendGetNextTask.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterTaskCompleted(Object taskKey, Callable srcWorkTask, Object taskResult) {
        Map<Object, Map.Entry<SubWorkTaskWrapper, Future>> map = this.registeredWorkThreads;
        synchronized (map) {
            this.registeredWorkThreads.remove(taskKey);
            this.completedTaskResults.computeIfAbsent(taskKey, v -> new LinkedList()).add(taskResult);
        }
        this.runningWorkerThreadCnt.decrementAndGet();
    }

    public boolean getSuspendGetNextTask() {
        return this.suspendGetNextTask.get();
    }

    public int getMaxWorkerThreadCnt() {
        return this.maxWorkerThreadCnt;
    }

    public void setMaxWorkerThreadCnt(int maxWorkerThreadCnt) {
        this.maxWorkerThreadCnt = maxWorkerThreadCnt;
    }

    public int getRunningWorkerThreadCnt() {
        return this.runningWorkerThreadCnt.get();
    }

    protected class SubWorkTaskWrapper
    extends IDataAbstractWorkTask<TASK_RESULT> {
        protected BiFunction<ThreeValueTuple<Object, Integer, TASK_STEP>, Object, TASK_RESULT> taskResultProcessFunc;

        protected SubWorkTaskWrapper(Object taskKey, IExceptionListener exceptionListener, TaskGroupCondition taskGroupCondition, BiFunction<ThreeValueTuple<Object, Integer, TASK_STEP>, Object, TASK_RESULT> taskResultProcessFunc) {
            super(taskKey, exceptionListener, taskGroupCondition);
            this.taskResultProcessFunc = taskResultProcessFunc;
        }

        @Override
        protected TASK_RESULT doTaskJob() {
            int taskIndex = 0;
            while (!this.isCancelled() && !IDataAbstractParallelWorkTaskGroup.this.waitingTaskQueue.isEmpty()) {
                try {
                    Callable taskStep = (Callable)IDataAbstractParallelWorkTaskGroup.this.waitingTaskQueue.pop();
                    if (taskStep == null) continue;
                    this.taskResult = this.taskResultProcessFunc.apply(new ThreeValueTuple<String, Integer, Callable>(this.getTaskUUId(), taskIndex++, taskStep), taskStep.call());
                }
                catch (Exception e) {
                    if (e instanceof NoSuchElementException) {
                        return null;
                    }
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
                }
            }
            return this.taskResult;
        }

        public BiFunction<ThreeValueTuple<Object, Integer, TASK_STEP>, Object, TASK_RESULT> getTaskResultProcessFunc() {
            return this.taskResultProcessFunc;
        }

        public void setTaskResultProcessFunc(BiFunction<ThreeValueTuple<Object, Integer, TASK_STEP>, Object, TASK_RESULT> taskResultProcessFunc) {
            this.taskResultProcessFunc = taskResultProcessFunc;
        }
    }
}

