/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.engine.task;

import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.faf.engine.task.IDataAbstractWorkTask;
import kd.macc.faf.engine.task.IDataWorkTask;
import kd.macc.faf.engine.task.TaskGroupCondition;
import kd.macc.faf.engine.task.service.IDataWorkTaskStepProvider;
import kd.macc.faf.engine.task.status.IDataSimpleWorkTaskStatisticStatus;
import kd.macc.faf.event.IWorkTaskStatusChangeListener;
import kd.macc.faf.event.IWorkTaskStatusEvent;
import kd.macc.faf.model.impl.ThreeValueTuple;
import kd.macc.faf.stream.pipe.IExceptionListener;

public abstract class IDataAbstractWorkGroupMainTask<TASK_RESULT, TASK_STEP extends Callable, TASK_STATUS extends IWorkTaskStatusEvent>
extends IDataAbstractWorkTask<TASK_RESULT>
implements IDataWorkTaskStepProvider<TASK_STEP>,
IWorkTaskStatusChangeListener {
    private static final Log logger = LogFactory.getLog(IDataAbstractWorkGroupMainTask.class);
    protected IExceptionListener subTaskExceptionListener;
    protected boolean continueOnSubTaskError;
    protected TASK_STATUS workTaskStatusEvent;
    protected Serializable version;

    protected IDataAbstractWorkGroupMainTask(Serializable taskKey, Serializable version, IExceptionListener exceptionListener) {
        super(taskKey);
        this.version = version;
        this.exceptionListener = exceptionListener;
        this.continueOnSubTaskError = false;
        this.subTaskExceptionListener = ex -> this.onSubTaskError(ex);
    }

    protected IDataAbstractWorkGroupMainTask(Serializable taskKey, Serializable version, IExceptionListener exceptionListener, boolean throwException) {
        super(throwException, taskKey, exceptionListener, new TaskGroupCondition());
        this.version = version;
        this.exceptionListener = exceptionListener;
        this.continueOnSubTaskError = false;
        this.subTaskExceptionListener = ex -> this.onSubTaskError(ex);
    }

    protected abstract Future processSubTask(TASK_STEP var1);

    protected abstract TASK_RESULT processTaskResult(int var1, TASK_STEP var2, Object var3);

    @Override
    protected TASK_RESULT doTaskJob() {
        ThreeValueTuple workTaskInfo;
        int taskIndex = 0;
        this.initializeTaskJob();
        while (!(this.isCancelled() || this.isError() || !this.hasSubTask() || this.isCancelled() || this.isError() || (workTaskInfo = this.getNextSubTask()) == null || workTaskInfo.getKey() == null)) {
            if (Boolean.TRUE.equals(workTaskInfo.getElement())) {
                this.waitSubTaskCompleted();
            }
            if (this.isCancelled() || this.isError()) continue;
            this.executeSubTask(taskIndex++, workTaskInfo);
        }
        return this.waitSubTaskCompleted();
    }

    protected void executeSubTask(int taskIndex, ThreeValueTuple<TASK_STEP, Boolean, Boolean> workTaskInfo) {
        Future subTaskResult;
        Callable subWorkTask = (Callable)workTaskInfo.getKey();
        if (subWorkTask instanceof IDataWorkTask && ((IDataWorkTask)subWorkTask).getUpdateReference()) {
            subWorkTask = this.updateSubTaskReference((IDataWorkTask)subWorkTask);
        }
        if ((subTaskResult = this.processSubTask(subWorkTask)) != null && Boolean.FALSE.equals(workTaskInfo.getValue())) {
            try {
                this.processTaskResult(taskIndex, subWorkTask, subTaskResult.get());
            }
            catch (Exception ex) {
                this.onSubTaskError(ex);
            }
        }
    }

    protected TASK_RESULT waitSubTaskCompleted() {
        return (TASK_RESULT)this.taskResult;
    }

    protected boolean onSubTaskError(Throwable ex) {
        logger.error(ex.getMessage(), ex);
        if (!this.continueOnSubTaskError) {
            this.terminateOnError();
        }
        return this.onException(ex);
    }

    protected void initializeTaskJob() {
        this.getWorkTaskStatusEvent();
    }

    @Override
    public TASK_RESULT getResult() {
        switch (this.taskStageCode.get()) {
            case -9: 
            case 9: 
            case 10: {
                return (TASK_RESULT)this.taskResult;
            }
        }
        return this.waitSubTaskCompleted();
    }

    public TASK_STATUS getWorkTaskStatusEvent() {
        if (this.workTaskStatusEvent == null && (this.workTaskStatusEvent = this.getWorkTaskStatusMgr().getCachedWorkTaskStatusEvent(this.getTaskKey())) == null) {
            this.workTaskStatusEvent = new IDataSimpleWorkTaskStatisticStatus(this.getTaskKey(), this.version, this.calcTaskTotalStatisticsPoints());
        }
        return this.workTaskStatusEvent;
    }

    public void setWorkTaskStatusEvent(TASK_STATUS workTaskStatusEvent) {
        this.workTaskStatusEvent = workTaskStatusEvent;
    }

    @Override
    public boolean isCancelled() {
        if (this.taskGroupCondition.active) {
            if (this.getWorkTaskStatusMgr().checkTaskCancelStatus(this.taskKey, true)) {
                this.cancel();
                return true;
            }
            return false;
        }
        return this.taskGroupCondition.cancelMode;
    }

    public long getTaskExecutionTime() {
        return this.getWorkTaskStatusEvent().getTaskExecutionTime();
    }

    @Override
    public void beforeTaskStart(Object taskKey, Callable srcWorkTask) {
    }

    @Override
    public void afterTaskCompleted(Object taskKey, Callable srcWorkTask, Object taskResult) {
    }

    @Override
    public void onTaskError(Object taskKey, Callable srcWorkTask, Throwable error) {
    }

    protected IDataWorkTask updateSubTaskReference(IDataWorkTask subWorkTask) {
        subWorkTask.setTaskGroupCondition(this.taskGroupCondition);
        subWorkTask.setTaskStatusChangeListener(this);
        if (subWorkTask instanceof IDataAbstractWorkTask) {
            ((IDataAbstractWorkTask)subWorkTask).setExceptionListener(this.subTaskExceptionListener);
        }
        return subWorkTask;
    }

    @Override
    public TaskGroupCondition getTaskGroupCondition() {
        return this.taskGroupCondition;
    }

    @Override
    public void setTaskGroupCondition(TaskGroupCondition taskGroupCondition) {
        this.taskGroupCondition = taskGroupCondition;
    }

    public IExceptionListener getSubTaskExceptionListener() {
        return this.subTaskExceptionListener;
    }

    public void setSubTaskExceptionListener(IExceptionListener subTaskExceptionListener) {
        this.subTaskExceptionListener = subTaskExceptionListener;
    }

    public boolean isContinueOnSubTaskError() {
        return this.continueOnSubTaskError;
    }

    public void setContinueOnSubTaskError(boolean continueOnSubTaskError) {
        this.continueOnSubTaskError = continueOnSubTaskError;
    }

    public Serializable getVersion() {
        return this.version;
    }

    public void setVersion(Serializable version) {
        this.version = version;
    }
}

