/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.engine.task;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kd.bos.context.RequestContext;
import kd.macc.faf.engine.task.IDataWorkTask;

public class IDataFutureWrapper<T>
implements Future<T> {
    protected Future<T> srcFuture = null;
    protected boolean waitSrcFutureSubmit = true;
    protected IDataWorkTask<T> srcWorkTask;

    public IDataFutureWrapper(IDataWorkTask<T> srcWorkTask) {
        this.srcWorkTask = srcWorkTask;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.waitSrcFutureSubmit = false;
        Future<T> taskFuture = this.getSrcFuture();
        if (taskFuture != null && !taskFuture.isDone()) {
            return taskFuture.cancel(mayInterruptIfRunning);
        }
        return true;
    }

    @Override
    public boolean isCancelled() {
        Future<T> taskFuture = this.getSrcFuture();
        return taskFuture == null ? true : taskFuture.isCancelled();
    }

    @Override
    public boolean isDone() {
        Future<T> taskFuture = this.getSrcFuture();
        return taskFuture == null ? false : taskFuture.isDone();
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        Future<T> taskFuture = this.getSrcFuture();
        return taskFuture == null ? null : (T)taskFuture.get();
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Future<T> taskFuture = this.getSrcFuture();
        return taskFuture == null ? null : (T)taskFuture.get(timeout, unit);
    }

    public boolean testTaskCompleted() {
        if (this.srcFuture != null) {
            return this.srcFuture.isDone() || this.srcFuture.isCancelled();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<T> getSrcFuture(long timeOut, TimeUnit unit) {
        if (this.srcFuture == null) {
            IDataWorkTask<T> iDataWorkTask = this.srcWorkTask;
            synchronized (iDataWorkTask) {
                try {
                    this.srcWorkTask.wait(unit.toMillis(timeOut));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return this.srcFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<T> getSrcFuture() {
        while (this.waitSrcFutureSubmit && this.srcFuture == null) {
            IDataWorkTask<T> iDataWorkTask = this.srcWorkTask;
            synchronized (iDataWorkTask) {
                try {
                    this.srcWorkTask.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return this.srcFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSrcFuture(Future<T> srcFuture) {
        this.srcFuture = srcFuture;
        IDataWorkTask<T> iDataWorkTask = this.srcWorkTask;
        synchronized (iDataWorkTask) {
            this.srcWorkTask.notifyAll();
        }
    }

    public RequestContext getTenantRequestContext() {
        return this.srcWorkTask.getTenantRequestContext();
    }

    public boolean isWaitSrcFutureSubmit() {
        return this.waitSrcFutureSubmit;
    }

    public void setWaitSrcFutureSubmit(boolean waitSrcFutureSubmit) {
        this.waitSrcFutureSubmit = waitSrcFutureSubmit;
    }
}

