/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.engine.task.impl;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.faf.engine.task.impl.FAFSimpleDataSyncTask;
import kd.macc.faf.helper.EntityMetaHelper;
import kd.macc.faf.rdb.RdbSQLSplitTaskIterator;
import kd.macc.faf.stream.pipe.IExceptionListener;
import kd.macc.faf.util.CalculateCondition;

public class FAFAiBizVoucherDataSyncTask
extends FAFSimpleDataSyncTask {
    private static final String ALGO_KEY = "PAAiBizVoucherDataSyncTask.processQueryReader";
    protected Map<String, String> subEntryValueMap;
    protected Map<String, String> flexFieldMap;
    protected RowMeta rowMeta;

    public FAFAiBizVoucherDataSyncTask(Serializable taskKey, Serializable version, IExceptionListener exceptionListener, MainEntityType outputDynEntity, RdbSQLSplitTaskIterator splitTaskIterator, Map<String, String> fieldMappings, Map<String, Object> defaultValueMap, int totalStatisticsPoints, Long analysisModelId, Map<String, CalculateCondition> conditionMap) {
        super(taskKey, version, exceptionListener, outputDynEntity, splitTaskIterator, fieldMappings, defaultValueMap, totalStatisticsPoints, analysisModelId, conditionMap);
    }

    public FAFAiBizVoucherDataSyncTask(Serializable taskKey, Serializable version, IExceptionListener exceptionListener, MainEntityType outputDynEntity, RdbSQLSplitTaskIterator splitTaskIterator, Map<String, String> fieldMappings, Map<String, Object> defaultValueMap, int totalStatisticsPoints, Long analysisModelId, Map<String, CalculateCondition> conditionMap, Map<String, String> subEntryValueMap, Map<String, String> flexFieldMap) {
        super(taskKey, version, exceptionListener, outputDynEntity, splitTaskIterator, fieldMappings, defaultValueMap, totalStatisticsPoints, analysisModelId, conditionMap);
        this.subEntryValueMap = subEntryValueMap;
        this.flexFieldMap = flexFieldMap;
    }

    @Override
    public void initializeTaskJob() {
        final HashSet<String> flexFieldSet = new HashSet<String>(Arrays.asList(this.splitTaskIterator.getSelectFields().split(",")));
        this.flexProperty = EntityMetaHelper.matchFlexProperty("ai_bizvoucher").stream().filter(new Predicate<String>(){

            @Override
            public boolean test(String s) {
                return flexFieldSet.contains(s);
            }
        }).collect(Collectors.toList());
        super.initializeTaskJob();
        this.rowMeta = ORM.create().createRowMeta(this.outputDynEntity.getName(), String.join((CharSequence)",", this.outputDynEntity.getAllFields().keySet()));
    }

    @Override
    public long processQueryReader(QFilter[] qFilter, DataSet dataSet) {
        int saveCount = 0;
        String sourceNumber = this.splitTaskIterator.getEntityNumber();
        boolean ifVoucherSubEntry = StringUtils.isNotEmpty((String)this.splitTaskIterator.getSubEntryFields());
        if (dataSet.hasNext()) {
            try (DataSet dssource = dataSet;
                 DataSet dsglassist = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)"gl_assist", (String)"id,assvals", null, null);
                 DataSet resultDataSet = this.leftJoinList(dssource, dsglassist, this.flexProperty);){
                HashMap<Long, Integer> writeDataIndex = new HashMap<Long, Integer>(this.batchCount);
                Object[] writeDataBuffer = new DynamicObject[this.batchCount];
                long[] targetIds = DBServiceHelper.genLongIds((String)("t_" + this.outputDynEntity.getName()), (int)this.batchCount);
                boolean hasCreateTimeField = EntityMetadataCache.getDataEntityType((String)this.outputDynEntity.getName()).getProperty("createtime") != null;
                Date now = new Date();
                int row = 0;
                Long entryEntityId = null;
                Long entityIdCache = null;
                DynamicObject dynObj = null;
                while (resultDataSet.hasNext()) {
                    Row next = resultDataSet.next();
                    Long entryId = next.getLong("entryentity.id");
                    Long sourceId = next.getLong("id");
                    if (entryId.equals(entryEntityId) && sourceId.equals(entityIdCache)) continue;
                    entryEntityId = entryId;
                    entityIdCache = sourceId;
                    if (dynObj != null && row == writeDataBuffer.length) {
                        if (ifVoucherSubEntry) {
                            this.disposeSubEntryData(sourceNumber, writeDataIndex, (DynamicObject[])writeDataBuffer);
                        }
                        this.saveBufferRecords(writeDataBuffer);
                        writeDataBuffer = new DynamicObject[this.batchCount];
                        writeDataIndex = new HashMap(this.batchCount);
                        targetIds = DBServiceHelper.genLongIds((String)("t_" + this.outputDynEntity.getName()), (int)this.batchCount);
                        row = 0;
                    }
                    ++saveCount;
                    dynObj = new DynamicObject((DynamicObjectType)this.outputDynEntity);
                    writeDataIndex.put(entryEntityId, row);
                    long targetId = targetIds[row];
                    writeDataBuffer[row++] = dynObj;
                    for (Map.Entry entry : this.defaultValueMap.entrySet()) {
                        dynObj.set((String)entry.getKey(), entry.getValue());
                    }
                    this.setConditionValue(next, dynObj);
                    dynObj.set("id", (Object)targetId);
                    dynObj.set("del", (Object)this.taskKey);
                    if (hasCreateTimeField) {
                        dynObj.set("createtime", (Object)now);
                    }
                    for (int i = 0; i < this.outputDimDynProps.length; ++i) {
                        this.outputDimDynProps[i].setValueFast((Object)dynObj, next.get((String)this.sourceFieldNames.get(i)));
                    }
                    ArrayList<Map> flexFieldList = new ArrayList<Map>(this.flexProperty.size());
                    for (String string : this.flexProperty) {
                        String flexFieldValue = next.getString(string + "assvals");
                        if (StringUtils.isNotEmpty((String)flexFieldValue)) {
                            Map flexFieldMap = (Map)SerializationUtils.fromJsonString((String)flexFieldValue, Map.class);
                            flexFieldList.add(flexFieldMap);
                            continue;
                        }
                        flexFieldList.add(new HashMap(1));
                    }
                    if (!flexFieldList.isEmpty()) {
                        for (Map.Entry entry : this.flexFieldMap.entrySet()) {
                            for (int i = 0; i < this.flexProperty.size(); ++i) {
                                String flex = (String)this.flexProperty.get(i);
                                if (!((String)entry.getKey()).startsWith(flex)) continue;
                                dynObj.set((String)entry.getValue(), ((Map)flexFieldList.get(i)).get(((String)entry.getKey()).substring(flex.length() + 1)));
                            }
                        }
                    }
                    if (!ifVoucherSubEntry) {
                        this.setRelationShipValue(dynObj);
                    }
                    dynObj.set("sourceformid", (Object)sourceNumber);
                    dynObj.set("sourcebillid", (Object)sourceId);
                    dynObj.set("createstamp", (Object)System.currentTimeMillis());
                }
                if (row > 0) {
                    if (ifVoucherSubEntry) {
                        this.disposeSubEntryData(sourceNumber, writeDataIndex, (DynamicObject[])writeDataBuffer);
                    }
                    this.saveBufferRecords(Arrays.copyOf(writeDataBuffer, row));
                }
            }
        }
        return saveCount;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void disposeSubEntryData(String sourceNumber, Map<Long, Integer> writeDataIndex, DynamicObject[] writeDataBuffer) {
        Long entryId = null;
        DynamicObject dynObj = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"task.impl.PAAiBizVoucherDataSyncTask", (String)sourceNumber, (String)this.splitTaskIterator.getSubEntryFields(), (QFilter[])new QFilter[]{new QFilter("entryentity.id", "in", writeDataIndex.keySet())}, null);){
            while (dataSet.hasNext()) {
                String flexField;
                String targetField;
                Row next = dataSet.next();
                Long tempEntryId = next.getLong("entryentity.id");
                if (!tempEntryId.equals(entryId)) {
                    entryId = tempEntryId;
                    dynObj = writeDataBuffer[writeDataIndex.get(entryId)];
                }
                if ((targetField = this.subEntryValueMap.get(flexField = next.getString("entryentity.subentryentity.flexfield"))) == null || dynObj == null) continue;
                if (DataType.BigDecimalType.equals((Object)this.rowMeta.getField(targetField).getDataType())) {
                    try {
                        BigDecimal value = new BigDecimal(next.getString("entryentity.subentryentity.value"));
                        dynObj.set(targetField, (Object)value);
                        continue;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                dynObj.set(targetField, (Object)next.getString("entryentity.subentryentity.value"));
            }
        }
        Iterator<Integer> iterator = writeDataIndex.values().iterator();
        while (iterator.hasNext()) {
            Integer index = iterator.next();
            this.setRelationShipValue(writeDataBuffer[index]);
        }
        return;
    }
}

