/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.engine.task.impl;

import java.io.Serializable;
import java.util.concurrent.Callable;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.faf.engine.task.IDataAbstractParallelWorkTaskGroup;
import kd.macc.faf.engine.task.IDataAbstractWorkTask;
import kd.macc.faf.engine.task.status.FAFWorkTaskStatusConsumer;
import kd.macc.faf.engine.task.status.IDataSimpleWorkTaskStatisticStatus;
import kd.macc.faf.engine.task.status.IDataWorkTaskStatusMgr;
import kd.macc.faf.handle.IFAFDataHandler;
import kd.macc.faf.model.impl.ThreeValueTuple;
import kd.macc.faf.rdb.RdbSQLAbstractCalculateIterator;
import kd.macc.faf.rdb.RdbSQLInfo;
import kd.macc.faf.stream.pipe.IExceptionListener;

public class FAFCalculateWorkTaskGroup
extends IDataAbstractParallelWorkTaskGroup<Long, Callable<Long>, IDataSimpleWorkTaskStatisticStatus> {
    private static final Log logger = LogFactory.getLog(FAFCalculateWorkTaskGroup.class);
    boolean multipleSQLQuery;
    RdbSQLAbstractCalculateIterator calculateIterator;
    IFAFDataHandler<Long> calculateHandler;

    protected FAFCalculateWorkTaskGroup(Serializable taskKey, Serializable version, IExceptionListener exceptionListener, RdbSQLAbstractCalculateIterator calculateIterator, IFAFDataHandler<Long> calculateHandler) {
        super(taskKey, version, exceptionListener);
        this.calculateIterator = calculateIterator;
        this.multipleSQLQuery = calculateIterator.isMultipleSQLQuery();
        this.calculateHandler = calculateHandler;
        this.taskResult = 0L;
    }

    protected FAFCalculateWorkTaskGroup(Serializable taskKey, Serializable version, RdbSQLAbstractCalculateIterator calculateIterator, IFAFDataHandler<Long> calculateHandler) {
        super(taskKey, version, null);
        this.calculateIterator = calculateIterator;
        this.multipleSQLQuery = calculateIterator.isMultipleSQLQuery();
        this.calculateHandler = calculateHandler;
        this.taskResult = 0L;
    }

    @Override
    protected Long doTaskJob() {
        this.realTask();
        return (Long)this.taskResult;
    }

    void realTask() {
        String outputDynEntity = this.calculateIterator.getEntityNumber();
        if (logger.isInfoEnabled()) {
            logger.info(String.format("Start Do Task Job: multipleSQLQuery=%s, outputDynEntity=%s", this.multipleSQLQuery, outputDynEntity));
        }
        this.updateTaskStatistics(0, 0, 0);
        if (this.multipleSQLQuery) {
            this.taskResult = super.doTaskJob();
        } else {
            this.initializeTaskJob();
            Callable<Long> singleQueryWorkTask = this.createOlapQuerySubTask("RdbInnerSingleQueryTask", this.calculateIterator.next());
            this.executeSubTask(0, new ThreeValueTuple<Callable<Long>, Boolean, Boolean>(singleQueryWorkTask, Boolean.FALSE, Boolean.FALSE));
        }
        if (logger.isInfoEnabled()) {
            logger.info(String.format("Complete Do Task Job on [%sms]: multipleSQLQuery=%s, outputDynEntity=%s, taskResult=%s", this.getTaskExecutionTime(), this.multipleSQLQuery, outputDynEntity, this.taskResult));
        }
    }

    protected Callable<Long> createOlapQuerySubTask(String taskTypeName, final RdbSQLInfo rdbSQLInfo) {
        return new IDataAbstractWorkTask<Long>((Object)taskTypeName, this.subTaskExceptionListener){
            RdbSQLInfo _subTaskSqlBuilder;
            IFAFDataHandler<Long> _subCalculateHandler;
            {
                super(taskKey, exceptionListener);
                this._subTaskSqlBuilder = rdbSQLInfo;
                this._subCalculateHandler = FAFCalculateWorkTaskGroup.this.calculateHandler;
            }

            @Override
            protected Long doTaskJob() {
                if (this._subTaskSqlBuilder == null) {
                    return 0L;
                }
                return this._subCalculateHandler.handle(this._subTaskSqlBuilder);
            }
        };
    }

    @Override
    protected ThreeValueTuple<Callable<Long>, Boolean, Boolean> doGetNextSubTask() {
        RdbSQLInfo curRdbSQLInfo = this.calculateIterator.next();
        if (curRdbSQLInfo == null) {
            return null;
        }
        return new ThreeValueTuple<Callable<Long>, Boolean, Boolean>(this.createOlapQuerySubTask("RDBInnerMultiQueryTask", curRdbSQLInfo), Boolean.FALSE, Boolean.TRUE);
    }

    @Override
    protected Long processTaskResult(int taskIndex, Callable<Long> task, Object taskResult) {
        FAFCalculateWorkTaskGroup fAFCalculateWorkTaskGroup = this;
        fAFCalculateWorkTaskGroup.taskResult = (Long)fAFCalculateWorkTaskGroup.taskResult + (taskResult != null ? (Long)taskResult : 0L);
        return fAFCalculateWorkTaskGroup.taskResult;
    }

    @Override
    public boolean hasSubTask() {
        return this.multipleSQLQuery && this.calculateIterator.hasNext() && !this.isCancelled();
    }

    protected void updateTaskStatistics(int fetchDataCnt, int processDataCnt, int skipErrorDataCnt) {
        IDataSimpleWorkTaskStatisticStatus workTaskStatusEvent = (IDataSimpleWorkTaskStatisticStatus)this.getWorkTaskStatusEvent();
        try {
            this.getWorkTaskStatusMgr().updateTaskStatus(workTaskStatusEvent);
        }
        catch (InterruptedException e) {
            throw new KDBizException((Throwable)e, new ErrorCode(ResManager.loadKDString((String)"\u66f4\u65b0\u53d6\u6570\u4efb\u52a1\u6761\u6570\u5931\u8d25", (String)"FAFCalculateWorkTaskGroup_0", (String)"macc-faf-common", (Object[])new Object[0]), e.getMessage()), new Object[0]);
        }
    }

    @Override
    protected IDataWorkTaskStatusMgr getWorkTaskStatusMgr() {
        return FAFWorkTaskStatusConsumer.getInstance();
    }
}

