/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.engine.task.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.RefProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractElement;
import kd.bos.metadata.entity.businessfield.AssistantField;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.CreateDateField;
import kd.bos.metadata.entity.commonfield.BigIntField;
import kd.bos.metadata.entity.commonfield.DateTimeField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.faf.engine.model.FAFWorkTaskMeta;
import kd.macc.faf.engine.model.IWorkTaskTransLog;
import kd.macc.faf.engine.task.IDataAbstractWorkTask;
import kd.macc.faf.enums.FAFDimensionTypeEnum;
import kd.macc.faf.enums.FAFSyncLogStatusEnum;
import kd.macc.faf.helper.EntityMetaHelper;
import kd.macc.faf.model.impl.IDataMapEntry;
import kd.macc.faf.util.AnalysisModelUtil;
import kd.macc.faf.util.CustomizedDynamicFormBuilderUtil;
import kd.macc.faf.util.CustomizedFormBuilderInfo;
import org.apache.commons.lang3.StringUtils;

public class FAFDataEntityCreateTask
extends IDataAbstractWorkTask<Object> {
    private static Log log = LogFactory.getLog(FAFDataEntityCreateTask.class);
    private IWorkTaskTransLog transLog;

    public FAFDataEntityCreateTask(IWorkTaskTransLog transLog) {
        super(FAFDataEntityCreateTask.class.getSimpleName());
        this.transLog = transLog;
    }

    @Override
    public void run() {
        this.doTaskJob();
    }

    @Override
    protected Object doTaskJob() {
        if (this.transLog == null) {
            return null;
        }
        IDataMapEntry<FAFSyncLogStatusEnum, String> iDataMapEntry = null;
        FAFWorkTaskMeta meta = (FAFWorkTaskMeta)this.transLog;
        iDataMapEntry = this.createTable(meta.getAnalysisModelId(), meta.getTableNumber(), meta.getTableName(), meta.isOnlyDetailTable());
        return iDataMapEntry;
    }

    private IDataMapEntry<FAFSyncLogStatusEnum, String> createTable(Long analysisModelId, String inputTableNumber, String inputTableName, boolean onlyDetail) {
        IDataMapEntry<FAFSyncLogStatusEnum, String> result = new IDataMapEntry<FAFSyncLogStatusEnum, String>(FAFSyncLogStatusEnum.FAILURE, "failure");
        DynamicObject analysisModel = BusinessDataServiceHelper.loadSingle((Object)analysisModelId, (String)"pa_analysismodel");
        if (analysisModel != null) {
            String inputTableName_dtl;
            if (inputTableNumber.endsWith("_") || inputTableNumber.startsWith("_")) {
                throw new KDBizException(ResManager.loadKDString((String)"\u201d\u7f16\u53f7\u201c\u4e0d\u80fd\u4ee5\u4e0b\u5212\u7ebf\u5f00\u5934\u6216\u7ed3\u5c3e\u3002", (String)"FAFDataEntityCreateTask_16", (String)"macc-faf-common", (Object[])new Object[0]));
            }
            String tableNumber_dtl = inputTableNumber + "_d";
            result = this.createTable(analysisModel, tableNumber_dtl, inputTableName_dtl = String.format(ResManager.loadKDString((String)"%s_\u660e\u7ec6\u8868", (String)"FAFDataEntityCreateTask_15", (String)"macc-faf-common", (Object[])new Object[0]), inputTableName), true);
            if (FAFSyncLogStatusEnum.SUCCESS == result.getKey() && !onlyDetail) {
                result = this.createTable(analysisModel, inputTableNumber, inputTableName, false);
            }
        }
        return result;
    }

    private IDataMapEntry<FAFSyncLogStatusEnum, String> createTable(DynamicObject analysisModel, String inputTableNumber, String formName, boolean isDetail) {
        IDataMapEntry<FAFSyncLogStatusEnum, String> result = new IDataMapEntry<FAFSyncLogStatusEnum, String>(FAFSyncLogStatusEnum.FAILURE, "failure");
        if (analysisModel != null) {
            String formId = AnalysisModelUtil.buildEntityNumber(inputTableNumber.toLowerCase());
            try {
                CustomizedFormBuilderInfo builderInfo = FAFDataEntityCreateTask.getCustomizedFormBuilderInfo(formId, formName, analysisModel, isDetail);
                CustomizedDynamicFormBuilderUtil.checkDesignerDataSaveResult(builderInfo, CustomizedDynamicFormBuilderUtil.SaveEntityPage(builderInfo, Boolean.TRUE), true);
                result = new IDataMapEntry<FAFSyncLogStatusEnum, String>(FAFSyncLogStatusEnum.SUCCESS, "success");
            }
            catch (Exception ex) {
                log.info("MACC-createTable\uff1a \u521b\u5efa\u6a21\u578b\u5931\u8d25-- isDetail: " + isDetail + " message:" + ex.getMessage());
                result = new IDataMapEntry<FAFSyncLogStatusEnum, String>(FAFSyncLogStatusEnum.FAILURE, ex.getMessage());
            }
        }
        return result;
    }

    public static IDataMapEntry<FAFSyncLogStatusEnum, String> rebuildMeta(DynamicObject analysisModel, String inputTableNumber, String formName, boolean isDetail, Boolean ifNewPage) {
        IDataMapEntry<FAFSyncLogStatusEnum, String> result = new IDataMapEntry<FAFSyncLogStatusEnum, String>(FAFSyncLogStatusEnum.FAILURE, "failure");
        if (analysisModel != null) {
            String formId = AnalysisModelUtil.buildEntityNumber(inputTableNumber.toLowerCase());
            try {
                CustomizedFormBuilderInfo builderInfo = FAFDataEntityCreateTask.getCustomizedFormBuilderInfo(formId, formName, analysisModel, isDetail);
                boolean saveStatus = CustomizedDynamicFormBuilderUtil.checkDesignerDataSaveResult(builderInfo, CustomizedDynamicFormBuilderUtil.SaveEntityPage(builderInfo, ifNewPage), true);
                result = new IDataMapEntry<FAFSyncLogStatusEnum, String>(saveStatus ? FAFSyncLogStatusEnum.SUCCESS : FAFSyncLogStatusEnum.FAILURE, String.valueOf(saveStatus));
            }
            catch (Exception ex) {
                log.info("MACC-createTable\uff1a \u521b\u5efa\u6a21\u578b\u5931\u8d25-- isDetail: " + isDetail + " message:" + ex.getMessage());
                result = new IDataMapEntry<FAFSyncLogStatusEnum, String>(FAFSyncLogStatusEnum.FAILURE, ex.getMessage());
            }
        }
        return result;
    }

    private static CustomizedFormBuilderInfo getCustomizedFormBuilderInfo(String formId, String formName, DynamicObject analysisModel, boolean isDetail) {
        String fieldName;
        CustomizedFormBuilderInfo builderInfo = CustomizedDynamicFormBuilderUtil.createCustomizedFormBuilderInfo(formId, formName, "2UK0B8T0A=WJ", "BaseFormModel");
        builderInfo.setBizUnitId("2XF5B1YXIBCY");
        builderInfo.setDbRoute("fias");
        FAFDataEntityCreateTask.addExtraField(builderInfo, "del", ResManager.loadKDString((String)"\u6807\u8bb0\u5220\u9664", (String)"FAFDataEntityCreateTask_0", (String)"macc-faf-common", (Object[])new Object[0]), 0, "0", BigIntField.class);
        FAFDataEntityCreateTask.addExtraField(builderInfo, "collectstatus", ResManager.loadKDString((String)"\u6c47\u603b\u72b6\u6001", (String)"FAFDataEntityCreateTask_1", (String)"macc-faf-common", (Object[])new Object[0]), 0, "0", BigIntField.class);
        FAFDataEntityCreateTask.addExtraField(builderInfo, "createtime", ResManager.loadKDString((String)"\u521b\u5efa\u65f6\u95f4", (String)"FAFDataEntityCreateTask_2", (String)"macc-faf-common", (Object[])new Object[0]), 0, "", CreateDateField.class);
        FAFDataEntityCreateTask.addExtraField(builderInfo, "operationstatus", ResManager.loadKDString((String)"\u64cd\u4f5c\u72b6\u6001", (String)"FAFDataEntityCreateTask_3", (String)"macc-faf-common", (Object[])new Object[0]), 0, "0", BigIntField.class);
        FAFDataEntityCreateTask.addExtraField(builderInfo, "offstatus", ResManager.loadKDString((String)"\u51b2\u9500\u72b6\u6001", (String)"FAFDataEntityCreateTask_4", (String)"macc-faf-common", (Object[])new Object[0]), 0, "0", BigIntField.class);
        FAFDataEntityCreateTask.addExtraField(builderInfo, "datastatus", ResManager.loadKDString((String)"\u6570\u636e\u72b6\u6001", (String)"FAFDataEntityCreateTask_5", (String)"macc-faf-common", (Object[])new Object[0]), 0, "0", BigIntField.class);
        FAFDataEntityCreateTask.addExtraField(builderInfo, "importbatch", ResManager.loadKDString((String)"\u5bfc\u5165\u6279\u6b21\u53f7", (String)"FAFDataEntityCreateTask_6", (String)"macc-faf-common", (Object[])new Object[0]), 255, "", TextField.class);
        FAFDataEntityCreateTask.addExtraField(builderInfo, "situationtype", ResManager.loadKDString((String)"\u9884\u7b97\u7c7b\u578b", (String)"FAFDataEntityCreateTask_7", (String)"macc-faf-common", (Object[])new Object[0]), 0, "0", BigIntField.class);
        FAFDataEntityCreateTask.addExtraField(builderInfo, "dimhash", ResManager.loadKDString((String)"\u591a\u7ef4\u5ea6\u54c8\u5e0c\u503c", (String)"FAFDataEntityCreateTask_17", (String)"macc-faf-common", (Object[])new Object[0]), 16, "", TextField.class);
        if (isDetail) {
            FAFDataEntityCreateTask.addExtraField(builderInfo, "createstamp", ResManager.loadKDString((String)"\u521b\u5efa\u65f6\u95f4\u6233", (String)"FAFDataEntityCreateTask_8", (String)"macc-faf-common", (Object[])new Object[0]), 0, "0", BigIntField.class);
            FAFDataEntityCreateTask.addExtraField(builderInfo, "summaryid", ResManager.loadKDString((String)"\u6c47\u603bID", (String)"FAFDataEntityCreateTask_9", (String)"macc-faf-common", (Object[])new Object[0]), 0, "0", BigIntField.class);
            FAFDataEntityCreateTask.addExtraField(builderInfo, "sourceformid", ResManager.loadKDString((String)"\u6570\u636e\u6765\u6e90formID", (String)"FAFDataEntityCreateTask_10", (String)"macc-faf-common", (Object[])new Object[0]), 255, " ", TextField.class);
            FAFDataEntityCreateTask.addExtraField(builderInfo, "sourcebillid", ResManager.loadKDString((String)"\u6570\u636e\u6765\u6e90PKID", (String)"FAFDataEntityCreateTask_11", (String)"macc-faf-common", (Object[])new Object[0]), 0, "0", BigIntField.class);
            FAFDataEntityCreateTask.addExtraField(builderInfo, "execlogid", ResManager.loadKDString((String)"\u4e00\u7ea7\u6267\u884c\u65e5\u5fd7ID", (String)"FAFDataEntityCreateTask_12", (String)"macc-faf-common", (Object[])new Object[0]), 0, "0", BigIntField.class);
            FAFDataEntityCreateTask.addExtraField(builderInfo, "subexeclogid", ResManager.loadKDString((String)"\u4e8c\u7ea7\u6267\u884c\u65e5\u5fd7ID", (String)"FAFDataEntityCreateTask_13", (String)"macc-faf-common", (Object[])new Object[0]), 0, "0", BigIntField.class);
            FAFDataEntityCreateTask.addExtraField(builderInfo, "execparentbillid", ResManager.loadKDString((String)"\u64cd\u4f5c\u6267\u884c\u7236\u5355\u636eID", (String)"FAFDataEntityCreateTask_14", (String)"macc-faf-common", (Object[])new Object[0]), 0, "0", BigIntField.class);
        }
        DynamicObjectCollection dimEntries = analysisModel.getDynamicObjectCollection("dimension_entry");
        Object[] uniteIndexs = new String[3];
        for (Object dimEntry : dimEntries) {
            DynamicObject dimension = dimEntry.getDynamicObject("dimension");
            String fieldNumber = dimension.getString("number");
            if (FAFDataEntityCreateTask.ifExistField(builderInfo, fieldNumber)) continue;
            fieldName = dimension.getString("name");
            FAFDimensionTypeEnum dimensionType = FAFDimensionTypeEnum.getEnum(dimension.getString("dimensiontype"));
            String necessityDim = dimEntry.getString("necessity_dim");
            switch (dimensionType) {
                case DATABASE: 
                case PERIOD: {
                    List<RefProp> refProps = Arrays.stream(dimEntry.getString("field_number_tag").split(",")).map(RefProp::new).collect(Collectors.toList());
                    String baseNumber = dimension.getString("dimensionsource.number");
                    builderInfo.addField(BasedataField.class, fieldNumber, fieldName, baseNumber, null, refProps);
                    break;
                }
                case ASSISTANTDATA: {
                    List<RefProp> refProps = Arrays.stream(dimEntry.getString("field_number_tag").split(",")).map(RefProp::new).collect(Collectors.toList());
                    String baseNumber = dimension.getString("assistantsource.number");
                    String assistTypeId = dimension.getString("assistantsource.id");
                    builderInfo.addField(AssistantField.class, fieldNumber, fieldName, baseNumber, assistTypeId, refProps);
                    break;
                }
                case OTHER: {
                    builderInfo.addTextField(fieldNumber, fieldName, 255, "");
                    break;
                }
                case DATE: {
                    builderInfo.addField(DateTimeField.class, fieldNumber, fieldName, "");
                    break;
                }
                case DENUMS: {
                    Long dimensionId = dimension.getLong("id");
                    dimension = BusinessDataServiceHelper.loadSingleFromCache((Object)dimensionId, (String)"pa_dimension");
                    HashMap<String, String> comItemMap = new HashMap<String, String>(10);
                    DynamicObjectCollection enums = dimension.getDynamicObjectCollection("entryentityenums");
                    for (DynamicObject anEnum : enums) {
                        comItemMap.put(anEnum.getString("title"), anEnum.getString("value"));
                    }
                    builderInfo.addComboField(fieldNumber, fieldName, "", comItemMap);
                    break;
                }
            }
            if (!"0".equals(necessityDim) && !"1".equals(necessityDim)) continue;
            uniteIndexs[Integer.parseInt((String)necessityDim)] = 'f' + fieldNumber;
        }
        DynamicObjectCollection measureEntries = analysisModel.getDynamicObjectCollection("measure_entry");
        for (DynamicObject measureEntry : measureEntries) {
            DynamicObject measure = measureEntry.getDynamicObject("measure");
            fieldName = measure.getString("name");
            String fieldNumber = measure.getString("number");
            if (FAFDataEntityCreateTask.ifExistField(builderInfo, fieldNumber)) continue;
            builderInfo.addDecimalField(fieldNumber, fieldName, null);
        }
        HashMap<String, String> tableIndexMap = new HashMap<String, String>(4);
        if (isDetail) {
            uniteIndexs[2] = "foperationstatus";
            tableIndexMap.put("idx_" + formId + "_opo", StringUtils.join((Object[])uniteIndexs, (String)","));
            tableIndexMap.put("idx_" + formId + "summaryid", "fsummaryid");
            tableIndexMap.put("idx_" + formId + "_sp", String.format("f%1$s,f%2$s", "subexeclogid", "execparentbillid"));
        } else {
            uniteIndexs[2] = "fimportbatch";
            tableIndexMap.put("idx_" + formId + "_opi", StringUtils.join((Object[])uniteIndexs, (String)","));
        }
        tableIndexMap.put("idx_" + formId + "dimhash", "fdimhash");
        builderInfo.setTableIndexMap(tableIndexMap);
        builderInfo.setDeveloper(true);
        EntityMetaHelper.constructMetadataList(builderInfo, analysisModel);
        return builderInfo;
    }

    public static void addExtraField(CustomizedFormBuilderInfo builderInfo, String fieldNumber, String fieldName, int maxLength, String defaultValue, Class<? extends Field> fieldTypeClass) {
        Set infoKeys;
        List items = builderInfo.getEntityMeta().getItems();
        if (items != null && !(infoKeys = items.stream().map(AbstractElement::getKey).collect(Collectors.toSet())).contains(fieldNumber)) {
            if (fieldTypeClass.equals(CreateDateField.class)) {
                builderInfo.addField(CreateDateField.class, fieldNumber, fieldName, defaultValue);
            } else if (fieldTypeClass.equals(BigIntField.class)) {
                builderInfo.addBigIntField(fieldNumber, fieldName, defaultValue);
            } else if (fieldTypeClass.equals(TextField.class)) {
                builderInfo.addTextField(fieldNumber, fieldName, maxLength, defaultValue);
            } else if (fieldTypeClass.equals(DecimalField.class)) {
                builderInfo.addDecimalField(fieldNumber, fieldName, defaultValue);
            }
        }
    }

    public static boolean ifExistField(CustomizedFormBuilderInfo builderInfo, String fieldNumber) {
        List items = builderInfo.getEntityMeta().getItems();
        if (items != null) {
            Set infoKeys = items.stream().map(AbstractElement::getKey).collect(Collectors.toSet());
            return infoKeys.contains(fieldNumber);
        }
        return false;
    }
}

