/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.engine.task.impl;

import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.faf.engine.model.FAFWorkTaskMeta;
import kd.macc.faf.engine.model.IWorkTaskTransLog;
import kd.macc.faf.engine.task.IDataAbstractWorkTask;
import kd.macc.faf.enums.FAFSyncLogStatusEnum;
import kd.macc.faf.model.impl.IDataMapEntry;
import kd.macc.faf.util.AnalysisModelUtil;
import kd.macc.faf.util.CustomizedDynamicFormBuilderUtil;

public class FAFDataEntityDeleteTask
extends IDataAbstractWorkTask<Object> {
    private static Log log = LogFactory.getLog(FAFDataEntityDeleteTask.class);
    private IWorkTaskTransLog transLog;

    public FAFDataEntityDeleteTask(IWorkTaskTransLog transLog) {
        super(FAFDataEntityDeleteTask.class.getSimpleName());
        this.transLog = transLog;
    }

    @Override
    public void run() {
        this.doTaskJob();
    }

    @Override
    protected Object doTaskJob() {
        if (this.transLog == null) {
            return null;
        }
        IDataMapEntry<FAFSyncLogStatusEnum, String> iDataMapEntry = null;
        FAFWorkTaskMeta meta = (FAFWorkTaskMeta)this.transLog;
        iDataMapEntry = this.dropTable(meta.getTableNumber());
        return iDataMapEntry;
    }

    private IDataMapEntry<FAFSyncLogStatusEnum, String> dropTable(String tableNumber) {
        CustomizedDynamicFormBuilderUtil.deleteForm(AnalysisModelUtil.buildEntityNumber(tableNumber.toLowerCase()), true);
        CustomizedDynamicFormBuilderUtil.deleteForm(AnalysisModelUtil.buildDetailEntityNumber(tableNumber.toLowerCase()), true);
        return new IDataMapEntry<FAFSyncLogStatusEnum, String>(FAFSyncLogStatusEnum.SUCCESS, "success");
    }
}

