/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.engine.task.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dlock.DLock;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.faf.engine.task.impl.FAFAiBizVoucherDataSyncTask;
import kd.macc.faf.engine.task.impl.FAFDataSyncWorkTaskWrapper;
import kd.macc.faf.engine.task.impl.FAFGLVoucherDataSyncTask;
import kd.macc.faf.engine.task.impl.FAFSimpleDataSyncTask;
import kd.macc.faf.helper.DLockHelper;
import kd.macc.faf.helper.EntityMetaHelper;
import kd.macc.faf.model.impl.ThreeValueTuple;
import kd.macc.faf.rdb.RdbSQLSplitTaskIterator;
import kd.macc.faf.util.CalculateCondition;

public class FAFDataExtractingTask
extends FAFSimpleDataSyncTask {
    private static final Log logger = LogFactory.getLog(FAFDataExtractingTask.class);
    private final Map<String, String> subEntryValueMap = new HashMap<String, String>(32);
    private final Map<String, String> flexFieldMap = new HashMap<String, String>(32);

    protected FAFDataExtractingTask(Serializable taskKey, Serializable version, MainEntityType outputDynEntity, RdbSQLSplitTaskIterator splitTaskIterator, Map<String, String> fieldMappings, Map<String, Object> defaultValueMap, int totalStatisticsPoints, Long analysisModelId, Map<String, CalculateCondition> conditionMap) {
        super(taskKey, version, null, outputDynEntity, splitTaskIterator, fieldMappings, defaultValueMap, totalStatisticsPoints, analysisModelId, conditionMap);
        if ("ai_bizvoucher".equals(splitTaskIterator.getEntityNumber())) {
            final HashSet<String> flexFieldSet = new HashSet<String>(Arrays.asList(splitTaskIterator.getSelectFields().split(",")));
            this.flexProperty = EntityMetaHelper.matchFlexProperty("ai_bizvoucher").stream().filter(new Predicate<String>(){

                @Override
                public boolean test(String s) {
                    return flexFieldSet.contains(s);
                }
            }).collect(Collectors.toList());
            Iterator<Map.Entry<String, String>> iterator = fieldMappings.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> next = iterator.next();
                String sourceValue = next.getValue();
                if (sourceValue.startsWith("dim_")) {
                    this.subEntryValueMap.put(sourceValue.substring("dim_".length()), next.getKey());
                    iterator.remove();
                    continue;
                }
                if (!this.flexProperty.contains(sourceValue.split("_")[0])) continue;
                this.flexFieldMap.put(sourceValue, next.getKey());
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Long doTaskJob() {
        String lockKey = DLockHelper.getMLockKey(this.outputDynEntity.getName());
        try (DLock dLock = DLock.create((String)lockKey);){
            if (dLock.tryLock(1000L)) {
                try {
                    Long l = super.doTaskJobNoLock();
                    return l;
                }
                finally {
                    dLock.unlock();
                }
            }
            logger.info("BusinessTask TryLock error!");
        }
        this.onException(new KDBizException(new ErrorCode("fi.pa.common.engine.PADataExtractingTask", "BusinessTask TryLock error!"), new Object[0]));
        return (Long)this.taskResult;
    }

    @Override
    public ThreeValueTuple<Callable<Long>, Boolean, Boolean> doGetNextSubTask() {
        ThreeValueTuple<Callable<Long>, Boolean, Boolean> resultTask;
        String entityNumber;
        RdbSQLSplitTaskIterator nextQFilterIterator = this.splitTaskIterator.createNextQFilterIterator();
        switch (entityNumber = this.splitTaskIterator.getEntityNumber()) {
            case "ai_bizvoucher": {
                FAFAiBizVoucherDataSyncTask aiBizVoucherDataSyncTask = new FAFAiBizVoucherDataSyncTask(this.taskKey, this.version, this.exceptionListener, this.outputDynEntity, nextQFilterIterator, this.fieldMappings, this.defaultValueMap, this.totalStatisticsPoints, this.analysisModelId, this.conditionMap, this.subEntryValueMap, this.flexFieldMap);
                aiBizVoucherDataSyncTask.setTaskMeta(this.taskMeta);
                aiBizVoucherDataSyncTask.setUpdateReference(false);
                aiBizVoucherDataSyncTask.setRelationShipWritePosLookupService(this.getRelationShipWritePosLookupService());
                resultTask = new ThreeValueTuple<FAFDataSyncWorkTaskWrapper<Long>, Boolean, Boolean>(new FAFDataSyncWorkTaskWrapper<Long>(aiBizVoucherDataSyncTask, this.taskMeta, false), Boolean.TRUE, Boolean.FALSE);
                break;
            }
            case "gl_voucher": {
                FAFGLVoucherDataSyncTask glVoucherDataSyncTask = new FAFGLVoucherDataSyncTask(this.taskKey, this.version, this.exceptionListener, this.outputDynEntity, nextQFilterIterator, this.fieldMappings, this.defaultValueMap, this.totalStatisticsPoints, this.analysisModelId, this.conditionMap);
                glVoucherDataSyncTask.setTaskMeta(this.taskMeta);
                glVoucherDataSyncTask.setUpdateReference(false);
                glVoucherDataSyncTask.setRelationShipWritePosLookupService(this.getRelationShipWritePosLookupService());
                resultTask = new ThreeValueTuple<Callable<Long>, Boolean, Boolean>((Callable<Long>)new FAFDataSyncWorkTaskWrapper<Long>(glVoucherDataSyncTask, this.getTaskMeta(), false), Boolean.TRUE, Boolean.FALSE);
                break;
            }
            default: {
                FAFSimpleDataSyncTask simpleDataSyncTask = new FAFSimpleDataSyncTask(this.taskKey, this.version, this.exceptionListener, this.outputDynEntity, nextQFilterIterator, this.fieldMappings, this.defaultValueMap, this.totalStatisticsPoints, this.analysisModelId, this.conditionMap);
                simpleDataSyncTask.setTaskMeta(this.taskMeta);
                simpleDataSyncTask.setUpdateReference(false);
                simpleDataSyncTask.setRelationShipWritePosLookupService(this.getRelationShipWritePosLookupService());
                resultTask = new ThreeValueTuple<FAFDataSyncWorkTaskWrapper<Long>, Boolean, Boolean>(new FAFDataSyncWorkTaskWrapper<Long>(simpleDataSyncTask, this.taskMeta, false), Boolean.TRUE, Boolean.FALSE);
            }
        }
        return resultTask;
    }

    @Override
    protected void doTaskFinallyCleanUp(boolean isCancelled, boolean withError) {
        if (isCancelled || withError) {
            // empty if block
        }
    }
}

