/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.engine.task.impl;

import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedDeque;
import kd.bos.dlock.DLock;
import kd.macc.faf.engine.task.IDataAbstractParallelWorkTaskGroup;
import kd.macc.faf.engine.task.IDataWorkTask;
import kd.macc.faf.engine.task.IWorkTaskResultProcessor;
import kd.macc.faf.engine.task.status.FAFWorkTaskStatusConsumer;
import kd.macc.faf.engine.task.status.IDataSimpleWorkTaskStatisticStatus;
import kd.macc.faf.engine.task.status.IDataWorkTaskStatusMgr;
import kd.macc.faf.helper.DLockHelper;
import kd.macc.faf.model.impl.ThreeValueTuple;
import kd.macc.faf.stream.pipe.IExceptionListener;

public class FAFDataParallelWorkTaskGroup
extends IDataAbstractParallelWorkTaskGroup<Long, Callable<Long>, IDataSimpleWorkTaskStatisticStatus> {
    protected ConcurrentLinkedDeque<Callable> waitingSubTaskQueue = new ConcurrentLinkedDeque();
    private String detailEntityNumber;

    protected FAFDataParallelWorkTaskGroup(Serializable taskKey, Serializable version, IWorkTaskResultProcessor<IDataWorkTask> processTaskResultFunc, String detailEntityNumber) {
        super(taskKey, version, null);
        this.exceptionListener = ex -> this.onTaskError(ex);
        this.detailEntityNumber = detailEntityNumber;
    }

    protected FAFDataParallelWorkTaskGroup(Serializable taskKey, Serializable version, IWorkTaskResultProcessor<IDataWorkTask> processTaskResultFunc, String detailEntityNumber, IExceptionListener groupExceptionListener) {
        super(taskKey, version, null);
        this.exceptionListener = ex -> {
            if (groupExceptionListener != null) {
                groupExceptionListener.onError(ex);
            }
            return this.onTaskError(ex);
        };
        this.detailEntityNumber = detailEntityNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Long doTaskJob() {
        block15: {
            String lockKey = DLockHelper.getMLockKey(this.detailEntityNumber);
            try (DLock dLock = DLock.create((String)lockKey);){
                if (!dLock.tryLock(1000L)) break block15;
                try {
                    super.doTaskJob();
                }
                finally {
                    dLock.unlock();
                }
            }
        }
        return 0L;
    }

    @Override
    protected ThreeValueTuple<Callable<Long>, Boolean, Boolean> doGetNextSubTask() {
        return new ThreeValueTuple<Callable<Long>, Boolean, Boolean>(this.waitingSubTaskQueue.pop(), Boolean.FALSE, Boolean.TRUE);
    }

    @Override
    protected Long processTaskResult(int taskIndex, Callable<Long> task, Object taskResult) {
        if (taskResult instanceof Long) {
            if (this.taskResult != null) {
                FAFDataParallelWorkTaskGroup fAFDataParallelWorkTaskGroup = this;
                fAFDataParallelWorkTaskGroup.taskResult = (Long)fAFDataParallelWorkTaskGroup.taskResult + (Long)taskResult;
            } else {
                this.taskResult = 0L;
            }
        }
        return (Long)this.taskResult;
    }

    @Override
    public boolean hasSubTask() {
        return !this.waitingSubTaskQueue.isEmpty();
    }

    protected boolean onTaskError(Throwable exception) {
        this.exception = exception;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubTask(Callable<Long> subWorkTask, boolean updateReference) {
        if (subWorkTask != null) {
            if (updateReference && subWorkTask instanceof IDataWorkTask) {
                this.updateSubTaskReference((IDataWorkTask)subWorkTask);
            }
            this.waitingSubTaskQueue.add(subWorkTask);
            ConcurrentLinkedDeque<Callable> concurrentLinkedDeque = this.waitingSubTaskQueue;
            synchronized (concurrentLinkedDeque) {
                this.waitingSubTaskQueue.notifyAll();
            }
        }
    }

    @Override
    protected IDataWorkTaskStatusMgr getWorkTaskStatusMgr() {
        return FAFWorkTaskStatusConsumer.getInstance();
    }
}

