/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.engine.task.impl;

import java.io.Serializable;
import java.util.concurrent.Future;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.faf.engine.task.IDataSequenceWorkTaskGroup;
import kd.macc.faf.engine.task.IDataWorkTask;
import kd.macc.faf.engine.task.IDataWorkTaskManager;
import kd.macc.faf.engine.task.IFinallyTask;
import kd.macc.faf.engine.task.IWorkTaskResultProcessor;
import kd.macc.faf.engine.task.status.FAFWorkTaskStatusConsumer;
import kd.macc.faf.engine.task.status.IDataSimpleWorkTaskStatisticStatus;
import kd.macc.faf.engine.task.status.IDataWorkTaskStatusMgr;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class FAFDataSequenceWorkTaskGroup
extends IDataSequenceWorkTaskGroup<Long, IDataWorkTask, IDataSimpleWorkTaskStatisticStatus> {
    private static final Log logger = LogFactory.getLog(FAFDataSequenceWorkTaskGroup.class);
    protected IFinallyTask endingTask;

    public FAFDataSequenceWorkTaskGroup(Serializable taskKey, Serializable version) {
        super(taskKey, version, null);
        this.exceptionListener = this::onTaskError;
        this.updateReference = false;
        this.throwException = false;
    }

    public FAFDataSequenceWorkTaskGroup(Serializable taskKey, Serializable version, IWorkTaskResultProcessor<IDataWorkTask> processTaskResultFunc) {
        super(taskKey, version, processTaskResultFunc);
        this.exceptionListener = ex -> this.onTaskError(ex);
        if (this.workTaskStatusEvent == null && taskKey != null && this.getWorkTaskStatusMgr().getCachedWorkTaskStatusEvent(taskKey) == null) {
            IDataSimpleWorkTaskStatisticStatus workTaskStatusEvent = new IDataSimpleWorkTaskStatisticStatus(taskKey, version, this.calcTaskTotalStatisticsPoints());
            try {
                this.workTaskStatusEvent = workTaskStatusEvent;
                this.getWorkTaskStatusMgr().updateTaskStatus(workTaskStatusEvent);
            }
            catch (InterruptedException e) {
                throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
            }
        }
    }

    public FAFDataSequenceWorkTaskGroup(Serializable taskKey, Serializable version, IWorkTaskResultProcessor<IDataWorkTask> processTaskResultFunc, int totalCount) {
        super(taskKey, version, processTaskResultFunc);
        this.setTotalStatisticsPoints(totalCount);
        this.exceptionListener = ex -> this.onTaskError(ex);
        IDataSimpleWorkTaskStatisticStatus workTaskStatusEvent = null;
        if (this.workTaskStatusEvent == null && taskKey != null) {
            workTaskStatusEvent = (IDataSimpleWorkTaskStatisticStatus)this.getWorkTaskStatusMgr().getCachedWorkTaskStatusEvent(taskKey);
            if (workTaskStatusEvent == null) {
                workTaskStatusEvent = new IDataSimpleWorkTaskStatisticStatus(taskKey, version, totalCount);
            } else {
                workTaskStatusEvent.updateTaskTotalTaskPoint(totalCount);
            }
            try {
                this.getWorkTaskStatusMgr().updateTaskStatus(workTaskStatusEvent);
            }
            catch (InterruptedException e) {
                throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
            }
            this.workTaskStatusEvent = workTaskStatusEvent;
        }
    }

    @Override
    protected Long processTaskResult(int i, IDataWorkTask workStep, Object taskResult) {
        super.processTaskResult(i, workStep, taskResult);
        if (taskResult instanceof Long) {
            if (this.taskResult != null) {
                FAFDataSequenceWorkTaskGroup fAFDataSequenceWorkTaskGroup = this;
                fAFDataSequenceWorkTaskGroup.taskResult = (Long)fAFDataSequenceWorkTaskGroup.taskResult + (Long)taskResult;
            } else {
                this.taskResult = 0L;
            }
        }
        return (Long)this.taskResult;
    }

    @Override
    protected void doTaskFinallyCleanUp(boolean isCancelled, boolean withError) {
        if (this.endingTask != null) {
            if (!(this.endingTask instanceof IDataWorkTask)) {
                String simpleName = this.endingTask.getClass().getSimpleName() + " is not a task";
                throw new KDBizException(simpleName);
            }
            if (isCancelled || withError) {
                this.endingTask.setRollBack(true);
            }
            IDataWorkTask task = (IDataWorkTask)((Object)this.endingTask);
            Future subTaskResult = IDataWorkTaskManager.getInstance().submit(task);
            try {
                subTaskResult.get();
            }
            catch (Exception ex) {
                this.onException(ex);
            }
        }
    }

    protected boolean onTaskError(Throwable exception) {
        this.exception = exception;
        if (logger.isInfoEnabled()) {
            logger.info("\u6267\u884c\u4efb\u52a1\u5f02\u5e38PADataSequenceWorkTaskGroup\uff1a%s" + ExceptionUtils.getStackTrace((Throwable)exception));
        }
        return true;
    }

    @Override
    protected boolean onException(Throwable exception) {
        boolean result = super.onException(exception);
        if (this.endingTask != null) {
            this.endingTask.setRollBack(true);
        }
        return result;
    }

    @Override
    protected final IDataWorkTaskStatusMgr getWorkTaskStatusMgr() {
        return FAFWorkTaskStatusConsumer.getInstance();
    }

    public IFinallyTask getEndingTask() {
        return this.endingTask;
    }

    public void setEndingTask(IFinallyTask endingTask) {
        this.endingTask = endingTask;
    }
}

