/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.engine.task.impl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.faf.dto.MappingRelationShipDTO;
import kd.macc.faf.engine.task.AbstractRdbDataQueryTask;
import kd.macc.faf.engine.task.IBuilder;
import kd.macc.faf.engine.task.impl.FAFDataExtractingTask;
import kd.macc.faf.enums.DataSourceTypeEnum;
import kd.macc.faf.enums.FAFDimensionTypeEnum;
import kd.macc.faf.helper.EntityMetaHelper;
import kd.macc.faf.helper.FAFSyncDataSchemeHelper;
import kd.macc.faf.rdb.RdbSQLSplitTaskIterator;
import kd.macc.faf.util.AnalysisModelUtil;
import kd.macc.faf.util.CalculateCondition;
import org.apache.commons.lang3.StringUtils;

public class FAFDataSyncTaskBuilder
implements IBuilder<AbstractRdbDataQueryTask> {
    public static final String KEY_DATASYNCTASK = "key_datasynctask";
    public static final String KEY_SCHEME_ID = "key_scheme_id";
    public static final String KEY_ENTITY_TYPE = "entity_type";
    public static final String KEY_RDB_ITERATOR = "rdb_iterator";

    @Override
    public AbstractRdbDataQueryTask build(Map<String, Object> param, Object ... objects) {
        RdbSQLSplitTaskIterator splitIterator;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Long taskId = (Long)param.get(KEY_DATASYNCTASK);
        Long schemeId = (Long)param.get(KEY_SCHEME_ID);
        DataSourceTypeEnum entityType = param.get(KEY_ENTITY_TYPE) == null ? DataSourceTypeEnum.TEMPPORARY : (DataSourceTypeEnum)((Object)param.get(KEY_ENTITY_TYPE));
        RdbSQLSplitTaskIterator rdbSQLSplitTaskIterator = splitIterator = param.get(KEY_RDB_ITERATOR) == null ? null : (RdbSQLSplitTaskIterator)param.get(KEY_RDB_ITERATOR);
        if (splitIterator == null) {
            return null;
        }
        DynamicObject schemeObj = BusinessDataReader.loadSingle((Object)schemeId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pa_syncdataschema"));
        Object tableNumber = schemeObj.getDynamicObject("analysismodel").get("tablenumber");
        long analysisModelId = schemeObj.getDynamicObject("analysismodel").getLong("id");
        if (tableNumber == null || "".equals(tableNumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u540c\u6b65\u6570\u636e\u524d\u8bf7\u5148\u521b\u5efa\u6570\u636e\u8868\u3002", (String)"FAFDataSyncTaskBuilder_0", (String)"macc-faf-common", (Object[])new Object[0]));
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)AnalysisModelUtil.buildEntityNumber(tableNumber.toString()));
        RowMeta rowMeta = ORM.create().createRowMeta(dataEntityType.getName(), String.join((CharSequence)",", dataEntityType.getAllFields().keySet()));
        tableNumber = tableNumber + "_d";
        HashMap<String, String> fieldMappings = new HashMap<String, String>(10);
        HashMap<String, Object> defaultValueMap = new HashMap<String, Object>(10);
        HashSet<String> selectFieldSet = new HashSet<String>(10);
        selectFieldSet.add("id");
        String dataSourceNumber = schemeObj.getDynamicObject("datasource").getDynamicObject("entity_number").getString("number");
        DynamicObjectCollection dimEntry = schemeObj.getDynamicObjectCollection("dimensionmapentry");
        boolean ifVoucherSubEntry = false;
        List<String> flexFields = EntityMetaHelper.matchFlexProperty(dataSourceNumber);
        for (DynamicObject dim : dimEntry) {
            String dimField;
            String dimNumber = dim.getString("dimension.number");
            String dimensionType = dim.getString("dimension.dimensiontype");
            if (FAFDimensionTypeEnum.DATABASE.getCode().equals(dimensionType) || FAFDimensionTypeEnum.ASSISTANTDATA.getCode().equals(dimensionType)) {
                if (DataType.StringType.equals((Object)rowMeta.getField(dimNumber).getDataType())) {
                    defaultValueMap.put(dimNumber, " ");
                } else if (DataType.LongType.equals((Object)rowMeta.getField(dimNumber).getDataType())) {
                    defaultValueMap.put(dimNumber, 0L);
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)(dimField = dim.getString("dimensionfield")))) {
                fieldMappings.put(dim.getString("dimension.number"), dimField);
                String flexField = this.matchFlexField(flexFields, dimField);
                if (flexField != null) {
                    selectFieldSet.add(flexField);
                    continue;
                }
                if (DataSourceTypeEnum.BIZVOUCHER == entityType && dimField.startsWith("dim_")) {
                    ifVoucherSubEntry = true;
                    continue;
                }
                selectFieldSet.add(dimField);
                continue;
            }
            String defaultValue = dim.getString("dimdefaultvalue");
            if (!StringUtils.isNotEmpty((CharSequence)defaultValue)) continue;
            if (DataType.TimestampType.equals((Object)rowMeta.getField(dimNumber).getDataType())) {
                try {
                    defaultValueMap.put(dim.getString("dimension.number"), format.parse(defaultValue));
                    continue;
                }
                catch (ParseException e) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u53d6\u6570\u65b9\u6848\u7684\u65f6\u95f4\u7ef4\u5ea6\u9ed8\u8ba4\u503c\u8f6c\u6362\u9519\u8bef\uff0c\u6b63\u786e\u683c\u5f0f\u4e3ayyyy-MM-dd\u3002", (String)"FAFDataSyncTaskBuilder_1", (String)"macc-faf-common", (Object[])new Object[0]));
                }
            }
            defaultValueMap.put(dim.getString("dimension.number"), defaultValue);
        }
        DynamicObjectCollection measureEntry = schemeObj.getDynamicObjectCollection("measuremapentry");
        HashMap<String, CalculateCondition> conditionMap = new HashMap<String, CalculateCondition>(5);
        for (DynamicObject measure : measureEntry) {
            String selectType;
            switch (selectType = measure.getString("selecttype")) {
                case "1": {
                    String condition = measure.getString("condition_tag");
                    CalculateCondition conditiondesc = new CalculateCondition(dataSourceNumber, condition);
                    conditionMap.put(measure.getString("measure.number"), conditiondesc);
                    selectFieldSet.addAll(conditiondesc.parseProperty());
                    break;
                }
                case "2": {
                    defaultValueMap.put(measure.getString("measure.number"), measure.getBigDecimal("measuredefaultvalue"));
                    break;
                }
                case "3": {
                    String measureField = measure.getString("measurefield");
                    selectFieldSet.add(measureField);
                    fieldMappings.put(measure.getString("measure.number"), measureField);
                    break;
                }
                case "4": {
                    String measureField = measure.getString("dimmeasurefield");
                    fieldMappings.put(measure.getString("measure.number"), measureField);
                    ifVoucherSubEntry = true;
                    break;
                }
            }
        }
        FAFDataExtractingTask task = null;
        switch (entityType) {
            case BIZVOUCHER: {
                selectFieldSet.add("entryentity.id");
                if (ifVoucherSubEntry) {
                    String subEntryField = "entryentity.subentryentity.flexfield,entryentity.subentryentity.value,entryentity.id";
                    splitIterator.setSubEntryFields(subEntryField);
                }
                splitIterator.setSelectFields(StringUtils.join(selectFieldSet, (char)','));
                break;
            }
            case VOUCHER: {
                selectFieldSet.add("entries.id");
                splitIterator.setSelectFields(StringUtils.join(selectFieldSet, (char)','));
                break;
            }
            case TEMPPORARY: 
            case GLBALANCE: {
                splitIterator.setSelectFields(StringUtils.join(selectFieldSet, (char)','));
                break;
            }
        }
        task = new FAFDataExtractingTask(taskId, Integer.valueOf(999), EntityMetadataCache.getDataEntityType((String)AnalysisModelUtil.buildEntityNumber(tableNumber.toString())), splitIterator, fieldMappings, defaultValueMap, 0, analysisModelId, conditionMap);
        task.setMappingRelationShipDTOList(FAFDataSyncTaskBuilder.buildMappingRelationShip(schemeId));
        return task;
    }

    public static List<MappingRelationShipDTO> buildMappingRelationShip(Long syncDataSchemaId) {
        DynamicObject schema = BusinessDataServiceHelper.loadSingleFromCache((Object)syncDataSchemaId, (String)"pa_syncdataschema");
        DynamicObjectCollection dimensionEntry = schema.getDynamicObjectCollection("dimensionmapentry");
        Set relationshipIds = dimensionEntry.stream().map(x -> x.getLong("mappingrelationship_id")).collect(Collectors.toSet());
        Map mappingRelationShipObj = BusinessDataServiceHelper.loadFromCache((String)"pa_mappingrelationship", (String)"id,number,sourcedim,targetdim,entryentity,entryentity.sourcedimtext,entryentity.targetdimtext", (QFilter[])new QFilter("id", "in", relationshipIds).toArray());
        ArrayList<MappingRelationShipDTO> mappingRelationShipDTOList = new ArrayList<MappingRelationShipDTO>(mappingRelationShipObj.size());
        for (DynamicObject entry : dimensionEntry) {
            long relationShipId = entry.getLong("mappingrelationship_id");
            if (relationShipId == 0L) continue;
            DynamicObject dimension = entry.getDynamicObject("dimension");
            String dimensionNumber = dimension.getString("number");
            mappingRelationShipDTOList.add(FAFSyncDataSchemeHelper.getMappingRelationShipDTO(dimensionNumber, (DynamicObject)mappingRelationShipObj.get(relationShipId)));
        }
        return mappingRelationShipDTOList;
    }

    private String matchFlexField(List<String> flexFieldSet, String dimField) {
        for (String flexfield : flexFieldSet) {
            if (!dimField.startsWith(flexfield)) continue;
            return flexfield;
        }
        return null;
    }

    public boolean validateCacheParam() {
        return true;
    }
}

