/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.engine.task.impl;

import java.util.Collection;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.faf.engine.model.FAFWorkTaskMeta;
import kd.macc.faf.engine.model.IWorkTaskTransLog;
import kd.macc.faf.engine.task.FAFAbstractWorkTask;
import kd.macc.faf.engine.task.IDataAbstractWorkTask;
import kd.macc.faf.enums.FAFStatusEnum;
import kd.macc.faf.event.IWorkTaskStatusEvent;
import kd.macc.faf.helper.FAFSyncTaskLogHelper;
import kd.macc.faf.util.IDataDateUtil;
import kd.macc.faf.util.IDataJsonUtil;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class FAFDataSyncWorkTaskWrapper<T>
extends FAFAbstractWorkTask<T> {
    private static final Log logger = LogFactory.getLog(FAFDataSyncWorkTaskWrapper.class);
    protected IDataAbstractWorkTask<T> actualTaskJob;
    protected IWorkTaskTransLog<Long> taskMeta;
    protected boolean needRequestDLock;
    private DynamicObject taskTransLogDync;
    protected boolean needUpdateTaskStatusEvent;

    public FAFDataSyncWorkTaskWrapper(IDataAbstractWorkTask<T> actualTaskJob, IWorkTaskTransLog<Long> taskMeta) {
        this(actualTaskJob, taskMeta, true);
    }

    public FAFDataSyncWorkTaskWrapper(IDataAbstractWorkTask<T> actualTaskJob, IWorkTaskTransLog<Long> taskMeta, boolean needUpdateTaskStatusEvent) {
        super(actualTaskJob.getTaskKey());
        this.actualTaskJob = actualTaskJob;
        this.taskMeta = taskMeta;
        this.needRequestDLock = taskMeta.isNeedRequestLock();
        this.needUpdateTaskStatusEvent = needUpdateTaskStatusEvent;
    }

    @Override
    public String toString() {
        return "FSADataSyncWorkTaskWrapper [actualTaskJob=" + this.actualTaskJob + ", taskMeta=" + this.taskMeta + ", needRequestDLock=" + this.needRequestDLock + "]";
    }

    @Override
    protected void updateTaskStageCode(int newStageCode) {
        super.updateTaskStageCode(newStageCode);
        Long taskId = this.taskMeta instanceof FAFWorkTaskMeta ? ((FAFWorkTaskMeta)this.taskMeta).getTaskId() : 0L;
        this.taskGroupCondition = this.actualTaskJob.getTaskGroupCondition();
        if (this.taskGroupCondition != null) {
            switch (newStageCode) {
                case 1: {
                    this.taskTransLogDync = this.addTaskTransLog(this.taskMeta);
                    break;
                }
                case 2: {
                    if (logger.isInfoEnabled()) {
                        logger.info(String.format("PADataSyncWorkTaskWrapper-taskId: %s", taskId));
                    }
                    this.updateTaskTransLog((Long)this.taskTransLogDync.get("id"), taskId, FAFStatusEnum.PROCESSING, null);
                    break;
                }
                case -9: 
                case 9: 
                case 10: {
                    FAFStatusEnum taskStatus;
                    if (this.actualTaskJob.getException() != null && logger.isInfoEnabled()) {
                        logger.info("\u6267\u884c\u4efb\u52a1\u5f02\u5e38PADataSyncWorkTaskWrapper\uff1a%s" + ExceptionUtils.getStackTrace((Throwable)this.actualTaskJob.getException()));
                    }
                    String logMessage = null;
                    String errorMsg = null;
                    if (this.taskGroupCondition.isCancelMode()) {
                        logMessage = ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u88ab\u624b\u52a8\u7ec8\u6b62\u3002", (String)"FAFDataSyncWorkTaskWrapper_0", (String)"macc-faf-common", (Object[])new Object[0]);
                        taskStatus = FAFStatusEnum.TERMINATE;
                    } else if (this.taskGroupCondition.isWithError()) {
                        StringBuilder errorMessage = new StringBuilder("traceId:").append(RequestContext.getOrCreate().getTraceId()).append(",detailMessage:");
                        if (this.actualTaskJob.getException() != null) {
                            if (StringUtils.isNotEmpty((String)this.actualTaskJob.getException().getMessage())) {
                                logMessage = this.actualTaskJob.getException().getMessage();
                                errorMessage.append(logMessage);
                            }
                            errorMessage.append("StackTrace: ").append(ExceptionUtils.getStackTrace((Throwable)this.actualTaskJob.getException()));
                            errorMsg = errorMessage.toString();
                        }
                        taskStatus = FAFStatusEnum.FAILURE;
                    } else {
                        taskStatus = FAFStatusEnum.SUCCESS;
                        logMessage = ResManager.loadKDString((String)"\u4efb\u52a1\u6210\u529f\u6267\u884c\u3002", (String)"FAFDataSyncWorkTaskWrapper_1", (String)"macc-faf-common", (Object[])new Object[0]);
                    }
                    this.updateTaskTransLog((Long)this.taskTransLogDync.get("id"), taskId, taskStatus, errorMsg);
                    if (!this.needUpdateTaskStatusEvent) break;
                    IWorkTaskStatusEvent workTaskStatusEvent = this.getWorkTaskStatusMgr().getCachedWorkTaskStatusEvent(this.taskKey);
                    if (workTaskStatusEvent != null) {
                        workTaskStatusEvent.setNeedMergeStatus(false);
                    }
                    this.updateWorkTaskStatusEvent(workTaskStatusEvent, logMessage, this.taskGroupCondition.isWithError(), this.taskGroupCondition.isCancelMode());
                    try {
                        this.saveIWorkTaskStatusEvent(taskId, workTaskStatusEvent);
                        this.getWorkTaskStatusMgr().updateTaskStatus(workTaskStatusEvent);
                        break;
                    }
                    catch (InterruptedException e) {
                        throw new KDBizException((Throwable)e, new ErrorCode("", String.format(ResManager.loadKDString((String)"%s\u66f4\u65b0\u5de5\u4f5c\u4efb\u52a1\u7684\u72b6\u6001\u4fe1\u606f\u65f6\u51fa\u73b0\u5f02\u5e38", (String)"FAFDataSyncWorkTaskWrapper_2", (String)"macc-faf-common", (Object[])new Object[0]), e.getMessage())), new Object[0]);
                    }
                }
            }
        }
    }

    protected void updateWorkTaskStatusEvent(IWorkTaskStatusEvent workTaskStatusEvent, String message, boolean isError, boolean interrupt) {
        if (workTaskStatusEvent != null) {
            if (interrupt) {
                workTaskStatusEvent.interruptUpdateStatus(message);
            } else if (isError) {
                workTaskStatusEvent.errorUpdateStatus(message);
            } else {
                workTaskStatusEvent.updateStatusMessage(message);
                workTaskStatusEvent.updateTaskEndStatus(true);
            }
        }
    }

    @Override
    protected T doTaskJob() {
        return this.actualTaskJob.call();
    }

    protected String getDLockKeyPrefix() {
        return "fi/pa";
    }

    protected String buildDLockKey(IWorkTaskTransLog<Long> taskMeta) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getDLockKeyPrefix());
        buf.append(taskMeta.getLockKey());
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DLock requestTransLogLock(IWorkTaskTransLog<Long> taskMeta) {
        if (!this.needRequestDLock) {
            return null;
        }
        String dlockKeyBuf = this.buildDLockKey(taskMeta);
        DLock dlock = null;
        boolean lockSuccess = false;
        try {
            dlock = DLock.createReentrant((String)dlockKeyBuf);
            lockSuccess = dlock.tryLock();
        }
        catch (Exception ex) {
            try {
                this.onException(ex);
            }
            catch (Throwable throwable) {
                if (logger.isInfoEnabled()) {
                    logger.info(String.format("requestTransLogLock Get Lock Result=%s, LockInfo=%s, FSAWorkTaskMeta=%s", lockSuccess, dlock, taskMeta));
                }
                if (dlock != null && !lockSuccess) {
                    dlock.close();
                }
                throw throwable;
            }
            if (logger.isInfoEnabled()) {
                logger.info(String.format("requestTransLogLock Get Lock Result=%s, LockInfo=%s, FSAWorkTaskMeta=%s", lockSuccess, dlock, taskMeta));
            }
            if (dlock != null && !lockSuccess) {
                dlock.close();
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info(String.format("requestTransLogLock Get Lock Result=%s, LockInfo=%s, FSAWorkTaskMeta=%s", lockSuccess, dlock, taskMeta));
        }
        if (dlock != null && !lockSuccess) {
            dlock.close();
        }
        return lockSuccess ? dlock : null;
    }

    protected void releaseLock(DLock dlock) {
        if (dlock == null) {
            return;
        }
        try {
            dlock.close();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    protected DynamicObject addTaskTransLog(IWorkTaskTransLog<Long> taskMeta) {
        return FAFSyncTaskLogHelper.createSyncLog(taskMeta);
    }

    protected DynamicObject updateTaskTransLog(Long taskTransLogId, Long taskId, FAFStatusEnum stepExecuteStatus, String message) {
        if (this.taskTransLogDync == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u4efb\u52a1\u4e8b\u52a1\u65e5\u5fd7\u8bb0\u5f55\uff1ataskTransLogId=%s", (String)"FAFDataSyncWorkTaskWrapper_3", (String)"macc-faf-common", (Object[])new Object[0]), taskTransLogId));
        }
        this.taskTransLogDync.set("status", (Object)String.valueOf(stepExecuteStatus.getCode()));
        this.taskTransLogDync.set("msg_tag", (Object)message);
        this.taskTransLogDync.set("instance", (Object)RequestContext.getOrCreate().getTraceId());
        this.taskTransLogDync.set("taskoperatetoken", (Object)System.currentTimeMillis());
        this.taskTransLogDync.set("updatetime", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.taskTransLogDync});
        if (taskId > 0L) {
            this.updateTaskStatus(taskId, stepExecuteStatus.getCodeString());
        }
        return this.taskTransLogDync;
    }

    private void saveIWorkTaskStatusEvent(Long taskId, IWorkTaskStatusEvent workTaskStatusEvent) {
        DynamicObject dynObj;
        if (taskId > 0L && (dynObj = QueryServiceHelper.queryOne((String)"pa_taskpreview", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taskId)})) != null) {
            DynamicObject taskDbj = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pa_taskpreview"));
            taskDbj.set("id", dynObj.get("id"));
            taskDbj.set("staticstatus_info_tag", (Object)IDataJsonUtil.toJSONString(workTaskStatusEvent));
            SaveServiceHelper.update((DynamicObject)taskDbj);
        }
    }

    private void updateTaskStatus(Long taskId, String status) {
        DynamicObject taskDbj;
        if (logger.isInfoEnabled()) {
            logger.info(String.format("\u540c\u6b65\u4efb\u52a1Id: %s", taskId));
        }
        if ((taskDbj = QueryServiceHelper.queryOne((String)"pa_taskpreview", (String)"id, status", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taskId)})) != null) {
            DynamicObject dynObj = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pa_taskpreview"));
            dynObj.set("id", taskDbj.get("id"));
            String originStatus = taskDbj.getString("status");
            if (!status.equals(originStatus)) {
                dynObj.set("status", (Object)status);
                dynObj.set("updatetime", (Object)new Date());
                if (FAFStatusEnum.FAILURE.getCodeString().equals(status) || FAFStatusEnum.SUCCESS.getCodeString().equals(status)) {
                    QFilter idFilter = new QFilter("datasynctask", "=", (Object)taskId);
                    DynamicObjectCollection beginTimeCols = QueryServiceHelper.query((String)"pa_tasklog", (String)"createtime", (QFilter[])idFilter.toArray(), (String)"createtime");
                    DynamicObjectCollection endTimeCol = QueryServiceHelper.query((String)"pa_tasklog", (String)"updatetime", (QFilter[])idFilter.toArray(), (String)"updatetime desc");
                    if (!CollectionUtils.isEmpty((Collection)beginTimeCols) && !CollectionUtils.isEmpty((Collection)endTimeCol)) {
                        Date beginCreateTime = ((DynamicObject)beginTimeCols.get(0)).getDate("createtime");
                        Date endUpdateTime = ((DynamicObject)endTimeCol.get(0)).getDate("updatetime");
                        String executionTime = IDataDateUtil.getTimeDiff(endUpdateTime, beginCreateTime);
                        dynObj.set("executiontime", (Object)executionTime);
                    }
                }
                SaveServiceHelper.update((DynamicObject)dynObj);
            }
        }
    }

    public IDataAbstractWorkTask<T> getActualTaskJob() {
        return this.actualTaskJob;
    }

    public void setActualTaskJob(IDataAbstractWorkTask<T> actualTaskJob) {
        this.actualTaskJob = actualTaskJob;
    }

    public boolean isNeedRequestDLock() {
        return this.needRequestDLock;
    }

    public void setNeedRequestDLock(boolean needRequestDLock) {
        this.needRequestDLock = needRequestDLock;
    }
}

